/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.role";
    private Properties roles;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.roles = this.load(ROLE_FILE_PROP_NAME, "", options).getProps();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        return this.usersByDn.get(this.getDistinguishedName(certs));
    }

    @Override
    protected Set<String> getUserRoles(String username) throws LoginException {
        HashSet<String> userRoles = new HashSet<String>();
        Enumeration<Object> enumeration = this.roles.keys();
        block0: while (enumeration.hasMoreElements()) {
            String groupName = (String)enumeration.nextElement();
            String[] userList = (this.roles.getProperty(groupName) + "").split(",");
            for (int i = 0; i < userList.length; ++i) {
                if (!username.equals(userList[i])) continue;
                userRoles.add(groupName);
                continue block0;
            }
        }
        return userRoles;
    }
}

