/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.jboss.logging.Logger;

public abstract class ActiveMQScheduledComponent
implements ActiveMQComponent,
Runnable {
    private static final Logger logger = Logger.getLogger(ActiveMQScheduledComponent.class);
    private final ScheduledExecutorService scheduledExecutorService;
    private long period;
    private TimeUnit timeUnit;
    private ScheduledFuture future;

    public ActiveMQScheduledComponent(ScheduledExecutorService scheduledExecutorService, long checkPeriod, TimeUnit timeUnit) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.period = checkPeriod;
        this.timeUnit = timeUnit;
    }

    public synchronized void start() {
        if (this.future != null) {
            return;
        }
        if (this.period >= 0L) {
            this.future = this.scheduledExecutorService.scheduleWithFixedDelay(this, this.period, this.period, this.timeUnit);
        } else {
            logger.tracef("did not start scheduled executor on %s because period was configured as %d", (Object)this, (Object)this.period);
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public synchronized ActiveMQScheduledComponent setPeriod(long period) {
        this.period = period;
        this.restartIfNeeded();
        return this;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public synchronized ActiveMQScheduledComponent setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.restartIfNeeded();
        return this;
    }

    public synchronized void stop() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(false);
        this.future = null;
    }

    public synchronized boolean isStarted() {
        return this.future != null;
    }

    private void restartIfNeeded() {
        if (this.isStarted()) {
            this.stop();
            this.start();
        }
    }
}

