/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.jboss.logging.Logger;

public class LegacyLDAPSecuritySettingPlugin
implements SecuritySettingPlugin {
    private static final Logger logger = Logger.getLogger(LegacyLDAPSecuritySettingPlugin.class);
    private static final long serialVersionUID = 4793109879399750045L;
    public static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String CONNECTION_URL = "connectionURL";
    public static final String CONNECTION_USERNAME = "connectionUsername";
    public static final String CONNECTION_PASSWORD = "connectionPassword";
    public static final String CONNECTION_PROTOCOL = "connectionProtocol";
    public static final String AUTHENTICATION = "authentication";
    public static final String ROLE_ATTRIBUTE = "roleAttribute";
    public static final String FILTER = "filter";
    public static final String DESTINATION_BASE = "destinationBase";
    public static final String ADMIN_PERMISSION_VALUE = "adminPermissionValue";
    public static final String READ_PERMISSION_VALUE = "readPermissionValue";
    public static final String WRITE_PERMISSION_VALUE = "writePermissionValue";
    public static final String ENABLE_LISTENER = "enableListener";
    private String initialContextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String connectionURL = "ldap://localhost:1024";
    private String connectionUsername;
    private String connectionPassword;
    private String connectionProtocol;
    private String authentication = "simple";
    private String destinationBase = "ou=destinations,o=ActiveMQ,ou=system";
    private String filter = "(cn=*)";
    private String roleAttribute = "uniqueMember";
    private String adminPermissionValue = "admin";
    private String readPermissionValue = "read";
    private String writePermissionValue = "write";
    private boolean enableListener = true;
    private DirContext context;
    private EventDirContext eventContext;
    private Map<String, Set<Role>> securityRoles;
    private HierarchicalRepository<Set<Role>> securityRepository;

    @Override
    public LegacyLDAPSecuritySettingPlugin init(Map<String, String> options) {
        if (options != null) {
            this.initialContextFactory = this.getOption(options, INITIAL_CONTEXT_FACTORY, this.initialContextFactory);
            this.connectionURL = this.getOption(options, CONNECTION_URL, this.connectionURL);
            this.connectionUsername = this.getOption(options, CONNECTION_USERNAME, this.connectionUsername);
            this.connectionPassword = this.getOption(options, CONNECTION_PASSWORD, this.connectionPassword);
            this.connectionProtocol = this.getOption(options, CONNECTION_PROTOCOL, this.connectionProtocol);
            this.authentication = this.getOption(options, AUTHENTICATION, this.authentication);
            this.destinationBase = this.getOption(options, DESTINATION_BASE, this.destinationBase);
            this.filter = this.getOption(options, FILTER, this.filter);
            this.roleAttribute = this.getOption(options, ROLE_ATTRIBUTE, this.roleAttribute);
            this.adminPermissionValue = this.getOption(options, ADMIN_PERMISSION_VALUE, this.adminPermissionValue);
            this.readPermissionValue = this.getOption(options, READ_PERMISSION_VALUE, this.readPermissionValue);
            this.writePermissionValue = this.getOption(options, WRITE_PERMISSION_VALUE, this.writePermissionValue);
            this.enableListener = this.getOption(options, ENABLE_LISTENER, Boolean.TRUE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
        }
        return this;
    }

    private String getOption(Map<String, String> options, String key, String defaultValue) {
        String result = options.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    public SecuritySettingPlugin setRoleAttribute(String roleAttribute) {
        this.roleAttribute = roleAttribute;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public LegacyLDAPSecuritySettingPlugin setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getDestinationBase() {
        return this.destinationBase;
    }

    public LegacyLDAPSecuritySettingPlugin setDestinationBase(String destinationBase) {
        this.destinationBase = destinationBase;
        return this;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public LegacyLDAPSecuritySettingPlugin setAuthentication(String authentication) {
        this.authentication = authentication;
        return this;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    public String getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionProtocol(String connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
        return this;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public LegacyLDAPSecuritySettingPlugin setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
        return this;
    }

    public String getInitialContextFactory() {
        return this.initialContextFactory;
    }

    public String getAdminPermissionValue() {
        return this.adminPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setAdminPermissionValue(String adminPermissionValue) {
        this.adminPermissionValue = adminPermissionValue;
        return this;
    }

    public String getReadPermissionValue() {
        return this.readPermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setReadPermissionValue(String readPermissionValue) {
        this.readPermissionValue = readPermissionValue;
        return this;
    }

    public String getWritePermissionValue() {
        return this.writePermissionValue;
    }

    public LegacyLDAPSecuritySettingPlugin setWritePermissionValue(String writePermissionValue) {
        this.writePermissionValue = writePermissionValue;
        return this;
    }

    public LegacyLDAPSecuritySettingPlugin setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
        return this;
    }

    public boolean isEnableListener() {
        return this.enableListener;
    }

    public LegacyLDAPSecuritySettingPlugin setEnableListener(boolean enableListener) {
        this.enableListener = enableListener;
        return this;
    }

    protected boolean isContextAlive() {
        boolean alive = false;
        if (this.context != null) {
            try {
                this.context.getAttributes("");
                alive = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return alive;
    }

    protected void open() throws NamingException {
        if (this.isContextAlive()) {
            return;
        }
        this.context = this.createContext();
        this.eventContext = (EventDirContext)this.context.lookup("");
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{this.roleAttribute});
        searchControls.setSearchScope(2);
        if (this.enableListener) {
            this.eventContext.addNamingListener(this.destinationBase, this.filter, searchControls, (NamingListener)new LDAPNamespaceChangeListener());
        }
    }

    private DirContext createContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.initialContextFactory);
        if (this.connectionUsername == null || "".equals(this.connectionUsername)) {
            throw new NamingException("Empty username is not allowed");
        }
        env.put("java.naming.security.principal", this.connectionUsername);
        if (this.connectionPassword == null || "".equals(this.connectionPassword)) {
            throw new NamingException("Empty password is not allowed");
        }
        env.put("java.naming.security.credentials", this.connectionPassword);
        env.put("java.naming.security.protocol", this.connectionProtocol);
        env.put("java.naming.provider.url", this.connectionURL);
        env.put("java.naming.security.authentication", this.authentication);
        return new InitialDirContext(env);
    }

    @Override
    public Map<String, Set<Role>> getSecurityRoles() {
        if (this.securityRoles == null) {
            this.populateSecurityRoles();
        }
        return this.securityRoles;
    }

    private LegacyLDAPSecuritySettingPlugin populateSecurityRoles() {
        ActiveMQServerLogger.LOGGER.populatingSecurityRolesFromLDAP(this.connectionURL);
        try {
            this.open();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorOpeningContextForLDAP(e);
            return this;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{this.roleAttribute});
        searchControls.setSearchScope(2);
        this.securityRoles = new HashMap<String, Set<Role>>();
        try {
            NamingEnumeration<SearchResult> searchResults = this.context.search(this.destinationBase, this.filter, searchControls);
            while (searchResults.hasMore()) {
                this.processSearchResult(this.securityRoles, searchResults.next());
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorPopulatingSecurityRolesFromLDAP(e);
        }
        return this;
    }

    @Override
    public void setSecurityRepository(HierarchicalRepository<Set<Role>> securityRepository) {
        this.securityRepository = securityRepository;
    }

    private void processSearchResult(Map<String, Set<Role>> securityRoles, SearchResult searchResult) throws NamingException {
        Attributes attrs = searchResult.getAttributes();
        if (attrs == null || attrs.size() == 0) {
            return;
        }
        LdapName searchResultLdapName = new LdapName(searchResult.getName());
        logger.debug((Object)("LDAP search result : " + searchResultLdapName));
        String permissionType = null;
        String destination = null;
        String destinationType = "unknown";
        for (Rdn rdn : searchResultLdapName.getRdns()) {
            if (rdn.getType().equals("cn")) {
                logger.debug((Object)("\tPermission type: " + rdn.getValue()));
                permissionType = rdn.getValue().toString();
            }
            if (rdn.getType().equals("uid")) {
                logger.debug((Object)("\tDestination name: " + rdn.getValue()));
                destination = rdn.getValue().toString();
            }
            if (!rdn.getType().equals("ou")) continue;
            String rawDestinationType = rdn.getValue().toString();
            if (rawDestinationType.toLowerCase().contains("queue")) {
                destinationType = "queue";
            } else if (rawDestinationType.toLowerCase().contains("topic")) {
                destinationType = "topic";
            }
            logger.debug((Object)("\tDestination type: " + destinationType));
        }
        logger.debug((Object)("\tAttributes: " + attrs));
        Attribute attr = attrs.get(this.roleAttribute);
        NamingEnumeration<?> e = attr.getAll();
        Set<Role> roles = securityRoles.get(destination);
        boolean exists = false;
        if (roles == null) {
            roles = new HashSet<Role>();
        } else {
            exists = true;
        }
        while (e.hasMore()) {
            String value = (String)e.next();
            LdapName ldapname = new LdapName(value);
            Rdn rdn = ldapname.getRdn(ldapname.size() - 1);
            String roleName = rdn.getValue().toString();
            logger.debug((Object)("\tRole name: " + roleName));
            Role role = new Role(roleName, permissionType.equalsIgnoreCase(this.writePermissionValue), permissionType.equalsIgnoreCase(this.readPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), permissionType.equalsIgnoreCase(this.adminPermissionValue), false, permissionType.equalsIgnoreCase(this.readPermissionValue));
            roles.add(role);
        }
        if (!exists) {
            securityRoles.put(destination, roles);
        }
    }

    @Override
    public SecuritySettingPlugin stop() {
        try {
            this.eventContext.close();
        }
        catch (NamingException e) {
            // empty catch block
        }
        try {
            if (this.context != null) {
                this.context.close();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return this;
    }

    public void objectAdded(NamingEvent namingEvent) {
        HashMap<String, Set<Role>> newRoles = new HashMap<String, Set<Role>>();
        try {
            this.processSearchResult(newRoles, (SearchResult)namingEvent.getNewBinding());
            for (Map.Entry entry : newRoles.entrySet()) {
                Set<Role> existingRoles = this.securityRepository.getMatch((String)entry.getKey());
                for (Role role : (Set)entry.getValue()) {
                    existingRoles.add(role);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void objectRemoved(NamingEvent namingEvent) {
        try {
            LdapName ldapName = new LdapName(namingEvent.getOldBinding().getName());
            String match = null;
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equals("uid")) continue;
                match = rdn.getValue().toString();
            }
            Set<Role> roles = this.securityRepository.getMatch(match);
            ArrayList<Role> rolesToRemove = new ArrayList<Role>();
            for (Rdn rdn : ldapName.getRdns()) {
                if (rdn.getValue().equals(this.writePermissionValue)) {
                    logger.debug((Object)"Removing write permission");
                    for (Role role : roles) {
                        if (!role.isSend()) continue;
                        rolesToRemove.add(role);
                    }
                } else if (rdn.getValue().equals(this.readPermissionValue)) {
                    logger.debug((Object)"Removing read permission");
                    for (Role role : roles) {
                        if (!role.isConsume()) continue;
                        rolesToRemove.add(role);
                    }
                } else if (rdn.getValue().equals(this.adminPermissionValue)) {
                    logger.debug((Object)"Removing admin permission");
                    for (Role role : roles) {
                        if (!role.isCreateDurableQueue() && !role.isCreateNonDurableQueue() && !role.isDeleteDurableQueue() && !role.isDeleteNonDurableQueue()) continue;
                        rolesToRemove.add(role);
                    }
                }
                for (Role roleToRemove : rolesToRemove) {
                    roles.remove(roleToRemove);
                }
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void objectRenamed(NamingEvent namingEvent) {
    }

    public void objectChanged(NamingEvent namingEvent) {
        this.objectRemoved(namingEvent);
        this.objectAdded(namingEvent);
    }

    public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
        this.context = null;
        ActiveMQServerLogger.LOGGER.error("Caught unexpected exception.", namingExceptionEvent.getException());
    }

    protected class LDAPNamespaceChangeListener
    implements NamespaceChangeListener,
    ObjectChangeListener {
        protected LDAPNamespaceChangeListener() {
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.namingExceptionThrown(evt);
        }

        @Override
        public void objectAdded(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectAdded(evt);
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectRemoved(evt);
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectRenamed(evt);
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            LegacyLDAPSecuritySettingPlugin.this.objectChanged(evt);
        }
    }
}

