/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessageEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PendingLargeMessageEncoding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.replication.ReplicatedJournal;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.jboss.logging.Logger;

public class JournalStorageManager
extends AbstractJournalStorageManager {
    private static final Logger logger = Logger.getLogger(JournalStorageManager.class);
    private SequentialFileFactory journalFF;
    private SequentialFileFactory bindingsFF;
    SequentialFileFactory largeMessagesFactory;
    private Journal originalMessageJournal;
    private Journal originalBindingsJournal;
    protected String largeMessagesDirectory;
    private ReplicationManager replicator;

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors) {
        this(config, executorFactory, scheduledExecutorService, ioExecutors, null);
    }

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, ExecutorFactory ioExecutors) {
        this(config, executorFactory, null, ioExecutors, null);
    }

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors, IOCriticalErrorListener criticalErrorListener) {
        super(config, executorFactory, scheduledExecutorService, ioExecutors, criticalErrorListener);
    }

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, ExecutorFactory ioExecutors, IOCriticalErrorListener criticalErrorListener) {
        super(config, executorFactory, null, ioExecutors, criticalErrorListener);
    }

    @Override
    protected void init(Configuration config, IOCriticalErrorListener criticalErrorListener) {
        if (config.getJournalType() != JournalType.NIO && config.getJournalType() != JournalType.ASYNCIO) {
            throw ActiveMQMessageBundle.BUNDLE.invalidJournal();
        }
        this.bindingsFF = new NIOSequentialFileFactory(config.getBindingsLocation(), criticalErrorListener, config.getJournalMaxIO_NIO());
        this.bindingsFF.setDatasync(config.isJournalDatasync());
        JournalImpl localBindings = new JournalImpl(this.ioExecutors, 0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactPercentage(), this.bindingsFF, "activemq-bindings", "bindings", 1, 0);
        this.bindingsJournal = localBindings;
        this.originalBindingsJournal = localBindings;
        if (config.getJournalType() == JournalType.ASYNCIO) {
            ActiveMQServerLogger.LOGGER.journalUseAIO();
            this.journalFF = new AIOSequentialFileFactory(config.getJournalLocation(), config.getJournalBufferSize_AIO(), config.getJournalBufferTimeout_AIO(), config.getJournalMaxIO_AIO(), config.isLogJournalWriteRate(), criticalErrorListener);
        } else if (config.getJournalType() == JournalType.NIO) {
            ActiveMQServerLogger.LOGGER.journalUseNIO();
            this.journalFF = new NIOSequentialFileFactory(config.getJournalLocation(), true, config.getJournalBufferSize_NIO(), config.getJournalBufferTimeout_NIO(), config.getJournalMaxIO_NIO(), config.isLogJournalWriteRate(), criticalErrorListener);
        } else {
            throw ActiveMQMessageBundle.BUNDLE.invalidJournalType2(config.getJournalType());
        }
        this.journalFF.setDatasync(config.isJournalDatasync());
        JournalImpl localMessage = new JournalImpl(this.ioExecutors, config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), this.journalFF, "activemq-data", "amq", config.getJournalType() == JournalType.ASYNCIO ? config.getJournalMaxIO_AIO() : config.getJournalMaxIO_NIO(), 0);
        this.messageJournal = localMessage;
        this.originalMessageJournal = localMessage;
        this.largeMessagesDirectory = config.getLargeMessagesDirectory();
        this.largeMessagesFactory = new NIOSequentialFileFactory(config.getLargeMessagesLocation(), false, criticalErrorListener, 1);
        this.perfBlastPages = config.getJournalPerfBlastPages();
        this.pageMaxConcurrentIO = config.getPageMaxConcurrentIO() != 1 ? new Semaphore(config.getPageMaxConcurrentIO()) : null;
    }

    @Override
    protected void beforeStart() throws Exception {
        this.checkAndCreateDir(this.config.getBindingsLocation(), this.config.isCreateBindingsDir());
        this.checkAndCreateDir(this.config.getJournalLocation(), this.config.isCreateJournalDir());
        this.checkAndCreateDir(this.config.getLargeMessagesLocation(), this.config.isCreateJournalDir());
        this.cleanupIncompleteFiles();
    }

    @Override
    protected void beforeStop() throws Exception {
        if (this.replicator != null) {
            this.replicator.stop();
        }
    }

    @Override
    public void stop() throws Exception {
        this.stop(false, true);
    }

    public boolean isReplicated() {
        return this.replicator != null;
    }

    private void cleanupIncompleteFiles() throws Exception {
        if (this.largeMessagesFactory != null) {
            List tmpFiles = this.largeMessagesFactory.listFiles("tmp");
            for (String tmpFile : tmpFiles) {
                SequentialFile file = this.largeMessagesFactory.createSequentialFile(tmpFile);
                file.delete();
            }
        }
    }

    @Override
    public synchronized void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        ReplicationManager replicatorInUse = this.replicator;
        if (replicatorInUse != null) {
            OperationContext token;
            if (sendFailover && (token = this.replicator.sendLiveIsStopping(ReplicationLiveIsStoppingMessage.LiveStopping.FAIL_OVER)) != null) {
                try {
                    token.waitCompletion(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            replicatorInUse.stop();
        }
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    @Override
    protected void performCachedLargeMessageDeletes() {
        for (Long largeMsgId : this.largeMessagesToDelete) {
            SequentialFile msg = this.createFileForLargeMessage((long)largeMsgId, StorageManager.LargeMessageExtension.DURABLE);
            try {
                msg.delete();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.journalErrorDeletingMessage(e, largeMsgId);
            }
            if (this.replicator == null) continue;
            this.replicator.largeMessageDelete(largeMsgId);
        }
        this.largeMessagesToDelete.clear();
    }

    protected SequentialFile createFileForLargeMessage(long messageID, boolean durable) {
        if (durable) {
            return this.createFileForLargeMessage(messageID, StorageManager.LargeMessageExtension.DURABLE);
        }
        return this.createFileForLargeMessage(messageID, StorageManager.LargeMessageExtension.TEMPORARY);
    }

    @Override
    protected LargeServerMessage parseLargeMessage(Map<Long, ServerMessage> messages, ActiveMQBuffer buff) throws Exception {
        LargeServerMessage largeMessage = this.createLargeMessage();
        LargeMessageEncoding messageEncoding = new LargeMessageEncoding(largeMessage);
        messageEncoding.decode(buff);
        if (largeMessage.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            SequentialFile linkedFile;
            long originalMessageID = largeMessage.getLongProperty(Message.HDR_ORIG_MESSAGE_ID);
            SequentialFile currentFile = this.createFileForLargeMessage(largeMessage.getMessageID(), true);
            if (!currentFile.exists() && (linkedFile = this.createFileForLargeMessage(originalMessageID, true)).exists()) {
                linkedFile.copyTo(currentFile);
                linkedFile.close();
            }
            currentFile.close();
        }
        return largeMessage;
    }

    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageClosed(storeName, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageDeleted(storeName, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
        if (this.isReplicated()) {
            this.readLock();
            try {
                if (this.isReplicated()) {
                    this.replicator.pageWrite(message, pageNumber);
                }
            }
            finally {
                this.readUnLock();
            }
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return this.journalFF.allocateDirectBuffer(size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        this.journalFF.releaseBuffer(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storePendingLargeMessage(long messageID) throws Exception {
        this.readLock();
        try {
            long recordID = this.generateID();
            this.messageJournal.appendAddRecord(recordID, (byte)29, (EncodingSupport)new PendingLargeMessageEncoding(messageID), true, (IOCompletion)this.getContext(true));
            long l = recordID;
            return l;
        }
        finally {
            this.readUnLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteLargeMessageFile(final LargeServerMessage largeServerMessage) throws ActiveMQException {
        SequentialFile file;
        block13: {
            if (largeServerMessage.getPendingRecordID() < 0L) {
                try {
                    largeServerMessage.setPendingRecordID(this.storePendingLargeMessage(largeServerMessage.getMessageID()));
                }
                catch (Exception e) {
                    throw new ActiveMQInternalErrorException(e.getMessage(), e);
                }
            }
            if ((file = largeServerMessage.getFile()) == null) {
                return;
            }
            if (largeServerMessage.isDurable() && this.isReplicated()) {
                this.readLock();
                try {
                    if (!this.isReplicated() || !this.replicator.isSynchronizing()) break block13;
                    Set set = this.largeMessagesToDelete;
                    synchronized (set) {
                        this.largeMessagesToDelete.add(largeServerMessage.getMessageID());
                        this.confirmLargeMessage(largeServerMessage);
                    }
                    return;
                }
                finally {
                    this.readUnLock();
                }
            }
        }
        Runnable deleteAction = new Runnable(){

            @Override
            public void run() {
                try {
                    JournalStorageManager.this.readLock();
                    try {
                        if (JournalStorageManager.this.replicator != null) {
                            JournalStorageManager.this.replicator.largeMessageDelete(largeServerMessage.getMessageID());
                        }
                        file.delete();
                        JournalStorageManager.this.confirmLargeMessage(largeServerMessage);
                    }
                    finally {
                        JournalStorageManager.this.readUnLock();
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.journalErrorDeletingMessage(e, largeServerMessage.getMessageID());
                }
            }
        };
        if (this.executor == null) {
            deleteAction.run();
        } else {
            this.executor.execute(deleteAction);
        }
    }

    @Override
    public LargeServerMessage createLargeMessage() {
        return new LargeServerMessageImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LargeServerMessage createLargeMessage(long id, MessageInternal message) throws Exception {
        this.readLock();
        try {
            if (this.isReplicated()) {
                this.replicator.largeMessageBegin(id);
            }
            LargeServerMessageImpl largeMessage = (LargeServerMessageImpl)this.createLargeMessage();
            largeMessage.copyHeadersAndProperties(message);
            largeMessage.setMessageID(id);
            largeMessage.validateFile();
            if (largeMessage.isDurable()) {
                long pendingRecordID = this.storePendingLargeMessage(id);
                largeMessage.setPendingRecordID(pendingRecordID);
            }
            LargeServerMessageImpl largeServerMessageImpl = largeMessage;
            return largeServerMessageImpl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
        return this.largeMessagesFactory.createSequentialFile(messageID + extension.getExtension());
    }

    private void sendJournalFile(JournalFile[] journalFiles, AbstractJournalStorageManager.JournalContent type) throws Exception {
        for (JournalFile jf : journalFiles) {
            if (!this.started) {
                return;
            }
            this.replicator.syncJournalFile(jf, type);
        }
    }

    private JournalFile[] prepareJournalForCopy(Journal journal, AbstractJournalStorageManager.JournalContent contentType, String nodeID, boolean autoFailBack) throws Exception {
        journal.forceMoveNextFile();
        JournalFile[] datafiles = journal.getDataFiles();
        this.replicator.sendStartSyncMessage(datafiles, contentType, nodeID, autoFailBack);
        return datafiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack, long initialReplicationSyncTimeout) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("JournalStorageManager must be started...");
        }
        assert (replicationManager != null);
        if (!(this.messageJournal instanceof JournalImpl) || !(this.bindingsJournal instanceof JournalImpl)) {
            throw ActiveMQMessageBundle.BUNDLE.notJournalImpl();
        }
        this.originalMessageJournal.scheduleCompactAndBlock(-1);
        this.originalBindingsJournal.scheduleCompactAndBlock(-1);
        JournalFile[] messageFiles = null;
        JournalFile[] bindingsFiles = null;
        Map<Long, Pair<String, Long>> pendingLargeMessages = null;
        try {
            Map<SimpleString, Collection<Integer>> pageFilesToSync;
            this.storageManagerLock.writeLock().lock();
            try {
                if (this.isReplicated()) {
                    throw new ActiveMQIllegalStateException("already replicating");
                }
                this.replicator = replicationManager;
                this.originalMessageJournal.synchronizationLock();
                this.originalBindingsJournal.synchronizationLock();
                try {
                    this.originalBindingsJournal.replicationSyncPreserveOldFiles();
                    this.originalMessageJournal.replicationSyncPreserveOldFiles();
                    pagingManager.lock();
                    try {
                        pagingManager.disableCleanup();
                        messageFiles = this.prepareJournalForCopy(this.originalMessageJournal, AbstractJournalStorageManager.JournalContent.MESSAGES, nodeID, autoFailBack);
                        bindingsFiles = this.prepareJournalForCopy(this.originalBindingsJournal, AbstractJournalStorageManager.JournalContent.BINDINGS, nodeID, autoFailBack);
                        pageFilesToSync = this.getPageInformationForSync(pagingManager);
                        pendingLargeMessages = this.recoverPendingLargeMessages();
                    }
                    finally {
                        pagingManager.unlock();
                    }
                }
                finally {
                    this.originalMessageJournal.synchronizationUnlock();
                    this.originalBindingsJournal.synchronizationUnlock();
                }
                this.bindingsJournal = new ReplicatedJournal(0, this.originalBindingsJournal, this.replicator);
                this.messageJournal = new ReplicatedJournal(1, this.originalMessageJournal, this.replicator);
                this.replicator.sendLargeMessageIdListMessage(pendingLargeMessages);
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
            this.sendJournalFile(messageFiles, AbstractJournalStorageManager.JournalContent.MESSAGES);
            this.sendJournalFile(bindingsFiles, AbstractJournalStorageManager.JournalContent.BINDINGS);
            this.sendLargeMessageFiles(pendingLargeMessages);
            this.sendPagesToBackup(pageFilesToSync, pagingManager);
            this.storageManagerLock.writeLock().lock();
            try {
                if (this.replicator != null) {
                    this.replicator.sendSynchronizationDone(nodeID, initialReplicationSyncTimeout);
                    this.performCachedLargeMessageDeletes();
                }
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            this.stopReplication();
            throw e;
        }
        finally {
            pagingManager.resumeCleanup();
            this.originalBindingsJournal.replicationSyncFinished();
            this.originalMessageJournal.replicationSyncFinished();
        }
    }

    private void sendLargeMessageFiles(Map<Long, Pair<String, Long>> pendingLargeMessages) throws Exception {
        Iterator<Map.Entry<Long, Pair<String, Long>>> iter = pendingLargeMessages.entrySet().iterator();
        while (this.started && iter.hasNext()) {
            Map.Entry<Long, Pair<String, Long>> entry = iter.next();
            String fileName = (String)entry.getValue().getA();
            long id = entry.getKey();
            long size = (Long)entry.getValue().getB();
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(fileName);
            if (!seqFile.exists()) continue;
            if (this.replicator != null) {
                this.replicator.syncLargeMessageFile(seqFile, size, id);
                continue;
            }
            throw ActiveMQMessageBundle.BUNDLE.replicatorIsNull();
        }
    }

    private Map<SimpleString, Collection<Integer>> getPageInformationForSync(PagingManager pagingManager) throws Exception {
        HashMap<SimpleString, Collection<Integer>> info = new HashMap<SimpleString, Collection<Integer>>();
        for (SimpleString storeName : pagingManager.getStoreNames()) {
            PagingStore store = pagingManager.getPageStore(storeName);
            info.put(storeName, store.getCurrentIds());
            store.forceAnotherPage();
        }
        return info;
    }

    private void checkAndCreateDir(File dir, boolean create) {
        if (!dir.exists()) {
            if (create) {
                if (!dir.mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + dir);
                }
            } else {
                throw ActiveMQMessageBundle.BUNDLE.cannotCreateDir(dir.getAbsolutePath());
            }
        }
    }

    private Map<Long, Pair<String, Long>> recoverPendingLargeMessages() throws Exception {
        HashMap<Long, Pair<String, Long>> largeMessages = new HashMap<Long, Pair<String, Long>>();
        List filenames = this.largeMessagesFactory.listFiles("msg");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String filename : filenames) {
            Long id = this.getLargeMessageIdFromFilename(filename);
            if (this.largeMessagesToDelete.contains(id)) continue;
            idList.add(id);
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(filename);
            long size = seqFile.size();
            largeMessages.put(id, (Pair<String, Long>)new Pair((Object)filename, (Object)size));
        }
        return largeMessages;
    }

    private void sendPagesToBackup(Map<SimpleString, Collection<Integer>> pageFilesToSync, PagingManager manager) throws Exception {
        for (Map.Entry<SimpleString, Collection<Integer>> entry : pageFilesToSync.entrySet()) {
            if (!this.started) {
                return;
            }
            PagingStore store = manager.getPageStore(entry.getKey());
            store.sendPages(this.replicator, entry.getValue());
        }
    }

    private long getLargeMessageIdFromFilename(String filename) {
        return Long.parseLong(filename.split("\\.")[0]);
    }

    @Override
    public void stopReplication() {
        logger.trace((Object)"stopReplication()");
        this.storageManagerLock.writeLock().lock();
        try {
            if (this.replicator == null) {
                return;
            }
            this.bindingsJournal = this.originalBindingsJournal;
            this.messageJournal = this.originalMessageJournal;
            try {
                this.replicator.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingReplicationManager(e);
            }
            this.replicator = null;
            this.performCachedLargeMessageDeletes();
        }
        finally {
            this.storageManagerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addBytesToLargeMessage(SequentialFile file, long messageId, byte[] bytes) throws Exception {
        this.readLock();
        try {
            file.position(file.size());
            file.writeDirect(ByteBuffer.wrap(bytes), false);
            if (this.isReplicated()) {
                this.replicator.largeMessageWrite(messageId, bytes);
            }
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        if (this.journalFF != null) {
            monitor.addStore(this.journalFF.getDirectory());
        }
        if (this.largeMessagesFactory != null) {
            monitor.addStore(this.largeMessagesFactory.getDirectory());
        }
        if (this.bindingsFF != null) {
            monitor.addStore(this.bindingsFF.getDirectory());
        }
    }
}

