/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryDatabase;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.JDBCJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActivationFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MemoryManager;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.PostQueueCreationCallback;
import org.apache.activemq.artemis.core.server.PostQueueDeletionCallback;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.QueueCreator;
import org.apache.activemq.artemis.core.server.QueueDeleter;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.Transformer;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.GroupHandlingAbstract;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.group.impl.LocalGroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.RemoteGroupingHandler;
import org.apache.activemq.artemis.core.server.impl.AIOFileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AutoCreatedQueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.impl.DivertImpl;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.QueueFactoryImpl;
import org.apache.activemq.artemis.core.server.impl.ServerInfo;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.impl.TransientQueueManagerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.impl.ManagementServiceImpl;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.server.reload.ReloadManagerImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.impl.ResourceManagerImpl;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.CertificateUtil;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SecurityFormatter;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.jboss.logging.Logger;

public class ActiveMQServerImpl
implements ActiveMQServer {
    private static final Logger logger = Logger.getLogger(ActiveMQServerImpl.class);
    @Deprecated
    public static final String GENERIC_IGNORED_FILTER = "__AMQX=-1";
    private HAPolicy haPolicy;
    private volatile SERVER_STATE state = SERVER_STATE.STOPPED;
    private final Version version;
    private final ActiveMQSecurityManager securityManager;
    private final Configuration configuration;
    private MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    private volatile ScheduledExecutorService scheduledPool;
    private volatile ExecutorFactory executorFactory;
    private volatile ExecutorService ioExecutorPool;
    private volatile ExecutorFactory ioExecutorFactory;
    private final NetworkHealthCheck networkHealthCheck = new NetworkHealthCheck(ActiveMQDefaultConfiguration.getDefaultNetworkCheckNic(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckPeriod(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckTimeout());
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile ActiveMQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile BackupManager backupManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private final List<ProtocolManagerFactory> protocolManagerFactories = new ArrayList<ProtocolManagerFactory>();
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private ReloadManager reloadManager;
    private FileStoreMonitor fileStoreMonitor;
    private QueueCreator jmsQueueCreator;
    private QueueDeleter jmsQueueDeleter;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Semaphore activationLock = new Semaphore(1);
    private final ReusableLatch activationLatch = new ReusableLatch(0);
    private final Set<ActivateCallback> activateCallbacks = new ConcurrentHashSet();
    private final Set<ActivationFailureListener> activationFailureListeners = new ConcurrentHashSet();
    private final Set<PostQueueCreationCallback> postQueueCreationCallbacks = new ConcurrentHashSet();
    private final Set<PostQueueDeletionCallback> postQueueDeletionCallbacks = new ConcurrentHashSet();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread backupActivationThread;
    private Activation activation;
    private final Map<String, Object> activationParams = new HashMap<String, Object>();
    private final ShutdownOnCriticalErrorListener shutdownOnCriticalIO = new ShutdownOnCriticalErrorListener();
    private final ActiveMQServer parentServer;
    private final List<SimpleString> scaledDownNodeIDs = new ArrayList<SimpleString>();
    private boolean threadPoolSupplied = false;
    private boolean scheduledPoolSupplied = false;
    private final ServiceRegistry serviceRegistry;
    private Date startDate;
    private final List<ActiveMQComponent> externalComponents = new ArrayList<ActiveMQComponent>();
    private final ConcurrentMap<String, AtomicInteger> connectedClientIds = new ConcurrentHashMap<String, AtomicInteger>();
    private final ActiveMQComponent networkCheckMonitor = new ActiveMQComponent(){

        public void start() throws Exception {
            ActiveMQServerImpl.this.internalStart();
        }

        public void stop() throws Exception {
            ActiveMQServerImpl.this.internalStop();
        }

        public String toString() {
            return ActiveMQServerImpl.this.toString();
        }

        public boolean isStarted() {
            return ActiveMQServerImpl.this.isStarted();
        }
    };

    public ActiveMQServerImpl() {
        this(null, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQServer parentServer) {
        this(configuration, null, null, parentServer);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager) {
        this(configuration, mbeanServer, securityManager, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer) {
        this(configuration, mbeanServer, securityManager, parentServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer, ServiceRegistry serviceRegistry) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        } else {
            ConfigurationUtils.validateConfiguration(configuration);
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>();
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>();
        this.securityRepository.setDefault(new HashSet());
        this.parentServer = parentServer;
        this.serviceRegistry = serviceRegistry == null ? new ServiceRegistryImpl() : serviceRegistry;
    }

    @Override
    public ReloadManager getReloadManager() {
        return this.reloadManager;
    }

    @Override
    public NetworkHealthCheck getNetworkHealthCheck() {
        return this.networkHealthCheck;
    }

    protected NodeManager createNodeManager(File directory, boolean replicatingBackup) {
        NodeManager manager = !this.configuration.isPersistenceEnabled() ? new InVMNodeManager(replicatingBackup) : (this.configuration.getJournalType() == JournalType.ASYNCIO && LibaioContext.isLoaded() ? new AIOFileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout()) : new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout()));
        return manager;
    }

    @Override
    public OperationContext newOperationContext() {
        return this.getStorageManager().newContext(this.getExecutorFactory().getExecutor());
    }

    public final synchronized void start() throws Exception {
        SERVER_STATE originalState = this.state;
        try {
            this.internalStart();
        }
        finally {
            if (originalState == SERVER_STATE.STOPPED) {
                this.networkHealthCheck.setTimeUnit(TimeUnit.MILLISECONDS).setPeriod(this.configuration.getNetworkCheckPeriod()).setNetworkTimeout(this.configuration.getNetworkCheckTimeout()).parseAddressList(this.configuration.getNetworkCheckList()).parseURIList(this.configuration.getNetworkCheckURLList()).setNICName(this.configuration.getNetworkCheckNIC()).setIpv4Command(this.configuration.getNetworkCheckPingCommand()).setIpv6Command(this.configuration.getNetworkCheckPing6Command());
                this.networkHealthCheck.addComponent(this.networkCheckMonitor);
            }
        }
    }

    private void internalStart() throws Exception {
        if (this.state != SERVER_STATE.STOPPED) {
            logger.debug((Object)"Server already started!");
            return;
        }
        this.configuration.parseSystemProperties();
        this.startDate = new Date();
        this.state = SERVER_STATE.STARTING;
        if (this.haPolicy == null) {
            this.haPolicy = ConfigurationUtils.getHAPolicy(this.configuration.getHAPolicyConfiguration(), this);
        }
        this.activationLatch.setCount(1);
        logger.debug((Object)("Starting server " + this));
        OperationContextImpl.clearContext();
        try {
            boolean wasLive;
            this.checkJournalDirectory();
            this.nodeManager = this.createNodeManager(this.configuration.getJournalLocation(), false);
            this.nodeManager.start();
            ActiveMQServerLogger.LOGGER.serverStarting(this.haPolicy.isBackup() ? "backup" : "live", this.configuration);
            boolean bl = wasLive = !this.haPolicy.isBackup();
            if (!this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO);
                this.activation.run();
            }
            if (this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.isSharedStore() ? this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO) : this.haPolicy.createActivation(this, wasLive, this.activationParams, this.shutdownOnCriticalIO);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"starting backupActivation");
                }
                this.backupActivationThread = new ActivationThread((Runnable)this.activation, ActiveMQMessageBundle.BUNDLE.activationForServer(this));
                this.backupActivationThread.start();
            } else {
                ActiveMQServerLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.configuration.getName(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice, this.serviceRegistry);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        if (this.activation instanceof SharedNothingBackupActivation) {
            return ((SharedNothingBackupActivation)this.activation).getReplicationEndpoint();
        }
        return null;
    }

    @Override
    public void unlockActivation() {
        this.activationLock.release();
    }

    @Override
    public void lockActivation() {
        try {
            this.activationLock.acquire();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected final void finalize() throws Throwable {
        if (this.state != SERVER_STATE.STOPPED) {
            ActiveMQServerLogger.LOGGER.serverFinalisedWIthoutBeingSTopped();
            this.stop();
        }
        super.finalize();
    }

    public void setState(SERVER_STATE state) {
        this.state = state;
    }

    public SERVER_STATE getState() {
        return this.state;
    }

    public void interrupBackupThread(NodeManager nodeManagerInUse) throws InterruptedException {
        long timeout = 30000L;
        long start = System.currentTimeMillis();
        while (this.backupActivationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
            if (nodeManagerInUse != null) {
                nodeManagerInUse.interrupt();
            }
            this.backupActivationThread.interrupt();
            this.backupActivationThread.join(1000L);
        }
        if (System.currentTimeMillis() - start >= timeout) {
            ActiveMQServerLogger.LOGGER.backupActivationTimeout();
            this.threadDump();
        }
    }

    public void resetNodeManager() throws Exception {
        this.nodeManager.stop();
        this.nodeManager = this.createNodeManager(this.configuration.getJournalLocation(), true);
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    @Override
    public void setHAPolicy(HAPolicy haPolicy) {
        if (logger.isTraceEnabled()) {
            logger.tracef("XXX @@@ Setting %s, isBackup=%s at %s", (Object)haPolicy, (Object)haPolicy.isBackup(), (Object)this);
        }
        this.haPolicy = haPolicy;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        if (this.state == SERVER_STATE.STARTING || this.state == SERVER_STATE.STARTED) {
            throw ActiveMQMessageBundle.BUNDLE.cannotSetMBeanserver();
        }
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void addExternalComponent(ActiveMQComponent externalComponent) {
        this.externalComponents.add(externalComponent);
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setActivation(SharedNothingLiveActivation activation) {
        this.activation = activation;
    }

    public final void stopTheServer(final boolean criticalIOError) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ActiveMQServerImpl.this.stop(false, criticalIOError, false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorStoppingServer(e);
                }
            }
        };
        thread.start();
    }

    public final void stop() throws Exception {
        try {
            this.internalStop();
        }
        finally {
            this.networkHealthCheck.stop();
        }
    }

    private void internalStop() throws Exception {
        this.stop(false);
    }

    @Override
    public void addActivationParam(String key, Object val) {
        this.activationParams.put(key, val);
    }

    @Override
    public boolean isAddressBound(String address) throws Exception {
        return this.postOffice.isAddressBound(SimpleString.toSimpleString((String)address));
    }

    @Override
    public BindingQueryResult bindingQuery(SimpleString address) throws Exception {
        if (address == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressIsNull();
        }
        boolean autoCreateJmsQueues = address.toString().startsWith("jms.queue.") && this.getAddressSettingsRepository().getMatch(address.toString()).isAutoCreateJmsQueues();
        boolean autoCreateJmsTopics = address.toString().startsWith("jms.topic.") && this.getAddressSettingsRepository().getMatch(address.toString()).isAutoCreateJmsTopics();
        ArrayList<SimpleString> names = new ArrayList<SimpleString>();
        ManagementService managementService = this.getManagementService();
        if (managementService != null && address.equals((Object)managementService.getManagementAddress())) {
            return new BindingQueryResult(true, names, autoCreateJmsQueues, autoCreateJmsTopics);
        }
        Bindings bindings = this.getPostOffice().getMatchingBindings(address);
        for (Binding binding : bindings.getBindings()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE && binding.getType() != BindingType.REMOTE_QUEUE) continue;
            names.add(binding.getUniqueName());
        }
        return new BindingQueryResult(!names.isEmpty(), names, autoCreateJmsQueues, autoCreateJmsTopics);
    }

    @Override
    public QueueQueryResult queueQuery(SimpleString name) {
        QueueQueryResult response;
        SimpleString managementAddress;
        if (name == null) {
            throw ActiveMQMessageBundle.BUNDLE.queueNameIsNull();
        }
        boolean autoCreateJmsQueues = name.toString().startsWith("jms.queue.") && this.getAddressSettingsRepository().getMatch(name.toString()).isAutoCreateJmsQueues();
        Binding binding = this.getPostOffice().getBinding(name);
        SimpleString simpleString = managementAddress = this.getManagementService() != null ? this.getManagementService().getManagementAddress() : null;
        if (binding != null && binding.getType() == BindingType.LOCAL_QUEUE) {
            Queue queue = (Queue)binding.getBindable();
            Filter filter = queue.getFilter();
            SimpleString filterString = filter == null ? null : filter.getFilterString();
            response = new QueueQueryResult(name, binding.getAddress(), queue.isDurable(), queue.isTemporary(), filterString, queue.getConsumerCount(), queue.getMessageCount(), autoCreateJmsQueues);
        } else {
            response = name.equals((Object)managementAddress) ? new QueueQueryResult(name, managementAddress, true, false, null, -1, -1L, autoCreateJmsQueues) : (autoCreateJmsQueues ? new QueueQueryResult(name, name, true, false, null, 0, 0L, true, false) : new QueueQueryResult(null, null, false, false, null, 0, 0L, false, false));
        }
        return response;
    }

    @Override
    public void threadDump() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        Map<Thread, StackTraceElement[]> stackTrace = Thread.getAllStackTraces();
        out.println(ActiveMQMessageBundle.BUNDLE.generatingThreadDump());
        out.println("*******************************************************************************");
        for (Map.Entry<Thread, StackTraceElement[]> el : stackTrace.entrySet()) {
            out.println("===============================================================================");
            out.println(ActiveMQMessageBundle.BUNDLE.threadDump(el.getKey(), el.getKey().getName(), el.getKey().getId(), el.getKey().getThreadGroup()));
            out.println();
            for (StackTraceElement traceEl : el.getValue()) {
                out.println(traceEl);
            }
        }
        out.println("===============================================================================");
        out.println(ActiveMQMessageBundle.BUNDLE.endThreadDump());
        out.println("*******************************************************************************");
        ActiveMQServerLogger.LOGGER.threadDump(str.toString());
    }

    @Override
    public final void stop(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false, false);
    }

    @Override
    public QueueCreator getJMSDestinationCreator() {
        return this.jmsQueueCreator;
    }

    @Override
    public void setJMSQueueCreator(QueueCreator jmsQueueCreator) {
        this.jmsQueueCreator = jmsQueueCreator;
    }

    @Override
    public QueueDeleter getJMSQueueDeleter() {
        return this.jmsQueueDeleter;
    }

    @Override
    public void setJMSQueueDeleter(QueueDeleter jmsQueueDeleter) {
        this.jmsQueueDeleter = jmsQueueDeleter;
    }

    @Override
    public boolean isReplicaSync() {
        if (this.activation instanceof SharedNothingLiveActivation) {
            ReplicationManager replicationManager = this.getReplicationManager();
            if (replicationManager == null) {
                return false;
            }
            return !replicationManager.isSynchronizing();
        }
        if (this.activation instanceof SharedNothingBackupActivation) {
            return ((SharedNothingBackupActivation)this.activation).isRemoteBackupUpToDate();
        }
        throw ActiveMQMessageBundle.BUNDLE.methodNotApplicable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting) {
        ActiveMQServerImpl activeMQServerImpl = this;
        synchronized (activeMQServerImpl) {
            if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
                return;
            }
            this.state = SERVER_STATE.STOPPING;
            if (this.fileStoreMonitor != null) {
                this.fileStoreMonitor.stop();
                this.fileStoreMonitor = null;
            }
            if (failoverOnServerShutdown) {
                this.activation.sendLiveIsStopping();
            }
            ActiveMQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                ActiveMQServerImpl.stopComponent(this.groupingHandler);
            }
            ActiveMQServerImpl.stopComponent(this.clusterManager);
            if (this.remotingService != null) {
                this.remotingService.pauseAcceptors();
            }
            if (this.remotingService != null && this.configuration.isGracefulShutdownEnabled()) {
                long timeout = this.configuration.getGracefulShutdownTimeout();
                try {
                    if (timeout == -1L) {
                        this.remotingService.getConnectionCountLatch().await();
                    } else {
                        this.remotingService.getConnectionCountLatch().await(timeout);
                    }
                }
                catch (InterruptedException e) {
                    ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.remotingService.getClass().getName());
                }
            }
            this.freezeConnections();
        }
        this.activation.postConnectionFreeze();
        this.closeAllServerSessions(criticalIOError);
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
        this.callDeActiveCallbacks();
        ActiveMQServerImpl.stopComponent(this.backupManager);
        try {
            this.activation.preStorageClose();
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.activation.getClass().getName());
        }
        ActiveMQServerImpl.stopComponent(this.pagingManager);
        if (this.storageManager != null) {
            try {
                this.storageManager.stop(criticalIOError, failoverOnServerShutdown);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.storageManager.getClass().getName());
            }
        }
        if (this.remotingService != null) {
            try {
                this.remotingService.stop(criticalIOError);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.remotingService.getClass().getName());
            }
        }
        if (this.managementService != null) {
            try {
                this.managementService.unregisterServer();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.managementService.getClass().getName());
            }
        }
        ActiveMQServerImpl.stopComponent(this.managementService);
        ActiveMQServerImpl.stopComponent(this.resourceManager);
        ActiveMQServerImpl.stopComponent(this.postOffice);
        if (this.scheduledPool != null && !this.scheduledPoolSupplied) {
            this.scheduledPool.shutdownNow();
        }
        ActiveMQServerImpl.stopComponent(this.memoryManager);
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.stop();
        }
        if (this.threadPool != null && !this.threadPoolSupplied) {
            this.shutdownPool(this.threadPool);
        }
        if (this.ioExecutorPool != null) {
            this.shutdownPool(this.ioExecutorPool);
        }
        if (!this.threadPoolSupplied) {
            this.threadPool = null;
        }
        if (!this.scheduledPoolSupplied) {
            this.scheduledPool = null;
        }
        if (this.securityStore != null) {
            try {
                this.securityStore.stop();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.managementService.getClass().getName());
            }
        }
        this.pagingManager = null;
        this.securityStore = null;
        this.resourceManager = null;
        this.postOffice = null;
        this.queueFactory = null;
        this.resourceManager = null;
        this.messagingServerControl = null;
        this.memoryManager = null;
        this.backupManager = null;
        this.storageManager = null;
        this.sessions.clear();
        this.state = SERVER_STATE.STOPPED;
        this.activationLatch.setCount(1);
        SimpleString tempNodeID = this.getNodeID();
        if (this.activation != null) {
            try {
                this.activation.close(failoverOnServerShutdown, restarting);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.activation.getClass().getName());
            }
        }
        if (this.backupActivationThread != null) {
            try {
                this.backupActivationThread.join(30000L);
            }
            catch (InterruptedException e) {
                ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.backupActivationThread.getClass().getName());
            }
            if (this.backupActivationThread.isAlive()) {
                ActiveMQServerLogger.LOGGER.backupActivationDidntFinish(this);
                this.backupActivationThread.interrupt();
            }
        }
        ActiveMQServerImpl.stopComponent(this.nodeManager);
        this.nodeManager = null;
        this.addressSettingsRepository.clearListeners();
        this.addressSettingsRepository.clearCache();
        this.scaledDownNodeIDs.clear();
        for (ActiveMQComponent externalComponent : this.externalComponents) {
            try {
                externalComponent.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(e, externalComponent.getClass().getName());
            }
        }
        if (this.identity != null) {
            ActiveMQServerLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        } else {
            ActiveMQServerLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        }
    }

    private void shutdownPool(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                ActiveMQServerLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                for (Runnable r : executorService.shutdownNow()) {
                    logger.debug((Object)("Cancelled the execution of " + r));
                }
            }
        }
        catch (InterruptedException e) {
            ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.threadPool.getClass().getName());
        }
    }

    public boolean checkLiveIsNotColocated(String nodeId) {
        if (this.parentServer == null) {
            return true;
        }
        return !this.parentServer.getNodeID().toString().equals(nodeId);
    }

    private void freezeConnections() {
        this.activation.freezeConnections(this.remotingService);
        for (ServerSession serverSession : this.sessions.values()) {
            try {
                serverSession.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSession(e);
            }
        }
    }

    private void closeAllServerSessions(boolean criticalIOError) {
        if (this.state != SERVER_STATE.STOPPING) {
            return;
        }
        for (ServerSession session : this.sessions.values()) {
            try {
                session.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
        if (!criticalIOError) {
            for (ServerSession session : this.sessions.values()) {
                try {
                    session.waitContextCompletion();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
                }
            }
        }
    }

    static void stopComponent(ActiveMQComponent component) {
        try {
            if (component != null) {
                component.stop();
            }
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, component.getClass().getName());
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(ActiveMQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String destroyConnectionWithSessionMetadata(String metaKey, String parameterValue) throws Exception {
        StringBuffer operationsExecuted = new StringBuffer();
        try {
            operationsExecuted.append("**************************************************************************************************\n");
            operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataHeader(metaKey, parameterValue) + "\n");
            Set<ServerSession> allSessions = this.getSessions();
            ServerSession sessionFound = null;
            for (ServerSession session : allSessions) {
                try {
                    String value = session.getMetaData(metaKey);
                    if (value == null || !value.equals(parameterValue)) continue;
                    sessionFound = session;
                    operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataClosingConnection(sessionFound.toString()) + "\n");
                    RemotingConnection conn = session.getRemotingConnection();
                    if (conn != null) {
                        conn.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataSendException(metaKey, parameterValue));
                    }
                    session.close(true);
                    this.sessions.remove(session.getName());
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
            if (sessionFound == null) {
                operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataNoSessionFound(metaKey, parameterValue) + "\n");
            }
            operationsExecuted.append("**************************************************************************************************");
            String string = operationsExecuted.toString();
            return string;
        }
        finally {
            ActiveMQServerLogger.LOGGER.info(operationsExecuted.toString());
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public ActiveMQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context) throws Exception {
        String validatedUser = "";
        if (this.securityStore != null) {
            X509Certificate[] certificates = null;
            if (connection.getTransportConnection() instanceof NettyConnection) {
                certificates = CertificateUtil.getCertsFromChannel((Channel)((NettyConnection)connection.getTransportConnection()).getChannel());
            }
            validatedUser = this.securityStore.authenticate(username, password, certificates);
        }
        this.checkSessionLimit(validatedUser);
        ServerSessionImpl session = this.internalCreateSession(name, username, password, validatedUser, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context, autoCreateQueues);
        this.sessions.put(name, session);
        return session;
    }

    private void checkSessionLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxConnections() == -1) {
                return;
            }
            if (limits.getMaxConnections() == 0 || this.getSessionCountForUser(username) >= limits.getMaxConnections()) {
                throw ActiveMQMessageBundle.BUNDLE.sessionLimitReached(username, limits.getMaxConnections());
            }
        }
    }

    private int getSessionCountForUser(String username) {
        int sessionCount = 0;
        for (Map.Entry<String, ServerSession> sessionEntry : this.sessions.entrySet()) {
            if (!sessionEntry.getValue().getUsername().equals(username)) continue;
            ++sessionCount;
        }
        return sessionCount;
    }

    @Override
    public void checkQueueCreationLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxQueues() == -1) {
                return;
            }
            if (limits.getMaxQueues() == 0 || this.getQueueCountForUser(username) >= limits.getMaxQueues()) {
                throw ActiveMQMessageBundle.BUNDLE.queueLimitReached(username, limits.getMaxQueues());
            }
        }
    }

    public int getQueueCountForUser(String username) throws Exception {
        Map<SimpleString, Binding> bindings = this.postOffice.getAllBindings();
        int queuesForUser = 0;
        for (Binding binding : bindings.values()) {
            if (!(binding instanceof LocalQueueBinding) || !((LocalQueueBinding)binding).getQueue().getUser().equals((Object)SimpleString.toSimpleString((String)username))) continue;
            ++queuesForUser;
        }
        return queuesForUser;
    }

    protected ServerSessionImpl internalCreateSession(String name, String username, String password, String validatedUser, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context, boolean autoCreateJMSQueues) throws Exception {
        return new ServerSessionImpl(name, username, password, validatedUser, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback, context, autoCreateJMSQueues ? this.jmsQueueCreator : null, this.pagingManager);
    }

    @Override
    public SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public ServerSession lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return session;
        }
        return null;
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    @Override
    public boolean isActive() {
        return this.activationLatch.getCount() < 1;
    }

    @Override
    public boolean waitForActivation(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activationLatch.await(timeout, unit);
    }

    @Override
    public ActiveMQServerControlImpl getActiveMQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public long getTotalConnectionCount() {
        return this.remotingService.getTotalConnectionCount();
    }

    @Override
    public long getTotalMessageCount() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessageCount();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAdded() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAdded();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAcknowledged() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAcknowledged();
        }
        return total;
    }

    @Override
    public long getTotalConsumerCount() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += (long)((LocalQueueBinding)binding).getQueue().getConsumerCount();
        }
        return total;
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, null, durable, temporary, false, false, false);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, queueName, filterString, user, durable, temporary, false, false, false);
    }

    @Override
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean autoCreated) throws Exception {
        return this.createQueue(address, queueName, filterString, user, durable, temporary, false, false, autoCreated);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString name, SimpleString filterString, SimpleString user, boolean durable) throws Exception {
        if (address == null) {
            throw new NullPointerException("address can't be null!");
        }
        Queue queue = this.createQueue(address, name, filterString, user, durable, !durable, true, !durable, false);
        if (!queue.getAddress().equals((Object)address)) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentAddress(name);
        }
        if (filterString != null && (queue.getFilter() == null || !queue.getFilter().getFilterString().equals((Object)filterString)) || filterString == null && queue.getFilter() != null) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentFilter(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transient Queue " + name + " created on address " + name + " with filter=" + filterString));
        }
    }

    @Override
    public Queue locateQueue(SimpleString queueName) {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString resourceName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.deployQueue(address, resourceName, filterString, durable, temporary, false);
    }

    @Override
    public Queue deployQueue(SimpleString address, SimpleString resourceName, SimpleString filterString, boolean durable, boolean temporary, boolean autoCreated) throws Exception {
        if (resourceName.toString().toLowerCase().startsWith("jms.topic")) {
            ActiveMQServerLogger.LOGGER.deployTopic(resourceName);
        } else {
            ActiveMQServerLogger.LOGGER.deployQueue(resourceName);
        }
        return this.createQueue(address, resourceName, filterString, null, durable, temporary, true, false, autoCreated);
    }

    @Override
    public void destroyQueue(SimpleString queueName) throws Exception {
        this.destroyQueue(queueName, null, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session) throws Exception {
        this.destroyQueue(queueName, session, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers) throws Exception {
        this.addressSettingsRepository.clearCache();
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        SimpleString address = binding.getAddress();
        Queue queue = (Queue)binding.getBindable();
        if (checkConsumerCount && queue.getConsumerCount() != 0) {
            throw ActiveMQMessageBundle.BUNDLE.cannotDeleteQueue(queue.getName(), queueName, binding.getClass().getName());
        }
        if (session != null) {
            if (queue.isDurable()) {
                this.securityStore.check(address, CheckType.DELETE_DURABLE_QUEUE, session);
            } else {
                this.securityStore.check(address, CheckType.DELETE_NON_DURABLE_QUEUE, session);
            }
        }
        queue.deleteQueue(removeConsumers);
        this.callPostQueueDeletionCallbacks(address, queueName);
    }

    @Override
    public void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public void registerActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.add(listener);
    }

    @Override
    public void unregisterActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.remove(listener);
    }

    @Override
    public void callActivationFailureListeners(Exception e) {
        for (ActivationFailureListener listener : this.activationFailureListeners) {
            listener.activationFailed(e);
        }
    }

    @Override
    public void registerPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueCreationCallbacks(SimpleString queueName) throws Exception {
        for (PostQueueCreationCallback callback : this.postQueueCreationCallbacks) {
            callback.callback(queueName);
        }
    }

    @Override
    public void registerPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueDeletionCallbacks(SimpleString address, SimpleString queueName) throws Exception {
        for (PostQueueDeletionCallback callback : this.postQueueDeletionCallbacks) {
            callback.callback(address, queueName);
        }
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public ExecutorFactory getIOExecutorFactory() {
        return this.ioExecutorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        if (this.groupingHandler != null && this.managementService != null) {
            this.managementService.removeNotificationListener(this.groupingHandler);
        }
        this.groupingHandler = groupingHandler;
        if (this.managementService != null) {
            this.managementService.addNotificationListener(this.groupingHandler);
        }
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.activation.getReplicationManager();
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            throw ActiveMQMessageBundle.BUNDLE.divertWithNoName();
        }
        if (config.getAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoAddress();
            return;
        }
        if (config.getForwardingAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoForwardingAddress();
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            ActiveMQServerLogger.LOGGER.divertBindingAlreadyExists(sName);
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.getServiceRegistry().getDivertTransformer(config.getName(), config.getTransformerClassName());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager);
        DivertBinding binding = new DivertBinding(this.storageManager.generateID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw ActiveMQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name, null, true);
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "ActiveMQServerImpl::" + this.identity;
        }
        return "ActiveMQServerImpl::" + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    protected PagingManager createPagingManager() throws Exception {
        return new PagingManagerImpl(this.getPagingStoreFactory(), this.addressSettingsRepository, this.configuration.getGlobalMaxSize());
    }

    protected PagingStoreFactory getPagingStoreFactory() throws Exception {
        if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
            return new PagingStoreFactoryDatabase(dbConf, this.storageManager, this.configuration.getJournalBufferTimeout_NIO(), this.scheduledPool, this.executorFactory, false, this.shutdownOnCriticalIO);
        }
        return new PagingStoreFactoryNIO(this.storageManager, this.configuration.getPagingLocation(), this.configuration.getJournalBufferTimeout_NIO(), this.scheduledPool, this.executorFactory, this.configuration.isJournalSyncNonTransactional(), this.shutdownOnCriticalIO);
    }

    private StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
                return new JDBCJournalStorageManager(this.configuration, this.getScheduledPool(), this.executorFactory, this.ioExecutorFactory, (IOCriticalErrorListener)this.shutdownOnCriticalIO);
            }
            return new JournalStorageManager(this.configuration, this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.shutdownOnCriticalIO);
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private void callDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            try {
                callback.deActivate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    private void callActivationCompleteCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activationComplete();
        }
    }

    private void initializeExecutorServices() {
        ThreadFactory tFactory;
        if (this.serviceRegistry.getExecutorService() == null) {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-server-" + this.toString(), false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory) : new ActiveMQThreadPoolExecutor(0, this.configuration.getThreadPoolMaxSize(), 60L, TimeUnit.SECONDS, tFactory);
        } else {
            this.threadPool = this.serviceRegistry.getExecutorService();
            this.threadPoolSupplied = true;
        }
        this.executorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        if (this.serviceRegistry.getIOExecutorService() != null) {
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.serviceRegistry.getIOExecutorService());
        } else {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-IO-server-" + this.toString(), false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.ioExecutorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory);
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.ioExecutorPool);
        }
        if (this.serviceRegistry.getScheduledExecutorService() == null) {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-scheduled-threads", false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), tFactory);
        } else {
            this.scheduledPoolSupplied = true;
            this.scheduledPool = this.serviceRegistry.getScheduledExecutorService();
        }
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    synchronized boolean initialisePart1(boolean scalingDown) throws Exception {
        if (this.state == SERVER_STATE.STOPPED) {
            return false;
        }
        this.initializeExecutorServices();
        if (this.configuration.getJournalType() == JournalType.ASYNCIO) {
            if (!AIOSequentialFileFactory.isSupported()) {
                ActiveMQServerLogger.LOGGER.switchingNIO();
                this.configuration.setJournalType(JournalType.NIO);
            } else if (!AIOSequentialFileFactory.isSupported((File)this.configuration.getJournalLocation())) {
                ActiveMQServerLogger.LOGGER.switchingNIOonPath(this.configuration.getJournalLocation().getAbsolutePath());
                this.configuration.setJournalType(JournalType.NIO);
            }
        }
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManager(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if (this.configuration.getClusterConfigurations().size() > 0 && ActiveMQDefaultConfiguration.getDefaultClusterUser().equals(this.configuration.getClusterUser()) && ActiveMQDefaultConfiguration.getDefaultClusterPassword().equals(this.configuration.getClusterPassword())) {
            ActiveMQServerLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getMessageExpiryThreadPriority(), this.configuration.isWildcardRoutingEnabled(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManager(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager, this.haPolicy.isBackup());
        this.backupManager = new BackupManager(this, this.executorFactory, this.scheduledPool, this.nodeManager, this.configuration, this.clusterManager);
        this.clusterManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool, this.protocolManagerFactories, this.executorFactory.getExecutor(), this.serviceRegistry);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.securityStore, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.haPolicy.isBackup());
        if (!scalingDown) {
            this.deployAddressSettingsFromConfiguration();
        }
        this.storageManager.start();
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        this.reloadManager = new ReloadManagerImpl(this.getScheduledPool(), this.executorFactory.getExecutor(), this.configuration.getConfigurationFileRefreshPeriod());
        if (this.configuration.getConfigurationUrl() != null && this.getScheduledPool() != null) {
            this.reloadManager.addCallback(this.configuration.getConfigurationUrl(), new ConfigurationFileReloader());
        }
        return true;
    }

    synchronized void initialisePart2(boolean scalingDown) throws Exception {
        if (this.state == SERVER_STATE.STOPPED || this.state == SERVER_STATE.STOPPING) {
            return;
        }
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ActiveMQServerLogger.LOGGER.dumpServerInfo(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        this.deployQueuesFromConfiguration();
        this.callActivateCallbacks();
        this.checkForPotentialOOMEInAddressConfiguration();
        if (!scalingDown) {
            this.deployDiverts();
            if (this.groupingHandler != null) {
                this.groupingHandler.start();
            }
            if (this.groupingHandler != null && this.groupingHandler instanceof LocalGroupingHandler) {
                this.clusterManager.start();
                this.groupingHandler.awaitBindings();
                this.remotingService.start();
            } else {
                this.remotingService.start();
                this.clusterManager.start();
            }
            if (this.nodeManager.getNodeId() == null) {
                throw ActiveMQMessageBundle.BUNDLE.nodeIdNull();
            }
            this.postOffice.startExpiryScanner();
        }
        try {
            this.injectMonitor(new FileStoreMonitor(this.getScheduledPool(), this.executorFactory.getExecutor(), this.configuration.getDiskScanPeriod(), TimeUnit.MILLISECONDS, (float)this.configuration.getMaxDiskUsage() / 100.0f));
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void injectMonitor(FileStoreMonitor storeMonitor) throws Exception {
        this.fileStoreMonitor = storeMonitor;
        this.pagingManager.injectMonitor(storeMonitor);
        this.storageManager.injectMonitor(storeMonitor);
        this.fileStoreMonitor.start();
    }

    public FileStoreMonitor getMonitor() {
        return this.fileStoreMonitor;
    }

    public void completeActivation() throws Exception {
        this.setState(SERVER_STATE.STARTED);
        this.getRemotingService().startAcceptors();
        this.activationLatch.countDown();
        this.callActivationCompleteCallbacks();
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.setSecurityRepository(this.securityRepository);
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        for (CoreQueueConfiguration config : this.configuration.getQueueConfigurations()) {
            this.deployQueue(SimpleString.toSimpleString((String)config.getAddress()), SimpleString.toSimpleString((String)config.getName()), SimpleString.toSimpleString((String)config.getFilterString()), config.isDurable(), false);
        }
    }

    private void checkForPotentialOOMEInAddressConfiguration() {
        long totalMaxSizeBytes = 0L;
        long addressCount = 0L;
        for (SimpleString address : this.postOffice.getAddresses()) {
            totalMaxSizeBytes += this.addressSettingsRepository.getMatch(address.toString()).getMaxSizeBytes();
            ++addressCount;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (totalMaxSizeBytes >= maxMemory && this.configuration.getGlobalMaxSize() < 0L) {
            ActiveMQServerLogger.LOGGER.potentialOOME(addressCount, totalMaxSizeBytes, maxMemory);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoader journalLoader = this.activation.createJournalLoader(this.postOffice, this.pagingManager, this.storageManager, this.queueFactory, this.nodeManager, this.managementService, this.groupingHandler, this.configuration, this.parentServer);
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        journalLoader.initQueues(queueBindingInfosMap, queueBindingInfos);
        journalLoader.handleGroupingBindings(groupingInfos);
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        LinkedList<PageCountPending> pendingNonTXPageCounter = new LinkedList<PageCountPending>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages, pendingNonTXPageCounter, journalLoader);
        journalLoader.handleDuplicateIds(duplicateIDMap);
        for (Pair<Long, Long> msgToDelete : pendingLargeMessages) {
            ActiveMQServerLogger.LOGGER.deletingPendingMessage(msgToDelete);
            LargeServerMessage msg = this.storageManager.createLargeMessage();
            msg.setMessageID((Long)msgToDelete.getB());
            msg.setPendingRecordID((Long)msgToDelete.getA());
            msg.setDurable(true);
            msg.deleteFile();
        }
        if (pendingNonTXPageCounter.size() != 0) {
            try {
                journalLoader.recoverPendingPageCounters(pendingNonTXPageCounter);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorRecoveringPageCounter(e);
            }
        }
        journalLoader.cleanUp();
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set setRoles = SecurityFormatter.createSecurity((String)roleItem.getSendRoles(), (String)roleItem.getConsumeRoles(), (String)roleItem.getCreateDurableQueueRoles(), (String)roleItem.getDeleteDurableQueueRoles(), (String)roleItem.getCreateNonDurableQueueRoles(), (String)roleItem.getDeleteNonDurableQueueRoles(), (String)roleItem.getManageRoles(), (String)roleItem.getBrowseRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated) throws Exception {
        QueueBinding binding = (QueueBinding)this.postOffice.getBinding(queueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return binding.getQueue();
            }
            throw ActiveMQMessageBundle.BUNDLE.queueAlreadyExists(queueName);
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long txID = this.storageManager.generateID();
        long queueID = this.storageManager.generateID();
        QueueConfig.Builder queueConfigBuilder = address == null ? QueueConfig.builderWith(queueID, queueName) : QueueConfig.builderWith(queueID, queueName, address);
        QueueConfig queueConfig = queueConfigBuilder.filter(filter).pagingManager(this.pagingManager).user(user).durable(durable).temporary(temporary).autoCreated(autoCreated).build();
        Queue queue = this.queueFactory.createQueueWith(queueConfig);
        if (transientQueue) {
            queue.setConsumersRefCount(new TransientQueueManagerImpl(this, queue.getName()));
        } else if (queue.isAutoCreated()) {
            queue.setConsumersRefCount(new AutoCreatedQueueManagerImpl(this.getJMSQueueDeleter(), queue.getName()));
        }
        LocalQueueBinding localQueueBinding = new LocalQueueBinding(queue.getAddress(), queue, this.nodeManager.getNodeId());
        if (queue.isDurable()) {
            this.storageManager.addQueueBinding(txID, localQueueBinding);
        }
        try {
            this.postOffice.addBinding(localQueueBinding);
            if (queue.isDurable()) {
                this.storageManager.commitBindings(txID);
            }
        }
        catch (Exception e) {
            try {
                if (durable) {
                    this.storageManager.rollbackBindings(txID);
                }
                PageSubscription pageSubscription = queue.getPageSubscription();
                try {
                    queue.close();
                }
                finally {
                    if (pageSubscription != null) {
                        pageSubscription.destroy();
                    }
                }
            }
            catch (Throwable ignored) {
                logger.debug((Object)ignored.getMessage(), ignored);
            }
            throw e;
        }
        this.managementService.registerAddress(queue.getAddress());
        this.managementService.registerQueue(queue, queue.getAddress(), this.storageManager);
        this.callPostQueueCreationCallbacks(queue.getName());
        return queue;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupHandlingAbstract groupingHandler1 = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.executorFactory, this.scheduledPool, this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout(), config.getGroupTimeout(), config.getReaperPeriod()) : new RemoteGroupingHandler(this.executorFactory, this.managementService, config.getName(), config.getAddress(), config.getTimeout(), config.getGroupTimeout());
            this.groupingHandler = groupingHandler1;
            this.managementService.addNotificationListener(groupingHandler1);
        }
    }

    public void checkJournalDirectory() {
        File journalDir = this.configuration.getJournalLocation();
        if (!journalDir.exists() && this.configuration.isPersistenceEnabled()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw ActiveMQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
    }

    @Override
    public void addProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.add(factory);
    }

    @Override
    public void removeProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.remove(factory);
    }

    @Override
    public ActiveMQServer createBackupServer(Configuration configuration) {
        return new ActiveMQServerImpl(configuration, null, this.securityManager, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScaledDownNode(SimpleString scaledDownNodeId) {
        List<SimpleString> list = this.scaledDownNodeIDs;
        synchronized (list) {
            this.scaledDownNodeIDs.add(scaledDownNodeId);
            if (this.scaledDownNodeIDs.size() > 10) {
                this.scaledDownNodeIDs.remove(10);
            }
        }
    }

    @Override
    public boolean hasScaledDown(SimpleString scaledDownNodeId) {
        return this.scaledDownNodeIDs.contains(scaledDownNodeId);
    }

    void moveServerData(int maxSavedReplicated) throws IOException {
        File[] dataDirs;
        for (File data : dataDirs = new File[]{this.configuration.getBindingsLocation(), this.configuration.getJournalLocation(), this.configuration.getPagingLocation(), this.configuration.getLargeMessagesLocation()}) {
            FileMoveManager moveManager = new FileMoveManager(data, maxSavedReplicated);
            moveManager.doMove();
        }
    }

    @Override
    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "not started";
        }
        return TimeUtils.printDuration((double)delta);
    }

    @Override
    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    @Override
    public boolean addClientConnection(String clientId, boolean unique) {
        AtomicInteger i = this.connectedClientIds.putIfAbsent(clientId, new AtomicInteger(1));
        if (i != null) {
            if (unique && i.get() != 0) {
                return false;
            }
            if (i.incrementAndGet() > 0) {
                this.connectedClientIds.put(clientId, i);
            }
        }
        return true;
    }

    @Override
    public void removeClientConnection(String clientId) {
        AtomicInteger i = (AtomicInteger)this.connectedClientIds.get(clientId);
        if (i != null && i.decrementAndGet() == 0) {
            this.connectedClientIds.remove(clientId);
        }
    }

    @Override
    public IOCriticalErrorListener getCriticalIOErrorListener() {
        return this.shutdownOnCriticalIO;
    }

    private final class ConfigurationFileReloader
    implements ReloadCallback {
        private ConfigurationFileReloader() {
        }

        @Override
        public void reload(URL uri) throws Exception {
            Configuration config = new FileConfigurationParser().parseMainConfig(uri.openStream());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("security");
            ActiveMQServerImpl.this.securityRepository.swap(config.getSecurityRoles().entrySet());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("address settings");
            ActiveMQServerImpl.this.addressSettingsRepository.swap(config.getAddressesSettings().entrySet());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("diverts");
            for (DivertConfiguration divertConfig : config.getDivertConfigurations()) {
                if (ActiveMQServerImpl.this.postOffice.getBinding(new SimpleString(divertConfig.getName())) != null) continue;
                ActiveMQServerImpl.this.deployDivert(divertConfig);
            }
        }
    }

    private final class ActivationThread
    extends Thread {
        final Runnable runnable;

        ActivationThread(Runnable runnable, String name) {
            super(name);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ActiveMQServerImpl.this.lockActivation();
            try {
                this.runnable.run();
            }
            finally {
                ActiveMQServerImpl.this.unlockActivation();
            }
        }
    }

    public final class ShutdownOnCriticalErrorListener
    implements IOCriticalErrorListener {
        boolean failedAlready = false;

        public synchronized void onIOException(Throwable cause, String message, SequentialFile file) {
            if (!this.failedAlready) {
                this.failedAlready = true;
                if (file == null) {
                    ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, "NULL", cause);
                } else {
                    ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, file.toString(), cause);
                }
                ActiveMQServerImpl.this.stopTheServer(true);
            }
        }
    }

    static enum SERVER_STATE {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

