/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static ClusterConnectionConfiguration getReplicationClusterConfiguration(Configuration conf, String replicationCluster) throws ActiveMQIllegalStateException {
        if (replicationCluster == null || replicationCluster.isEmpty()) {
            return conf.getClusterConfigurations().get(0);
        }
        for (ClusterConnectionConfiguration clusterConf : conf.getClusterConfigurations()) {
            if (!replicationCluster.equals(clusterConf.getName())) continue;
            return clusterConf;
        }
        throw new ActiveMQIllegalStateException("Missing cluster-configuration for replication-clustername '" + replicationCluster + "'.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HAPolicy getHAPolicy(HAPolicyConfiguration conf, ActiveMQServer server) throws ActiveMQIllegalStateException {
        if (conf == null) {
            return new LiveOnlyPolicy();
        }
        switch (conf.getType()) {
            case LIVE_ONLY: {
                LiveOnlyPolicyConfiguration pc = (LiveOnlyPolicyConfiguration)conf;
                return new LiveOnlyPolicy(ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()));
            }
            case REPLICATED: {
                ReplicatedPolicyConfiguration pc = (ReplicatedPolicyConfiguration)conf;
                return new ReplicatedPolicy(pc.isCheckForLiveServer(), pc.getGroupName(), pc.getClusterName(), pc.getInitialReplicationSyncTimeout(), server.getNetworkHealthCheck(), pc.getVoteOnReplicationFailure(), pc.getQuorumSize());
            }
            case REPLICA: {
                ReplicaPolicyConfiguration pc = (ReplicaPolicyConfiguration)conf;
                return new ReplicaPolicy(pc.getClusterName(), pc.getMaxSavedReplicatedJournalsSize(), pc.getGroupName(), pc.isRestartBackup(), pc.isAllowFailBack(), pc.getInitialReplicationSyncTimeout(), ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()), server.getNetworkHealthCheck(), pc.getVoteOnReplicationFailure(), pc.getQuorumSize());
            }
            case SHARED_STORE_MASTER: {
                SharedStoreMasterPolicyConfiguration pc = (SharedStoreMasterPolicyConfiguration)conf;
                return new SharedStoreMasterPolicy(pc.isFailoverOnServerShutdown());
            }
            case SHARED_STORE_SLAVE: {
                SharedStoreSlavePolicyConfiguration pc = (SharedStoreSlavePolicyConfiguration)conf;
                return new SharedStoreSlavePolicy(pc.isFailoverOnServerShutdown(), pc.isRestartBackup(), pc.isAllowFailBack(), ConfigurationUtils.getScaleDownPolicy(pc.getScaleDownConfiguration()));
            }
            case COLOCATED: {
                BackupPolicy backupPolicy;
                ColocatedPolicyConfiguration pc = (ColocatedPolicyConfiguration)conf;
                HAPolicyConfiguration liveConf = pc.getLiveConfig();
                HAPolicy<LiveActivation> livePolicy = liveConf == null ? new ReplicatedPolicy(server.getNetworkHealthCheck()) : ConfigurationUtils.getHAPolicy(liveConf, server);
                HAPolicyConfiguration backupConf = pc.getBackupConfig();
                if (backupConf == null) {
                    if (livePolicy instanceof ReplicatedPolicy) {
                        backupPolicy = new ReplicaPolicy(server.getNetworkHealthCheck());
                    } else {
                        if (!(livePolicy instanceof SharedStoreMasterPolicy)) throw ActiveMQMessageBundle.BUNDLE.liveBackupMismatch();
                        backupPolicy = new SharedStoreSlavePolicy();
                    }
                } else {
                    backupPolicy = (BackupPolicy)ConfigurationUtils.getHAPolicy(backupConf, server);
                }
                if ((!(livePolicy instanceof ReplicatedPolicy) || backupPolicy instanceof ReplicaPolicy) && (!(livePolicy instanceof SharedStoreMasterPolicy) || backupPolicy instanceof SharedStoreSlavePolicy)) return new ColocatedPolicy(pc.isRequestBackup(), pc.getBackupRequestRetries(), pc.getBackupRequestRetryInterval(), pc.getMaxBackups(), pc.getBackupPortOffset(), pc.getExcludedConnectors(), livePolicy, backupPolicy);
                throw ActiveMQMessageBundle.BUNDLE.liveBackupMismatch();
            }
        }
        throw ActiveMQMessageBundle.BUNDLE.unsupportedHAPolicyConfiguration(conf);
    }

    public static ScaleDownPolicy getScaleDownPolicy(ScaleDownConfiguration scaleDownConfiguration) {
        if (scaleDownConfiguration != null) {
            if (scaleDownConfiguration.getDiscoveryGroup() != null) {
                return new ScaleDownPolicy(scaleDownConfiguration.getDiscoveryGroup(), scaleDownConfiguration.getGroupName(), scaleDownConfiguration.getClusterName(), scaleDownConfiguration.isEnabled());
            }
            return new ScaleDownPolicy(scaleDownConfiguration.getConnectors(), scaleDownConfiguration.getGroupName(), scaleDownConfiguration.getClusterName(), scaleDownConfiguration.isEnabled());
        }
        return null;
    }

    public static void validateConfiguration(Configuration configuration) {
        ConfigurationUtils.compareTTLWithCheckPeriod(configuration);
    }

    private static void compareTTLWithCheckPeriod(Configuration configuration) {
        for (ClusterConnectionConfiguration clusterConnectionConfiguration : configuration.getClusterConfigurations()) {
            ConfigurationUtils.compareTTLWithCheckPeriod(clusterConnectionConfiguration.getName(), clusterConnectionConfiguration.getConnectionTTL(), configuration.getConnectionTTLOverride(), clusterConnectionConfiguration.getClientFailureCheckPeriod());
        }
        for (BridgeConfiguration bridgeConfiguration : configuration.getBridgeConfigurations()) {
            ConfigurationUtils.compareTTLWithCheckPeriod(bridgeConfiguration.getName(), bridgeConfiguration.getConnectionTTL(), configuration.getConnectionTTLOverride(), bridgeConfiguration.getClientFailureCheckPeriod());
        }
    }

    private static void compareTTLWithCheckPeriod(String name, long connectionTTL, long connectionTTLOverride, long checkPeriod) {
        if (connectionTTLOverride == checkPeriod) {
            ActiveMQServerLogger.LOGGER.connectionTTLEqualsCheckPeriod(name, "connection-ttl-override", "check-period");
        }
        if (connectionTTL == checkPeriod) {
            ActiveMQServerLogger.LOGGER.connectionTTLEqualsCheckPeriod(name, "connection-ttl", "check-period");
        }
    }
}

