/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.server.DivertConfigurationRoutingType;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class DivertConfiguration
implements Serializable {
    private static final long serialVersionUID = 6910543740464269629L;
    private String name = null;
    private String routingName = UUIDGenerator.getInstance().generateStringUUID();
    private String address = null;
    private String forwardingAddress = null;
    private boolean exclusive = ActiveMQDefaultConfiguration.isDefaultDivertExclusive();
    private String filterString = null;
    private String transformerClassName = null;
    private DivertConfigurationRoutingType routingType = DivertConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());

    public String getName() {
        return this.name;
    }

    public String getRoutingName() {
        return this.routingName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public DivertConfigurationRoutingType getRoutingType() {
        return this.routingType;
    }

    public DivertConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DivertConfiguration setRoutingName(String routingName) {
        this.routingName = routingName == null ? UUIDGenerator.getInstance().generateStringUUID() : routingName;
        return this;
    }

    public DivertConfiguration setAddress(String address) {
        this.address = address;
        return this;
    }

    public DivertConfiguration setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
        return this;
    }

    public DivertConfiguration setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        return this;
    }

    public DivertConfiguration setFilterString(String filterString) {
        this.filterString = filterString;
        return this;
    }

    public DivertConfiguration setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
        return this;
    }

    public DivertConfiguration setRoutingType(DivertConfigurationRoutingType routingType) {
        this.routingType = routingType;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.exclusive ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.forwardingAddress == null ? 0 : this.forwardingAddress.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.routingName == null ? 0 : this.routingName.hashCode());
        result = 31 * result + (this.transformerClassName == null ? 0 : this.transformerClassName.hashCode());
        result = 31 * result + (this.routingType == null ? 0 : this.routingType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DivertConfiguration other = (DivertConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.forwardingAddress == null ? other.forwardingAddress != null : !this.forwardingAddress.equals(other.forwardingAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.routingName == null ? other.routingName != null : !this.routingName.equals(other.routingName)) {
            return false;
        }
        if (this.transformerClassName == null ? other.transformerClassName != null : !this.transformerClassName.equals(other.transformerClassName)) {
            return false;
        }
        return !(this.routingType == null ? other.routingType != null : !this.routingType.equals((Object)other.routingType));
    }
}

