/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.JsonLoader;

public class AddressControlImpl
extends AbstractControl
implements AddressControl {
    private AddressInfo addressInfo;
    private final PostOffice postOffice;
    private final PagingManager pagingManager;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final SecurityStore securityStore;
    private final ManagementService managementService;

    public AddressControlImpl(AddressInfo addressInfo, PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, HierarchicalRepository<Set<Role>> securityRepository, SecurityStore securityStore, ManagementService managementService) throws Exception {
        super(AddressControl.class, storageManager);
        this.addressInfo = addressInfo;
        this.postOffice = postOffice;
        this.pagingManager = pagingManager;
        this.securityRepository = securityRepository;
        this.securityStore = securityStore;
        this.managementService = managementService;
    }

    public String getAddress() {
        return this.addressInfo.getName().toString();
    }

    public Set<RoutingType> getDeliveryModes() {
        return this.addressInfo.getRoutingTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeliveryModesAsJSON() throws Exception {
        this.clearIO();
        try {
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            Set<RoutingType> routingTypes = this.getDeliveryModes();
            for (RoutingType routingType : routingTypes) {
                json.add(routingType.toString());
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getQueueNames() throws Exception {
        this.clearIO();
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.addressInfo.getName());
            ArrayList<String> queueNames = new ArrayList<String>();
            for (Binding binding : bindings.getBindings()) {
                if (!(binding instanceof QueueBinding)) continue;
                queueNames.add(binding.getUniqueName().toString());
            }
            String[] stringArray = queueNames.toArray(new String[queueNames.size()]);
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getBindingNames() throws Exception {
        this.clearIO();
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.addressInfo.getName());
            String[] bindingNames = new String[bindings.getBindings().size()];
            int i = 0;
            for (Binding binding : bindings.getBindings()) {
                bindingNames[i++] = binding.getUniqueName().toString();
            }
            String[] stringArray = bindingNames;
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRoles() throws Exception {
        this.clearIO();
        try {
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = new Object[]{role.getName(), CheckType.SEND.hasRole(role), CheckType.CONSUME.hasRole(role), CheckType.CREATE_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_DURABLE_QUEUE.hasRole(role), CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), CheckType.MANAGE.hasRole(role)};
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRolesAsJSON() throws Exception {
        this.clearIO();
        try {
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            for (Role role : roles) {
                json.add((JsonValue)role.toJson());
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getNumberOfBytesPerPage() throws Exception {
        this.clearIO();
        try {
            long l = this.pagingManager.getPageStore(this.addressInfo.getName()).getPageSizeBytes();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getAddressSize() throws Exception {
        this.clearIO();
        try {
            long l = this.pagingManager.getPageStore(this.addressInfo.getName()).getAddressSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getNumberOfMessages() throws Exception {
        this.clearIO();
        long totalMsgs = 0L;
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.addressInfo.getName());
            for (Binding binding : bindings.getBindings()) {
                if (!(binding instanceof QueueBinding)) continue;
                totalMsgs += ((QueueBinding)binding).getQueue().getMessageCount();
            }
            long l = totalMsgs;
            return l;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaging() throws Exception {
        this.clearIO();
        try {
            boolean bl = this.pagingManager.getPageStore(this.addressInfo.getName()).isPaging();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getNumberOfPages() throws Exception {
        this.clearIO();
        try {
            PagingStore pageStore = this.pagingManager.getPageStore(this.addressInfo.getName());
            if (!pageStore.isPaging()) {
                int n = 0;
                return n;
            }
            int n = this.pagingManager.getPageStore(this.addressInfo.getName()).getNumberOfPages();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessageCount() {
        return this.getMessageCount(DurabilityType.ALL);
    }

    public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, final String user, final String password) throws Exception {
        try {
            this.securityStore.check(this.addressInfo.getName(), CheckType.SEND, new SecurityAuth(){

                @Override
                public String getUsername() {
                    return user;
                }

                @Override
                public String getPassword() {
                    return password;
                }

                @Override
                public RemotingConnection getRemotingConnection() {
                    return null;
                }
            });
            CoreMessage message = new CoreMessage(this.storageManager.generateID(), 50);
            for (String header : headers.keySet()) {
                message.putStringProperty(new SimpleString(header), new SimpleString(headers.get(header)));
            }
            message.setType((byte)type);
            message.setDurable(durable);
            message.setTimestamp(System.currentTimeMillis());
            if (body != null) {
                message.getBodyBuffer().writeBytes(Base64.decode((String)body));
            }
            message.setAddress(this.addressInfo.getName());
            this.postOffice.route((Message)message, true);
            return "" + message.getMessageID();
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AddressControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AddressControl.class);
    }

    private int getMessageCount(DurabilityType durability) {
        List<QueueControl> queues = this.getQueues(durability);
        int count = 0;
        for (QueueControl queue : queues) {
            count = (int)((long)count + queue.getMessageCount());
        }
        return count;
    }

    private List<QueueControl> getQueues(DurabilityType durability) {
        try {
            String[] queues;
            ArrayList<QueueControl> matchingQueues = new ArrayList<QueueControl>();
            for (String queue : queues = this.getQueueNames()) {
                QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("queue." + queue);
                if (coreQueueControl == null || coreQueueControl.getName().equals(this.getAddress()) || durability != DurabilityType.ALL && (durability != DurabilityType.DURABLE || !coreQueueControl.isDurable()) && (durability != DurabilityType.NON_DURABLE || coreQueueControl.isDurable())) continue;
                matchingQueues.add(coreQueueControl);
            }
            return matchingQueues;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private static enum DurabilityType {
        ALL,
        DURABLE,
        NON_DURABLE;

    }
}

