/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;

public class PagedMessageImpl
implements PagedMessage {
    private byte[] largeMessageLazyData;
    private Message message;
    private long[] queueIDs;
    private long transactionID = 0L;
    private volatile StorageManager storageManager;

    public PagedMessageImpl(Message message, long[] queueIDs, long transactionID) {
        this(message, queueIDs);
        this.transactionID = transactionID;
    }

    public PagedMessageImpl(Message message, long[] queueIDs) {
        this.queueIDs = queueIDs;
        this.message = message;
    }

    public PagedMessageImpl(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void initMessage(StorageManager storage) {
        if (this.largeMessageLazyData != null) {
            LargeServerMessage lgMessage = storage.createLargeMessage();
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((byte[])this.largeMessageLazyData);
            LargeMessagePersister.getInstance().decode(buffer, lgMessage);
            ((LargeServerMessage)this.message).incrementDelayDeletionCount();
            this.message = lgMessage;
            this.largeMessageLazyData = null;
        }
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public long[] getQueueIDs() {
        return this.queueIDs;
    }

    public void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        boolean isLargeMessage = buffer.readBoolean();
        if (isLargeMessage) {
            int largeMessageHeaderSize = buffer.readInt();
            if (this.storageManager == null) {
                this.largeMessageLazyData = new byte[largeMessageHeaderSize];
                buffer.readBytes(this.largeMessageLazyData);
            } else {
                this.message = this.storageManager.createLargeMessage();
                LargeMessagePersister.getInstance().decode(buffer, (LargeServerMessage)this.message);
                ((LargeServerMessage)this.message).incrementDelayDeletionCount();
            }
        } else {
            this.message = MessagePersister.getInstance().decode(buffer, null);
        }
        int queueIDsSize = buffer.readInt();
        this.queueIDs = new long[queueIDsSize];
        for (int i = 0; i < queueIDsSize; ++i) {
            this.queueIDs[i] = buffer.readLong();
        }
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        boolean isLargeMessage = this.isLargeMessage();
        buffer.writeBoolean(isLargeMessage);
        if (isLargeMessage) {
            buffer.writeInt(LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)this.message));
            LargeMessagePersister.getInstance().encode(buffer, (LargeServerMessage)this.message);
        } else {
            this.message.getPersister().encode(buffer, (Object)this.message);
        }
        buffer.writeInt(this.queueIDs.length);
        for (long queueID : this.queueIDs) {
            buffer.writeLong(queueID);
        }
    }

    public boolean isLargeMessage() {
        return this.message instanceof ICoreMessage && ((ICoreMessage)this.message).isLargeMessage();
    }

    public int getEncodeSize() {
        if (this.isLargeMessage()) {
            return 13 + LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)this.message) + 4 + this.queueIDs.length * 8;
        }
        return 9 + this.message.getPersister().getEncodeSize((Object)this.message) + 4 + this.queueIDs.length * 8;
    }

    public String toString() {
        return "PagedMessageImpl [queueIDs=" + Arrays.toString(this.queueIDs) + ", transactionID=" + this.transactionID + ", message=" + this.message + "]";
    }
}

