/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.jboss.logging.Logger;

public final class LargeServerMessageImpl
extends CoreMessage
implements LargeServerMessage {
    private static final Logger logger = Logger.getLogger(LargeServerMessageImpl.class);
    private final JournalStorageManager storageManager;
    private long pendingRecordID = -1L;
    private boolean paged;
    private SequentialFile file;
    private SequentialFile pendingCopy;
    private long bodySize = -1L;
    private final AtomicInteger delayDeletionCount = new AtomicInteger(0);
    private volatile int memoryEstimate = -1;

    public LargeServerMessageImpl(JournalStorageManager storageManager) {
        this.storageManager = storageManager;
    }

    private LargeServerMessageImpl(LargeServerMessageImpl copy, TypedProperties properties, SequentialFile fileCopy, long newID) {
        super((CoreMessage)copy, properties);
        this.storageManager = copy.storageManager;
        this.file = fileCopy;
        this.bodySize = copy.bodySize;
        this.setMessageID(newID);
    }

    private static String toDate(long timestamp) {
        if (timestamp == 0L) {
            return "0";
        }
        return new Date(timestamp).toString();
    }

    public boolean isServerMessage() {
        return true;
    }

    @Override
    public long getPendingRecordID() {
        return this.pendingRecordID;
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
        this.pendingRecordID = pendingRecordID;
    }

    @Override
    public void setPaged() {
        this.paged = true;
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.validateFile();
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.storageManager.addBytesToLargeMessage(this.file, this.getMessageID(), bytes);
        this.bodySize += (long)bytes.length;
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    public void encode(ActiveMQBuffer buffer1) {
        super.encodeHeadersAndProperties(buffer1.byteBuf());
    }

    public void decode(ActiveMQBuffer buffer1) {
        this.file = null;
        super.decodeHeadersAndProperties(buffer1.byteBuf());
    }

    @Override
    public synchronized void incrementDelayDeletionCount() {
        this.delayDeletionCount.incrementAndGet();
        try {
            this.incrementRefCount();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorIncrementDelayDeletionCount(e);
        }
    }

    @Override
    public synchronized void decrementDelayDeletionCount() throws Exception {
        int count = this.delayDeletionCount.decrementAndGet();
        this.decrementRefCount();
        if (count == 0) {
            this.checkDelete();
        }
    }

    public LargeBodyEncoder getBodyEncoder() throws ActiveMQException {
        this.validateFile();
        return new DecodingContext();
    }

    private void checkDelete() throws Exception {
        if (this.getRefCount() <= 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Deleting file " + this.file + " as the usage was complete"));
            }
            try {
                this.deleteFile();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public synchronized int decrementRefCount() throws Exception {
        int currentRefCount = super.decrementRefCount();
        if (this.delayDeletionCount.get() <= 0) {
            this.checkDelete();
        }
        return currentRefCount;
    }

    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.validateFile();
        this.releaseResources();
        this.storageManager.deleteLargeMessageFile(this);
    }

    public synchronized int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = this.getHeadersAndPropertiesEncodeSize() + 4 + this.getEncodeSize() + 40 + 1;
        }
        return this.memoryEstimate;
    }

    @Override
    public synchronized void releaseResources() {
        if (this.file != null && this.file.isOpen()) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    public void referenceOriginalMessage(Message original, String originalQueue) {
        super.referenceOriginalMessage(original, originalQueue);
        if (original instanceof LargeServerMessageImpl) {
            LargeServerMessageImpl otherLM = (LargeServerMessageImpl)original;
            this.paged = otherLM.paged;
            if (this.paged) {
                this.removeProperty(Message.HDR_ORIG_MESSAGE_ID);
            }
        }
    }

    public Message copy() {
        SequentialFile newfile = this.storageManager.createFileForLargeMessage(this.messageID, this.durable);
        LargeServerMessageImpl newMessage = new LargeServerMessageImpl(this, this.properties, newfile, this.messageID);
        return newMessage;
    }

    public Message copy(long newID) {
        try {
            int bytesRead;
            LargeServerMessage newMessage = this.storageManager.createLargeMessage(newID, (Message)this);
            boolean originallyOpen = this.file != null && this.file.isOpen();
            this.validateFile();
            byte[] bufferBytes = new byte[102400];
            ByteBuffer buffer = ByteBuffer.wrap(bufferBytes);
            long oldPosition = this.file.position();
            this.file.open();
            this.file.position(0L);
            do {
                byte[] bufferToWrite;
                buffer.clear();
                bytesRead = this.file.read(buffer);
                if (bytesRead <= 0) break;
                if (bytesRead == bufferBytes.length) {
                    bufferToWrite = bufferBytes;
                } else {
                    bufferToWrite = new byte[bytesRead];
                    System.arraycopy(bufferBytes, 0, bufferToWrite, 0, bytesRead);
                }
                newMessage.addBytes(bufferToWrite);
            } while (bytesRead >= bufferBytes.length);
            this.file.position(oldPosition);
            if (!originallyOpen) {
                this.file.close();
                newMessage.getFile().close();
            }
            return newMessage;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.lareMessageErrorCopying(e, this);
            return null;
        }
    }

    @Override
    public SequentialFile getFile() throws ActiveMQException {
        this.validateFile();
        return this.file;
    }

    public String toString() {
        return "LargeServerMessage[messageID=" + this.messageID + ",durable=" + this.isDurable() + ",userID=" + this.getUserID() + ",priority=" + this.getPriority() + ", timestamp=" + LargeServerMessageImpl.toDate(this.getTimestamp()) + ",expiration=" + LargeServerMessageImpl.toDate(this.getExpiration()) + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]@" + System.identityHashCode(this);
    }

    protected void finalize() throws Throwable {
        this.releaseResources();
        super.finalize();
    }

    public synchronized void validateFile() throws ActiveMQException {
        try {
            if (this.file == null) {
                if (this.messageID <= 0L) {
                    throw new RuntimeException("MessageID not set on LargeMessage");
                }
                this.file = this.createFile();
                this.openFile();
                this.bodySize = this.file.size();
            }
        }
        catch (Exception e) {
            throw new ActiveMQInternalErrorException(e.getMessage(), e);
        }
    }

    protected SequentialFile createFile() {
        return this.storageManager.createFileForLargeMessage(this.getMessageID(), this.durable);
    }

    protected void openFile() throws Exception {
        if (this.file == null) {
            this.validateFile();
        } else if (!this.file.isOpen()) {
            this.file.open();
        }
    }

    protected void closeFile() throws Exception {
        if (this.file != null && this.file.isOpen()) {
            this.file.close();
        }
    }

    class DecodingContext
    implements LargeBodyEncoder {
        private SequentialFile cFile;

        DecodingContext() {
        }

        public void open() throws ActiveMQException {
            try {
                if (this.cFile != null && this.cFile.isOpen()) {
                    this.cFile.close();
                }
                this.cFile = LargeServerMessageImpl.this.file.cloneFile();
                this.cFile.open();
            }
            catch (Exception e) {
                throw new ActiveMQException(ActiveMQExceptionType.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws ActiveMQException {
            try {
                if (this.cFile != null) {
                    this.cFile.close();
                }
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public int encode(ByteBuffer bufferRead) throws ActiveMQException {
            try {
                return this.cFile.read(bufferRead);
            }
            catch (Exception e) {
                throw new ActiveMQInternalErrorException(e.getMessage(), e);
            }
        }

        public int encode(ActiveMQBuffer bufferOut, int size) throws ActiveMQException {
            ByteBuffer bufferRead = ByteBuffer.allocate(size);
            int bytesRead = this.encode(bufferRead);
            bufferRead.flip();
            if (bytesRead > 0) {
                bufferOut.writeBytes(bufferRead.array(), 0, bytesRead);
            }
            return bytesRead;
        }

        public long getLargeBodySize() {
            if (LargeServerMessageImpl.this.bodySize < 0L) {
                try {
                    LargeServerMessageImpl.this.bodySize = LargeServerMessageImpl.this.file.size();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
            return LargeServerMessageImpl.this.bodySize;
        }
    }
}

