/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

public class CompositeAddress {
    public static String SEPARATOR = "::";
    private final String address;
    private final String queueName;

    public String getAddress() {
        return this.address;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public CompositeAddress(String address, String queueName) {
        this.address = address;
        this.queueName = queueName;
    }

    public static boolean isFullyQualified(String address) {
        return address.toString().contains(SEPARATOR);
    }

    public static CompositeAddress getQueueName(String address) {
        String[] split = address.split(SEPARATOR);
        if (split.length <= 0) {
            throw new IllegalStateException("Nott A Fully Qualified Name");
        }
        return new CompositeAddress(split[0], split[1]);
    }
}

