/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.replication.ReplicationManager;

public final class ReplicationAddMessage
extends PacketImpl {
    private long id;
    private byte journalID;
    private ReplicationManager.ADD_OPERATION_TYPE operation;
    private byte journalRecordType;
    private Persister persister;
    private Object encodingData;
    private byte[] recordData;

    public ReplicationAddMessage() {
        super((byte)91);
    }

    public ReplicationAddMessage(byte journalID, ReplicationManager.ADD_OPERATION_TYPE operation, long id, byte journalRecordType, Persister persister, Object encodingData) {
        this();
        this.journalID = journalID;
        this.operation = operation;
        this.id = id;
        this.journalRecordType = journalRecordType;
        this.persister = persister;
        this.encodingData = encodingData;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeBoolean(this.operation.toBoolean());
        buffer.writeLong(this.id);
        buffer.writeByte(this.journalRecordType);
        buffer.writeInt(this.persister.getEncodeSize(this.encodingData));
        this.persister.encode(buffer, this.encodingData);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.operation = ReplicationManager.ADD_OPERATION_TYPE.toOperation(buffer.readBoolean());
        this.id = buffer.readLong();
        this.journalRecordType = buffer.readByte();
        int recordDataSize = buffer.readInt();
        this.recordData = new byte[recordDataSize];
        buffer.readBytes(this.recordData);
    }

    public long getId() {
        return this.id;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public ReplicationManager.ADD_OPERATION_TYPE getRecord() {
        return this.operation;
    }

    public byte getJournalRecordType() {
        return this.journalRecordType;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encodingData == null ? 0 : this.encodingData.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.journalID;
        result = 31 * result + this.journalRecordType;
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + Arrays.hashCode(this.recordData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationAddMessage)) {
            return false;
        }
        ReplicationAddMessage other = (ReplicationAddMessage)((Object)obj);
        if (this.encodingData == null ? other.encodingData != null : !this.encodingData.equals(other.encodingData)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.journalID != other.journalID) {
            return false;
        }
        if (this.journalRecordType != other.journalRecordType) {
            return false;
        }
        if (this.operation != other.operation) {
            return false;
        }
        return Arrays.equals(this.recordData, other.recordData);
    }
}

