/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.Quorum;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVoteServerConnect;

public class SharedNothingBackupQuorum
implements Quorum,
SessionFailureListener {
    private QuorumManager quorumManager;
    private String targetServerID = "";
    private final NodeManager nodeManager;
    private final StorageManager storageManager;
    private final ScheduledExecutorService scheduledPool;
    private final int quorumSize;
    private CountDownLatch latch;
    private ClientSessionFactoryInternal sessionFactory;
    private CoreRemotingConnection connection;
    private final NetworkHealthCheck networkHealthCheck;
    public static final int WAIT_TIME_AFTER_FIRST_LIVE_STOPPING_MSG = 60;
    private volatile BACKUP_ACTIVATION signal;
    private static final int LATCH_TIMEOUT = 30;
    private final Object decisionGuard = new Object();

    public SharedNothingBackupQuorum(StorageManager storageManager, NodeManager nodeManager, ScheduledExecutorService scheduledPool, NetworkHealthCheck networkHealthCheck, int quorumSize) {
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.quorumSize = quorumSize;
        this.latch = new CountDownLatch(1);
        this.nodeManager = nodeManager;
        this.networkHealthCheck = networkHealthCheck;
    }

    @Override
    public String getName() {
        return "SharedNothingBackupQuorum";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decideOnAction(Topology topology) {
        Object object = this.decisionGuard;
        synchronized (object) {
            if (this.signal == BACKUP_ACTIVATION.FAIL_OVER) {
                if (this.networkHealthCheck != null && !this.networkHealthCheck.check()) {
                    this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
                }
                return;
            }
            this.signal = !this.isLiveDown() ? BACKUP_ACTIVATION.FAILURE_REPLICATING : BACKUP_ACTIVATION.FAIL_OVER;
            if (this.networkHealthCheck != null && this.networkHealthCheck.check()) {
                this.signal = BACKUP_ACTIVATION.FAIL_OVER;
            } else {
                ActiveMQServerLogger.LOGGER.serverIsolatedOnNetwork();
                this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
            }
        }
        this.latch.countDown();
    }

    public void liveIDSet(String liveID) {
        this.targetServerID = liveID;
        this.nodeManager.setNodeID(liveID);
    }

    @Override
    public void setQuorumManager(QuorumManager quorumManager) {
        this.quorumManager = quorumManager;
    }

    @Override
    public void nodeDown(Topology topology, long eventUID, String nodeID) {
        if (this.targetServerID.equals(nodeID)) {
            this.decideOnAction(topology);
        }
    }

    @Override
    public void nodeUp(Topology topology) {
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        this.decideOnAction(this.sessionFactory.getServerLocator().getTopology());
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    @Override
    public void close() {
        this.causeExit(BACKUP_ACTIVATION.STOP);
    }

    public void setSessionFactory(ClientSessionFactoryInternal sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.connection = (CoreRemotingConnection)sessionFactory.getConnection();
        this.connection.addFailureListener((FailureListener)this);
        sessionFactory.addFailureListener((SessionFailureListener)this);
    }

    public synchronized void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        this.removeListener();
        this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.FAIL_OVER) {
            this.latch.countDown();
        }
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED) {
            final CountDownLatch localLatch = this.latch;
            this.scheduledPool.schedule(new Runnable(){

                @Override
                public void run() {
                    localLatch.countDown();
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }

    public void notifyRegistrationFailed() {
        this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
        this.latch.countDown();
    }

    public void notifyAlreadyReplicating() {
        this.signal = BACKUP_ACTIVATION.ALREADY_REPLICATING;
        this.latch.countDown();
    }

    private void removeListener() {
        if (this.connection != null) {
            this.connection.removeFailureListener((FailureListener)this);
        }
    }

    public BACKUP_ACTIVATION waitForStatusChange() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return BACKUP_ACTIVATION.STOP;
        }
        return this.signal;
    }

    public synchronized void causeExit(BACKUP_ACTIVATION explicitSignal) {
        this.removeListener();
        this.signal = explicitSignal;
        this.latch.countDown();
    }

    public synchronized void reset() {
        this.latch = new CountDownLatch(1);
    }

    private boolean isLiveDown() {
        int size = this.quorumSize == -1 ? this.quorumManager.getMaxClusterSize() : this.quorumSize;
        QuorumVoteServerConnect quorumVote = new QuorumVoteServerConnect(size, this.storageManager);
        this.quorumManager.vote(quorumVote);
        try {
            quorumVote.await(30, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.quorumManager.voteComplete(quorumVote);
        return quorumVote.getDecision();
    }

    public static enum BACKUP_ACTIVATION {
        FAIL_OVER,
        FAILURE_REPLICATING,
        ALREADY_REPLICATING,
        STOP;

    }
}

