/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public abstract class AbstractProtocolManager<P, I extends BaseInterceptor<P>, C extends RemotingConnection>
implements ProtocolManager<I> {
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();

    protected void invokeInterceptors(List<I> interceptors, P message, C connection) {
        if (interceptors != null && !interceptors.isEmpty()) {
            for (BaseInterceptor interceptor : interceptors) {
                try {
                    if (interceptor.intercept(message, connection)) continue;
                    break;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.error(e);
                }
            }
        }
    }

    @Override
    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    @Override
    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    @Override
    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }
}

