/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin;

import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;

public interface ActiveMQServerPlugin {
    default public void afterCreateConnection(RemotingConnection connection) {
    }

    default public void afterDestroyConnection(RemotingConnection connection) {
    }

    default public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) {
    }

    default public void afterCreateSession(ServerSession session) {
    }

    default public void beforeCloseSession(ServerSession session, boolean failed) {
    }

    default public void afterCloseSession(ServerSession session, boolean failed) {
    }

    default public void beforeSessionMetadataAdded(ServerSession session, String key, String data) {
    }

    default public void afterSessionMetadataAdded(ServerSession session, String key, String data) {
    }

    default public void beforeCreateConsumer(long consumerID, SimpleString queueName, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) {
    }

    default public void afterCreateConsumer(ServerConsumer consumer) {
    }

    default public void beforeCloseConsumer(ServerConsumer consumer, boolean failed) {
    }

    default public void afterCloseConsumer(ServerConsumer consumer, boolean failed) {
    }

    default public void beforeCreateQueue(QueueConfig queueConfig) {
    }

    default public void afterCreateQueue(Queue queue) {
    }

    default public void beforeDestroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
    }

    default public void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
    }

    default public void beforeSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue) {
    }

    default public void afterSend(Transaction tx, Message message, boolean direct, boolean noAutoCreateQueue, RoutingStatus result) {
    }

    default public void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
    }

    default public void afterMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, RoutingStatus result) {
    }

    default public void beforeDeliver(MessageReference reference) {
    }

    default public void afterDeliver(MessageReference reference) {
    }

    default public void messageExpired(MessageReference message, SimpleString messageExpiryAddress) {
    }

    default public void messageAcknowledged(MessageReference ref, AckReason reason) {
    }

    default public void beforeDeployBridge(BridgeConfiguration config) {
    }

    default public void afterDeployBridge(Bridge bridge) {
    }
}

