/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageIterator;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.jboss.logging.Logger;

public final class PageTransactionInfoImpl
implements PageTransactionInfo {
    private static final Logger logger = Logger.getLogger(PageTransactionInfoImpl.class);
    private static final AtomicIntegerFieldUpdater<PageTransactionInfoImpl> numberOfMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTransactionInfoImpl.class, "numberOfMessages");
    private static final AtomicIntegerFieldUpdater<PageTransactionInfoImpl> numberOfPersistentMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(PageTransactionInfoImpl.class, "numberOfPersistentMessages");
    private long transactionID;
    private volatile long recordID = -1L;
    private volatile boolean committed = false;
    private volatile boolean useRedelivery = false;
    private volatile boolean rolledback = false;
    private volatile int numberOfMessages = 0;
    private volatile int numberOfPersistentMessages = 0;
    private List<LateDelivery> lateDeliveries;

    public PageTransactionInfoImpl(long transactionID) {
        this();
        this.transactionID = transactionID;
    }

    public PageTransactionInfoImpl() {
    }

    @Override
    public long getRecordID() {
        return this.recordID;
    }

    @Override
    public void setRecordID(long recordID) {
        this.recordID = recordID;
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public boolean onUpdate(int update, StorageManager storageManager, PagingManager pagingManager) {
        int afterUpdate = numberOfMessagesUpdater.addAndGet(this, -update);
        return this.internalCheckSize(storageManager, pagingManager, afterUpdate);
    }

    @Override
    public boolean checkSize(StorageManager storageManager, PagingManager pagingManager) {
        return this.internalCheckSize(storageManager, pagingManager, numberOfMessagesUpdater.get(this));
    }

    public boolean internalCheckSize(StorageManager storageManager, PagingManager pagingManager, int size) {
        if (size <= 0) {
            if (storageManager != null) {
                try {
                    storageManager.deletePageTransactional(this.recordID);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.pageTxDeleteError(e, this.recordID);
                }
                pagingManager.removeTransaction(this.transactionID);
            }
            return false;
        }
        return true;
    }

    @Override
    public void increment(int durableSize, int nonDurableSize) {
        numberOfPersistentMessagesUpdater.addAndGet(this, durableSize);
        numberOfMessagesUpdater.addAndGet(this, durableSize + nonDurableSize);
    }

    @Override
    public int getNumberOfMessages() {
        return numberOfMessagesUpdater.get(this);
    }

    public synchronized void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        numberOfMessagesUpdater.set(this, buffer.readInt());
        numberOfPersistentMessagesUpdater.set(this, numberOfMessagesUpdater.get(this));
        this.committed = true;
    }

    public synchronized void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        buffer.writeInt(numberOfPersistentMessagesUpdater.get(this));
    }

    public synchronized int getEncodeSize() {
        return 12;
    }

    @Override
    public synchronized void commit() {
        if (this.lateDeliveries != null) {
            for (LateDelivery pos : this.lateDeliveries) {
                pos.getSubscription().redeliver(pos.getIterator(), pos.getPagePosition());
            }
            this.lateDeliveries.clear();
        }
        this.committed = true;
        this.lateDeliveries = null;
    }

    @Override
    public void store(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        storageManager.storePageTransaction(tx.getID(), this);
    }

    @Override
    public void storeUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx) throws Exception {
        this.internalUpdatePageManager(storageManager, pagingManager, tx, 1);
    }

    @Override
    public void reloadUpdate(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) throws Exception {
        UpdatePageTXOperation updt = this.internalUpdatePageManager(storageManager, pagingManager, tx, increment);
        updt.setStored();
    }

    protected UpdatePageTXOperation internalUpdatePageManager(StorageManager storageManager, PagingManager pagingManager, Transaction tx, int increment) {
        UpdatePageTXOperation pgtxUpdate = (UpdatePageTXOperation)tx.getProperty(4);
        if (pgtxUpdate == null) {
            pgtxUpdate = new UpdatePageTXOperation(storageManager, pagingManager);
            tx.putProperty(4, pgtxUpdate);
            tx.addOperation(pgtxUpdate);
        }
        tx.setContainsPersistent();
        pgtxUpdate.addUpdate(this, increment);
        return pgtxUpdate;
    }

    @Override
    public boolean isCommit() {
        return this.committed;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public boolean isRollback() {
        return this.rolledback;
    }

    @Override
    public synchronized void rollback() {
        this.rolledback = true;
        this.committed = false;
        if (this.lateDeliveries != null) {
            for (LateDelivery pos : this.lateDeliveries) {
                pos.getSubscription().lateDeliveryRollback(pos.getPagePosition());
            }
            this.lateDeliveries = null;
        }
    }

    public String toString() {
        return "PageTransactionInfoImpl(transactionID=" + this.transactionID + ",id=" + this.recordID + ",numberOfMessages=" + this.numberOfMessages + ")";
    }

    @Override
    public synchronized boolean deliverAfterCommit(PageIterator iterator, PageSubscription cursor, PagePosition cursorPos) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("deliver after commit on " + cursor + ", position=" + cursorPos));
        }
        if (this.committed && this.useRedelivery) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("commit & useRedelivery on " + cursor + ", position=" + cursorPos));
            }
            cursor.addPendingDelivery(cursorPos);
            cursor.redeliver(iterator, cursorPos);
            return true;
        }
        if (this.committed) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("committed on " + cursor + ", position=" + cursorPos + ", ignoring position"));
            }
            return false;
        }
        if (this.rolledback) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("rolled back, position ignored on " + cursor + ", position=" + cursorPos));
            }
            cursor.positionIgnored(cursorPos);
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("deliverAftercommit/else, marking useRedelivery on " + cursor + ", position " + cursorPos));
        }
        this.useRedelivery = true;
        if (this.lateDeliveries == null) {
            this.lateDeliveries = new LinkedList<LateDelivery>();
        }
        cursor.addPendingDelivery(cursorPos);
        this.lateDeliveries.add(new LateDelivery(cursor, cursorPos, iterator));
        return true;
    }

    private static class UpdatePageTXOperation
    extends TransactionOperationAbstract {
        private final HashMap<PageTransactionInfo, AtomicInteger> countsToUpdate = new HashMap();
        private boolean stored = false;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;

        private UpdatePageTXOperation(StorageManager storageManager, PagingManager pagingManager) {
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        public void setStored() {
            this.stored = true;
        }

        public void addUpdate(PageTransactionInfo info, int increment) {
            AtomicInteger counter = this.countsToUpdate.get(info);
            if (counter == null) {
                counter = new AtomicInteger(0);
                this.countsToUpdate.put(info, counter);
            }
            counter.addAndGet(increment);
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.storeUpdates(tx);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                entry.getKey().onUpdate(entry.getValue().intValue(), this.storageManager, this.pagingManager);
            }
        }

        private void storeUpdates(Transaction tx) throws Exception {
            if (!this.stored) {
                this.stored = true;
                for (Map.Entry<PageTransactionInfo, AtomicInteger> entry : this.countsToUpdate.entrySet()) {
                    this.storageManager.updatePageTransaction(tx.getID(), entry.getKey(), entry.getValue().get());
                }
            }
        }
    }

    private static class LateDelivery {
        final PageSubscription subscription;
        final PagePosition pagePosition;
        final PageIterator iterator;

        private LateDelivery(PageSubscription subscription, PagePosition pagePosition, PageIterator iterator) {
            this.subscription = subscription;
            this.pagePosition = pagePosition;
            this.iterator = iterator;
        }

        public PageSubscription getSubscription() {
            return this.subscription;
        }

        public PagePosition getPagePosition() {
            return this.pagePosition;
        }

        public PageIterator getIterator() {
            return this.iterator;
        }
    }
}

