/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.IDGenerator;

public interface StorageManager
extends IDGenerator,
ActiveMQComponent {
    default public long getMaxRecordSize() {
        return Long.MAX_VALUE;
    }

    default public SequentialFileFactory getJournalSequentialFileFactory() {
        return null;
    }

    public void criticalError(Throwable var1);

    public OperationContext getContext();

    public void lineUpContext();

    public OperationContext newContext(Executor var1);

    public OperationContext newSingleThreadContext();

    public void setContext(OperationContext var1);

    public void stop(boolean var1, boolean var2) throws Exception;

    public void pageClosed(SimpleString var1, int var2);

    public void pageDeleted(SimpleString var1, int var2);

    public void pageWrite(PagedMessage var1, int var2);

    public void afterCompleteOperations(IOCallback var1);

    public void afterStoreOperations(IOCallback var1);

    public boolean waitOnOperations(long var1) throws Exception;

    public void waitOnOperations() throws Exception;

    public void beforePageRead() throws Exception;

    public boolean beforePageRead(long var1, TimeUnit var3) throws InterruptedException;

    public void afterPageRead() throws Exception;

    public ByteBuffer allocateDirectBuffer(int var1);

    public void freeDirectBuffer(ByteBuffer var1);

    public void clearContext();

    public void confirmPendingLargeMessageTX(Transaction var1, long var2, long var4) throws Exception;

    public void confirmPendingLargeMessage(long var1) throws Exception;

    public void storeMessage(Message var1) throws Exception;

    public void storeReference(long var1, long var3, boolean var5) throws Exception;

    public void deleteMessage(long var1) throws Exception;

    public void storeAcknowledge(long var1, long var3) throws Exception;

    public void storeCursorAcknowledge(long var1, PagePosition var3) throws Exception;

    public void updateDeliveryCount(MessageReference var1) throws Exception;

    public void updateScheduledDeliveryTime(MessageReference var1) throws Exception;

    public void storeDuplicateID(SimpleString var1, byte[] var2, long var3) throws Exception;

    public void deleteDuplicateID(long var1) throws Exception;

    public void storeMessageTransactional(long var1, Message var3) throws Exception;

    public void storeReferenceTransactional(long var1, long var3, long var5) throws Exception;

    public void storeAcknowledgeTransactional(long var1, long var3, long var5) throws Exception;

    public void storeCursorAcknowledgeTransactional(long var1, long var3, PagePosition var5) throws Exception;

    public void deleteCursorAcknowledgeTransactional(long var1, long var3) throws Exception;

    public void deleteCursorAcknowledge(long var1) throws Exception;

    public void storePageCompleteTransactional(long var1, long var3, PagePosition var5) throws Exception;

    public void deletePageComplete(long var1) throws Exception;

    public void updateScheduledDeliveryTimeTransactional(long var1, MessageReference var3) throws Exception;

    public void storeDuplicateIDTransactional(long var1, SimpleString var3, byte[] var4, long var5) throws Exception;

    public void updateDuplicateIDTransactional(long var1, SimpleString var3, byte[] var4, long var5) throws Exception;

    public void deleteDuplicateIDTransactional(long var1, long var3) throws Exception;

    public LargeServerMessage createLargeMessage();

    public LargeServerMessage createLargeMessage(long var1, Message var3) throws Exception;

    public SequentialFile createFileForLargeMessage(long var1, LargeMessageExtension var3);

    public void prepare(long var1, Xid var3) throws Exception;

    public void commit(long var1) throws Exception;

    public void commit(long var1, boolean var3) throws Exception;

    public void rollback(long var1) throws Exception;

    public void rollbackBindings(long var1) throws Exception;

    public void commitBindings(long var1) throws Exception;

    public void storePageTransaction(long var1, PageTransactionInfo var3) throws Exception;

    public void updatePageTransaction(long var1, PageTransactionInfo var3, int var4) throws Exception;

    public void deletePageTransactional(long var1) throws Exception;

    public JournalLoadInformation loadMessageJournal(PostOffice var1, PagingManager var2, ResourceManager var3, Map<Long, QueueBindingInfo> var4, Map<SimpleString, List<Pair<byte[], Long>>> var5, Set<Pair<Long, Long>> var6, List<PageCountPending> var7, JournalLoader var8) throws Exception;

    public long storeHeuristicCompletion(Xid var1, boolean var2) throws Exception;

    public void deleteHeuristicCompletion(long var1) throws Exception;

    public void addQueueBinding(long var1, Binding var3) throws Exception;

    public void updateQueueBinding(long var1, Binding var3) throws Exception;

    public void deleteQueueBinding(long var1, long var3) throws Exception;

    public long storeQueueStatus(long var1, AddressQueueStatus var3) throws Exception;

    public void deleteQueueStatus(long var1) throws Exception;

    public long storeAddressStatus(long var1, AddressQueueStatus var3) throws Exception;

    public void deleteAddressStatus(long var1) throws Exception;

    public void addAddressBinding(long var1, AddressInfo var3) throws Exception;

    public void deleteAddressBinding(long var1, long var3) throws Exception;

    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> var1, List<GroupingInfo> var2, List<AddressBindingInfo> var3) throws Exception;

    public void addGrouping(GroupBinding var1) throws Exception;

    public void deleteGrouping(long var1, GroupBinding var3) throws Exception;

    public void storeAddressSetting(PersistedAddressSetting var1) throws Exception;

    public void deleteAddressSetting(SimpleString var1) throws Exception;

    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception;

    public void storeSecurityRoles(PersistedRoles var1) throws Exception;

    public void deleteSecurityRoles(SimpleString var1) throws Exception;

    public List<PersistedRoles> recoverPersistedRoles() throws Exception;

    public long storePageCounter(long var1, long var3, long var5, long var7) throws Exception;

    public long storePendingCounter(long var1, long var3) throws Exception;

    public void deleteIncrementRecord(long var1, long var3) throws Exception;

    public void deletePageCounter(long var1, long var3) throws Exception;

    public void deletePendingPageCounter(long var1, long var3) throws Exception;

    public long storePageCounterInc(long var1, long var3, int var5, long var6) throws Exception;

    public long storePageCounterInc(long var1, int var3, long var4) throws Exception;

    public Journal getBindingsJournal();

    public Journal getMessageJournal();

    public void startReplication(ReplicationManager var1, PagingManager var2, String var3, boolean var4, long var5) throws Exception;

    public boolean addToPage(PagingStore var1, Message var2, Transaction var3, RouteContextList var4) throws Exception;

    public void stopReplication();

    public void addBytesToLargeMessage(SequentialFile var1, long var2, byte[] var4) throws Exception;

    public void storeID(long var1, long var3) throws Exception;

    public void deleteID(long var1) throws Exception;

    public void readLock();

    public void readUnLock();

    public void persistIdGenerator();

    public void injectMonitor(FileStoreMonitor var1) throws Exception;

    public static enum LargeMessageExtension {
        DURABLE(".msg"),
        TEMPORARY(".tmp"),
        SYNC(".sync");

        final String extension;

        private LargeMessageExtension(String extension) {
            this.extension = extension;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

