/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation.address;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.FederatedConsumerKey;
import org.apache.activemq.artemis.core.server.federation.Federation;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;
import org.apache.activemq.artemis.core.server.federation.address.FederatedAddressConsumerKey;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.jboss.logging.Logger;

public class FederatedAddress
extends FederatedAbstract
implements ActiveMQServerQueuePlugin,
Serializable {
    private static final Logger logger = Logger.getLogger(FederatedAddress.class);
    public static final String FEDERATED_QUEUE_PREFIX = "federated";
    public static final SimpleString HDR_HOPS = new SimpleString("_AMQ_Hops");
    private final SimpleString queueNameFormat;
    private final SimpleString filterString;
    private final Set<Matcher> includes;
    private final Set<Matcher> excludes;
    private final FederationAddressPolicyConfiguration config;

    public FederatedAddress(Federation federation, FederationAddressPolicyConfiguration config, ActiveMQServer server, FederationUpstream upstream) {
        super(federation, server, upstream);
        Objects.requireNonNull(config.getName());
        this.config = config;
        this.filterString = config.getMaxHops() == -1 ? null : HDR_HOPS.concat(" IS NULL OR ").concat(HDR_HOPS).concat("<").concat(Integer.toString(config.getMaxHops()));
        this.queueNameFormat = SimpleString.toSimpleString((String)"federated.${federation}.${upstream}.${address}.${routeType}");
        if (config.getIncludes().isEmpty()) {
            this.includes = Collections.emptySet();
        } else {
            this.includes = new HashSet<Matcher>(config.getIncludes().size());
            for (FederationAddressPolicyConfiguration.Matcher include : config.getIncludes()) {
                this.includes.add(new Matcher(include, this.wildcardConfiguration));
            }
        }
        if (config.getExcludes().isEmpty()) {
            this.excludes = Collections.emptySet();
        } else {
            this.excludes = new HashSet<Matcher>(config.getExcludes().size());
            for (FederationAddressPolicyConfiguration.Matcher exclude : config.getExcludes()) {
                this.excludes.add(new Matcher(exclude, this.wildcardConfiguration));
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.server.getPostOffice().getAllBindings().values().stream().filter(b -> b instanceof QueueBinding).map(b -> ((QueueBinding)b).getQueue()).forEach(this::conditionalCreateRemoteConsumer);
    }

    @Override
    public synchronized void afterCreateQueue(Queue queue) {
        this.conditionalCreateRemoteConsumer(queue);
    }

    private void conditionalCreateRemoteConsumer(Queue queue) {
        if (this.server.hasBrokerFederationPlugins()) {
            AtomicBoolean conditionalCreate = new AtomicBoolean(true);
            try {
                this.server.callBrokerFederationPlugins(plugin -> conditionalCreate.set(conditionalCreate.get() && plugin.federatedAddressConditionalCreateConsumer(queue)));
            }
            catch (ActiveMQException t) {
                ActiveMQServerLogger.LOGGER.federationPluginExecutionError(t, "federatedAddressConditionalCreateConsumer");
                throw new IllegalStateException(t.getMessage(), t.getCause());
            }
            if (!conditionalCreate.get()) {
                return;
            }
        }
        this.createRemoteConsumer(queue);
    }

    public FederationAddressPolicyConfiguration getConfig() {
        return this.config;
    }

    private void createRemoteConsumer(Queue queue) {
        if (this.match(queue)) {
            FederatedConsumerKey key = this.getKey(queue);
            Transformer transformer = this.getTransformer(this.config.getTransformerRef());
            Transformer addHop = FederatedAddress::addHop;
            this.createRemoteConsumer(key, this.mergeTransformers(addHop, transformer), clientSession -> this.createRemoteQueue(clientSession, key));
        }
    }

    private void createRemoteQueue(ClientSession clientSession, FederatedConsumerKey key) throws ActiveMQException {
        if (!clientSession.queueQuery(key.getQueueName()).isExists()) {
            QueueAttributes queueAttributes = new QueueAttributes().setRoutingType(key.getRoutingType()).setFilterString(key.getQueueFilterString()).setDurable(Boolean.valueOf(true)).setAutoDelete(Boolean.valueOf(this.config.getAutoDelete() == null ? true : this.config.getAutoDelete())).setAutoDeleteDelay(Long.valueOf(this.config.getAutoDeleteDelay() == null ? TimeUnit.HOURS.toMillis(1L) : this.config.getAutoDeleteDelay().longValue())).setAutoDeleteMessageCount(Long.valueOf(this.config.getAutoDeleteMessageCount() == null ? -1L : this.config.getAutoDeleteMessageCount())).setMaxConsumers(Integer.valueOf(-1)).setPurgeOnNoConsumers(Boolean.valueOf(false));
            clientSession.createQueue(key.getAddress(), key.getQueueName(), false, queueAttributes);
        }
    }

    private boolean match(Queue queue) {
        if (RoutingType.ANYCAST.equals((Object)queue.getRoutingType())) {
            return false;
        }
        for (Matcher exclude : this.excludes) {
            if (!exclude.test(queue)) continue;
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        for (Matcher include : this.includes) {
            if (!include.test(queue)) continue;
            return true;
        }
        return false;
    }

    private static Message addHop(Message message) {
        if (message != null) {
            int hops = FederatedAddress.toInt(message.getExtraBytesProperty(HDR_HOPS));
            message.putExtraBytesProperty(HDR_HOPS, ByteUtil.intToBytes((int)(++hops)));
        }
        return message;
    }

    private static int toInt(byte[] bytes) {
        if (bytes != null && bytes.length == 4) {
            return ByteUtil.bytesToInt((byte[])bytes);
        }
        return 0;
    }

    @Override
    public synchronized void beforeDestroyQueue(Queue queue, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        FederatedConsumerKey key = this.getKey(queue);
        this.removeRemoteConsumer(key);
    }

    private FederatedConsumerKey getKey(Queue queue) {
        return new FederatedAddressConsumerKey(this.federation.getName(), this.upstream.getName(), queue.getAddress(), queue.getRoutingType(), this.queueNameFormat, this.filterString);
    }

    public static class Matcher {
        Predicate<String> addressPredicate;

        Matcher(FederationAddressPolicyConfiguration.Matcher config, WildcardConfiguration wildcardConfiguration) {
            if (config.getAddressMatch() != null && !config.getAddressMatch().isEmpty()) {
                this.addressPredicate = new Match<Object>(config.getAddressMatch(), null, wildcardConfiguration).getPattern().asPredicate();
            }
        }

        public boolean test(Queue queue) {
            return this.addressPredicate == null || this.addressPredicate.test(queue.getAddress().toString());
        }
    }
}

