/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LiveNodeLocator;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.AnyLiveNodeLocatorForScaleDown;
import org.apache.activemq.artemis.core.server.impl.NamedLiveNodeLocatorForScaleDown;
import org.apache.activemq.artemis.core.server.impl.ScaleDownHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.jboss.logging.Logger;

public class LiveOnlyActivation
extends Activation {
    private static final Logger logger = Logger.getLogger(LiveOnlyActivation.class);
    private LiveOnlyPolicy liveOnlyPolicy;
    private final ActiveMQServerImpl activeMQServer;
    private ServerLocatorInternal scaleDownServerLocator;
    private ClientSessionFactoryInternal scaleDownClientSessionFactory;

    public LiveOnlyActivation(ActiveMQServerImpl server, LiveOnlyPolicy liveOnlyPolicy) {
        this.activeMQServer = server;
        this.liveOnlyPolicy = liveOnlyPolicy;
    }

    public LiveOnlyPolicy getLiveOnlyPolicy() {
        return this.liveOnlyPolicy;
    }

    @Override
    public void run() {
        try {
            this.activeMQServer.initialisePart1(false);
            this.activeMQServer.registerActivateCallback(this.activeMQServer.getNodeManager().startLiveNode());
            if (this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPED || this.activeMQServer.getState() == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation();
            if (this.activeMQServer.getIdentity() != null) {
                ActiveMQServerLogger.LOGGER.serverIsLive(this.activeMQServer.getIdentity());
            } else {
                ActiveMQServerLogger.LOGGER.serverIsLive();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse;
        if (this.scaleDownServerLocator != null) {
            this.scaleDownServerLocator.close();
            this.scaleDownServerLocator = null;
        }
        if ((nodeManagerInUse = this.activeMQServer.getNodeManager()) != null) {
            if (permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        String nodeID;
        if (this.liveOnlyPolicy.getScaleDownPolicy() != null && this.liveOnlyPolicy.getScaleDownPolicy().isEnabled()) {
            this.connectToScaleDownTarget(this.liveOnlyPolicy.getScaleDownPolicy());
        }
        RemotingConnection rc = this.scaleDownClientSessionFactory == null ? null : this.scaleDownClientSessionFactory.getConnection();
        String string = nodeID = rc == null ? null : this.scaleDownClientSessionFactory.getServerLocator().getTopology().getMember(rc).getNodeId();
        if (remotingService != null) {
            remotingService.freeze(nodeID, null);
        }
    }

    @Override
    public void postConnectionFreeze() {
        if (this.liveOnlyPolicy.getScaleDownPolicy() != null && this.liveOnlyPolicy.getScaleDownPolicy().isEnabled() && this.scaleDownClientSessionFactory != null) {
            try {
                this.scaleDown();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToScaleDown(e);
            }
            finally {
                this.scaleDownClientSessionFactory.close();
                this.scaleDownServerLocator.close();
            }
        }
    }

    public void connectToScaleDownTarget(ScaleDownPolicy scaleDownPolicy) {
        try {
            this.scaleDownServerLocator = ScaleDownPolicy.getScaleDownConnector(scaleDownPolicy, this.activeMQServer);
            this.scaleDownServerLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.scaleDownServerLocator));
            LiveNodeLocator nodeLocator = scaleDownPolicy.getGroupName() == null ? new AnyLiveNodeLocatorForScaleDown(this.activeMQServer) : new NamedLiveNodeLocatorForScaleDown(scaleDownPolicy.getGroupName(), this.activeMQServer);
            this.scaleDownServerLocator.addClusterTopologyListener((ClusterTopologyListener)nodeLocator);
            nodeLocator.connectToCluster(this.scaleDownServerLocator);
            nodeLocator.locateNode(10000L);
            ClientSessionFactoryInternal clientSessionFactory = null;
            while (clientSessionFactory == null) {
                Pair<TransportConfiguration, TransportConfiguration> possibleLive = null;
                possibleLive = nodeLocator.getLiveConfiguration();
                if (possibleLive == null) break;
                try {
                    clientSessionFactory = (ClientSessionFactoryInternal)this.scaleDownServerLocator.createSessionFactory((TransportConfiguration)possibleLive.getA(), 0, false);
                }
                catch (Exception e) {
                    logger.trace((Object)("Failed to connect to " + possibleLive.getA()));
                    nodeLocator.notifyRegistrationFailed(false);
                    if (clientSessionFactory != null) {
                        clientSessionFactory.close();
                    }
                    clientSessionFactory = null;
                }
            }
            if (clientSessionFactory == null) {
                throw new ActiveMQException("Unable to connect to server for scale-down");
            }
            this.scaleDownClientSessionFactory = clientSessionFactory;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToScaleDown(e);
        }
    }

    public long scaleDown() throws Exception {
        ScaleDownHandler scaleDownHandler = new ScaleDownHandler(this.activeMQServer.getPagingManager(), this.activeMQServer.getPostOffice(), this.activeMQServer.getNodeManager(), this.activeMQServer.getClusterManager().getClusterController(), this.activeMQServer.getStorageManager());
        ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = ((PostOfficeImpl)this.activeMQServer.getPostOffice()).getDuplicateIDCaches();
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        for (SimpleString address : duplicateIDCaches.keySet()) {
            DuplicateIDCache duplicateIDCache = this.activeMQServer.getPostOffice().getDuplicateIDCache(address);
            duplicateIDMap.put(address, duplicateIDCache.getMap());
        }
        return scaleDownHandler.scaleDown((ClientSessionFactory)this.scaleDownClientSessionFactory, this.activeMQServer.getResourceManager(), duplicateIDMap, this.activeMQServer.getManagementService().getManagementAddress(), null);
    }
}

