/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueManager;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class QueueManagerImpl
extends ReferenceCounterUtil
implements QueueManager {
    private final SimpleString queueName;
    private final ActiveMQServer server;

    private void doIt() {
        Queue queue = this.server.locateQueue(this.queueName);
        if (queue == null) {
            if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("no queue to delete \"" + this.queueName + ".\"");
            }
            return;
        }
        if (QueueManagerImpl.isAutoDelete(queue) && QueueManagerImpl.consumerCountCheck(queue) && QueueManagerImpl.delayCheck(queue) && QueueManagerImpl.messageCountCheck(queue)) {
            QueueManagerImpl.performAutoDeleteQueue(this.server, queue);
        } else if (queue.isPurgeOnNoConsumers()) {
            QueueManagerImpl.purge(queue);
        }
    }

    private static void purge(Queue queue) {
        long consumerCount = queue.getConsumerCount();
        long messageCount = queue.getMessageCount();
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("purging queue \"" + queue.getName() + ".\" consumerCount = " + consumerCount + "; messageCount = " + messageCount);
        }
        try {
            queue.deleteMatchingReferences(500, null, AckReason.KILLED);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToPurgeQueue(e, queue.getName());
        }
    }

    public static void performAutoDeleteQueue(ActiveMQServer server, Queue queue) {
        SimpleString queueName = queue.getName();
        AddressSettings settings = server.getAddressSettingsRepository().getMatch(queue.getAddress().toString());
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.info("deleting auto-created queue \"" + queueName + ".\" consumerCount = " + queue.getConsumerCount() + "; messageCount = " + queue.getMessageCount() + "; isAutoDelete = " + queue.isAutoDelete());
        }
        try {
            server.destroyQueue(queueName, null, true, false, settings.isAutoDeleteAddresses(), true);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, queueName);
        }
    }

    public static boolean isAutoDelete(Queue queue) {
        return queue.isAutoDelete();
    }

    public static boolean messageCountCheck(Queue queue) {
        return queue.getAutoDeleteMessageCount() == -1L || queue.getMessageCount() <= queue.getAutoDeleteMessageCount();
    }

    public static boolean delayCheck(Queue queue) {
        long consumerRemovedTimestamp = queue.getConsumerRemovedTimestamp();
        return consumerRemovedTimestamp != -1L && System.currentTimeMillis() - consumerRemovedTimestamp >= queue.getAutoDeleteDelay();
    }

    public static boolean consumerCountCheck(Queue queue) {
        return queue.getConsumerCount() == 0;
    }

    public QueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        super((Executor)server.getExecutorFactory().getExecutor());
        this.server = server;
        this.queueName = queueName;
        this.setTask(this::doIt);
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

