/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.utils.JsonLoader;

public class AddressControlImpl
extends AbstractControl
implements AddressControl {
    private AddressInfo addressInfo;
    private final ActiveMQServer server;
    private final PagingManager pagingManager;
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final SecurityStore securityStore;
    private final ManagementService managementService;

    public AddressControlImpl(AddressInfo addressInfo, ActiveMQServer server, PagingManager pagingManager, StorageManager storageManager, HierarchicalRepository<Set<Role>> securityRepository, SecurityStore securityStore, ManagementService managementService) throws Exception {
        super(AddressControl.class, storageManager);
        this.server = server;
        this.addressInfo = addressInfo;
        this.pagingManager = pagingManager;
        this.securityRepository = securityRepository;
        this.securityStore = securityStore;
        this.managementService = managementService;
    }

    public String getAddress() {
        return this.addressInfo.getName().toString();
    }

    public String[] getRoutingTypes() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoutingTypes((Object)this.addressInfo);
        }
        EnumSet<RoutingType> routingTypes = this.addressInfo.getRoutingTypes();
        String[] result = new String[routingTypes.size()];
        int i = 0;
        for (RoutingType routingType : routingTypes) {
            result[i++] = routingType.toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRoutingTypesAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoutingTypesAsJSON((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            String[] routingTypes;
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            for (String routingType : routingTypes = this.getRoutingTypes()) {
                json.add(routingType);
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getQueueNames() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getQueueNames((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.clearIO();
        try {
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
            if (bindings != null) {
                ArrayList<String> queueNames = new ArrayList<String>();
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    queueNames.add(binding.getUniqueName().toString());
                }
                String[] stringArray = queueNames.toArray(new String[queueNames.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getBindingNames() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getBindingNames((Object)this.addressInfo);
        }
        try {
            this.clearIO();
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
            if (bindings != null) {
                String[] bindingNames = new String[bindings.getBindings().size()];
                int i = 0;
                for (Binding binding : bindings.getBindings()) {
                    bindingNames[i++] = binding.getUniqueName().toString();
                }
                String[] stringArray = bindingNames;
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRoles() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoles((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.clearIO();
        try {
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = new Object[]{role.getName(), CheckType.SEND.hasRole(role), CheckType.CONSUME.hasRole(role), CheckType.CREATE_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_DURABLE_QUEUE.hasRole(role), CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), CheckType.MANAGE.hasRole(role)};
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRolesAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRolesAsJSON((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.clearIO();
        try {
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            Set<Role> roles = this.securityRepository.getMatch(this.addressInfo.getName().toString());
            for (Role role : roles) {
                json.add((JsonValue)role.toJson());
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfBytesPerPage() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getNumberOfBytesPerPage((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                long l = 0L;
                return l;
            }
            long l = pagingStore.getPageSizeBytes();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    private PagingStore getPagingStore() throws Exception {
        return this.pagingManager.getPageStore(this.addressInfo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAddressSize() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressSize((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                long l = 0L;
                return l;
            }
            long l = pagingStore.getAddressSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getNumberOfMessages() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getNumberOfMessages((Object)this.addressInfo);
        }
        this.clearIO();
        long totalMsgs = 0L;
        try {
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(this.addressInfo.getName());
            if (bindings != null) {
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    totalMsgs += ((QueueBinding)binding).getQueue().getMessageCount();
                }
            }
            long l = totalMsgs;
            return l;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaging() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isPaging((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pagingStore = this.getPagingStore();
            if (pagingStore == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = pagingStore.isPaging();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getNumberOfPages() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getNumberOfPages((Object)this.addressInfo);
        }
        this.clearIO();
        try {
            PagingStore pageStore = this.getPagingStore();
            if (pageStore == null || !pageStore.isPaging()) {
                int n = 0;
                return n;
            }
            int n = pageStore.getNumberOfPages();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getMessageCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMessageCount((Object)this.addressInfo);
        }
        return this.getMessageCount(DurabilityType.ALL);
    }

    public long getRoutedMessageCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoutedMessageCount((Object)this.addressInfo);
        }
        return this.addressInfo.getRoutedMessageCount();
    }

    public long getUnRoutedMessageCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getUnRoutedMessageCount((Object)this.addressInfo);
        }
        return this.addressInfo.getUnRoutedMessageCount();
    }

    public String sendMessage(Map<String, String> headers, int type, String body, boolean durable, String user, String password) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.sendMessage((Object)this, null, (Object[])new Object[]{headers, type, body, durable, user, "****"});
        }
        try {
            return this.sendMessage(this.addressInfo.getName(), this.server, headers, type, body, durable, user, password, new Long[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AddressControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AddressControl.class);
    }

    public void pause() {
        this.pause(false);
    }

    public void pause(boolean persist) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.pause((Object)this.addressInfo, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.addressInfo.setPostOffice(this.server.getPostOffice());
            this.addressInfo.setStorageManager(this.server.getStorageManager());
            this.addressInfo.pause(persist);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resume() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.resume((Object)this.addressInfo);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.addressInfo.setPostOffice(this.server.getPostOffice());
            this.addressInfo.setStorageManager(this.server.getStorageManager());
            this.addressInfo.resume();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPaused() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isPaused((Object)this.addressInfo);
        }
        return this.addressInfo.isPaused();
    }

    public boolean isRetroactiveResource() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isRetroactiveResource((Object)this.addressInfo);
        }
        return ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)this.addressInfo.getName());
    }

    public long getCurrentDuplicateIdCacheSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getCurrentDuplicateIdCacheSize((Object)this.addressInfo);
        }
        DuplicateIDCache cache = (DuplicateIDCache)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().get(this.addressInfo.getName());
        try {
            if (cache != null) {
                return cache.getMap().size();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.debug("Failed to get duplicate ID cache size", e);
        }
        return 0L;
    }

    public boolean clearDuplicateIdCache() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.clearDuplicateIdCache((Object)this.addressInfo);
        }
        DuplicateIDCache cache = (DuplicateIDCache)((PostOfficeImpl)this.server.getPostOffice()).getDuplicateIDCaches().get(this.addressInfo.getName());
        try {
            if (cache != null) {
                cache.clear();
                return true;
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.debug("Failed to clear duplicate ID cache", e);
        }
        return false;
    }

    private long getMessageCount(DurabilityType durability) {
        List<QueueControl> queues = this.getQueues(durability);
        long count = 0L;
        for (QueueControl queue : queues) {
            count += queue.getMessageCount();
        }
        return count;
    }

    private List<QueueControl> getQueues(DurabilityType durability) {
        try {
            String[] queues;
            ArrayList<QueueControl> matchingQueues = new ArrayList<QueueControl>();
            for (String queue : queues = this.getQueueNames()) {
                QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("queue." + queue);
                if (coreQueueControl == null || durability != DurabilityType.ALL && (durability != DurabilityType.DURABLE || !coreQueueControl.isDurable()) && (durability != DurabilityType.NON_DURABLE || coreQueueControl.isDurable())) continue;
                matchingQueues.add(coreQueueControl);
            }
            return matchingQueues;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private void checkStarted() {
        if (!this.server.getPostOffice().isStarted()) {
            throw new IllegalStateException("Broker is not started. Queues can not be managed yet");
        }
    }

    private static enum DurabilityType {
        ALL,
        DURABLE,
        NON_DURABLE;

    }
}

