/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.logs.AuditLogger;

public class DivertControlImpl
extends AbstractControl
implements DivertControl {
    private final Divert divert;
    private final DivertConfiguration configuration;
    private final String internalNamingPrefix;

    public DivertControlImpl(Divert divert, StorageManager storageManager, DivertConfiguration configuration, String internalNamingPrefix) throws Exception {
        super(DivertControl.class, storageManager);
        this.divert = divert;
        this.configuration = configuration;
        this.internalNamingPrefix = internalNamingPrefix;
    }

    public String getAddress() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddress((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.configuration.getAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getFilter() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getFilter((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.configuration.getFilterString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getForwardingAddress() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getForwardingAddress((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.configuration.getForwardingAddress();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getRoutingName() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoutingName((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getRoutingName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTransformerClassName() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTransformerClassName((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getTransformerPropertiesAsJSON() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTransformerPropertiesAsJSON((Object)this.divert);
        }
        return JsonUtil.toJsonObject(this.getTransformerProperties()).toString();
    }

    public Map<String, String> getTransformerProperties() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTransformerProperties((Object)this.divert);
        }
        this.clearIO();
        try {
            Map map = this.configuration.getTransformerConfiguration() == null ? null : this.configuration.getTransformerConfiguration().getProperties();
            return map;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getRoutingType() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoutingType((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.configuration.getRoutingType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUniqueName() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getUniqueName((Object)this.divert);
        }
        this.clearIO();
        try {
            String string = this.divert.getUniqueName().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isExclusive() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isExclusive((Object)this.divert);
        }
        this.clearIO();
        try {
            boolean bl = this.divert.isExclusive();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isRetroactiveResource() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isRetroactiveResource((Object)this.divert);
        }
        return ResourceNames.isRetroactiveResource((String)this.internalNamingPrefix, (SimpleString)this.divert.getUniqueName());
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(DivertControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(DivertControl.class);
    }
}

