/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.server.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManagerFactory;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.AcceptorFactory;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ServerConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextFactoryProvider;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jboss.logging.Logger;

public class RemotingServiceImpl
implements RemotingService,
ServerConnectionLifeCycleListener {
    private static final Logger logger = Logger.getLogger(RemotingServiceImpl.class);
    private static final int ACCEPTOR_STOP_TIMEOUT = 3000;
    private volatile boolean started = false;
    private final Set<TransportConfiguration> acceptorsConfig;
    private final List<BaseInterceptor> incomingInterceptors = new CopyOnWriteArrayList<BaseInterceptor>();
    private final List<BaseInterceptor> outgoingInterceptors = new CopyOnWriteArrayList<BaseInterceptor>();
    private final Map<String, Acceptor> acceptors = new HashMap<String, Acceptor>();
    private final ConcurrentMap<Object, ConnectionEntry> connections = new ConcurrentHashMap<Object, ConnectionEntry>();
    private final ReusableLatch connectionCountLatch = new ReusableLatch(0);
    private final ActiveMQServer server;
    private final ManagementService managementService;
    private ExecutorService threadPool;
    private final Executor flushExecutor;
    private final ScheduledExecutorService scheduledThreadPool;
    private FailureCheckAndFlushThread failureCheckAndFlushThread;
    private final ClusterManager clusterManager;
    private final Map<String, ProtocolManagerFactory> protocolMap = new ConcurrentHashMap<String, ProtocolManagerFactory>();
    private ActiveMQPrincipal defaultInvmSecurityPrincipal;
    private ServiceRegistry serviceRegistry;
    private boolean paused = false;
    private AtomicLong totalConnectionCount = new AtomicLong(0L);
    private long connectionTtlCheckInterval;

    public RemotingServiceImpl(ClusterManager clusterManager, Configuration config, ActiveMQServer server, ManagementService managementService, ScheduledExecutorService scheduledThreadPool, List<ProtocolManagerFactory> protocolManagerFactories, Executor flushExecutor, ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.acceptorsConfig = config.getAcceptorConfigurations();
        this.server = server;
        this.clusterManager = clusterManager;
        this.setInterceptors(config);
        this.managementService = managementService;
        this.scheduledThreadPool = scheduledThreadPool;
        CoreProtocolManagerFactory coreProtocolManagerFactory = new CoreProtocolManagerFactory();
        MessagePersister.getInstance();
        MessagePersister.registerProtocol(coreProtocolManagerFactory);
        this.flushExecutor = flushExecutor;
        ActiveMQServerLogger.LOGGER.addingProtocolSupport(coreProtocolManagerFactory.getProtocols()[0], coreProtocolManagerFactory.getModuleName());
        this.protocolMap.put(coreProtocolManagerFactory.getProtocols()[0], coreProtocolManagerFactory);
        if (config.isResolveProtocols()) {
            this.resolveProtocols(this.getClass().getClassLoader());
            if (this.getClass().getClassLoader() != Thread.currentThread().getContextClassLoader()) {
                this.resolveProtocols(Thread.currentThread().getContextClassLoader());
            }
        }
        if (protocolManagerFactories != null) {
            this.loadProtocolManagerFactories(protocolManagerFactories);
        }
        this.connectionTtlCheckInterval = config.getConnectionTtlCheckInterval();
    }

    private void setInterceptors(Configuration configuration) {
        this.incomingInterceptors.addAll(this.serviceRegistry.getIncomingInterceptors(configuration.getIncomingInterceptorClassNames()));
        this.outgoingInterceptors.addAll(this.serviceRegistry.getOutgoingInterceptors(configuration.getOutgoingInterceptorClassNames()));
    }

    @Override
    public Map<String, ProtocolManagerFactory> getProtocolFactoryMap() {
        return this.protocolMap;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        logger.tracef("Starting remoting service %s", (Object)this);
        this.paused = false;
        ThreadFactory tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new ActiveMQThreadFactory("ActiveMQ-remoting-threads-" + RemotingServiceImpl.this.server.toString() + "-" + System.identityHashCode(this), false, Thread.currentThread().getContextClassLoader());
            }
        });
        this.threadPool = Executors.newCachedThreadPool(tFactory);
        for (TransportConfiguration info : this.acceptorsConfig) {
            this.createAcceptor(info);
        }
        this.failureCheckAndFlushThread = new FailureCheckAndFlushThread(this.connectionTtlCheckInterval);
        this.failureCheckAndFlushThread.start();
        this.started = true;
    }

    @Override
    public Acceptor createAcceptor(String name, String uri) throws Exception {
        List<TransportConfiguration> configurations = ConfigurationUtils.parseAcceptorURI(name, uri);
        return this.createAcceptor(configurations.get(0));
    }

    @Override
    public Acceptor createAcceptor(TransportConfiguration info) {
        Acceptor acceptor = null;
        try {
            String protocols;
            AcceptorFactory factory = this.server.getServiceRegistry().getAcceptorFactory(info.getName(), info.getFactoryClassName());
            Map<String, ProtocolManagerFactory> selectedProtocolFactories = new ConcurrentHashMap<String, ProtocolManagerFactory>();
            String protocol = ConfigurationHelper.getStringProperty((String)"protocol", null, (Map)info.getParams());
            if (protocol != null) {
                ActiveMQServerLogger.LOGGER.warnDeprecatedProtocol();
                this.locateProtocols(protocol, info, selectedProtocolFactories);
            }
            if ((protocols = ConfigurationHelper.getStringProperty((String)"protocols", null, (Map)info.getParams())) != null) {
                this.locateProtocols(protocols, info, selectedProtocolFactories);
            }
            ClusterConnection clusterConnection = this.lookupClusterConnection(info);
            if (selectedProtocolFactories.isEmpty()) {
                selectedProtocolFactories = this.protocolMap;
            }
            ConcurrentHashMap<String, ProtocolManager> selectedProtocols = new ConcurrentHashMap<String, ProtocolManager>();
            for (Map.Entry<String, ProtocolManagerFactory> entry : selectedProtocolFactories.entrySet()) {
                selectedProtocols.put(entry.getKey(), entry.getValue().createProtocolManager(this.server, info.getCombinedParams(), this.incomingInterceptors, this.outgoingInterceptors));
            }
            acceptor = factory.createAcceptor(info.getName(), clusterConnection, info.getParams(), new DelegatingBufferHandler(), this, this.threadPool, this.scheduledThreadPool, selectedProtocols);
            if (this.defaultInvmSecurityPrincipal != null && acceptor.isUnsecurable()) {
                acceptor.setDefaultActiveMQPrincipal(this.defaultInvmSecurityPrincipal);
            }
            this.acceptors.put(info.getName(), acceptor);
            if (this.managementService != null) {
                acceptor.setNotificationService(this.managementService);
                this.managementService.registerAcceptor(acceptor, info);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorCreatingAcceptor(e, info.getFactoryClassName());
        }
        return acceptor;
    }

    public Map<String, Acceptor> getAcceptors() {
        return this.acceptors;
    }

    @Override
    public void destroyAcceptor(String name) throws Exception {
        Acceptor acceptor = this.acceptors.get(name);
        if (acceptor != null) {
            acceptor.stop();
            this.acceptors.remove(name);
        }
    }

    @Override
    public synchronized void startAcceptors() throws Exception {
        if (this.isStarted()) {
            for (Acceptor a : this.acceptors.values()) {
                try {
                    a.start();
                }
                catch (Throwable t) {
                    ActiveMQServerLogger.LOGGER.errorStartingAcceptor(a.getName(), a.getConfiguration());
                    throw t;
                }
            }
        }
    }

    @Override
    public synchronized void allowInvmSecurityOverride(ActiveMQPrincipal principal) {
        this.defaultInvmSecurityPrincipal = principal;
        for (Acceptor acceptor : this.acceptors.values()) {
            if (!acceptor.isUnsecurable()) continue;
            acceptor.setDefaultActiveMQPrincipal(principal);
        }
    }

    @Override
    public synchronized void pauseAcceptors() {
        if (!this.started) {
            return;
        }
        this.paused = true;
        for (Acceptor acceptor : this.acceptors.values()) {
            try {
                acceptor.pause();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingAcceptor(acceptor.getName());
            }
        }
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized void freeze(String scaleDownNodeID, CoreRemotingConnection connectionToKeepOpen) {
        if (!this.started) {
            return;
        }
        this.failureCheckAndFlushThread.close(false);
        HashMap<Object, ConnectionEntry> connectionEntries = new HashMap<Object, ConnectionEntry>(this.connections);
        for (Map.Entry<Object, ConnectionEntry> entry : connectionEntries.entrySet()) {
            RemotingConnection conn = entry.getValue().connection;
            if (conn.equals(connectionToKeepOpen)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending connection.disconnection packet to " + conn));
            }
            if (conn.isClient()) continue;
            conn.disconnect(scaleDownNodeID, false);
            this.removeConnection(entry.getKey());
        }
    }

    @Override
    public void stop(boolean criticalError) throws Exception {
        boolean ok;
        if (!this.started) {
            return;
        }
        SSLContextFactoryProvider.getSSLContextFactory().clearSSLContexts();
        this.failureCheckAndFlushThread.close(criticalError);
        for (Acceptor acceptor : this.acceptors.values()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pausing acceptor " + acceptor));
            }
            try {
                acceptor.pause();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingAcceptor(acceptor.getName());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending disconnect on live connections");
        }
        HashSet connectionEntries = new HashSet(this.connections.values());
        for (Object entry : connectionEntries) {
            RemotingConnection conn = ((ConnectionEntry)entry).connection;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending connection.disconnection packet to " + conn));
            }
            conn.disconnect(criticalError);
        }
        CountDownLatch countDownLatch = new CountDownLatch(this.acceptors.size());
        for (Acceptor acceptor : this.acceptors.values()) {
            try {
                acceptor.asyncStop(countDownLatch::countDown);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingAcceptor(acceptor.getName());
            }
        }
        countDownLatch.await(3000L, TimeUnit.MILLISECONDS);
        this.acceptors.clear();
        this.connections.clear();
        this.connectionCountLatch.setCount(0);
        if (this.managementService != null) {
            this.managementService.unregisterAcceptors();
        }
        this.threadPool.shutdown();
        if (!criticalError && !(ok = this.threadPool.awaitTermination(10000L, TimeUnit.MILLISECONDS))) {
            ActiveMQServerLogger.LOGGER.timeoutRemotingThreadPool();
        }
        this.started = false;
    }

    @Override
    public Acceptor getAcceptor(String name) {
        return this.acceptors.get(name);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private RemotingConnection getConnection(Object remotingConnectionID) {
        ConnectionEntry entry = (ConnectionEntry)this.connections.get(remotingConnectionID);
        if (entry != null) {
            return entry.connection;
        }
        ActiveMQServerLogger.LOGGER.errorRemovingConnection();
        return null;
    }

    public ConnectionEntry getConnectionEntry(Object remotingConnectionID) {
        ConnectionEntry entry = (ConnectionEntry)this.connections.get(remotingConnectionID);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    @Override
    public RemotingConnection removeConnection(Object remotingConnectionID) {
        ConnectionEntry entry = (ConnectionEntry)this.connections.remove(remotingConnectionID);
        if (entry != null) {
            logger.debug((Object)("RemotingServiceImpl::removing connection ID " + remotingConnectionID));
            this.connectionCountLatch.countDown();
            return entry.connection;
        }
        logger.debug((Object)("The connectionID::" + remotingConnectionID + " was already removed by some other module"));
        return null;
    }

    @Override
    public synchronized Set<RemotingConnection> getConnections() {
        HashSet<RemotingConnection> conns = new HashSet<RemotingConnection>(this.connections.size());
        for (ConnectionEntry entry : this.connections.values()) {
            conns.add(entry.connection);
        }
        return conns;
    }

    @Override
    public int getConnectionCount() {
        return this.connections.size();
    }

    @Override
    public long getTotalConnectionCount() {
        return this.totalConnectionCount.get();
    }

    @Override
    public synchronized ReusableLatch getConnectionCountLatch() {
        return this.connectionCountLatch;
    }

    private ProtocolManagerFactory getProtocolManager(String protocol) {
        return this.protocolMap.get(protocol);
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ProtocolManager protocol) {
        if (this.server == null) {
            throw new IllegalStateException("Unable to create connection, server hasn't finished starting up");
        }
        ConnectionEntry entry = protocol.createConnectionEntry((Acceptor)component, connection);
        try {
            if (this.server.hasBrokerConnectionPlugins()) {
                this.server.callBrokerConnectionPlugins(plugin -> plugin.afterCreateConnection(entry.connection));
            }
        }
        catch (ActiveMQException t) {
            logger.warn("Error executing afterCreateConnection plugin method: {}", (Object)t.getMessage(), (Throwable)t);
            throw new IllegalStateException(t.getMessage(), t.getCause());
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Connection created " + connection));
        }
        this.connections.put(connection.getID(), entry);
        this.connectionCountLatch.countUp();
        this.totalConnectionCount.incrementAndGet();
    }

    public void connectionDestroyed(Object connectionID) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Connection removed " + connectionID + " from server " + this.server), (Throwable)new Exception("trace"));
        }
        this.issueFailure(connectionID, (ActiveMQException)new ActiveMQRemoteDisconnectException());
    }

    private void issueFailure(Object connectionID, ActiveMQException e) {
        ConnectionEntry conn = (ConnectionEntry)this.connections.get(connectionID);
        if (conn != null && !conn.connection.isSupportReconnect()) {
            RemotingConnection removedConnection = this.removeConnection(connectionID);
            if (removedConnection != null) {
                try {
                    if (this.server.hasBrokerConnectionPlugins()) {
                        this.server.callBrokerConnectionPlugins(plugin -> plugin.afterDestroyConnection(removedConnection));
                    }
                }
                catch (ActiveMQException t) {
                    logger.warn("Error executing afterDestroyConnection plugin method: {}", (Object)t.getMessage(), (Throwable)t);
                    conn.connection.fail(t);
                    return;
                }
            }
            conn.connection.fail(e);
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        this.issueFailure(connectionID, me);
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
    }

    @Override
    public void addIncomingInterceptor(BaseInterceptor interceptor) {
        this.incomingInterceptors.add(interceptor);
        this.updateProtocols();
    }

    @Override
    public List<BaseInterceptor> getIncomingInterceptors() {
        return Collections.unmodifiableList(this.incomingInterceptors);
    }

    @Override
    public boolean removeIncomingInterceptor(BaseInterceptor interceptor) {
        if (this.incomingInterceptors.remove(interceptor)) {
            this.updateProtocols();
            return true;
        }
        return false;
    }

    @Override
    public void addOutgoingInterceptor(BaseInterceptor interceptor) {
        this.outgoingInterceptors.add(interceptor);
        this.updateProtocols();
    }

    @Override
    public List<BaseInterceptor> getOutgoinInterceptors() {
        return Collections.unmodifiableList(this.outgoingInterceptors);
    }

    @Override
    public boolean removeOutgoingInterceptor(BaseInterceptor interceptor) {
        if (this.outgoingInterceptors.remove(interceptor)) {
            this.updateProtocols();
            return true;
        }
        return false;
    }

    private ClusterConnection lookupClusterConnection(TransportConfiguration acceptorConfig) {
        String clusterConnectionName = (String)acceptorConfig.getParams().get("clusterConnection");
        ClusterConnection clusterConnection = null;
        if (clusterConnectionName != null) {
            clusterConnection = this.clusterManager.getClusterConnection(clusterConnectionName);
        }
        if (clusterConnection == null) {
            clusterConnection = this.clusterManager.getDefaultConnection(acceptorConfig);
        }
        return clusterConnection;
    }

    protected void updateProtocols() {
        for (Acceptor acceptor : this.acceptors.values()) {
            acceptor.updateInterceptors(this.incomingInterceptors, this.outgoingInterceptors);
        }
    }

    private void locateProtocols(String protocolList, Object transportConfig, Map<String, ProtocolManagerFactory> protocolMap) {
        String[] protocolsSplit;
        for (String protocolItem : protocolsSplit = protocolList.split(",")) {
            ProtocolManagerFactory protocolManagerFactory = this.protocolMap.get(protocolItem);
            if (protocolManagerFactory == null) {
                ActiveMQServerLogger.LOGGER.noProtocolManagerFound(protocolItem, transportConfig.toString());
                continue;
            }
            protocolMap.put(protocolItem, protocolManagerFactory);
        }
    }

    private void resolveProtocols(ClassLoader loader) {
        ServiceLoader<ProtocolManagerFactory> serviceLoader = ServiceLoader.load(ProtocolManagerFactory.class, loader);
        this.loadProtocolManagerFactories(serviceLoader);
    }

    private void loadProtocolManagerFactories(Iterable<ProtocolManagerFactory> protocolManagerFactoryCollection) {
        for (ProtocolManagerFactory next : protocolManagerFactoryCollection) {
            String[] protocols;
            MessagePersister.registerProtocol(next);
            for (String protocol : protocols = next.getProtocols()) {
                ActiveMQServerLogger.LOGGER.addingProtocolSupport(protocol, next.getModuleName());
                this.protocolMap.put(protocol, next);
            }
        }
    }

    private final class FailureCheckAndFlushThread
    extends Thread {
        private final long pauseInterval;
        private volatile boolean closed;
        private final CountDownLatch latch;

        FailureCheckAndFlushThread(long pauseInterval) {
            super("activemq-failure-check-thread");
            this.latch = new CountDownLatch(1);
            this.pauseInterval = pauseInterval;
        }

        public void close(boolean criticalError) {
            this.closed = true;
            this.latch.countDown();
            if (!criticalError) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
        }

        @Override
        public void run() {
            while (!this.closed) {
                try {
                    RemotingConnection conn;
                    long now = System.currentTimeMillis();
                    HashSet<Pair> toRemove = new HashSet<Pair>();
                    for (ConnectionEntry entry : RemotingServiceImpl.this.connections.values()) {
                        conn = entry.connection;
                        boolean flush = true;
                        if (entry.ttl != -1L) {
                            if (!conn.checkDataReceived()) {
                                if (now >= entry.lastCheck + entry.ttl) {
                                    toRemove.add(new Pair(conn.getID(), (Object)entry.ttl));
                                    flush = false;
                                }
                            } else {
                                entry.lastCheck = now;
                            }
                        }
                        if (!flush) continue;
                        RemotingServiceImpl.this.flushExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    conn.scheduledFlush();
                                }
                                catch (Throwable e) {
                                    ActiveMQServerLogger.LOGGER.failedToFlushOutstandingDataFromTheConnection(e);
                                }
                            }
                        });
                    }
                    for (final Pair pair : toRemove) {
                        conn = RemotingServiceImpl.this.getConnection(pair.getA());
                        if (conn == null) continue;
                        RemotingServiceImpl.this.flushExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                conn.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.clientExited(conn.getRemoteAddress(), (Long)pair.getB()));
                            }
                        });
                        RemotingServiceImpl.this.removeConnection(pair.getA());
                    }
                    if (!this.latch.await(this.pauseInterval, TimeUnit.MILLISECONDS)) continue;
                    return;
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.errorOnFailureCheck(e);
                }
            }
        }
    }

    private final class DelegatingBufferHandler
    implements BufferHandler {
        private DelegatingBufferHandler() {
        }

        public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
            ConnectionEntry conn = (ConnectionEntry)RemotingServiceImpl.this.connections.get(connectionID);
            if (conn != null) {
                try {
                    conn.connection.bufferReceived(connectionID, buffer);
                }
                catch (RuntimeException e) {
                    ActiveMQServerLogger.LOGGER.disconnectCritical("Error decoding buffer", e);
                    conn.connection.fail(new ActiveMQException(e.getMessage()));
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("ConnectionID = " + connectionID + " was already closed, so ignoring packet"));
            }
        }
    }
}

