/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.jboss.logging.Logger;

public class BackupManager
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(BackupManager.class);
    private ActiveMQServer server;
    private Executor executor;
    private ScheduledExecutorService scheduledExecutor;
    private NodeManager nodeManager;
    private Configuration configuration;
    private ClusterManager clusterManager;
    List<BackupConnector> backupConnectors = new ArrayList<BackupConnector>();
    private boolean started;

    public BackupManager(ActiveMQServer server, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, NodeManager nodeManager, Configuration configuration, ClusterManager clusterManager) {
        this.server = server;
        this.executor = executorFactory.getExecutor();
        this.scheduledExecutor = scheduledExecutor;
        this.nodeManager = nodeManager;
        this.configuration = configuration;
        this.clusterManager = clusterManager;
    }

    public List<BackupConnector> getBackupConnectors() {
        return this.backupConnectors;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        for (ClusterConnectionConfiguration config : this.configuration.getClusterConfigurations()) {
            logger.debug((Object)("deploy backup config " + config));
            this.deployBackupConnector(config);
        }
        for (BackupConnector conn : this.backupConnectors) {
            if (logger.isDebugEnabled()) {
                logger.debugf("****** BackupManager connecting to %s", (Object)conn);
            }
            conn.start();
            if (!this.server.getHAPolicy().isBackup() || !this.server.getHAPolicy().isSharedStore()) continue;
            conn.informTopology();
            conn.announceBackup();
        }
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.close();
        }
        this.started = false;
    }

    public void announceBackup() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.announceBackup();
        }
    }

    private void deployBackupConnector(ClusterConnectionConfiguration config) throws Exception {
        if (!config.validateConfiguration()) {
            return;
        }
        TransportConfiguration connector = config.getTransportConfiguration(this.configuration);
        if (connector == null) {
            return;
        }
        if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration dg = config.getDiscoveryGroupConfiguration(this.configuration);
            if (dg == null) {
                return;
            }
            DiscoveryBackupConnector backupConnector = new DiscoveryBackupConnector(dg, config.getName(), connector, config.getRetryInterval(), this.clusterManager);
            this.backupConnectors.add(backupConnector);
        } else {
            TransportConfiguration[] tcConfigs = config.getTransportConfigurations(this.configuration);
            StaticBackupConnector backupConnector = new StaticBackupConnector(tcConfigs, config.getName(), connector, config.getRetryInterval(), this.clusterManager);
            this.backupConnectors.add(backupConnector);
        }
    }

    public void activated() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            backupConnector.close();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isBackupAnnounced() {
        for (BackupConnector backupConnector : this.backupConnectors) {
            if (backupConnector.isBackupAnnounced()) continue;
            return false;
        }
        return true;
    }

    private final class DiscoveryBackupConnector
    extends BackupConnector {
        private final DiscoveryGroupConfiguration discoveryGroupConfiguration;

        private DiscoveryBackupConnector(DiscoveryGroupConfiguration discoveryGroupConfiguration, String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            super(name, connector, retryInterval, clusterManager);
            this.discoveryGroupConfiguration = discoveryGroupConfiguration;
        }

        @Override
        public ServerLocatorInternal createServerLocator(Topology topology) {
            return new ServerLocatorImpl(topology, true, this.discoveryGroupConfiguration).setRetryInterval(this.retryInterval);
        }

        @Override
        public String toString() {
            return "DiscoveryBackupConnector [group=" + this.discoveryGroupConfiguration + "]";
        }
    }

    private final class StaticBackupConnector
    extends BackupConnector {
        private final TransportConfiguration[] tcConfigs;

        private StaticBackupConnector(TransportConfiguration[] tcConfigs, String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            super(name, connector, retryInterval, clusterManager);
            this.tcConfigs = tcConfigs;
        }

        @Override
        public ServerLocatorInternal createServerLocator(Topology topology) {
            if (this.tcConfigs != null && this.tcConfigs.length > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(BackupManager.this + "Creating a serverLocator for " + Arrays.toString(this.tcConfigs)));
                }
                ServerLocatorImpl locator = new ServerLocatorImpl(topology, true, this.tcConfigs);
                locator.setClusterConnection(true);
                locator.setRetryInterval(this.retryInterval);
                locator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)locator, BackupManager.this.server.getStorageManager()));
                return locator;
            }
            return null;
        }

        @Override
        public String toString() {
            return "StaticBackupConnector [tcConfigs=" + Arrays.toString(this.tcConfigs) + "]";
        }
    }

    public abstract class BackupConnector {
        private volatile ServerLocatorInternal backupServerLocator;
        private String name;
        private TransportConfiguration connector;
        protected long retryInterval;
        private ClusterManager clusterManager;
        private boolean stopping = false;
        private boolean announcingBackup;
        private boolean backupAnnounced = false;

        public String toString() {
            return "BackupConnector{name='" + this.name + '\'' + ", connector=" + this.connector + '}';
        }

        private BackupConnector(String name, TransportConfiguration connector, long retryInterval, ClusterManager clusterManager) {
            this.name = name;
            this.connector = connector;
            this.retryInterval = retryInterval;
            this.clusterManager = clusterManager;
        }

        abstract ServerLocatorInternal createServerLocator(Topology var1);

        public ServerLocator getBackupServerLocator() {
            return this.backupServerLocator;
        }

        void start() {
            this.stopping = false;
            this.backupAnnounced = false;
            ClusterConnection clusterConnection = this.clusterManager.getClusterConnection(this.name);
            this.backupServerLocator = this.createServerLocator(clusterConnection.getTopology());
            if (this.backupServerLocator != null) {
                this.backupServerLocator.setIdentity("backupLocatorFor='" + BackupManager.this.server + "'");
                this.backupServerLocator.setReconnectAttempts(-1);
                this.backupServerLocator.setInitialConnectAttempts(-1);
                this.backupServerLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.backupServerLocator, BackupManager.this.server.getStorageManager()));
            }
        }

        public void announceBackup() {
            BackupManager.this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (BackupConnector.this.stopping) {
                        return;
                    }
                    try {
                        ServerLocatorInternal localBackupLocator = BackupConnector.this.backupServerLocator;
                        if (localBackupLocator == null) {
                            if (!BackupConnector.this.stopping) {
                                ActiveMQServerLogger.LOGGER.errorAnnouncingBackup(this.toString());
                            }
                            return;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(BackupConnector.this + ":: announcing " + BackupConnector.this.connector + " to " + BackupConnector.this.backupServerLocator));
                        }
                        BackupConnector.this.announcingBackup = true;
                        ClientSessionFactoryInternal backupSessionFactory = localBackupLocator.connect();
                        if (backupSessionFactory != null) {
                            ClusterControl clusterControl = BackupConnector.this.clusterManager.getClusterController().connectToNodeInCluster(backupSessionFactory);
                            clusterControl.authorize();
                            clusterControl.sendNodeAnnounce(System.currentTimeMillis(), BackupManager.this.nodeManager.getNodeId().toString(), BackupManager.this.server.getHAPolicy().getBackupGroupName(), BackupManager.this.server.getHAPolicy().getScaleDownClustername(), true, BackupConnector.this.connector, null);
                            ActiveMQServerLogger.LOGGER.backupAnnounced();
                            BackupConnector.this.backupAnnounced = true;
                        }
                    }
                    catch (RejectedExecutionException localBackupLocator) {
                    }
                    catch (Exception e) {
                        if (BackupManager.this.scheduledExecutor.isShutdown()) {
                            return;
                        }
                        if (BackupConnector.this.stopping) {
                            return;
                        }
                        ActiveMQServerLogger.LOGGER.errorAnnouncingBackup(e);
                        BackupConnector.this.retryConnection();
                    }
                    finally {
                        BackupConnector.this.announcingBackup = false;
                    }
                }
            });
        }

        protected void retryConnection() {
            BackupManager.this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    BackupConnector.this.announceBackup();
                }
            }, this.retryInterval, TimeUnit.MILLISECONDS);
        }

        public void informTopology() {
            this.clusterManager.informClusterOfBackup(this.name);
        }

        public void close() {
            this.stopping = true;
            if (this.announcingBackup) {
                this.closeLocator(this.backupServerLocator);
            }
            BackupManager.this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BackupConnector backupConnector = BackupConnector.this;
                    synchronized (backupConnector) {
                        BackupConnector.this.closeLocator(BackupConnector.this.backupServerLocator);
                        BackupConnector.this.backupServerLocator = null;
                    }
                }
            });
        }

        public boolean isBackupAnnounced() {
            return this.backupAnnounced;
        }

        private void closeLocator(ServerLocatorInternal backupServerLocator) {
            if (backupServerLocator != null) {
                backupServerLocator.close();
            }
        }
    }
}

