/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.CopyOnWriteBindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.Proposal;
import org.apache.activemq.artemis.core.server.group.impl.Response;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.jboss.logging.Logger;

public final class BindingsImpl
implements Bindings {
    private static final Logger logger = Logger.getLogger(BindingsImpl.class);
    public static final int MAX_GROUP_RETRY = 10;
    private final CopyOnWriteBindings routingNameBindingMap = new CopyOnWriteBindings();
    private final Map<Long, Binding> bindingsIdMap = new ConcurrentHashMap<Long, Binding>();
    private final Map<SimpleString, Binding> bindingsNameMap = new ConcurrentHashMap<SimpleString, Binding>();
    private final Set<Binding> exclusiveBindings = new CopyOnWriteArraySet<Binding>();
    private volatile MessageLoadBalancingType messageLoadBalancingType = MessageLoadBalancingType.OFF;
    private final GroupingHandler groupingHandler;
    private final SimpleString name;
    private static final AtomicInteger sequenceVersion = new AtomicInteger(Integer.MIN_VALUE);
    private final AtomicInteger version = new AtomicInteger(sequenceVersion.incrementAndGet());

    public BindingsImpl(SimpleString name, GroupingHandler groupingHandler) {
        this.groupingHandler = groupingHandler;
        this.name = name;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public void setMessageLoadBalancingType(MessageLoadBalancingType messageLoadBalancingType) {
        this.messageLoadBalancingType = messageLoadBalancingType;
    }

    @Override
    public MessageLoadBalancingType getMessageLoadBalancingType() {
        return this.messageLoadBalancingType;
    }

    @Override
    public Collection<Binding> getBindings() {
        return this.bindingsIdMap.values();
    }

    @Override
    public void unproposed(SimpleString groupID) {
        for (Binding binding : this.bindingsIdMap.values()) {
            binding.unproposed(groupID);
        }
    }

    @Override
    public void addBinding(Binding binding) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("addBinding(" + binding + ") being called"));
            }
            if (binding.isExclusive()) {
                this.exclusiveBindings.add(binding);
            } else {
                this.routingNameBindingMap.addBindingIfAbsent(binding);
            }
            this.bindingsIdMap.put(binding.getID(), binding);
            this.bindingsNameMap.put(binding.getUniqueName(), binding);
            if (binding instanceof RemoteQueueBinding) {
                this.setMessageLoadBalancingType(((RemoteQueueBinding)binding).getMessageLoadBalancingType());
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Adding binding " + binding + " into " + this + " bindingTable: " + this.debugBindings()));
            }
        }
        finally {
            this.updated();
        }
    }

    @Override
    public void updated(QueueBinding binding) {
        this.updated();
    }

    private void updated() {
        this.version.set(sequenceVersion.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binding removeBindingByUniqueName(SimpleString bindingUniqueName) {
        Binding binding = this.bindingsNameMap.remove(bindingUniqueName);
        if (binding == null) {
            return null;
        }
        try {
            if (binding.isExclusive()) {
                this.exclusiveBindings.remove(binding);
            } else {
                this.routingNameBindingMap.removeBinding(binding);
            }
            this.bindingsIdMap.remove(binding.getID());
            assert (!this.bindingsNameMap.containsKey(binding.getUniqueName()));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Removing binding " + binding + " from " + this + " bindingTable: " + this.debugBindings()));
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.updated();
        }
    }

    @Override
    public boolean allowRedistribute() {
        return this.messageLoadBalancingType.equals((Object)MessageLoadBalancingType.ON_DEMAND);
    }

    @Override
    public boolean redistribute(Message message, Queue originatingQueue, RoutingContext context) throws Exception {
        SimpleString routingName;
        Pair<Binding[], CopyOnWriteBindings.BindingIndex> bindingsAndPosition;
        MessageLoadBalancingType loadBalancingType = this.messageLoadBalancingType;
        if (loadBalancingType.equals((Object)MessageLoadBalancingType.STRICT) || loadBalancingType.equals((Object)MessageLoadBalancingType.OFF)) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Redistributing message %s", (Object)message);
        }
        if ((bindingsAndPosition = this.routingNameBindingMap.getBindings(routingName = originatingQueue.getName())) == null) {
            return false;
        }
        Binding[] bindings = (Binding[])bindingsAndPosition.getA();
        CopyOnWriteBindings.BindingIndex bindingIndex = (CopyOnWriteBindings.BindingIndex)bindingsAndPosition.getB();
        assert (bindings.length > 0);
        int bindingsCount = bindings.length;
        int nextPosition = bindingIndex.getIndex();
        if (nextPosition >= bindingsCount) {
            nextPosition = 0;
        }
        Binding nextBinding = null;
        for (int i = 0; i < bindingsCount; ++i) {
            Binding binding = bindings[nextPosition];
            nextPosition = BindingsImpl.moveNextPosition(nextPosition, bindingsCount);
            Filter filter = binding.getFilter();
            boolean highPrior = binding.isHighAcceptPriority(message);
            if (!highPrior || binding.getBindable() == originatingQueue || filter != null && !filter.match(message)) continue;
            nextBinding = binding;
            break;
        }
        if (nextBinding == null) {
            return false;
        }
        bindingIndex.setIndex(nextPosition);
        nextBinding.route(message, context);
        return true;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        this.route(message, context, true);
    }

    private void route(Message message, RoutingContext context, boolean groupRouting) throws Exception {
        boolean routed;
        byte[] ids;
        int currentVersion = this.version.get();
        boolean reusableContext = context.isReusable(message, currentVersion);
        if (!reusableContext) {
            context.clear();
        }
        if ((ids = message.removeExtraBytesProperty(Message.HDR_SCALEDOWN_TO_IDS)) != null) {
            this.handleScaledDownMessage(message, ids);
        }
        if (!(routed = !this.exclusiveBindings.isEmpty() ? this.routeToExclusiveBindings(message, context) : false)) {
            SimpleString groupId;
            byte[] routeToIds = message.removeExtraBytesProperty(Message.HDR_ROUTE_TO_IDS);
            if (routeToIds != null) {
                context.clear().setReusable(false);
                this.routeFromCluster(message, context, routeToIds);
            } else if (groupRouting && this.groupingHandler != null && (groupId = message.getGroupID()) != null) {
                context.clear().setReusable(false);
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, groupId, 0);
            } else if (CompositeAddress.isFullyQualified((String)message.getAddress())) {
                context.clear().setReusable(false);
                Binding theBinding = this.bindingsNameMap.get(CompositeAddress.extractQueueName((SimpleString)message.getAddressSimpleString()));
                if (theBinding != null) {
                    theBinding.route(message, context);
                }
            } else if (!reusableContext) {
                this.simpleRouting(message, context, currentVersion);
            }
        }
    }

    private boolean routeToExclusiveBindings(Message message, RoutingContext context) throws Exception {
        boolean hasExclusives = false;
        boolean routed = false;
        for (Binding binding : this.exclusiveBindings) {
            Filter filter;
            if (!hasExclusives) {
                context.clear().setReusable(false);
                hasExclusives = true;
            }
            if ((filter = binding.getFilter()) != null && !filter.match(message)) continue;
            binding.getBindable().route(message, context);
            routed = true;
        }
        return routed;
    }

    private void handleScaledDownMessage(Message message, byte[] ids) {
        ByteBuffer buffer = ByteBuffer.wrap(ids);
        while (buffer.hasRemaining()) {
            long id = buffer.getLong();
            for (Map.Entry<Long, Binding> entry : this.bindingsIdMap.entrySet()) {
                RemoteQueueBinding remoteQueueBinding;
                if (!(entry.getValue() instanceof RemoteQueueBinding) || (remoteQueueBinding = (RemoteQueueBinding)entry.getValue()).getRemoteQueueID() != id) continue;
                message.putExtraBytesProperty(Message.HDR_ROUTE_TO_IDS, ByteBuffer.allocate(8).putLong(remoteQueueBinding.getID()).array());
            }
        }
    }

    private void simpleRouting(Message message, RoutingContext context, int currentVersion) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.tracef("Routing message %s on binding=%s current context::$s", (Object)message, (Object)this, (Object)context);
        }
        this.routingNameBindingMap.forEach((routingName, bindings, nextPosition) -> {
            Binding nextBinding = this.getNextBinding(message, bindings, nextPosition);
            if (nextBinding != null && nextBinding.getFilter() == null && nextBinding.isLocal() && bindings.length == 1) {
                context.setReusable(true, currentVersion);
            } else {
                context.setReusable(false, currentVersion);
            }
            if (nextBinding != null) {
                nextBinding.route(message, context);
            }
        });
    }

    public String toString() {
        return "BindingsImpl [name=" + this.name + "]";
    }

    private Binding getNextBinding(Message message, Binding[] bindings, CopyOnWriteBindings.BindingIndex bindingIndex) {
        int bindingsCount;
        int nextPosition = bindingIndex.getIndex();
        if (nextPosition >= (bindingsCount = bindings.length)) {
            nextPosition = 0;
        }
        Binding nextBinding = null;
        int lastLowPriorityBinding = -1;
        MessageLoadBalancingType loadBalancingType = this.messageLoadBalancingType;
        for (int i = 0; i < bindingsCount; ++i) {
            Binding binding = bindings[nextPosition];
            if (BindingsImpl.matchBinding(message, binding, loadBalancingType)) {
                if (bindingsCount == 1 || binding.isConnected() && (loadBalancingType.equals((Object)MessageLoadBalancingType.STRICT) || binding.isHighAcceptPriority(message))) {
                    nextBinding = binding;
                    nextPosition = BindingsImpl.moveNextPosition(nextPosition, bindingsCount);
                    break;
                }
                if (lastLowPriorityBinding == -1 || loadBalancingType.equals((Object)MessageLoadBalancingType.ON_DEMAND) && binding instanceof LocalQueueBinding) {
                    lastLowPriorityBinding = nextPosition;
                }
            }
            nextPosition = BindingsImpl.moveNextPosition(nextPosition, bindingsCount);
        }
        if (nextBinding == null && lastLowPriorityBinding != -1) {
            nextBinding = bindings[lastLowPriorityBinding];
            nextPosition = BindingsImpl.moveNextPosition(lastLowPriorityBinding, bindingsCount);
        }
        if (nextBinding != null) {
            bindingIndex.setIndex(nextPosition);
        }
        return nextBinding;
    }

    private static boolean matchBinding(Message message, Binding binding, MessageLoadBalancingType loadBalancingType) {
        if (loadBalancingType.equals((Object)MessageLoadBalancingType.OFF) && binding instanceof RemoteQueueBinding) {
            return false;
        }
        Filter filter = binding.getFilter();
        return filter == null || filter.match(message);
    }

    private void routeUsingStrictOrdering(Message message, RoutingContext context, GroupingHandler groupingGroupingHandler, SimpleString groupId, int tries) throws Exception {
        this.routingNameBindingMap.forEach((routingName, bindings, nextPosition) -> {
            SimpleString fullID = groupId.concat(".").concat(routingName);
            Response resp = groupingGroupingHandler.getProposal(fullID, true);
            if (resp == null) {
                Binding theBinding = this.getNextBinding(message, bindings, nextPosition);
                if (theBinding == null) {
                    return;
                }
                resp = groupingGroupingHandler.propose(new Proposal(fullID, theBinding.getClusterName()));
                if (resp == null) {
                    logger.debug((Object)("it got a timeout on propose, trying again, number of retries: " + tries));
                    theBinding = null;
                }
                if (resp != null && resp.getAlternativeClusterName() != null) {
                    theBinding = BindingsImpl.locateBinding(resp.getAlternativeClusterName(), bindings);
                }
                this.routeAndCheckNull(message, context, resp, theBinding, groupId, tries);
            } else {
                Binding chosen = BindingsImpl.locateBinding(resp.getChosenClusterName(), bindings);
                this.routeAndCheckNull(message, context, resp, chosen, groupId, tries);
            }
        });
    }

    private static Binding locateBinding(SimpleString clusterName, Binding[] bindings) {
        for (Binding binding : bindings) {
            if (!binding.getClusterName().equals((Object)clusterName)) continue;
            return binding;
        }
        return null;
    }

    private void routeAndCheckNull(Message message, RoutingContext context, Response resp, Binding theBinding, SimpleString groupId, int tries) throws Exception {
        if (theBinding != null) {
            theBinding.route(message, context);
        } else {
            if (resp != null) {
                this.groupingHandler.forceRemove(resp.getGroupId(), resp.getClusterName());
            }
            if (tries < 10) {
                this.routeUsingStrictOrdering(message, context, this.groupingHandler, groupId, tries + 1);
            } else {
                ActiveMQServerLogger.LOGGER.impossibleToRouteGrouped();
                this.route(message, context, false);
            }
        }
    }

    private String debugBindings() {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.println("\n**************************************************");
        out.println("routingNameBindingMap:");
        if (this.routingNameBindingMap.isEmpty()) {
            out.println("\tEMPTY!");
        }
        this.routingNameBindingMap.forEach((routingName, bindings, nextPosition) -> {
            out.println("\tkey=" + routingName + ",\tposition=" + nextPosition.getIndex() + "\tvalue(s):");
            for (Binding bind : bindings) {
                out.println("\t\t" + bind);
            }
            out.println();
        });
        out.println();
        out.println("bindingsMap:");
        if (this.bindingsIdMap.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Map.Entry<Long, Binding> entry : this.bindingsIdMap.entrySet()) {
            out.println("\tkey=" + entry.getKey() + ", value=" + entry.getValue());
        }
        out.println();
        out.println("exclusiveBindings:");
        if (this.exclusiveBindings.isEmpty()) {
            out.println("\tEMPTY!");
        }
        for (Binding binding : this.exclusiveBindings) {
            out.println("\t" + binding);
        }
        out.println("####################################################");
        return writer.toString();
    }

    private void routeFromCluster(Message message, RoutingContext context, byte[] ids) throws Exception {
        long bindingID;
        ByteBuffer buff;
        byte[] idsToAck = (byte[])message.removeProperty(Message.HDR_ROUTE_TO_ACK_IDS);
        ArrayList<Long> idsToAckList = new ArrayList<Long>();
        if (idsToAck != null) {
            buff = ByteBuffer.wrap(idsToAck);
            while (buff.hasRemaining()) {
                bindingID = buff.getLong();
                idsToAckList.add(bindingID);
            }
        }
        buff = ByteBuffer.wrap(ids);
        while (buff.hasRemaining()) {
            bindingID = buff.getLong();
            Binding binding = this.bindingsIdMap.get(bindingID);
            if (binding != null) {
                if (idsToAckList.contains(bindingID)) {
                    binding.routeWithAck(message, context);
                    continue;
                }
                binding.route(message, context);
                continue;
            }
            ActiveMQServerLogger.LOGGER.bindingNotFound(bindingID, message.toString(), this.toString());
        }
    }

    private static int moveNextPosition(int position, int length) {
        if (++position == length) {
            position = 0;
        }
        return position;
    }

    public Map<SimpleString, List<Binding>> getRoutingNameBindingMap() {
        return this.routingNameBindingMap.copyAsMap();
    }
}

