/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueManager;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;
import org.jboss.logging.Logger;

public class QueueManagerImpl
extends ReferenceCounterUtil
implements QueueManager {
    private static final Logger logger = Logger.getLogger(QueueManagerImpl.class);
    private final SimpleString queueName;
    private final ActiveMQServer server;

    private void doIt() {
        Queue queue = this.server.locateQueue(this.queueName);
        if (queue == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("no queue to delete \"" + this.queueName + "\"."));
            }
            return;
        }
        if (queue.isPurgeOnNoConsumers()) {
            QueueManagerImpl.purge(queue);
        }
    }

    private static void purge(Queue queue) {
        long consumerCount = queue.getConsumerCount();
        long messageCount = queue.getMessageCount();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("purging queue \"" + queue.getName() + "\": consumerCount = " + consumerCount + "; messageCount = " + messageCount));
        }
        try {
            queue.deleteMatchingReferences(500, null, AckReason.KILLED);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToPurgeQueue(e, queue.getName());
        }
    }

    public static void performAutoDeleteQueue(ActiveMQServer server, Queue queue) {
        SimpleString queueName = queue.getName();
        AddressSettings settings = server.getAddressSettingsRepository().getMatch(queue.getAddress().toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleting auto-created queue \"" + queueName + "\": consumerCount = " + queue.getConsumerCount() + "; messageCount = " + queue.getMessageCount() + "; isAutoDelete = " + queue.isAutoDelete()));
        }
        ActiveMQServerLogger.LOGGER.autoRemoveQueue("" + queue.getName(), queue.getID(), "" + queue.getAddress());
        try {
            server.destroyQueue(queueName, null, true, false, settings.isAutoDeleteAddresses(), true);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedDestination(e, queueName, "queue");
        }
    }

    public static boolean isAutoDelete(Queue queue) {
        return queue.isAutoDelete();
    }

    public static boolean messageCountCheck(Queue queue) {
        return queue.getAutoDeleteMessageCount() == -1L || queue.getMessageCount() <= queue.getAutoDeleteMessageCount();
    }

    public static boolean delayCheck(Queue queue) {
        return System.currentTimeMillis() - queue.getConsumerRemovedTimestamp() >= queue.getAutoDeleteDelay();
    }

    public static boolean consumerCountCheck(Queue queue) {
        return queue.getConsumerCount() == 0;
    }

    public QueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        super((Executor)server.getExecutorFactory().getExecutor());
        this.server = server;
        this.queueName = queueName;
        this.setTask(this::doIt);
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

