/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.LivePageCacheImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageSyncTimer;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.jboss.logging.Logger;

public class PagingStoreImpl
implements PagingStore {
    private static final Logger logger = Logger.getLogger(PagingStoreImpl.class);
    private final SimpleString address;
    private final StorageManager storageManager;
    private final DecimalFormat format = new DecimalFormat("000000000");
    private final AtomicInteger currentPageSize = new AtomicInteger(0);
    private final SimpleString storeName;
    private volatile SequentialFileFactory fileFactory;
    private final PagingStoreFactory storeFactory;
    private final PageSyncTimer syncTimer;
    private long maxSize;
    private long pageSize;
    private volatile AddressFullMessagePolicy addressFullMessagePolicy;
    private boolean printedDropMessagesWarning;
    private final PagingManager pagingManager;
    private final boolean usingGlobalMaxSize;
    private final Executor executor;
    private final AtomicLong sizeInBytes = new AtomicLong();
    private int numberOfPages;
    private int firstPageId;
    private volatile int currentPageId;
    private volatile Page currentPage;
    private volatile boolean paging = false;
    private final PageCursorProvider cursorProvider;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    private final boolean syncNonTransactional;
    private volatile AtomicBoolean blocking = new AtomicBoolean(false);
    private long rejectThreshold;
    private final java.util.Queue<OverSizedRunnable> onMemoryFreedRunnables = new ConcurrentLinkedQueue<OverSizedRunnable>();
    private final Runnable memoryFreedRunnablesExecutor = new MemoryFreedRunnablesExecutor();

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, Executor executor, boolean syncNonTransactional) {
        if (pagingManager == null) {
            throw new IllegalStateException("Paging Manager can't be null");
        }
        this.address = address;
        this.storageManager = storageManager;
        this.storeName = storeName;
        this.applySetting(addressSettings);
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE && this.maxSize != -1L && this.pageSize >= this.maxSize) {
            throw new IllegalStateException("pageSize for address " + address + " >= maxSize. Normally pageSize should" + " be significantly smaller than maxSize, ms: " + this.maxSize + " ps " + this.pageSize);
        }
        this.executor = executor;
        this.pagingManager = pagingManager;
        this.fileFactory = fileFactory;
        this.storeFactory = storeFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.syncTimer = scheduledExecutor != null && syncTimeout > 0L ? new PageSyncTimer(this, scheduledExecutor, executor, syncTimeout) : null;
        this.cursorProvider = storeFactory.newCursorProvider(this, this.storageManager, addressSettings, executor);
        this.usingGlobalMaxSize = pagingManager.isUsingGlobalSize();
    }

    @Override
    public void applySetting(AddressSettings addressSettings) {
        this.maxSize = addressSettings.getMaxSizeBytes();
        this.pageSize = addressSettings.getPageSizeBytes();
        this.addressFullMessagePolicy = addressSettings.getAddressFullMessagePolicy();
        this.rejectThreshold = addressSettings.getMaxSizeBytesRejectThreshold();
        if (this.cursorProvider != null) {
            this.cursorProvider.setCacheMaxSize(addressSettings.getPageCacheMaxSize());
        }
    }

    public String toString() {
        return "PagingStoreImpl(" + this.address + ")";
    }

    @Override
    public boolean lock(long timeout) {
        if (timeout == -1L) {
            this.lock.writeLock().lock();
            return true;
        }
        try {
            return this.lock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void unlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public PageCursorProvider getCursorProvider() {
        return this.cursorProvider;
    }

    @Override
    public long getFirstPage() {
        return this.firstPageId;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getAddressSize() {
        return this.sizeInBytes.get();
    }

    @Override
    public long getMaxSize() {
        if (this.maxSize < 0L) {
            return this.pageSize * 2L;
        }
        return this.maxSize;
    }

    @Override
    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    @Override
    public long getPageSizeBytes() {
        return this.pageSize;
    }

    @Override
    public File getFolder() {
        SequentialFileFactory factoryUsed = this.fileFactory;
        if (factoryUsed != null) {
            return factoryUsed.getDirectory();
        }
        return null;
    }

    @Override
    public boolean isPaging() {
        this.lock.readLock().lock();
        try {
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
                boolean bl = false;
                return bl;
            }
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
                boolean bl = this.isFull();
                return bl;
            }
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP) {
                boolean bl = this.isFull();
                return bl;
            }
            boolean bl = this.paging;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public int getCurrentWritingPage() {
        return this.currentPageId;
    }

    @Override
    public SimpleString getStoreName() {
        return this.storeName;
    }

    @Override
    public void sync() throws Exception {
        if (this.syncTimer != null) {
            this.syncTimer.addSync(this.storageManager.getContext());
        } else {
            this.ioSync();
        }
    }

    @Override
    public void ioSync() throws Exception {
        this.lock.readLock().lock();
        try {
            if (this.currentPage != null) {
                this.currentPage.sync();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        this.cursorProvider.processReload();
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    public boolean isStarted() {
        return this.running;
    }

    public synchronized void stop() throws Exception {
        if (this.running) {
            this.cursorProvider.stop();
            this.running = false;
            this.flushExecutors();
            if (this.currentPage != null) {
                this.currentPage.close(false);
                this.currentPage = null;
            }
        }
    }

    @Override
    public void flushExecutors() {
        this.cursorProvider.flushExecutors();
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        if (!future.await(60000L)) {
            ActiveMQServerLogger.LOGGER.pageStoreTimeout(this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.lock.writeLock().lock();
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            this.firstPageId = Integer.MAX_VALUE;
            if (this.fileFactory != null) {
                this.currentPageId = 0;
                if (this.currentPage != null) {
                    this.currentPage.close(false);
                }
                this.currentPage = null;
                List files = this.fileFactory.listFiles("page");
                this.numberOfPages = files.size();
                for (String fileName : files) {
                    int fileId = PagingStoreImpl.getPageIdFromFileName(fileName);
                    if (fileId > this.currentPageId) {
                        this.currentPageId = fileId;
                    }
                    if (fileId >= this.firstPageId) continue;
                    this.firstPageId = fileId;
                }
                if (this.currentPageId != 0) {
                    this.currentPage = this.createPage(this.currentPageId);
                    this.currentPage.open();
                    List<PagedMessage> messages = this.currentPage.read(this.storageManager);
                    LivePageCacheImpl pageCache = new LivePageCacheImpl(this.currentPage);
                    for (PagedMessage msg : messages) {
                        pageCache.addLiveMessage(msg);
                        if (!msg.getMessage().isLargeMessage()) continue;
                        ((LargeServerMessage)msg.getMessage()).decrementDelayDeletionCount();
                    }
                    this.currentPage.setLiveCache(pageCache);
                    this.currentPageSize.set(this.currentPage.getSize());
                    this.cursorProvider.addPageCache(pageCache);
                }
                if (this.currentPage != null && (this.numberOfPages != 1 || this.currentPage.getSize() != 0)) {
                    this.startPaging();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void stopPaging() {
        this.lock.writeLock().lock();
        try {
            this.paging = false;
            this.cursorProvider.onPageModeCleared();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean startPaging() {
        if (!this.running) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
            if (this.currentPage == null) {
                try {
                    this.openNewPage();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.pageStoreStartIOError(e);
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
            }
            this.paging = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean checkPageFileExists(int pageNumber) {
        String fileName = this.createFileName(pageNumber);
        try {
            this.checkFileFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SequentialFile file = this.fileFactory.createSequentialFile(fileName);
        return file.exists();
    }

    @Override
    public Page createPage(int pageNumber) throws Exception {
        String fileName = this.createFileName(pageNumber);
        this.checkFileFactory();
        SequentialFile file = this.fileFactory.createSequentialFile(fileName);
        Page page = new Page(this.storeName, this.storageManager, this.fileFactory, file, pageNumber);
        file.open();
        file.position(0L);
        file.close();
        return page;
    }

    private void checkFileFactory() throws Exception {
        if (this.fileFactory == null) {
            this.fileFactory = this.storeFactory.newFileFactory(this.getStoreName());
        }
    }

    @Override
    public void forceAnotherPage() throws Exception {
        this.openNewPage();
    }

    @Override
    public Page depage() throws Exception {
        this.lock.writeLock().lock();
        try {
            Page returnPage;
            if (!this.running) {
                Page page = null;
                return page;
            }
            if (this.numberOfPages == 0) {
                Page page = null;
                return page;
            }
            --this.numberOfPages;
            if (this.currentPageId == this.firstPageId) {
                this.firstPageId = Integer.MAX_VALUE;
                if (this.currentPage == null) {
                    throw new IllegalStateException("CurrentPage is null");
                }
                Page returnPage2 = this.currentPage;
                returnPage2.close(false);
                this.currentPage = null;
                if (returnPage2.getNumberOfMessages() == 0) {
                    this.stopPaging();
                    returnPage2.open();
                    returnPage2.delete(null);
                    Page page = null;
                    return page;
                }
                this.openNewPage();
                Page page = returnPage2;
                return page;
            }
            Page page = returnPage = this.createPage(this.firstPageId++);
            return page;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean checkMemory(Runnable runWhenAvailable) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL && (this.maxSize != -1L || this.usingGlobalMaxSize || this.pagingManager.isDiskFull())) {
            if (this.isFull()) {
                return false;
            }
        } else if ((this.pagingManager.isDiskFull() || this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK && (this.maxSize != -1L || this.usingGlobalMaxSize)) && (this.pagingManager.isDiskFull() || this.maxSize > 0L && this.sizeInBytes.get() > this.maxSize || this.pagingManager.isGlobalFull())) {
            OverSizedRunnable ourRunnable = new OverSizedRunnable(runWhenAvailable);
            this.onMemoryFreedRunnables.add(ourRunnable);
            if (!(this.pagingManager.isGlobalFull() || this.sizeInBytes.get() > this.maxSize && this.maxSize >= 0L)) {
                ourRunnable.run();
            } else {
                if (this.usingGlobalMaxSize || this.pagingManager.isDiskFull()) {
                    this.pagingManager.addBlockedStore(this);
                }
                if (!this.blocking.get()) {
                    if (this.pagingManager.isDiskFull()) {
                        ActiveMQServerLogger.LOGGER.blockingDiskFull(this.address);
                    } else {
                        ActiveMQServerLogger.LOGGER.blockingMessageProduction(this.address, this.sizeInBytes.get(), this.maxSize, this.pagingManager.getGlobalSize());
                    }
                    this.blocking.set(true);
                }
            }
            return true;
        }
        runWhenAvailable.run();
        return true;
    }

    @Override
    public void addSize(int size) {
        boolean globalFull = this.pagingManager.addSize(size).isGlobalFull();
        long newSize = this.sizeInBytes.addAndGet(size);
        if (newSize < 0L) {
            ActiveMQServerLogger.LOGGER.negativeAddressSize(newSize, this.address.toString());
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            if (this.usingGlobalMaxSize && !globalFull || this.maxSize != -1L) {
                this.checkReleaseMemory(globalFull, newSize);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE) {
            if (size > 0 && (this.maxSize != -1L && newSize > this.maxSize || globalFull) && this.startPaging()) {
                ActiveMQServerLogger.LOGGER.pageStoreStart(this.storeName, newSize, this.maxSize);
            }
            return;
        }
    }

    @Override
    public boolean checkReleasedMemory() {
        return this.checkReleaseMemory(this.pagingManager.isGlobalFull(), this.sizeInBytes.get());
    }

    public boolean checkReleaseMemory(boolean globalOversized, long newSize) {
        if (!(globalOversized || newSize > this.maxSize && this.maxSize >= 0L || this.onMemoryFreedRunnables.isEmpty())) {
            this.executor.execute(this.memoryFreedRunnablesExecutor);
            if (this.blocking.get()) {
                ActiveMQServerLogger.LOGGER.unblockingMessageProduction(this.address, this.sizeInBytes.get(), this.maxSize);
                this.blocking.set(false);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean page(Message message, Transaction tx, RouteContextList listCtx, ReentrantReadWriteLock.ReadLock managerLock) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("PagingStore(" + this.getStoreName() + ") not initialized");
        }
        boolean full = this.isFull();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (full) {
                if (!this.printedDropMessagesWarning) {
                    this.printedDropMessagesWarning = true;
                    ActiveMQServerLogger.LOGGER.pageStoreDropMessages(this.storeName, this.sizeInBytes.get(), this.maxSize);
                }
                if (message.isLargeMessage()) {
                    ((LargeServerMessage)message).deleteFile();
                }
                if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
                    throw ActiveMQMessageBundle.BUNDLE.addressIsFull(this.address.toString());
                }
                return true;
            }
            return false;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (!this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (managerLock != null) {
            managerLock.lock();
        }
        try {
            int bytesToWrite;
            block27: {
                this.lock.writeLock().lock();
                try {
                    if (this.paging) break block27;
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            message.setAddress(this.address);
            long transactionID = tx == null ? -1L : tx.getID();
            PagedMessageImpl pagedMessage = new PagedMessageImpl(message, this.routeQueues(tx, listCtx), transactionID);
            if (message.isLargeMessage()) {
                ((LargeServerMessage)message).setPaged();
            }
            if ((long)this.currentPageSize.addAndGet(bytesToWrite = pagedMessage.getEncodeSize() + 6) > this.pageSize && this.currentPage.getNumberOfMessages() > 0) {
                this.openNewPage();
                this.currentPageSize.addAndGet(bytesToWrite);
            }
            if (tx != null) {
                this.installPageTransaction(tx, listCtx);
            }
            this.applyPageCounters(tx, this.getCurrentPage(), listCtx);
            this.currentPage.write(pagedMessage);
            if (tx == null && this.syncNonTransactional && message.isDurable()) {
                this.sync();
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Paging message " + pagedMessage + " on pageStore " + this.getStoreName() + " pageNr=" + this.currentPage.getPageId()));
            }
            boolean bl = true;
            this.lock.writeLock().unlock();
            return bl;
        }
        finally {
            if (managerLock != null) {
                managerLock.unlock();
            }
        }
    }

    @Override
    public void disableCleanup() {
        this.getCursorProvider().disableCleanup();
    }

    @Override
    public void enableCleanup() {
        this.getCursorProvider().resumeCleanup();
    }

    private long[] routeQueues(Transaction tx, RouteContextList ctx) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        long[] ids = new long[durableQueues.size() + nonDurableQueues.size()];
        int i = 0;
        for (Queue q : durableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i++] = q.getID();
        }
        return ids;
    }

    private void applyPageCounters(Transaction tx, Page page, RouteContextList ctx) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        for (Queue q : durableQueues) {
            if (tx == null) {
                q.getPageSubscription().getCounter().pendingCounter(page, 1);
                continue;
            }
            q.getPageSubscription().getCounter().increment(tx, 1);
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1);
        }
    }

    public void durableDown(Message message, int durableCount) {
    }

    public void durableUp(Message message, int durableCount) {
    }

    public void nonDurableUp(Message message, int count) {
        if (count == 1) {
            this.addSize(message.getMemoryEstimate() + MessageReferenceImpl.getMemoryEstimate());
        } else {
            this.addSize(MessageReferenceImpl.getMemoryEstimate());
        }
    }

    public void nonDurableDown(Message message, int count) {
        if (count < 0) {
            return;
        }
        if (count == 0) {
            this.addSize(-message.getMemoryEstimate() - MessageReferenceImpl.getMemoryEstimate());
        } else {
            this.addSize(-MessageReferenceImpl.getMemoryEstimate());
        }
    }

    private void installPageTransaction(Transaction tx, RouteContextList listCtx) throws Exception {
        FinishPageMessageOperation pgOper = (FinishPageMessageOperation)tx.getProperty(5);
        if (pgOper == null) {
            PageTransactionInfoImpl pgTX = new PageTransactionInfoImpl(tx.getID());
            this.pagingManager.addTransaction(pgTX);
            pgOper = new FinishPageMessageOperation(pgTX, this.storageManager, this.pagingManager);
            tx.putProperty(5, pgOper);
            tx.addOperation(pgOper);
        }
        pgOper.addStore(this);
        pgOper.pageTransaction.increment(listCtx.getNumberOfDurableQueues(), listCtx.getNumberOfNonDurableQueues());
    }

    private void openNewPage() throws Exception {
        this.lock.writeLock().lock();
        try {
            ++this.numberOfPages;
            int tmpCurrentPageId = this.currentPageId + 1;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("new pageNr=" + tmpCurrentPageId), (Throwable)new Exception("trace"));
            }
            if (this.currentPage != null) {
                this.currentPage.close(true);
            }
            this.currentPage = this.createPage(tmpCurrentPageId);
            LivePageCacheImpl pageCache = new LivePageCacheImpl(this.currentPage);
            this.currentPage.setLiveCache(pageCache);
            this.cursorProvider.addPageCache(pageCache);
            this.currentPageSize.set(0);
            this.currentPage.open();
            this.currentPageId = tmpCurrentPageId;
            if (this.currentPageId < this.firstPageId) {
                this.firstPageId = this.currentPageId;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFileName(int pageID) {
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            return this.format.format(pageID) + ".page";
        }
    }

    private static int getPageIdFromFileName(String fileName) {
        return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
    }

    @Override
    public boolean isFull() {
        return this.maxSize > 0L && this.getAddressSize() > this.maxSize || this.pagingManager.isGlobalFull();
    }

    @Override
    public boolean isRejectingMessages() {
        if (this.addressFullMessagePolicy != AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        return this.rejectThreshold != -1L && this.getAddressSize() > this.rejectThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getCurrentIds() throws Exception {
        this.lock.writeLock().lock();
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            if (this.fileFactory != null) {
                for (String fileName : this.fileFactory.listFiles("page")) {
                    ids.add(PagingStoreImpl.getPageIdFromFileName(fileName));
                }
            }
            ArrayList<Integer> arrayList = ids;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void sendPages(ReplicationManager replicator, Collection<Integer> pageIds) throws Exception {
        for (Integer id : pageIds) {
            SequentialFile sFile = this.fileFactory.createSequentialFile(this.createFileName(id));
            if (!sFile.exists()) continue;
            ActiveMQServerLogger.LOGGER.replicaSyncFile(sFile, sFile.size());
            replicator.syncPages(sFile, id.intValue(), this.getAddress());
        }
    }

    private static class FinishPageMessageOperation
    implements TransactionOperation {
        private final PageTransactionInfo pageTransaction;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;
        private final Set<PagingStore> usedStores = new HashSet<PagingStore>();
        private boolean stored = false;

        public void addStore(PagingStore store) {
            this.usedStores.add(store);
        }

        private FinishPageMessageOperation(PageTransactionInfo pageTransaction, StorageManager storageManager, PagingManager pagingManager) {
            this.pageTransaction = pageTransaction;
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        @Override
        public void afterCommit(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void syncStore() throws Exception {
            for (PagingStore store : this.usedStores) {
                store.sync();
            }
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void storePageTX(Transaction tx) throws Exception {
            if (!this.stored) {
                tx.setContainsPersistent();
                this.pageTransaction.store(this.storageManager, this.pagingManager, tx);
                this.stored = true;
            }
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }

    private static final class OverSizedRunnable
    implements Runnable {
        private final AtomicBoolean ran = new AtomicBoolean(false);
        private final Runnable runnable;

        private OverSizedRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (this.ran.compareAndSet(false, true)) {
                this.runnable.run();
            }
        }
    }

    private class MemoryFreedRunnablesExecutor
    implements Runnable {
        private MemoryFreedRunnablesExecutor() {
        }

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = (Runnable)PagingStoreImpl.this.onMemoryFreedRunnables.poll()) != null) {
                runnable.run();
            }
        }
    }
}

