/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.Krb5SslCallback;

public class JaasCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;
    final Connection connection;

    public JaasCallbackHandler(String username, String password, Connection connection) {
        this.username = username;
        this.password = password;
        this.connection = connection;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (this.password == null) {
                    passwordCallback.setPassword(null);
                    continue;
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callback;
                if (this.username == null) {
                    nameCallback.setName(null);
                    continue;
                }
                nameCallback.setName(this.username);
                continue;
            }
            if (callback instanceof CertificateCallback) {
                CertificateCallback certCallback = (CertificateCallback)callback;
                certCallback.setCertificates(CertificateUtil.getCertsFromConnection((Connection)this.connection));
                continue;
            }
            if (callback instanceof Krb5SslCallback) {
                Krb5SslCallback krb5SslCallback = (Krb5SslCallback)callback;
                krb5SslCallback.setPeerPrincipal(CertificateUtil.getPeerPrincipalFromConnection((Connection)this.connection));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

