/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.Krb5SslCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public class Krb5SslLoginModule
implements LoginModule {
    private static final Logger logger = Logger.getLogger(Krb5SslLoginModule.class);
    private Subject subject;
    private final List<Principal> principals = new LinkedList<Principal>();
    private CallbackHandler callbackHandler;
    private boolean loginSucceeded;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new Krb5SslCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.principals.add(((Krb5SslCallback)callbacks[0]).getPeerPrincipal());
        if (!this.principals.isEmpty()) {
            this.loginSucceeded = true;
        }
        logger.debug((Object)("login " + this.principals));
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        if (result) {
            this.principals.add(new UserPrincipal(this.principals.get(0).getName()));
            this.subject.getPrincipals().addAll(this.principals);
        }
        this.clear();
        logger.debug((Object)("commit, result: " + result));
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        logger.debug((Object)"abort");
        return true;
    }

    private void clear() {
        this.loginSucceeded = false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        logger.debug((Object)"logout");
        return true;
    }
}

