/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.balancing.BrokerBalancerConfiguration;
import org.apache.activemq.artemis.core.config.balancing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.balancing.PoolConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.policies.Policy;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactoryResolver;
import org.apache.activemq.artemis.core.server.balancing.pools.AbstractPool;
import org.apache.activemq.artemis.core.server.balancing.pools.ClusterPool;
import org.apache.activemq.artemis.core.server.balancing.pools.DiscoveryGroupService;
import org.apache.activemq.artemis.core.server.balancing.pools.DiscoveryPool;
import org.apache.activemq.artemis.core.server.balancing.pools.Pool;
import org.apache.activemq.artemis.core.server.balancing.pools.StaticPool;
import org.apache.activemq.artemis.core.server.balancing.targets.ActiveMQTargetFactory;
import org.apache.activemq.artemis.core.server.balancing.targets.LocalTarget;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.transformer.KeyTransformer;
import org.apache.activemq.artemis.core.server.balancing.transformer.TransformerFactory;
import org.apache.activemq.artemis.core.server.balancing.transformer.TransformerFactoryResolver;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.jboss.logging.Logger;

public final class BrokerBalancerManager
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(BrokerBalancerManager.class);
    private final Configuration config;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile boolean started = false;
    private Map<String, BrokerBalancer> balancerControllers = new HashMap<String, BrokerBalancer>();

    public boolean isStarted() {
        return this.started;
    }

    public BrokerBalancerManager(Configuration config, ActiveMQServer server, ScheduledExecutorService scheduledExecutor) {
        this.config = config;
        this.server = server;
        this.scheduledExecutor = scheduledExecutor;
    }

    public void deploy() throws Exception {
        for (BrokerBalancerConfiguration balancerConfig : this.config.getBalancerConfigurations()) {
            this.deployBrokerBalancer(balancerConfig);
        }
    }

    public void deployBrokerBalancer(BrokerBalancerConfiguration config) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debugf("Deploying BrokerBalancer " + config.getName(), new Object[0]);
        }
        LocalTarget localTarget = new LocalTarget(null, this.server);
        Pool pool = null;
        PoolConfiguration poolConfiguration = config.getPoolConfiguration();
        if (poolConfiguration != null) {
            pool = this.deployPool(config.getPoolConfiguration(), localTarget);
        }
        Policy policy = null;
        NamedPropertyConfiguration policyConfiguration = config.getPolicyConfiguration();
        if (policyConfiguration != null) {
            policy = this.deployPolicy(policyConfiguration, pool);
        }
        KeyTransformer transformer = null;
        NamedPropertyConfiguration transformerConfiguration = config.getTransformerConfiguration();
        if (transformerConfiguration != null) {
            transformer = this.deployTransformer(transformerConfiguration);
        }
        BrokerBalancer balancer = new BrokerBalancer(config.getName(), config.getTargetKey(), config.getTargetKeyFilter(), localTarget, config.getLocalTargetFilter(), pool, policy, transformer, config.getCacheTimeout());
        this.balancerControllers.put(balancer.getName(), balancer);
        this.server.getManagementService().registerBrokerBalancer(balancer);
    }

    private Pool deployPool(PoolConfiguration config, Target localTarget) throws Exception {
        AbstractPool pool;
        ActiveMQTargetFactory targetFactory = new ActiveMQTargetFactory();
        targetFactory.setUsername(config.getUsername());
        targetFactory.setPassword(config.getPassword());
        if (config.getClusterConnection() != null) {
            ClusterConnection clusterConnection = this.server.getClusterManager().getClusterConnection(config.getClusterConnection());
            pool = new ClusterPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), clusterConnection);
        } else if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.server.getConfiguration().getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            DiscoveryGroupService discoveryService = new DiscoveryGroupService(new DiscoveryGroup(this.server.getNodeID().toString(), config.getDiscoveryGroupName(), discoveryGroupConfiguration.getRefreshTimeout(), discoveryGroupConfiguration.getBroadcastEndpointFactory(), null));
            pool = new DiscoveryPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), discoveryService);
        } else if (config.getStaticConnectors() != null) {
            Map<String, TransportConfiguration> connectorConfigurations = this.server.getConfiguration().getConnectorConfigurations();
            ArrayList<TransportConfiguration> staticConnectors = new ArrayList<TransportConfiguration>();
            for (String staticConnector : config.getStaticConnectors()) {
                TransportConfiguration connector = connectorConfigurations.get(staticConnector);
                if (connector != null) {
                    staticConnectors.add(connector);
                    continue;
                }
                logger.warn((Object)("Static connector not found: " + config.isLocalTargetEnabled()));
            }
            pool = new StaticPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), staticConnectors);
        } else {
            throw new IllegalStateException("Pool configuration not valid");
        }
        pool.setUsername(config.getUsername());
        pool.setPassword(config.getPassword());
        pool.setQuorumSize(config.getQuorumSize());
        pool.setQuorumTimeout(config.getQuorumTimeout());
        if (config.isLocalTargetEnabled()) {
            pool.addTarget(localTarget);
        }
        return pool;
    }

    private Policy deployPolicy(NamedPropertyConfiguration policyConfig, Pool pool) throws ClassNotFoundException {
        PolicyFactory policyFactory = PolicyFactoryResolver.getInstance().resolve(policyConfig.getName());
        Policy policy = policyFactory.create();
        policy.init(policyConfig.getProperties());
        if (policy.getTargetProbe() != null) {
            pool.addTargetProbe(policy.getTargetProbe());
        }
        return policy;
    }

    private KeyTransformer deployTransformer(NamedPropertyConfiguration configuration) throws Exception {
        TransformerFactory factory = TransformerFactoryResolver.getInstance().resolve(configuration.getName());
        KeyTransformer transformer = factory.create();
        transformer.init(configuration.getProperties());
        return transformer;
    }

    public BrokerBalancer getBalancer(String name) {
        return this.balancerControllers.get(name);
    }

    public void start() throws Exception {
        for (BrokerBalancer brokerBalancer : this.balancerControllers.values()) {
            brokerBalancer.start();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        for (BrokerBalancer balancer : this.balancerControllers.values()) {
            balancer.stop();
            this.server.getManagementService().unregisterBrokerBalancer(balancer.getName());
        }
    }
}

