package org.apache.activemq.artemis.core.server.plugin.impl;

import java.util.Locale;
import java.io.Serializable;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.api.core.Message;
import org.jboss.logging.DelegatingBasicLogger;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import java.lang.String;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.jboss.logging.Logger;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.jboss.logging.BasicLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.server.ServerSession;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import java.lang.Exception;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import java.lang.Object;
import org.apache.activemq.artemis.core.server.cluster.Bridge;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-07-26T12:03:13-0400")
public class LoggingActiveMQServerPluginLogger_$logger extends DelegatingBasicLogger implements LoggingActiveMQServerPluginLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingActiveMQServerPluginLogger_$logger.class.getName();
    public LoggingActiveMQServerPluginLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void afterCreateConnection(final RemotingConnection connection) {
        super.log.logv(FQCN, INFO, null, afterCreateConnection$str(), connection);
    }
    protected String afterCreateConnection$str() {
        return "AMQ841000: created connection: {0}";
    }
    @Override
    public final void afterDestroyConnection(final RemotingConnection connection) {
        super.log.logv(FQCN, INFO, null, afterDestroyConnection$str(), connection);
    }
    protected String afterDestroyConnection$str() {
        return "AMQ841001: destroyed connection: {0}";
    }
    @Override
    public final void afterCreateSession(final String sessionName, final Object sesssionConnectionID) {
        super.log.logv(FQCN, INFO, null, afterCreateSession$str(), sessionName, sesssionConnectionID);
    }
    protected String afterCreateSession$str() {
        return "AMQ841002: created session name: {0}, session connectionID: {1}";
    }
    @Override
    public final void afterCloseSession(final String sessionName, final boolean sesssionConnectionID) {
        super.log.logv(FQCN, INFO, null, afterCloseSession$str(), sessionName, sesssionConnectionID);
    }
    protected String afterCloseSession$str() {
        return "AMQ841003: closed session with session name: {0}, failed: {1}";
    }
    @Override
    public final void afterSessionMetadataAdded(final String sessionName, final String key, final String data) {
        super.log.logv(FQCN, INFO, null, afterSessionMetadataAdded$str(), sessionName, key, data);
    }
    protected String afterSessionMetadataAdded$str() {
        return "AMQ841004: added session metadata for session name : {0}, key: {1}, data: {2}";
    }
    @Override
    public final void afterCreateConsumer(final String consumerID, final String sessionID) {
        super.log.logv(FQCN, INFO, null, afterCreateConsumer$str(), consumerID, sessionID);
    }
    protected String afterCreateConsumer$str() {
        return "AMQ841005: created consumer with ID: {0}, with session name: {1}";
    }
    @Override
    public final void afterCloseConsumer(final String consumerID, final String sessionID, final boolean failed) {
        super.log.logv(FQCN, INFO, null, afterCloseConsumer$str(), consumerID, sessionID, failed);
    }
    protected String afterCloseConsumer$str() {
        return "AMQ841006: closed consumer ID: {0}, with  consumer Session: {1}, failed: {2}";
    }
    @Override
    public final void afterCreateQueue(final Queue queue) {
        super.log.logv(FQCN, INFO, null, afterCreateQueue$str(), queue);
    }
    protected String afterCreateQueue$str() {
        return "AMQ841007: created queue: {0}";
    }
    @Override
    public final void afterDestroyQueue(final Queue queue, final SimpleString address, final SecurityAuth session, final boolean checkConsumerCount, final boolean removeConsumers, final boolean autoDeleteAddress) {
        super.log.logv(FQCN, INFO, null, afterDestroyQueue$str(), queue, address, session, checkConsumerCount, removeConsumers, autoDeleteAddress);
    }
    protected String afterDestroyQueue$str() {
        return "AMQ841008: destroyed queue: {0}, with args address: {1}, session: {2}, checkConsumerCount: {3}, removeConsumers: {4}, autoDeleteAddress: {5}";
    }
    @Override
    public final void afterSend(final String messageID, final RoutingStatus result, final String tx) {
        super.log.logv(FQCN, INFO, null, afterSend$str(), messageID, result, tx);
    }
    protected String afterSend$str() {
        return "AMQ841009: sent message with ID: {0}, result: {1}, transaction: {2}";
    }
    @Override
    public final void afterMessageRoute(final String messageID, final RoutingStatus result) {
        super.log.logv(FQCN, INFO, null, afterMessageRoute$str(), messageID, result);
    }
    protected String afterMessageRoute$str() {
        return "AMQ841010: routed message with ID: {0}, result: {1}";
    }
    @Override
    public final void afterDeliverNoConsumer(final String messageID) {
        super.log.logv(FQCN, INFO, null, afterDeliverNoConsumer$str(), messageID);
    }
    protected String afterDeliverNoConsumer$str() {
        return "AMQ841011: delivered message with message ID: {0}, consumer info UNAVAILABLE";
    }
    @Override
    public final void afterDeliver(final String messageID, final SimpleString queueAddress, final SimpleString queueName, final String consumerSessionID, final long consumerID) {
        super.log.logv(FQCN, INFO, null, afterDeliver$str(), messageID, queueAddress, queueName, consumerSessionID, consumerID);
    }
    protected String afterDeliver$str() {
        return "AMQ841012: delivered message with message ID: {0}, to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}";
    }
    @Override
    public final void messageExpired(final MessageReference message, final SimpleString messageExpiryAddress) {
        super.log.logv(FQCN, INFO, null, messageExpired$str(), message, messageExpiryAddress);
    }
    protected String messageExpired$str() {
        return "AMQ841013: expired message: {0}, messageExpiryAddress: {1}";
    }
    @Override
    public final void messageAcknowledged(final MessageReference ref, final Transaction tx) {
        super.log.logv(FQCN, INFO, null, messageAcknowledged$str(), ref, tx);
    }
    protected String messageAcknowledged$str() {
        return "AMQ841014: messageAcknowledged: {0}, with transaction: {2}";
    }
    @Override
    public final void afterDeployBridge(final Bridge config) {
        super.log.logv(FQCN, INFO, null, afterDeployBridge$str(), config);
    }
    protected String afterDeployBridge$str() {
        return "AMQ841015: deployed bridge: {0}";
    }
    @Override
    public final void criticalFailure(final CriticalComponent components) {
        super.log.logv(FQCN, INFO, null, criticalFailure$str(), components);
    }
    protected String criticalFailure$str() {
        return "AMQ841016: criticalFailure called with criticalComponent: {0}";
    }
    @Override
    public final void onSendError(final String messageID, final String sessionName, final String sessionConnectionID, final Exception e) {
        super.log.logv(FQCN, INFO, null, onSendError$str(), messageID, sessionName, sessionConnectionID, e);
    }
    protected String onSendError$str() {
        return "AMQ841017: error sending message with ID: {0}, session name: {1}, session connectionID: {2}, exception: {3}";
    }
    @Override
    public final void onMessageRouteError(final String messageID, final Exception e) {
        super.log.logv(FQCN, INFO, null, onMessageRouteError$str(), messageID, e);
    }
    protected String onMessageRouteError$str() {
        return "AMQ841018: error routing message with ID: {0}, exception: {1}";
    }
    @Override
    public final void beforeCreateSession(final String name, final String username, final int minLargeMessageSize, final RemotingConnection connection, final boolean autoCommitSends, final boolean autoCommitAcks, final boolean preAcknowledge, final boolean xa, final String publicAddress, final OperationContext context) {
        super.log.logv(FQCN, DEBUG, null, beforeCreateSession$str(), name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, publicAddress, context);
    }
    protected String beforeCreateSession$str() {
        return "AMQ843000: beforeCreateSession called with name: {0}, username: {1}, minLargeMessageSize: {2}, connection: {3}, autoCommitSends: {4}, autoCommitAcks: {5}, preAcknowledge: {6}, xa: {7}, publicAddress: {8}, context: {9}";
    }
    @Override
    public final void beforeCloseSession(final String sessionName, final ServerSession session, final boolean failed) {
        super.log.logv(FQCN, DEBUG, null, beforeCloseSession$str(), sessionName, session, failed);
    }
    protected String beforeCloseSession$str() {
        return "AMQ843001: beforeCloseSession called with session name : {0}, session: {1}, failed: {2}";
    }
    @Override
    public final void beforeSessionMetadataAdded(final String sessionName, final ServerSession session, final String key, final String data) {
        super.log.logv(FQCN, DEBUG, null, beforeSessionMetadataAdded$str(), sessionName, session, key, data);
    }
    protected String beforeSessionMetadataAdded$str() {
        return "AMQ843002: beforeSessionMetadataAdded called with session name: {0} , session: {1}, key: {2}, data: {3}";
    }
    @Override
    public final void afterSessionMetadataAddedDetails(final String sessionName, final ServerSession session, final String key, final String data) {
        super.log.logv(FQCN, DEBUG, null, afterSessionMetadataAddedDetails$str(), sessionName, session, key, data);
    }
    protected String afterSessionMetadataAddedDetails$str() {
        return "AMQ843003: added session metadata for session name : {0}, session: {1}, key: {2}, data: {3}";
    }
    @Override
    public final void beforeCreateConsumer(final String consumerID, final QueueBinding queueBinding, final SimpleString filterString, final boolean browseOnly, final boolean supportLargeMessage) {
        super.log.logv(FQCN, DEBUG, null, beforeCreateConsumer$str(), consumerID, queueBinding, filterString, browseOnly, supportLargeMessage);
    }
    protected String beforeCreateConsumer$str() {
        return "AMQ843004: beforeCreateConsumer called with ConsumerID: {0}, QueueBinding: {1}, filterString: {2}, browseOnly: {3}, supportLargeMessage: {4}";
    }
    @Override
    public final void beforeCloseConsumer(final ServerConsumer consumer, final String sessionID, final boolean failed) {
        super.log.logv(FQCN, DEBUG, null, beforeCloseConsumer$str(), consumer, sessionID, failed);
    }
    protected String beforeCloseConsumer$str() {
        return "AMQ843005: beforeCloseConsumer called with consumer: {0}, consumer sessionID: {1}, failed: {2}";
    }
    @Override
    public final void beforeCreateQueue(final QueueConfiguration queueConfig) {
        super.log.logv(FQCN, DEBUG, null, beforeCreateQueue$str(), queueConfig);
    }
    protected String beforeCreateQueue$str() {
        return "AMQ843006: beforeCreateQueue called with queueConfig: {0}";
    }
    @Override
    public final void beforeDestroyQueue(final SimpleString queueName, final SecurityAuth session, final boolean checkConsumerCount, final boolean removeConsumers, final boolean autoDeleteAddress) {
        super.log.logv(FQCN, DEBUG, null, beforeDestroyQueue$str(), queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress);
    }
    protected String beforeDestroyQueue$str() {
        return "AMQ843007: beforeDestroyQueue called with queueName: {0}, session: {1}, checkConsumerCount: {2}, removeConsumers: {3}, autoDeleteAddress: {4}";
    }
    @Override
    public final void beforeSend(final Message message, final Transaction tx, final ServerSession session, final boolean direct, final boolean noAutoCreateQueue) {
        super.log.logv(FQCN, DEBUG, null, beforeSend$str(), message, tx, session, direct, noAutoCreateQueue);
    }
    protected String beforeSend$str() {
        return "AMQ843008: beforeSend called with message: {0}, tx: {1}, session: {2}, direct: {3}, noAutoCreateQueue: {4}";
    }
    @Override
    public final void afterSendDetails(final Message message, final String result, final Transaction tx, final String sessionName, final String connectionID, final boolean direct, final boolean noAutoCreateQueue) {
        super.log.logv(FQCN, DEBUG, null, afterSendDetails$str(), message, result, tx, sessionName, connectionID, direct, noAutoCreateQueue);
    }
    protected String afterSendDetails$str() {
        return "AMQ843009: afterSend message: {0}, result: {1}, transaction: {2}, session: {3}, connection: {4}, direct: {5}, noAutoCreateQueue: {6}";
    }
    @Override
    public final void beforeMessageRoute(final Message message, final RoutingContext context, final boolean direct, final boolean rejectDuplicates) {
        super.log.logv(FQCN, DEBUG, null, beforeMessageRoute$str(), message, context, direct, rejectDuplicates);
    }
    protected String beforeMessageRoute$str() {
        return "AMQ843010: beforeMessageRoute called with message: {0}, context: {1}, direct: {2}, rejectDuplicates: {3}";
    }
    @Override
    public final void afterMessageRouteDetails(final Message message, final RoutingContext context, final boolean direct, final boolean rejectDuplicates) {
        super.log.logv(FQCN, DEBUG, null, afterMessageRouteDetails$str(), message, context, direct, rejectDuplicates);
    }
    protected String afterMessageRouteDetails$str() {
        return "AMQ843011: afterMessageRoute message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}";
    }
    @Override
    public final void beforeDeliver(final ServerConsumer consumer, final MessageReference reference) {
        super.log.logv(FQCN, DEBUG, null, beforeDeliver$str(), consumer, reference);
    }
    protected String beforeDeliver$str() {
        return "AMQ843012: beforeDeliver called with consumer: {0}, reference: {1}";
    }
    @Override
    public final void afterDeliverDetails(final String messageID, final SimpleString queueAddress, final SimpleString queueName, final String consumerSessionID, final long consumerID, final MessageReference reference, final ServerConsumer consumer) {
        super.log.logv(FQCN, DEBUG, null, afterDeliverDetails$str(), messageID, queueAddress, queueName, consumerSessionID, consumerID, reference, consumer);
    }
    protected String afterDeliverDetails$str() {
        return "AMQ843013: delivered message with message ID: {0} to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}, full message reference: {5}, full consumer: {6}";
    }
    @Override
    public final void messageAcknowledgedDetails(final String messageID, final String sessionID, final String consumerID, final String queueName, final String tx, final AckReason reason) {
        super.log.logv(FQCN, DEBUG, null, messageAcknowledgedDetails$str(), messageID, sessionID, consumerID, queueName, tx, reason);
    }
    protected String messageAcknowledgedDetails$str() {
        return "AMQ843014: messageAcknowledged ID: {0}, sessionID: {1}, consumerID: {2}, queue: {3}, transaction: {4}, ackReason: {5}";
    }
    @Override
    public final void beforeDeployBridge(final BridgeConfiguration config) {
        super.log.logv(FQCN, DEBUG, null, beforeDeployBridge$str(), config);
    }
    protected String beforeDeployBridge$str() {
        return "AMQ843015: beforeDeployBridge called with bridgeConfiguration: {0}";
    }
    @Override
    public final void onSendErrorDetails(final String messageID, final Message message, final String sessionName, final Transaction tx, final ServerSession session, final boolean direct, final boolean noAutoCreateQueue) {
        super.log.logv(FQCN, DEBUG, null, onSendErrorDetails$str(), messageID, message, sessionName, tx, session, direct, noAutoCreateQueue);
    }
    protected String onSendErrorDetails$str() {
        return "AMQ843016: onSendError message ID: {0}, message {1}, session name: {2} with tx: {3}, session: {4}, direct: {5}, noAutoCreateQueue: {6}";
    }
    @Override
    public final void onMessageRouteErrorDetails(final Message message, final RoutingContext context, final boolean direct, final boolean rejectDuplicates) {
        super.log.logv(FQCN, DEBUG, null, onMessageRouteErrorDetails$str(), message, context, direct, rejectDuplicates);
    }
    protected String onMessageRouteErrorDetails$str() {
        return "AMQ843017: onMessageRouteError message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}";
    }
    @Override
    public final void rolledBackTransaction(final Transaction tx, final String resource) {
        super.log.logv(FQCN, DEBUG, null, rolledBackTransaction$str(), tx, resource);
    }
    protected String rolledBackTransaction$str() {
        return "AMQ843020: rolled back transaction {0} involving {1}";
    }
}
