/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import io.netty.util.collection.LongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.paging.cursor.PagedReferenceImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.ConcurrentLongHashMap;
import org.apache.activemq.artemis.utils.collections.LinkedList;
import org.apache.activemq.artemis.utils.collections.LongHashSet;
import org.jboss.logging.Logger;

public class PageCursorProviderImpl
implements PageCursorProvider {
    private static final Logger logger = Logger.getLogger(PageCursorProviderImpl.class);
    protected final AtomicInteger scheduledCleanup = new AtomicInteger(0);
    protected volatile boolean cleanupEnabled = true;
    protected final PagingStore pagingStore;
    protected final StorageManager storageManager;
    private final ConcurrentLongHashMap<PageSubscription> activeCursors = new ConcurrentLongHashMap();
    private static final long PAGE_READ_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(30L);
    private static final long CONCURRENT_PAGE_READ_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);
    private static final long PAGE_READ_PERMISSION_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize) {
        this(pagingStore, storageManager, executor, maxCacheSize, false);
    }

    public PageCursorProviderImpl(PagingStore pagingStore, StorageManager storageManager, ArtemisExecutor executor, int maxCacheSize, boolean readWholePage) {
        this.pagingStore = pagingStore;
        this.storageManager = storageManager;
    }

    @Override
    public synchronized PageSubscription createSubscription(long cursorID, Filter filter, boolean persistent) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(this.pagingStore.getAddress() + " creating subscription " + cursorID + " with filter " + filter));
        }
        if (this.activeCursors.containsKey(cursorID)) {
            throw new IllegalStateException("Cursor " + cursorID + " had already been created");
        }
        PageSubscriptionImpl activeCursor = new PageSubscriptionImpl(this, this.pagingStore, this.storageManager, filter, cursorID, persistent);
        this.activeCursors.put(cursorID, (Object)activeCursor);
        return activeCursor;
    }

    @Override
    public synchronized PageSubscription getSubscription(long cursorID) {
        return (PageSubscription)this.activeCursors.get(cursorID);
    }

    @Override
    public PagedReference newReference(PagedMessage msg, PageSubscription subscription) {
        return new PagedReferenceImpl(msg, subscription);
    }

    @Override
    public void processReload() throws Exception {
        long cursorsMinPage;
        List cursorList = this.activeCursors.values();
        for (PageSubscription cursor : cursorList) {
            cursor.processReload();
        }
        if (!cursorList.isEmpty() && (cursorsMinPage = this.checkMinPage(cursorList)) != Long.MAX_VALUE) {
            for (long startPage = this.pagingStore.getFirstPage(); startPage < cursorsMinPage; ++startPage) {
                for (PageSubscription cursor : cursorList) {
                    cursor.reloadPageInfo(startPage);
                }
            }
        }
        this.cleanup();
    }

    @Override
    public void stop() {
        for (PageSubscription cursor : this.activeCursors.values()) {
            cursor.stop();
        }
        int pendingCleanupTasks = this.scheduledCleanup.get();
        if (pendingCleanupTasks > 0) {
            logger.tracef("Stopping with %d cleanup tasks to be completed yet", pendingCleanupTasks);
        }
    }

    @Override
    public void flushExecutors() {
        this.pagingStore.flushExecutors();
    }

    @Override
    public void close(PageSubscription cursor) {
        this.activeCursors.remove(cursor.getId());
        this.scheduleCleanup();
    }

    @Override
    public void scheduleCleanup() {
        if (!this.cleanupEnabled || this.scheduledCleanup.intValue() > 2) {
            return;
        }
        this.scheduledCleanup.incrementAndGet();
        this.pagingStore.execute(new Runnable(){

            @Override
            public void run() {
                PageCursorProviderImpl.this.storageManager.setContext(PageCursorProviderImpl.this.storageManager.newSingleThreadContext());
                try {
                    if (PageCursorProviderImpl.this.cleanupEnabled) {
                        PageCursorProviderImpl.this.cleanup();
                    }
                }
                finally {
                    PageCursorProviderImpl.this.storageManager.clearContext();
                    PageCursorProviderImpl.this.scheduledCleanup.decrementAndGet();
                }
            }
        });
    }

    @Override
    public void onPageModeCleared() {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        for (PageSubscription sub : subscriptions) {
            try {
                sub.onPageModeCleared(tx);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCleaningPagingOnQueue(e, sub.getQueue().getName().toString());
            }
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorCleaningPagingDuringCommit(e);
        }
    }

    @Override
    public void disableCleanup() {
        this.cleanupEnabled = false;
    }

    @Override
    public void resumeCleanup() {
        this.cleanupEnabled = true;
        this.scheduleCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cleanup() {
        ArrayList<Page> depagedPages = new ArrayList<Page>();
        LongHashSet depagedPagesSet = new LongHashSet();
        try (ArtemisCloseable readLock = this.storageManager.closeableReadLock();){
            do {
                if (!this.pagingStore.lock(100L)) continue;
                logger.tracef(">>>> Cleanup %s", (Object)this.pagingStore.getAddress());
                PageCursorProviderImpl pageCursorProviderImpl = this;
                synchronized (pageCursorProviderImpl) {
                    try {
                        if (!this.pagingStore.isStarted()) {
                            logger.trace((Object)"Paging store is not started");
                            return;
                        }
                        if (!this.pagingStore.isPaging()) {
                            logger.trace((Object)"Paging Store was not paging, so no reason to retry the cleanup");
                            return;
                        }
                        ArrayList<PageSubscription> cursorList = this.cloneSubscriptions();
                        long minPage = this.checkMinPage(cursorList);
                        long firstPage = this.pagingStore.getFirstPage();
                        this.deliverIfNecessary(cursorList, minPage);
                        logger.tracef("firstPage=%s, minPage=%s, currentWritingPage=%s", firstPage, minPage, this.pagingStore.getCurrentWritingPage());
                        this.cleanupRegularStream(depagedPages, depagedPagesSet, cursorList, minPage, firstPage);
                        this.cleanupMiddleStream(depagedPages, depagedPagesSet, cursorList, minPage, firstPage);
                        assert (this.pagingStore.getNumberOfPages() >= 0L);
                        if (this.pagingStore.getNumberOfPages() == 0L || this.pagingStore.getNumberOfPages() == 1L && (this.pagingStore.getCurrentPage() == null || this.pagingStore.getCurrentPage().getNumberOfMessages() == 0)) {
                            logger.tracef("StopPaging being called on %s", (Object)this.pagingStore);
                            this.pagingStore.stopPaging();
                            break block26;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Couldn't cleanup page on address " + this.pagingStore.getAddress() + " as numberOfPages == " + this.pagingStore.getNumberOfPages() + " and currentPage.numberOfMessages = " + this.pagingStore.getCurrentPage().getNumberOfMessages()));
                        }
                        break block26;
                    }
                    catch (Exception ex) {
                        ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        // MONITOREXIT @DISABLED, blocks:[0, 19, 12, 13] lbl39 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (readLock == null) return;
                        readLock.close();
                        return;
                    }
                }
            } while (this.pagingStore.isStarted());
            return;
            {
                block26: {
                    finally {
                        logger.tracef("<<<< Cleanup end on %s", (Object)this.pagingStore.getAddress());
                        this.pagingStore.unlock();
                    }
                }
            }
        }
        this.finishCleanup(depagedPages);
    }

    private void cleanupRegularStream(ArrayList<Page> depagedPages, LongHashSet depagedPagesSet, ArrayList<PageSubscription> cursorList, long minPage, long firstPage) throws Exception {
        Page page;
        boolean complete;
        Page currentPage = this.pagingStore.getCurrentPage();
        if (minPage == this.pagingStore.getCurrentWritingPage() && currentPage != null && currentPage.getNumberOfMessages() > 0 && (complete = this.checkPageCompletion(cursorList, minPage))) {
            this.cleanupComplete(cursorList);
        }
        for (long i = firstPage; i <= minPage && this.checkPageCompletion(cursorList, i) && (page = this.pagingStore.depage()) != null; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Depaging page " + page.getPageId()));
            }
            depagedPagesSet.add(page.getPageId());
            depagedPages.add(page);
        }
    }

    private void cleanupMiddleStream(ArrayList<Page> depagedPages, LongHashSet depagedPagesSet, ArrayList<PageSubscription> cursorList, long minPage, long firstPage) {
        long currentPageId = this.pagingStore.getCurrentWritingPage();
        LongObjectHashMap counts = new LongObjectHashMap();
        int subscriptions = cursorList.size();
        cursorList.forEach(sub -> sub.forEachConsumedPage(consumedPage -> {
            if (consumedPage.isDone()) {
                AtomicInteger count = (AtomicInteger)counts.get(consumedPage.getPageId());
                if (count == null) {
                    count = new AtomicInteger(0);
                    counts.put(consumedPage.getPageId(), (Object)count);
                }
                count.incrementAndGet();
            }
        }));
        counts.forEach((pageID, counter) -> {
            try {
                if (pageID > minPage && pageID > firstPage && pageID != currentPageId && counter.get() >= subscriptions && !depagedPagesSet.contains(pageID.longValue())) {
                    Page page = this.pagingStore.removePage(pageID.intValue());
                    logger.debugf("Removing page %s", pageID);
                    if (page != null) {
                        depagedPages.add(page);
                        depagedPagesSet.add(page.getPageId());
                    }
                }
            }
            catch (Throwable e) {
                logger.warn((Object)("Error while Issuing cleanupMiddlePages with " + pageID + ", counter = " + counter), e);
                depagedPages.forEach(p -> logger.warn((Object)("page " + p)));
            }
        });
    }

    protected void cleanupComplete(ArrayList<PageSubscription> cursorList) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Address " + this.pagingStore.getAddress() + " is leaving page mode as all messages are consumed and acknowledged from the page store"));
        }
        this.pagingStore.forceAnotherPage();
        Page currentPage = this.pagingStore.getCurrentPage();
        this.storeBookmark(cursorList, currentPage);
        this.pagingStore.stopPaging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishCleanup(ArrayList<Page> depagedPages) {
        logger.tracef("this(%s) finishing cleanup on %s", (Object)this, depagedPages);
        try {
            for (Page depagedPage : depagedPages) {
                this.storageManager.beforePageRead();
                LinkedList<PagedMessage> pgdMessagesList = null;
                try {
                    depagedPage.open(false);
                    pgdMessagesList = depagedPage.read(this.storageManager, true);
                }
                finally {
                    try {
                        depagedPage.close(false, false);
                    }
                    catch (Exception exception) {}
                    this.storageManager.afterPageRead();
                }
                depagedPage.delete(pgdMessagesList);
                this.onDeletePage(depagedPage);
            }
        }
        catch (Exception ex) {
            ActiveMQServerLogger.LOGGER.problemCleaningPageAddress(ex, this.pagingStore.getAddress());
            return;
        }
    }

    private boolean checkPageCompletion(ArrayList<PageSubscription> cursorList, long minPage) throws Exception {
        logger.tracef("checkPageCompletion(%d)", minPage);
        boolean complete = true;
        if (!this.pagingStore.checkPageFileExists(minPage)) {
            logger.tracef("store %s did not have an existing file, considering it a complete file then", (Object)this.pagingStore.getAddress());
            return true;
        }
        for (PageSubscription cursor : cursorList) {
            if (!cursor.isComplete(minPage)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Cursor " + cursor + " was considered incomplete at pageNr=" + minPage));
                }
                complete = false;
                break;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Cursor " + cursor + " was considered **complete** at pageNr=" + minPage));
        }
        return complete;
    }

    private synchronized ArrayList<PageSubscription> cloneSubscriptions() {
        ArrayList<PageSubscription> cursorList = new ArrayList<PageSubscription>(this.activeCursors.values());
        return cursorList;
    }

    protected void onDeletePage(Page deletedPage) throws Exception {
        ArrayList<PageSubscription> subscriptions = this.cloneSubscriptions();
        for (PageSubscription subs : subscriptions) {
            subs.onDeletePage(deletedPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBookmark(ArrayList<PageSubscription> cursorList, Page currentPage) throws Exception {
        try {
            for (PageSubscription cursor : cursorList) {
                cursor.confirmPosition(new PagePositionImpl(currentPage.getPageId(), -1));
            }
        }
        finally {
            for (PageSubscription cursor : cursorList) {
                cursor.enableAutoCleanup();
            }
        }
    }

    public String toString() {
        return "PageCursorProviderImpl{pagingStore=" + this.pagingStore + "}";
    }

    private long checkMinPage(Collection<PageSubscription> cursorList) {
        long minPage = Long.MAX_VALUE;
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.pagingStore.getAddress() + " has a cursor " + cursor + " with first page=" + firstPage));
            }
            if (firstPage < 0L || firstPage >= minPage) continue;
            minPage = firstPage;
        }
        logger.tracef("checkMinPage(%s) will have minPage=%s", (Object)this.pagingStore.getAddress(), (Object)minPage);
        return minPage;
    }

    private void deliverIfNecessary(Collection<PageSubscription> cursorList, long minPage) {
        boolean currentWriting = minPage == this.pagingStore.getCurrentWritingPage();
        for (PageSubscription cursor : cursorList) {
            long firstPage = cursor.getFirstPage();
            if (firstPage != minPage || cursor.getQueue().getMessageCount() != 0L || currentWriting && cursor.isComplete(firstPage)) continue;
            cursor.getQueue().deliverAsync();
            break;
        }
    }
}

