/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import io.netty.channel.Channel;
import java.io.File;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.naming.NamingException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class ActiveMQServerLogger_impl
implements ActiveMQServerLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQServerLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void interruptWhilstStoppingComponent(String componentClassName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ223000: Received Interrupt Exception whilst waiting for component to shutdown: {}", (Object)componentClassName);
        }
    }

    @Override
    public void ignoredQuorumVote(ServerConnectVote vote) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ223001: Ignored quorum vote due to quorum reached or vote casted: {}", (Object)vote);
        }
    }

    @Override
    public void serverStarting(String type, Configuration configuration) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221000: {} Message Broker is starting with configuration {}", (Object)type, (Object)configuration);
        }
    }

    @Override
    public void serverStarted(String fullVersion, String name, SimpleString nodeId, String identity) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221001: Apache ActiveMQ Artemis Message Broker version {} [{}, nodeID={}] {}", new Object[]{fullVersion, name, nodeId, identity});
        }
    }

    @Override
    public void serverStopped(String version, SimpleString nodeId, String uptime) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221002: Apache ActiveMQ Artemis Message Broker version {} [{}] stopped, uptime {}", new Object[]{version, nodeId, uptime});
        }
    }

    @Override
    public void deployQueue(String routingType, String queueName, String addressName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221003: Deploying {} queue {} on address {}", new Object[]{routingType, queueName, addressName});
        }
    }

    @Override
    public void dumpServerInfo(String serverInfo) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221004: {}", (Object)serverInfo);
        }
    }

    @Override
    public void deletingPendingMessage(Pair<Long, Long> msgToDelete) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221005: Deleting pending large message as it was not completed: {}", msgToDelete);
        }
    }

    @Override
    public void awaitingLiveLock() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221006: Waiting to obtain live lock");
        }
    }

    @Override
    public void serverIsLive() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221007: Server is now live");
        }
    }

    @Override
    public void awaitFailBack() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221008: live server wants to restart, restarting server in backup");
        }
    }

    @Override
    public void backupServerStarted(String version, SimpleString nodeID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221109: Apache ActiveMQ Artemis Backup Server version {} [{}] started, waiting live to fail before it gets active", (Object)version, (Object)nodeID);
        }
    }

    @Override
    public void backupServerIsLive() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221010: Backup Server is now live");
        }
    }

    @Override
    public void serverIsLive(String identity) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221011: Server {} is now live", (Object)identity);
        }
    }

    @Override
    public void journalUseAIO() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221012: Using AIO Journal");
        }
    }

    @Override
    public void journalUseNIO() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221013: Using NIO Journal");
        }
    }

    @Override
    public void percentLoaded(Long percent) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221014: {}% loaded", (Object)percent);
        }
    }

    @Override
    public void journalCannotFindQueueReloading(Long queueID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221015: Can not find queue {} while reloading ACKNOWLEDGE_CURSOR, deleting record now", (Object)queueID);
        }
    }

    @Override
    public void journalCannotFindQueueReloadingPage(Long queueID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221016: Can not find queue {} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now", (Object)queueID);
        }
    }

    @Override
    public void journalCannotFindQueueReloadingPageCursor(Long queueID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221017: Can not find queue {} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now", (Object)queueID);
        }
    }

    @Override
    public void largeMessageWithNoRef(Long messageID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221018: Large message: {} did not have any associated reference, file will be deleted", (Object)messageID);
        }
    }

    @Override
    public void journalUnreferencedMessage(Long messageID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221019: Deleting unreferenced message id={} from the journal", (Object)messageID);
        }
    }

    @Override
    public void startedAcceptor(String acceptorType, String host, int port, String enabledProtocols) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221020: Started {} Acceptor at {}:{} for protocols [{}]", new Object[]{acceptorType, host, port, enabledProtocols});
        }
    }

    @Override
    public void errorRemovingConnection() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221021: failed to remove connection");
        }
    }

    @Override
    public void errorStartingConnectorService(String name, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221022: unable to start connector service: {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void errorStoppingConnectorService(String name, Throwable e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221023: unable to stop connector service: {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void backupServerSynchronized(ActiveMQServerImpl server, String liveID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221024: Backup server {} is synchronized with live server, nodeID={}.", (Object)server, (Object)liveID);
        }
    }

    @Override
    public void replicaSyncFile(SequentialFile jf, Long size) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221025: Replication: sending {} (size={}) to replica.", (Object)jf, (Object)size);
        }
    }

    @Override
    public void bridgeNoBindings(SimpleString name, SimpleString forwardingAddress, SimpleString address) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221026: Bridge {} connected to forwardingAddress={}. {} does not have any bindings. Messages will be ignored until a binding is created.", new Object[]{name, forwardingAddress, address});
        }
    }

    @Override
    public void bridgeConnected(BridgeImpl name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221027: Bridge {} is connected", (Object)name);
        }
    }

    @Override
    public void bridgeStopping() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221028: Bridge is stopping, will not retry");
        }
    }

    @Override
    public void bridgeStopped(String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221029: stopped bridge {}", (Object)name);
        }
    }

    @Override
    public void bridgePaused(String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221030: paused bridge {}", (Object)name);
        }
    }

    @Override
    public void backupAnnounced() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221031: backup announced");
        }
    }

    @Override
    public void waitingToBecomeBackup() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221032: Waiting to become backup node");
        }
    }

    @Override
    public void gotBackupLock() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221033: ** got backup lock");
        }
    }

    @Override
    public void waitingToObtainLiveLock(String timeoutMessage) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221034: Waiting {} to obtain live lock", (Object)timeoutMessage);
        }
    }

    @Override
    public void obtainedLiveLock() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221035: Live Server Obtained live lock");
        }
    }

    @Override
    public void messageWithDuplicateID(Object duplicateProperty, SimpleString toAddress, SimpleString address, SimpleString simpleString) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221036: Message with duplicate ID {} was already set at {}. Move from {} being ignored and message removed from {}", new Object[]{duplicateProperty, toAddress, address, simpleString});
        }
    }

    @Override
    public void becomingLive(ActiveMQServer server) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221037: {} to become 'live'", (Object)server);
        }
    }

    @Override
    public void deprecatedConfigurationOption(String deprecatedOption) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221038: Configuration option '{}' is deprecated. Consult the manual for details.", (Object)deprecatedOption);
        }
    }

    @Override
    public void restartingReplicatedBackupAfterFailback() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221039: Restarting as Replicating backup server after live restart");
        }
    }

    @Override
    public void remoteGroupCoordinatorsNotStarted() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221040: Remote group coordinators has not started.");
        }
    }

    @Override
    public void cantFindQueueOnPageComplete(long queueID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221041: Cannot find queue {} while reloading PAGE_CURSOR_COMPLETE, deleting record now", (Object)queueID);
        }
    }

    @Override
    public void timedOutWaitingCompletions(String bridgeName, long numberOfMessages) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221042: Bridge {} timed out waiting for the completion of {} messages, we will just shutdown the bridge after 10 seconds wait", (Object)bridgeName, (Object)numberOfMessages);
        }
    }

    @Override
    public void addingProtocolSupport(String moduleName, String protocolKey) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221043: Protocol module found: [{}]. Adding protocol support for: {}", (Object)moduleName, (Object)protocolKey);
        }
    }

    @Override
    public void switchingNIO() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221045: libaio is not available, switching the configuration into NIO");
        }
    }

    @Override
    public void unblockingMessageProduction(SimpleString addressName, String sizeInfo) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221046: Unblocking message production on address '{}'; {}", (Object)addressName, (Object)sizeInfo);
        }
    }

    @Override
    public void backupServerScaledDown() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221047: Backup Server has scaled down to live server");
        }
    }

    @Override
    public void slowConsumerDetected(String sessionID, long consumerID, String queueName, String remoteAddress, float slowConsumerThreshold, float consumerRate) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221048: Consumer {}:{} attached to queue '{}' from {} identified as 'slow.' Expected consumption rate: {} msgs/second; actual consumption rate: {} msgs/second.", new Object[]{sessionID, consumerID, queueName, remoteAddress, Float.valueOf(slowConsumerThreshold), Float.valueOf(consumerRate)});
        }
    }

    @Override
    public void activatingReplica(SimpleString nodeID) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221049: Activating Replica for node: {}", (Object)nodeID);
        }
    }

    @Override
    public void activatingSharedStoreSlave() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221050: Activating Shared Store Slave");
        }
    }

    @Override
    public void populatingSecurityRolesFromLDAP(String url) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221051: Populating security roles from LDAP at: {}", (Object)url);
        }
    }

    @Override
    public void deployTopic(SimpleString topicName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221052: Deploying topic {}", (Object)topicName);
        }
    }

    @Override
    public void disallowedProtocol(String protocol, String acceptorName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221053: Disallowing use of vulnerable protocol '{}' on acceptor '{}'. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.", (Object)protocol, (Object)acceptorName);
        }
    }

    @Override
    public void switchingNIOonPath(String journalPath) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221054: libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {}", (Object)journalPath);
        }
    }

    @Override
    public void removingBackupData(String path) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221055: There were too many old replicated folders upon startup, removing {}", (Object)path);
        }
    }

    @Override
    public void reloadingConfiguration(String module) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221056: Reloading configuration: {}", (Object)module);
        }
    }

    @Override
    public void usingDefaultPaging(long bytes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221057: Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {}", (Object)bytes);
        }
    }

    @Override
    public void invalidJournalFileSize(int journalFileSize, int fileSize, int alignment) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221058: resetting Journal File size from {} to {} to fit with alignment of {}", new Object[]{journalFileSize, fileSize, alignment});
        }
    }

    @Override
    public void backupDeletingData(String oldPath) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221059: Deleting old data directory {} as the max folders is set to 0", (Object)oldPath);
        }
    }

    @Override
    public void sendingQuorumVoteRequest(String remoteAddress, String vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221060: Sending quorum vote request to {}: {}", (Object)remoteAddress, (Object)vote);
        }
    }

    @Override
    public void receivedQuorumVoteResponse(String remoteAddress, String vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221061: Received quorum vote response from {}: {}", (Object)remoteAddress, (Object)vote);
        }
    }

    @Override
    public void receivedQuorumVoteRequest(String vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221062: Received quorum vote request: {}", (Object)vote);
        }
    }

    @Override
    public void sendingQuorumVoteResponse(String vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221063: Sending quorum vote response: {}", (Object)vote);
        }
    }

    @Override
    public void nodeFoundInClusterTopology(String nodeId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221064: Node {} found in cluster topology", (Object)nodeId);
        }
    }

    @Override
    public void nodeNotFoundInClusterTopology(String nodeId) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221065: Node {} not found in cluster topology", (Object)nodeId);
        }
    }

    @Override
    public void initiatingQuorumVote(SimpleString vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221066: Initiating quorum vote: {}", (Object)vote);
        }
    }

    @Override
    public void waitingForQuorumVoteResults(int timeout, String unit) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221067: Waiting {} {} for quorum vote results.", (Object)timeout, (Object)unit);
        }
    }

    @Override
    public void receivedAllQuorumVotes() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221068: Received all quorum votes.");
        }
    }

    @Override
    public void timeoutWaitingForQuorumVoteResponses() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221069: Timeout waiting for quorum vote responses.");
        }
    }

    @Override
    public void restartingAsBackupBasedOnQuorumVoteResults() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221070: Restarting as backup based on quorum vote results.");
        }
    }

    @Override
    public void failingOverBasedOnQuorumVoteResults() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221071: Failing over based on quorum vote results.");
        }
    }

    @Override
    public void failedToFindRolesForTheSubject(Exception e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221072: Can't find roles for the subject.", (Throwable)e);
        }
    }

    @Override
    public void failedAddRolePrincipal(Exception e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221073: Can't add role principal.", (Throwable)e);
        }
    }

    @Override
    public void debugStarted(Long globalSizeBytes, Long numberOfMessages) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221074: Debug started : size = {} bytes, messages = {}", (Object)globalSizeBytes, (Object)numberOfMessages);
        }
    }

    @Override
    public void deprecatedWildcardRoutingEnabled() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221075: Usage of wildcardRoutingEnabled configuration property is deprecated, please use wildCardConfiguration.enabled instead");
        }
    }

    @Override
    public void onDestroyConnectionWithSessionMetadata(String msg) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221076: {}", (Object)msg);
        }
    }

    @Override
    public void infoNoQueueWithID(Long id, Long record) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221077: There is no queue with ID {}, deleting record {}", (Object)id, (Object)record);
        }
    }

    @Override
    public void infoScaledDownMessages(Long num) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221078: Scaled down {} messages total.", (Object)num);
        }
    }

    @Override
    public void ignoringPrepareOnXidAlreadyCalled(String xid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221079: Ignoring prepare on xid as already called : {}", (Object)xid);
        }
    }

    @Override
    public void deployAddress(String addressName, String routingTypes) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221080: Deploying address {} supporting {}", (Object)addressName, (Object)routingTypes);
        }
    }

    @Override
    public void infoNoAddressWithID(Long id, Long record) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221081: There is no address with ID {}, deleting record {}", (Object)id, (Object)record);
        }
    }

    @Override
    public void initializingMetricsPlugin(String clazz, String properties) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221082: Initializing metrics plugin {} with properties: {}", (Object)clazz, (Object)properties);
        }
    }

    @Override
    public void ignoringQuorumVote(int maxClusterSize) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221083: ignoring quorum vote as max cluster size is {}.", (Object)maxClusterSize);
        }
    }

    @Override
    public void requestedQuorumVotes(int vote) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221084: Requested {} quorum votes", (Object)vote);
        }
    }

    @Override
    public void routeClientConnection(Connection connection, Target target) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221085: Route {} to {}", (Object)connection, (Object)target);
        }
    }

    @Override
    public void cannotRouteClientConnection(Connection connection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ221086: Cannot route {}", (Object)connection);
        }
    }

    @Override
    public void serverFinalisedWIthoutBeingSTopped() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222000: ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope");
        }
    }

    @Override
    public void errorClosingSessionsWhileStoppingServer(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222001: Error closing sessions while stopping server", (Throwable)e);
        }
    }

    @Override
    public void timedOutStoppingThreadpool(ExecutorService service) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222002: Timed out waiting for pool to terminate {}. Interrupting all its threads!", (Object)service);
        }
    }

    @Override
    public void divertWithNoAddress() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222004: Must specify an address for each divert. This one will not be deployed.");
        }
    }

    @Override
    public void divertWithNoForwardingAddress() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222005: Must specify a forwarding address for each divert. This one will not be deployed.");
        }
    }

    @Override
    public void divertBindingAlreadyExists(SimpleString bindingName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222006: Binding already exists with name {}, divert will not be deployed", (Object)bindingName);
        }
    }

    @Override
    public void clusterSecurityRisk() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222007: Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.");
        }
    }

    @Override
    public void serverRestartWarning(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222008: unable to restart server, please kill and restart manually", (Throwable)e);
        }
    }

    @Override
    public void replicationStartProblem(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222009: Unable to announce backup for replication. Trying to stop the server.", (Throwable)e);
        }
    }

    @Override
    public void ioCriticalIOError(String message, String file, Throwable code) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ222010: Critical IO Error, shutting down the server. file={}, message={}", new Object[]{message, file, code});
        }
    }

    @Override
    public void errorStoppingServer(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222011: Error stopping server", (Throwable)e);
        }
    }

    @Override
    public void backupActivationProblem() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222012: Timed out waiting for backup activation to exit");
        }
    }

    @Override
    public void errorStartingReplication(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222013: Error when trying to start replication", (Throwable)e);
        }
    }

    @Override
    public void errorStoppingReplication(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222014: Error when trying to stop replication", (Throwable)e);
        }
    }

    @Override
    public void connectorWithNoName() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222016: Cannot deploy a connector with no name specified.");
        }
    }

    @Override
    public void connectorAlreadyDeployed(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222017: There is already a connector with name {} deployed. This one will not be deployed.", (Object)name);
        }
    }

    @Override
    public void AIONotFound() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222018: AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal");
        }
    }

    @Override
    public void discoveryGroupAlreadyDeployed(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222019: There is already a discovery group with name {} deployed. This one will not be deployed.", (Object)name);
        }
    }

    @Override
    public void errorScanningURLs(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222020: error scanning for URL's", (Throwable)e);
        }
    }

    @Override
    public void problemUndeployingNode(Node node, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222021: problem undeploying {}", (Object)node, (Object)e);
        }
    }

    @Override
    public void timedOutStoppingPagingCursor(Executor executor) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222022: Timed out waiting for paging cursor to stop {}", (Object)executor);
        }
    }

    @Override
    public void problemCleaningPageAddress(SimpleString address, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222023: problem cleaning page address {}", (Object)address, (Object)e);
        }
    }

    @Override
    public void problemCompletingOperations(OperationContext e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222024: Could not complete operations on IO context {}", (Object)e);
        }
    }

    @Override
    public void problemCleaningPagesubscriptionCounter(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222025: Problem cleaning page subscription counter", e);
        }
    }

    @Override
    public void problemCleaningCursorPages(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222026: Error on cleaning up cursor pages", (Throwable)e);
        }
    }

    @Override
    public void timedOutFlushingExecutorsPagingCursor(PageSubscription pageSubscription) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222027: Timed out flushing executors for paging cursor to stop {}", (Object)pageSubscription);
        }
    }

    @Override
    public void pageNotFound(PagePosition pos, long queueID, String queue) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222028: Could not find page cache for page {}, on queue {}/{} removing it from the journal", new Object[]{pos, queueID, queue});
        }
    }

    @Override
    public void pageSubscriptionCouldntLoad(long transactionID, PagePosition position, SimpleString address, SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222029: Could not locate page transaction {}, ignoring message on position {} on address={} queue={}", new Object[]{transactionID, position, address, name});
        }
    }

    @Override
    public void pageInvalid(String fileName, String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222030: File {} being renamed to {}.invalidPage as it was loaded partially. Please verify your data.", (Object)fileName, (Object)name);
        }
    }

    @Override
    public void pageDeleteError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222031: Error while deleting page file", (Throwable)e);
        }
    }

    @Override
    public void pageFinaliseError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222032: page finalise error", (Throwable)e);
        }
    }

    @Override
    public void pageSuspectFile(String fileName, int position, int msgNumber) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222033: Page file {} had incomplete records at position {} at record number {}", new Object[]{fileName, position, msgNumber});
        }
    }

    @Override
    public void pageTxDeleteError(long recordID, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222034: Can not delete page transaction id={}", (Object)recordID, (Object)e);
        }
    }

    @Override
    public void pageStoreFactoryNoIdFile(String s, String addressFile) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222035: Directory {} did not have an identification file {}", (Object)s, (Object)addressFile);
        }
    }

    @Override
    public void pageStoreTimeout(SimpleString address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222036: Timed out on waiting PagingStore {} to shutdown", (Object)address);
        }
    }

    @Override
    public void pageStoreStartIOError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222037: IO Error, impossible to start paging", (Throwable)e);
        }
    }

    @Override
    public void pageStoreStart(SimpleString storeName, String sizeInfo) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ222038: Starting paging on address '{}'; {}", (Object)storeName, (Object)sizeInfo);
        }
    }

    @Override
    public void pageStoreDropMessages(SimpleString storeName, String sizeInfo) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222039: Messages sent to address '{}' are being dropped; {}", (Object)storeName, (Object)sizeInfo);
        }
    }

    @Override
    public void serverIsStopped() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222040: Server is stopped");
        }
    }

    @Override
    public void journalCannotFindQueueDelCount(Long queueID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222041: Cannot find queue {} to update delivery count", (Object)queueID);
        }
    }

    @Override
    public void journalCannotFindMessageDelCount(Long msg) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222042: Cannot find message {} to update delivery count", (Object)msg);
        }
    }

    @Override
    public void journalCannotFindQueueForMessage(Long queueID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222043: Message for queue {} which does not exist. This message will be ignored.", (Object)queueID);
        }
    }

    @Override
    public void journalErrorDeletingMessage(Long messageID, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222044: It was not possible to delete message {}", (Object)messageID, (Object)e);
        }
    }

    @Override
    public void journalMessageInPreparedTX(Long queueID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222045: Message in prepared tx for queue {} which does not exist. This message will be ignored.", (Object)queueID);
        }
    }

    @Override
    public void journalErrorRemovingRef(Long messageID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222046: Failed to remove reference for {}", (Object)messageID);
        }
    }

    @Override
    public void journalCannotFindQueueReloadingACK(Long queueID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222047: Can not find queue {} while reloading ACKNOWLEDGE_CURSOR", (Object)queueID);
        }
    }

    @Override
    public void journalPAGEOnPrepared() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222048: PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state");
        }
    }

    @Override
    public void journalInvalidRecordType(Byte recordType) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222049: InternalError: Record type {} not recognized. Maybe you are using journal files created on a different version", (Object)recordType);
        }
    }

    @Override
    public void journalInvalidRecordTypeOnPreparedTX(Byte recordType) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222050: Can not locate recordType={} on loadPreparedTransaction//deleteRecords", (Object)recordType);
        }
    }

    @Override
    public void journalError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222051: Journal Error", (Throwable)e);
        }
    }

    @Override
    public void errorIncrementDelayDeletionCount(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222052: error incrementing delay detection", (Throwable)e);
        }
    }

    @Override
    public void lareMessageErrorCopying(LargeServerMessage largeServerMessage, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222053: Error on copying large message {} for DLA or Expiry", (Object)largeServerMessage, (Object)e);
        }
    }

    @Override
    public void errorExecutingAIOCallback(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222054: Error on executing IOCallback", t);
        }
    }

    @Override
    public void errorDeletingDuplicateCache(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222055: Error on deleting duplicate cache", (Throwable)e);
        }
    }

    @Override
    public void noDLA(SimpleString address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222056: Did not route to any bindings for address {} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.", (Object)address);
        }
    }

    @Override
    public void ioErrorAddingReferences(Integer errorCode, String errorMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222057: It was not possible to add references due to an IO error code {} message = {}", (Object)errorCode, (Object)errorMessage);
        }
    }

    @Override
    public void duplicateMessageDetected(Message message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222059: Duplicate message detected - message will not be routed. Message information:\n{}", (Object)message);
        }
    }

    @Override
    public void journalErrorConfirmingLargeMessage(Long messageID, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222060: Error while confirming large message completion on rollback for recordID={}", (Object)messageID, (Object)e);
        }
    }

    @Override
    public void clientConnectionFailed(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222061: Client connection failed, clearing up resources for session {}", (Object)name);
        }
    }

    @Override
    public void clearingUpSession(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222062: Cleared up resources for session {}", (Object)name);
        }
    }

    @Override
    public void errorProcessingIOCallback(Integer errorCode, String errorMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222063: Error processing IOCallback code = {} message = {}", (Object)errorCode, (Object)errorMessage);
        }
    }

    @Override
    public void incompatibleVersionAfterConnect(int version, int clientVersion) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AMQ222065: Client is not being consistent on the request versioning. It just sent a version id={} while it informed {} previously", (Object)version, (Object)clientVersion);
        }
    }

    @Override
    public void reattachRequestFailed(String remoteAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222066: Reattach request from {} failed as there is no confirmationWindowSize configured, which may be ok for your system", (Object)remoteAddress);
        }
    }

    @Override
    public void connectionFailureDetected(String message, ActiveMQExceptionType type) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222067: Connection failure has been detected: {} [code={}]", (Object)message, (Object)type);
        }
    }

    @Override
    public void errorCleaningStompConn(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222069: error cleaning up stomp connection", (Throwable)e);
        }
    }

    @Override
    public void stompTXAckNorSupported() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222070: Stomp Transactional acknowledgement is not supported");
        }
    }

    @Override
    public void errorOnStompHeartBeat(InterruptedException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222071: Interrupted while waiting for stomp heartbeat to die", (Throwable)e);
        }
    }

    @Override
    public void timedOutFlushingInvmChannel() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222072: Timed out flushing channel on InVMConnection");
        }
    }

    @Override
    public void nettyChannelGroupError() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222074: channel group did not completely close");
        }
    }

    @Override
    public void nettyChannelStillOpen(Channel channel, SocketAddress remoteAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222075: {} is still connected to {}", (Object)channel, (Object)remoteAddress);
        }
    }

    @Override
    public void nettyChannelGroupBindError() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222076: channel group did not completely unbind");
        }
    }

    @Override
    public void nettyChannelStillBound(Channel channel, SocketAddress remoteAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222077: {} is still bound to {}", (Object)channel, (Object)remoteAddress);
        }
    }

    @Override
    public void errorCreatingRemotingInterceptor(String interceptorClass, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222078: Error instantiating remoting interceptor {}", (Object)interceptorClass, (Object)e);
        }
    }

    @Override
    public void invalidAcceptorKeys(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222079: The following keys are invalid for configuring the acceptor: {} the acceptor will not be started.", (Object)s);
        }
    }

    @Override
    public void errorCreatingAcceptor(String factoryClassName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222080: Error instantiating remoting acceptor {}", (Object)factoryClassName, (Object)e);
        }
    }

    @Override
    public void timeoutRemotingThreadPool() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222081: Timed out waiting for remoting thread pool to terminate");
        }
    }

    @Override
    public void errorOnFailureCheck(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222082: error on connection failure check", e);
        }
    }

    @Override
    public void connectorKeysInvalid(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222083: The following keys are invalid for configuring the connector service: {} the connector will not be started.", (Object)s);
        }
    }

    @Override
    public void connectorKeysMissing(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222084: The following keys are required for configuring the connector service: {} the connector will not be started.", (Object)s);
        }
    }

    @Override
    public void invalidPacketForReplication(Packet packet) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222085: Packet {} can not be processed by the ReplicationEndpoint", (Object)packet);
        }
    }

    @Override
    public void errorHandlingReplicationPacket(Packet packet, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222086: error handling packet {} for replication", (Object)packet, (Object)e);
        }
    }

    @Override
    public void errorClosingPageOnReplication(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222087: Replication Error while closing the page on backup", (Throwable)e);
        }
    }

    @Override
    public void journalcomparisonMismatch(String s) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222088: Journal comparison mismatch:\n{}", (Object)s);
        }
    }

    @Override
    public void errorDeletingLargeMessage(long messageId, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222089: Replication Error deleting large message ID = {}", (Object)messageId, (Object)e);
        }
    }

    @Override
    public void largeMessageNotAvailable(long messageId) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222090: Replication Large MessageID {}  is not available on backup server. Ignoring replication message", (Object)messageId);
        }
    }

    @Override
    public void replicationStopOnBackupShutdown() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222091: The backup node has been shut-down, replication will now stop");
        }
    }

    @Override
    public void replicationStopOnBackupFail(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222092: Connection to the backup node failed, removing replication now", (Throwable)e);
        }
    }

    @Override
    public void timedOutWaitingToStopBridge() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222093: Timed out waiting to stop Bridge");
        }
    }

    @Override
    public void bridgeUnableToSendMessage(MessageReference ref, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222094: Bridge unable to send message {}, will try again once bridge reconnects", (Object)ref, (Object)e);
        }
    }

    @Override
    public void bridgeConnectionFailed(Boolean failedOver) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222095: Connection failed with failedOver={}", (Object)failedOver);
        }
    }

    @Override
    public void errorQueryingBridge(String name, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222096: Error on querying binding on bridge {}. Retrying in 100 milliseconds", (Object)name, (Object)t);
        }
    }

    @Override
    public void errorQueryingBridge(String address, Integer retryCount) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222097: Address {} does not have any bindings, retry #({})", (Object)address, (Object)retryCount);
        }
    }

    @Override
    public void errorStartingBridge(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222098: Server is starting, retry to create the session for bridge {}", (Object)name);
        }
    }

    @Override
    public void errorConnectingBridge(Bridge bridge, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222099: Bridge {} is unable to connect to destination. It will be disabled.", (Object)bridge, (Object)e);
        }
    }

    @Override
    public void bridgeLocatorShutdown() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222100: ServerLocator was shutdown, can not retry on opening connection for bridge");
        }
    }

    @Override
    public void bridgeAbortStart(String name, Integer retryCount, Integer reconnectAttempts) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222101: Bridge {} achieved {} maxattempts={} it will stop retrying to reconnect", new Object[]{name, retryCount, reconnectAttempts});
        }
    }

    @Override
    public void errorReConnecting(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222102: Unexpected exception while trying to reconnect", (Throwable)e);
        }
    }

    @Override
    public void timedOutXID(Xid xid) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222103: transaction with xid {} timed out", (Object)xid);
        }
    }

    @Override
    public void ioErrorOnTX(Integer errorCode, String errorMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222104: IO Error completing the transaction, code = {}, message = {}", (Object)errorCode, (Object)errorMessage);
        }
    }

    @Override
    public void replacingIncompleteLargeMessage(Long messageID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222106: Replacing incomplete LargeMessage with ID={}", (Object)messageID);
        }
    }

    @Override
    public void clientConnectionFailedClearingSession(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222107: Cleared up resources for session {}", (Object)name);
        }
    }

    @Override
    public void broadcastGroupClosed(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222108: unable to send notification when broadcast group is stopped", (Throwable)e);
        }
    }

    @Override
    public void timeoutLockingConsumer(String consumer, String remoteAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222109: Timed out waiting for write lock on consumer {} from {}. Check the Thread dump", (Object)consumer, (Object)remoteAddress);
        }
    }

    @Override
    public void noQueueIdDefined(Message message, Message messageCopy, SimpleString idsHeaderName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222110: no queue IDs defined!,  originalMessage  = {}, copiedMessage = {}, props={}", new Object[]{message, messageCopy, idsHeaderName});
        }
    }

    @Override
    public void managementOperationError(String op, String resourceName, Exception e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("AMQ222111: exception while invoking {} on {}", new Object[]{op, resourceName, e});
        }
    }

    @Override
    public void managementAttributeError(String att, String resourceName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222112: exception while retrieving attribute {} on {}", new Object[]{att, resourceName, e});
        }
    }

    @Override
    public void managementStopError(Integer size, List<String> unexpectedResourceNames) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222113: On ManagementService stop, there are {} unexpected registered MBeans: {}", (Object)size, unexpectedResourceNames);
        }
    }

    @Override
    public void unableToDeleteGroupBindings(SimpleString groupId, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222114: Unable to delete group binding info {}", (Object)groupId, (Object)e);
        }
    }

    @Override
    public void errorClosingServerLocator(ServerLocatorInternal clusterLocator, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222115: Error closing serverLocator={}", (Object)clusterLocator, (Object)e);
        }
    }

    @Override
    public void unableToStartBroadcastGroup(String name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222116: unable to start broadcast group {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void unableToStartClusterConnection(SimpleString name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222117: unable to start cluster connection {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void unableToStartBridge(SimpleString name, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222118: unable to start Bridge {}", (Object)name, (Object)e);
        }
    }

    @Override
    public void announceBackupNoConnector(String connectorName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222119: No connector with name {}. backup cannot be announced.", (Object)connectorName);
        }
    }

    @Override
    public void announceBackupNoClusterConnections() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222120: no cluster connections defined, unable to announce backup");
        }
    }

    @Override
    public void bridgeNotUnique() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222121: Must specify a unique name for each bridge. This one will not be deployed.");
        }
    }

    @Override
    public void bridgeNoQueue(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222122: Must specify a queue name for each bridge. This one {} will not be deployed.", (Object)name);
        }
    }

    @Override
    public void bridgeNoForwardAddress(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222123: Forward address is not specified on bridge {}. Will use original message address instead", (Object)bridgeName);
        }
    }

    @Override
    public void bridgeAlreadyDeployed(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222124: There is already a bridge with name {} deployed. This one will not be deployed.", (Object)name);
        }
    }

    @Override
    public void bridgeQueueNotFound(String queueName, String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222125: No queue found with name {} bridge {} will not be deployed.", (Object)queueName, (Object)bridgeName);
        }
    }

    @Override
    public void bridgeNoDiscoveryGroup(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222126: No discovery group found with name {} bridge will not be deployed.", (Object)name);
        }
    }

    @Override
    public void clusterConnectionNotUnique() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222127: Must specify a unique name for each cluster connection. This one will not be deployed.");
        }
    }

    @Override
    public void clusterConnectionNoForwardAddress() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222128: Must specify an address for each cluster connection. This one will not be deployed.");
        }
    }

    @Override
    public void clusterConnectionNoConnector(String connectorName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222129: No connector with name {}. The cluster connection will not be deployed.", (Object)connectorName);
        }
    }

    @Override
    public void clusterConnectionAlreadyExists(String connectorName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222130: Cluster Configuration  {} already exists. The cluster connection will not be deployed.", (Object)connectorName);
        }
    }

    @Override
    public void clusterConnectionNoDiscoveryGroup(String discoveryGroupName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222131: No discovery group with name {}. The cluster connection will not be deployed.", (Object)discoveryGroupName);
        }
    }

    @Override
    public void broadcastGroupAlreadyExists(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222132: There is already a broadcast-group with name {} deployed. This one will not be deployed.", (Object)name);
        }
    }

    @Override
    public void broadcastGroupNoConnector(String connectorName, String bgName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222133: There is no connector deployed with name {}. The broadcast group with name {} will not be deployed.", (Object)connectorName, (Object)bgName);
        }
    }

    @Override
    public void noConnector(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222134: No connector defined with name {}. The bridge will not be deployed.", (Object)name);
        }
    }

    @Override
    public void errorStoppingRedistributor() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222135: Stopping Redistributor, Timed out waiting for tasks to complete");
        }
    }

    @Override
    public void ioErrorRedistributing(Integer errorCode, String errorMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222136: IO Error during redistribution, errorCode = {} message = {}", (Object)errorCode, (Object)errorMessage);
        }
    }

    @Override
    public void errorAnnouncingBackup(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222137: Unable to announce backup, retrying", e);
        }
    }

    @Override
    public void noLocalMemborOnClusterConnection(ClusterConnectionImpl clusterConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222138: Local Member is not set at on ClusterConnection {}", (Object)clusterConnection);
        }
    }

    @Override
    public void remoteQueueAlreadyBoundOnClusterConnection(Object messageFlowRecord, SimpleString clusterName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222139: {}::Remote queue binding {} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses", messageFlowRecord, (Object)clusterName);
        }
    }

    @Override
    public void nodeManagerCantOpenFile(File file, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222141: Node Manager can not open file {}", (Object)file, (Object)e);
        }
    }

    @Override
    public void errorResttingLargeMessage(Object deliverer, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222142: Error on resetting large message deliver - {}", deliverer, (Object)e);
        }
    }

    @Override
    public void errorTransferringConsumer() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222143: Timed out waiting for executor to complete");
        }
    }

    @Override
    public void errorFlushingExecutorsOnQueue() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222144: Queue could not finish waiting executors. Try increasing the thread pool size");
        }
    }

    @Override
    public void errorExpiringReferencesOnQueue(MessageReference ref, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222145: Error expiring reference {} on queue", (Object)ref, (Object)e);
        }
    }

    @Override
    public void errorExpiringReferencesNoBindings(SimpleString expiryAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222146: Message has expired. No bindings for Expiry Address {} so dropping it", (Object)expiryAddress);
        }
    }

    @Override
    public void errorExpiringReferencesNoAddress(SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222147: Messages are being expired on queue {}, but there is no Expiry Address configured so messages will be dropped.", (Object)name);
        }
    }

    @Override
    public void noBindingsOnDLA(MessageReference ref, SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222148: Sending message {} to Dead Letter Address {}, but it has no bindings so dropping it", (Object)ref, (Object)name);
        }
    }

    @Override
    public void sendingMessageToDLA(MessageReference ref, SimpleString name, SimpleString simpleString) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222149: Sending message {} to Dead Letter Address {} from {}", new Object[]{ref, name, simpleString});
        }
    }

    @Override
    public void sendingMessageToDLAnoDLA(MessageReference ref, SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222150: Sending message {} to Dead Letter Address, but there is no Dead Letter Address configured for queue {} so dropping it", (Object)ref, (Object)name);
        }
    }

    @Override
    public void removingBadConsumer(Consumer consumer, Object reference, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222151: removing consumer which did not handle a message, consumer={}, message={}", new Object[]{consumer, reference, e});
        }
    }

    @Override
    public void errorDecrementingRefCount(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222152: Unable to decrement reference counting on queue", e);
        }
    }

    @Override
    public void cannotFindMessageOnJournal(Long messageID, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222153: Cannot locate record for message id = {} on Journal", (Object)messageID, (Object)e);
        }
    }

    @Override
    public void errorCheckingDLQ(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222154: Error checking DLQ", e);
        }
    }

    @Override
    public void errorRegisteringBackup() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222155: Failed to register as backup. Stopping the server.");
        }
    }

    @Override
    public void memoryError(Integer memoryWarningThreshold, String info) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222156: Less than {}%\n{}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)", (Object)memoryWarningThreshold, (Object)info);
        }
    }

    @Override
    public void errorCompletingCallbackOnReplicationManager(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222157: Error completing callback on replication manager", e);
        }
    }

    @Override
    public void activationDidntFinish(ActiveMQServer server) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222158: {} activation thread did not finish.", (Object)server);
        }
    }

    @Override
    public void broadcastBridgeStoppedError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222159: unable to send notification when broadcast group is stopped", (Throwable)e);
        }
    }

    @Override
    public void notificationBridgeStoppedError(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222160: unable to send notification when broadcast group is stopped", (Throwable)e);
        }
    }

    @Override
    public void groupHandlerSendTimeout() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222161: Group Handler timed-out waiting for sendCondition");
        }
    }

    @Override
    public void backupMovingDataAway(String oldPath, String newPath) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ222162: Moving data directory {} to {}", (Object)oldPath, (Object)newPath);
        }
    }

    @Override
    public void stopReplicatedBackupAfterFailback() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222163: Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.");
        }
    }

    @Override
    public void errorStartingReplication(BackupReplicationStartFailedMessage.BackupRegistrationProblem problem) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222164: Error when trying to start replication {}", (Object)problem);
        }
    }

    @Override
    public void AddressSettingsNoDLA(SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222165: No Dead Letter Address configured for queue {} in AddressSettings", (Object)name);
        }
    }

    @Override
    public void AddressSettingsNoExpiryAddress(SimpleString name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222166: No Expiry Address configured for queue {} in AddressSettings", (Object)name);
        }
    }

    @Override
    public void groupingQueueRemoved(int size, SimpleString clusterName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222167: Group Binding not available so deleting {} groups from {}, groups will be bound to another node", (Object)size, (Object)clusterName);
        }
    }

    @Override
    public void warnDeprecatedProtocol() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222168: The 'protocol' property is deprecated. If you want this Acceptor to support multiple protocols, use the 'protocols' property, e.g. with value 'CORE,AMQP,STOMP'");
        }
    }

    @Override
    public void warnDisconnectOldClient(String queueName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222169: You have old legacy clients connected to the queue {} and we can't disconnect them, these clients may just hang", (Object)queueName);
        }
    }

    @Override
    public void bridgeConfirmationWindowTooSmall(String bridgeName, String address, int windowConfirmation, long maxSizeBytes) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222170: Bridge {} forwarding address {} has confirmation-window-size ({}) greater than address' max-size-bytes' ({})", new Object[]{bridgeName, address, windowConfirmation, maxSizeBytes});
        }
    }

    @Override
    public void bridgeCantFindAddressConfig(String bridgeName, String forwardingAddress) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222171: Bridge {} forwarding address {} could not be resolved on address-settings configuration", (Object)bridgeName, (Object)forwardingAddress);
        }
    }

    @Override
    public void queueBusy(String name, long timeout) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222172: Queue {} was busy for more than {} milliseconds. There are possibly consumers hanging on a network operation", (Object)name, (Object)timeout);
        }
    }

    @Override
    public void queueDuplicatedRenaming(String name, String newName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222173: Queue {} is duplicated during reload. This queue will be renamed as {}", (Object)name, (Object)newName);
        }
    }

    @Override
    public void timeoutFlushInTransit(String queueName, String addressName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222174: Queue {}, on address={}, is taking too long to flush deliveries. Watch out for frozen clients.", (Object)queueName, (Object)addressName);
        }
    }

    @Override
    public void bridgeCantFindConnectors(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222175: Bridge {} could not find configured connectors", (Object)bridgeName);
        }
    }

    @Override
    public void xidReplacedOnXStart(String xidOriginalToString, String xidReplacedToString) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222176: A session that was already doing XA work on {} is replacing the xid by {} . This was most likely caused from a previous communication timeout", (Object)xidOriginalToString, (Object)xidReplacedToString);
        }
    }

    @Override
    public void rolePermissionConfigurationError(String permission) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222177: Wrong configuration for role, {} is not a valid permission", (Object)permission);
        }
    }

    @Override
    public void errorRecoveringPageCounter(Throwable error) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222178: Error during recovery of page counters", error);
        }
    }

    @Override
    public void failedToScaleDown(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222181: Unable to scaleDown messages", e);
        }
    }

    @Override
    public void missingClusterConfigForScaleDown(String scaleDownCluster) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222182: Missing cluster-configuration for scale-down-clustername {}", (Object)scaleDownCluster);
        }
    }

    @Override
    public void blockingMessageProduction(SimpleString addressName, String pageInfo) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222183: Blocking message production on address '{}'; {}", (Object)addressName, (Object)pageInfo);
        }
    }

    @Override
    public void groupBindingsOnRecovery() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222184: Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this");
        }
    }

    @Override
    public void noClusterConnectionForReplicationCluster() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222185: no cluster connection for specified replication cluster");
        }
    }

    @Override
    public void clusterControlAuthfailure(String causeMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222186: unable to authorise cluster control: {}", (Object)causeMessage);
        }
    }

    @Override
    public void activateReplicatedBackupFailed(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222187: Failed to activate replicated backup", e);
        }
    }

    @Override
    public void unableToFindTargetQueue(String targetNodeID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222188: Unable to find target queue for node {}", (Object)targetNodeID);
        }
    }

    @Override
    public void activateSharedStoreSlaveFailed(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222189: Failed to activate shared store slave", e);
        }
    }

    @Override
    public void cannotFindRoleForUser(String user) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222191: Could not find any configured role for user {}.", (Object)user);
        }
    }

    @Override
    public void couldNotDeleteTempFile(String tempFileName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222192: Could not delete: {}", (Object)tempFileName);
        }
    }

    @Override
    public void memoryLimitReached(String producerID, String address, long duration) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222193: Memory Limit reached. Producer ({}) stopped to prevent flooding {} (blocking for {}s). See http://activemq.apache.org/producer-flow-control.html for more info.", new Object[]{producerID, address, duration});
        }
    }

    @Override
    public void nullPageCursorInfo(String address, String position, long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222194: PageCursorInfo == null on address {}, pos = {}, queue = {}.", new Object[]{address, position, id});
        }
    }

    @Override
    public void largeMessageNotFound(long id) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222195: Large message {} wasn't found when dealing with add pending large message", (Object)id);
        }
    }

    @Override
    public void bindingNotFound(long id, String message, String binding) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222196: Could not find binding with id={} on routeFromCluster for message={} binding = {}", new Object[]{id, message, binding});
        }
    }

    @Override
    public void nonDeliveryHandled() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222197: Internal error! Delivery logic has identified a non delivery and still handled a consumer!");
        }
    }

    @Override
    public void couldNotFlushClusterManager(String manager) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222198: Could not flush ClusterManager executor ({}) in 10 seconds, verify your thread pool size", (Object)manager);
        }
    }

    @Override
    public void threadDump(String manager) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222199: Thread dump: {}", (Object)manager);
        }
    }

    @Override
    public void couldNotFinishExecutor(String clusterConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222200: Could not finish executor on {}", (Object)clusterConnection);
        }
    }

    @Override
    public void activationTimeout() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222201: Timed out waiting for activation to exit");
        }
    }

    @Override
    public void connectionTTLEqualsCheckPeriod(String connectionName, String ttl, String checkPeriod) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222202: {}: <{}> should not be set to the same value as <{}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.", new Object[]{connectionName, ttl, checkPeriod});
        }
    }

    @Override
    public void noProtocolManagerFound(String protocol, String host) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222203: Classpath lacks a protocol-manager for protocol {}, Protocol being ignored on acceptor {}", (Object)protocol, (Object)host);
        }
    }

    @Override
    public void duplicatedAcceptor(String name, String parameters, String classFactory) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222204: Duplicated Acceptor {} with parameters {} classFactory={} duplicated on the configuration", new Object[]{name, parameters, classFactory});
        }
    }

    @Override
    public void potentialOOME(long addressCount, long totalMaxSizeBytes, long maxMemory) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222205: OutOfMemoryError possible! There are currently {} addresses with a total max-size-bytes of {} bytes, but the maximum memory available is {} bytes.", new Object[]{addressCount, totalMaxSizeBytes, maxMemory});
        }
    }

    @Override
    public void connectionLimitReached(long connectionsAllowed, String address) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222206: Connection limit of {} reached. Refusing connection from {}.", (Object)connectionsAllowed, (Object)address);
        }
    }

    @Override
    public void slowReplicationResponse() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222207: The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.");
        }
    }

    @Override
    public void sslHandshakeFailed(String clientAddress, String cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222208: SSL handshake failed for client from {}: {}.", (Object)clientAddress, (Object)cause);
        }
    }

    @Override
    public void impossibleToRouteGrouped() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222209: Could not contact group handler coordinator after 10 retries, message being routed without grouping information");
        }
    }

    @Override
    public void diskBeyondCapacity(String usableSpace, String totalSpace, String usage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222210: Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.", new Object[]{usableSpace, totalSpace, usage});
        }
    }

    @Override
    public void diskCapacityRestored(String usableSpace, String totalSpace, String usage) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ222211: Free storage space is at {} of {} total. Usage rate is {} which is below the configured <max-disk-usage>.", new Object[]{usableSpace, totalSpace, usage});
        }
    }

    @Override
    public void blockingDiskFull(SimpleString addressName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222212: Disk Full! Blocking message production on address '{}'. Clients will report blocked.", (Object)addressName);
        }
    }

    @Override
    public void serverIsolatedOnNetwork() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222213: There was an issue on the network, server is isolated!");
        }
    }

    @Override
    public void negativeAddressSize(String destination, long size) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222214: Destination {} has an inconsistent and negative address size={}.", (Object)destination, (Object)size);
        }
    }

    @Override
    public void negativeGlobalAddressSize(long size) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222215: Global Address Size has negative and inconsistent value as {}", (Object)size);
        }
    }

    @Override
    public void securityProblemWhileAuthenticating(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222216: Security problem while authenticating: {}", (Object)message);
        }
    }

    @Override
    public void connectorRefNotFound(String connectorRef, String clusterConnection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222217: Cannot find connector-ref {}. The cluster-connection {} will not be deployed.", (Object)connectorRef, (Object)clusterConnection);
        }
    }

    @Override
    public void disconnectCritical(String reason, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222218: Server disconnecting: {}", (Object)reason, (Object)e);
        }
    }

    @Override
    public void fileDoesNotExist(String path) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222219: File {} does not exist", (Object)path);
        }
    }

    @Override
    public void errorCleaningPagingOnQueue(String queue, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222220:    Error while cleaning paging on queue {}", (Object)queue, (Object)e);
        }
    }

    @Override
    public void errorCleaningPagingDuringCommit(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222221: Error while cleaning page, during the commit", (Throwable)e);
        }
    }

    @Override
    public void errorDeletingPageCompleteRecord(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222222: Error while deleting page-complete-record", (Throwable)e);
        }
    }

    @Override
    public void errorCalculateMessageMemoryEstimate(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222223: Failed to calculate message memory estimate", e);
        }
    }

    @Override
    public void errorCalculateScheduledDeliveryTime(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222224: Failed to calculate scheduled delivery time", e);
        }
    }

    @Override
    public void sendingUnexpectedExceptionToClient(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222225: Sending unexpected exception to the client", e);
        }
    }

    @Override
    public void connectionConfigurationIsNull(String connectorName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222226: Connection configuration is null for connectorName {}", (Object)connectorName);
        }
    }

    @Override
    public void failedToProcessEvent(NamingException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222227: Failed to process an event", (Throwable)e);
        }
    }

    @Override
    public void missingReplicationTokenOnQueue() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222228: Missing replication token on queue");
        }
    }

    @Override
    public void failedToPerformRollback(IllegalStateException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222229: Failed to perform rollback", (Throwable)e);
        }
    }

    @Override
    public void failedToSendNotification(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222230: Failed to send notification", (Throwable)e);
        }
    }

    @Override
    public void failedToFlushOutstandingDataFromTheConnection(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222231: Failed to flush outstanding data from the connection", e);
        }
    }

    @Override
    public void unableToAcquireLock(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222232: Unable to acquire lock", (Throwable)e);
        }
    }

    @Override
    public void unableDestroyConnectionWithSessionMetadata(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222233: Unable to destroy connection with session metadata", e);
        }
    }

    @Override
    public void unableToInvokeCallback(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222234: Unable to invoke a callback", e);
        }
    }

    @Override
    public void unableToInjectMonitor(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222235: Unable to inject a monitor", e);
        }
    }

    @Override
    public void unableToFlushDeliveries(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222236: Unable to flush deliveries", (Throwable)e);
        }
    }

    @Override
    public void unableToCancelRedistributor(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222237: Unable to stop redistributor", (Throwable)e);
        }
    }

    @Override
    public void unableToCommitTransaction(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222238: Unable to commit transaction", (Throwable)e);
        }
    }

    @Override
    public void unableToDeleteQueueStatus(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222239: Unable to delete Queue status", (Throwable)e);
        }
    }

    @Override
    public void unableToPauseQueue(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222240: Unable to pause a Queue", (Throwable)e);
        }
    }

    @Override
    public void unableToResumeQueue(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222241: Unable to resume a Queue", (Throwable)e);
        }
    }

    @Override
    public void unableToGetMessagePriority(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222242: Unable to obtain message priority, using default ", e);
        }
    }

    @Override
    public void unableToExtractGroupID(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222243: Unable to extract GroupID from message", e);
        }
    }

    @Override
    public void unableToCheckIfMessageExpired(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222244: Unable to check if message expired", e);
        }
    }

    @Override
    public void unableToPerformPostAcknowledge(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222245: Unable to perform post acknowledge", e);
        }
    }

    @Override
    public void unableToRollbackOnClose(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222246: Unable to rollback on close", (Throwable)e);
        }
    }

    @Override
    public void unableToCloseConsumer(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222247: Unable to close consumer", e);
        }
    }

    @Override
    public void unableToRemoveConsumer(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222248: Unable to remove consumer", e);
        }
    }

    @Override
    public void unableToRollbackOnTxTimedOut(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222249: Unable to rollback on TX timed out", (Throwable)e);
        }
    }

    @Override
    public void unableToDeleteHeuristicCompletion(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222250: Unable to delete heuristic completion from storage manager", (Throwable)e);
        }
    }

    @Override
    public void unableToStartReplication(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222251: Unable to start replication", (Throwable)e);
        }
    }

    @Override
    public void unableToCalculateFileSize(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222252: Unable to calculate file size", (Throwable)e);
        }
    }

    @Override
    public void errorWhileSyncingData(String target, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222253: Error while syncing data on largeMessageInSync:: {}", (Object)target, (Object)e);
        }
    }

    @Override
    public void invalidRecordType(byte type, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222254: Invalid record type {}", (Object)type, (Object)e);
        }
    }

    @Override
    public void unableToCalculateFileStoreUsage(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222255: Unable to calculate file store usage", (Throwable)e);
        }
    }

    @Override
    public void failedToUnregisterAcceptors(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222256: Failed to unregister acceptors", (Throwable)e);
        }
    }

    @Override
    public void failedToDecrementMessageReferenceCount(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222257: Failed to decrement message reference count", (Throwable)e);
        }
    }

    @Override
    public void errorOnDeletingQueue(String queueName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222258: Error on deleting queue {}", (Object)queueName, (Object)e);
        }
    }

    @Override
    public void failedToFlushExecutor(InterruptedException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222259: Failed to flush the executor", (Throwable)e);
        }
    }

    @Override
    public void failedToRollback(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222260: Failed to perform rollback", (Throwable)e);
        }
    }

    @Override
    public void failedToActivateBackup(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222261: Failed to activate a backup", (Throwable)e);
        }
    }

    @Override
    public void failedToStopClusterManager(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222262: Failed to stop cluster manager", (Throwable)e);
        }
    }

    @Override
    public void failedToStopClusterConnection(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222263: Failed to stop cluster connection", (Throwable)e);
        }
    }

    @Override
    public void failedToProcessMessageReferenceAfterRollback(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222264: Failed to process message reference after rollback", (Throwable)e);
        }
    }

    @Override
    public void failedToFinishDelivery(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222265: Failed to finish delivery, unable to lock delivery", (Throwable)e);
        }
    }

    @Override
    public void failedToSendRequestToNode(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222266: Failed to send request to the node", (Throwable)e);
        }
    }

    @Override
    public void failedToDisconnectBindings(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222267: Failed to disconnect bindings", (Throwable)e);
        }
    }

    @Override
    public void failedToRemoveRecord(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222268: Failed to remove a record", (Throwable)e);
        }
    }

    @Override
    public void useFixedValueOnJournalPoolFiles() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222269: Please use a fixed value for \"journal-pool-files\". Default changed per https://issues.apache.org/jira/browse/ARTEMIS-1628");
        }
    }

    @Override
    public void unableToCreateManagementNotificationAddress(SimpleString addressName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222270: Unable to create management notification address: {}", (Object)addressName, (Object)e);
        }
    }

    @Override
    public void journalMessageAckMissingQueueInPreparedTX(Long queueID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222702: Message ack in prepared tx for queue {} which does not exist. This ack will be ignored.", (Object)queueID);
        }
    }

    @Override
    public void bridgeAddressFull(String addressName, String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222703: Address \"{}\" is full. Bridge {} will disconnect", (Object)addressName, (Object)bridgeName);
        }
    }

    @Override
    public void problemDeployingAddress(String addressName, String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222274: Failed to deploy address {}: {}", (Object)addressName, (Object)message);
        }
    }

    @Override
    public void problemDeployingQueue(String queueName, String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222275: Failed to deploy queue {}: {}", (Object)queueName, (Object)message);
        }
    }

    @Override
    public void unableToExtractGroupSequence(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222278: Unable to extract GroupSequence from message", e);
        }
    }

    @Override
    public void federationCantFindPolicyRef(String upstreamName, String policyRef) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222279: Federation upstream {} policy ref {} could not be resolved in federation configuration", (Object)upstreamName, (Object)policyRef);
        }
    }

    @Override
    public void federationUnknownPolicyType(String upstreamName, String policyRef) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222280: Federation upstream {} policy ref {} is of unknown type in federation configuration", (Object)upstreamName, (Object)policyRef);
        }
    }

    @Override
    public void federationAvoidStackOverflowPolicyRef(String upstreamName, String policyRef) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222281: Federation upstream {} policy ref {} are too self referential, avoiding stack overflow , ", (Object)upstreamName, (Object)policyRef);
        }
    }

    @Override
    public void federationCantFindUpstreamConnector(String downstreamName, String upstreamRef) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222282: Federation downstream {} upstream transport configuration ref {} could not be resolved in federation configuration", (Object)downstreamName, (Object)upstreamRef);
        }
    }

    @Override
    public void federationDownstreamDeployed(String downstreamName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ222283: Federation downstream {} has been deployed", (Object)downstreamName);
        }
    }

    @Override
    public void federationDownstreamUnDeployed(String downstreamName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ222284: Federation downstream {} has been undeployed", (Object)downstreamName);
        }
    }

    @Override
    public void emptyAddressFile(String addressFile, String directory) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222285: File {} at {} is empty. Delete the empty file to stop this message.", (Object)addressFile, (Object)directory);
        }
    }

    @Override
    public void federationPluginExecutionError(String pluginMethod, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222286: Error executing {} federation plugin method.", (Object)pluginMethod, (Object)e);
        }
    }

    @Override
    public void federationBindingsLookupError(SimpleString address, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222287: Error looking up bindings for address {}.", (Object)address, (Object)e);
        }
    }

    @Override
    public void pageLookupError(long pageNr, int messageNr, int offset, int startNr) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222288: Page {}, message {} could not be found on offset {}, with starting message {}. This represents a logic error or inconsistency on the data, and the system will try once again from the beggining of the page file.", new Object[]{pageNr, messageNr, offset, startNr});
        }
    }

    @Override
    public void noMatchingBindingsOnDLAWithAutoCreateDLAResources(SimpleString address, String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222289: Did not route to any matching bindings on dead-letter-address {} and auto-create-dead-letter-resources is true; dropping message: {}", (Object)address, (Object)message);
        }
    }

    @Override
    public void failedToFindClusterConnection(String packet) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222290: Failed to find cluster-connection when handling cluster-connect packet. Ignoring: {}", (Object)packet);
        }
    }

    @Override
    public void metricsPluginElementDeprecated() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222291: The metrics-plugin element is deprecated and replaced by the metrics element");
        }
    }

    @Override
    public void metricsPluginElementIgnored() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222292: The metrics-plugin element is ignored because the metrics element is defined");
        }
    }

    @Override
    public void possibleSplitBrain(String nodeID, String connectionPairInformation) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222294: There is a possible split brain on nodeID {}, coming from connectors {}. Topology update ignored.", (Object)nodeID, (Object)connectionPairInformation);
        }
    }

    @Override
    public void possibleSplitBrain(String nodeID) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222295: There is a possible split brain on nodeID {}. Topology update ignored", (Object)nodeID);
        }
    }

    @Override
    public void unableToDeployHawtioMBean(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222296: Unable to deploy Hawtio MBeam, console client side RBAC not available", e);
        }
    }

    @Override
    public void unableStartManagementContext(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222297: Unable to start Management Context, RBAC not available", (Throwable)e);
        }
    }

    @Override
    public void failedToCreateBootstrapCredentials(String user, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222298: Failed to create bootstrap user \"{}\". User management may not function.", (Object)user, (Object)e);
        }
    }

    @Override
    public void noBootstrapCredentialsFound() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222299: No bootstrap credentials found. User management may not function.");
        }
    }

    @Override
    public void gettingSslHandlerFailed(String clientAddress, String cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222300: Getting SSL handler failed when serving client from {}: {}.", (Object)clientAddress, (Object)cause);
        }
    }

    @Override
    public void duplicateAddressSettingMatch(String match) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222301: Duplicate address-setting match found: {}. These settings will be ignored! Please review your broker.xml and consolidate any duplicate address-setting elements.", (Object)match);
        }
    }

    @Override
    public void failedToDealWithObjectProperty(SimpleString property, String exceptionMessage) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222302: Failed to deal with property {} when converting message from core to OpenWire: {}", (Object)property, (Object)exceptionMessage);
        }
    }

    @Override
    public void errorRedistributing(String queueName, long m, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222303: Redistribution by {} of messageID = {} failed", new Object[]{queueName, m, t});
        }
    }

    @Override
    public void unableToLoadMessageFromJournal(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222304: Unable to load message from journal", t);
        }
    }

    @Override
    public void federationDispatchError(String message, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222305: Error federating message {}.", (Object)message, (Object)e);
        }
    }

    @Override
    public void failedToLoadPreparedTX(String message, Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222306: Failed to load prepared TX and it will be rolled back: {}", (Object)message, (Object)e);
        }
    }

    @Override
    public void queuesElementDeprecated() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222307: The queues element is deprecated and replaced by the addresses element");
        }
    }

    @Override
    public void failBackCheckerFailure(String component) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ222308: Unable to listen for incoming fail-back request because {} is null. Ensure the broker has the proper cluster-connection configuration.", (Object)component);
        }
    }

    @Override
    public void initializationError(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224000: Failure in initialisation", e);
        }
    }

    @Override
    public void errorDeployingURI(URI uri, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224001: Error deploying URI {}", (Object)uri, (Object)e);
        }
    }

    @Override
    public void errorDeployingURI(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224002: Error deploying URI", e);
        }
    }

    @Override
    public void errorUnDeployingURI(URI a, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224003: Error undeploying URI {}", (Object)a, (Object)e);
        }
    }

    @Override
    public void unableToDeployNode(Node node, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224005: Unable to deploy node {}", (Object)node, (Object)e);
        }
    }

    @Override
    public void invalidFilter(SimpleString filter) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224006: Invalid filter: {}", (Object)filter);
        }
    }

    @Override
    public void pageSubscriptionError(IOCallback IOCallback2, String error) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224007: page subscription = {} error={}", (Object)IOCallback2, (Object)error);
        }
    }

    @Override
    public void batchingIdError(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224008: Failed to store id", (Throwable)e);
        }
    }

    @Override
    public void cannotFindMessage(Long id) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224009: Cannot find message {}", (Object)id);
        }
    }

    @Override
    public void journalCannotFindQueue(Long queue, Long id) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224010: Cannot find queue messages for queueID={} on ack for messageID={}", (Object)queue, (Object)id);
        }
    }

    @Override
    public void journalCannotFindQueueScheduled(Long queue, Long id) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224011: Cannot find queue messages {} for message {} while processing scheduled messages", (Object)queue, (Object)id);
        }
    }

    @Override
    public void largeMessageErrorReleasingResources(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224012: error releasing resources", (Throwable)e);
        }
    }

    @Override
    public void errorClosingSession(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224014: Failed to close session", (Throwable)e);
        }
    }

    @Override
    public void caughtXaException(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224015: Caught XA exception", (Throwable)e);
        }
    }

    @Override
    public void caughtException(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224016: Caught exception", e);
        }
    }

    @Override
    public void invalidPacket(Packet packet) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224017: Invalid packet {}", (Object)packet);
        }
    }

    @Override
    public void failedToCreateSession(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224018: Failed to create session", (Throwable)e);
        }
    }

    @Override
    public void failedToReattachSession(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224019: Failed to reattach session", (Throwable)e);
        }
    }

    @Override
    public void failedToHandleCreateQueue(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224020: Failed to handle create queue", (Throwable)e);
        }
    }

    @Override
    public void errorDecodingPacket(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224021: Failed to decode packet", (Throwable)e);
        }
    }

    @Override
    public void errorCallingFailureListener(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224022: Failed to execute failure listener", e);
        }
    }

    @Override
    public void stompErrorTXExists(String txID) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224024: Stomp Error, tx already exist! {}", (Object)txID);
        }
    }

    @Override
    public void errorWritingToInvmConnector(Runnable runnable, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224027: Failed to write to handler on invm connector {}", (Object)runnable, (Object)e);
        }
    }

    @Override
    public void errorStoppingAcceptor(String name) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224028: Failed to stop acceptor {}", (Object)name);
        }
    }

    @Override
    public void largeMessageIncompatible() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224029: large message sync: largeMessage instance is incompatible with it, ignoring data");
        }
    }

    @Override
    public void errorCancellingRefOnBridge(MessageReference ref2, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224030: Could not cancel reference {}", (Object)ref2, (Object)e);
        }
    }

    @Override
    public void errorPausingBridge(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224032: Failed to pause bridge", (Throwable)e);
        }
    }

    @Override
    public void errorBroadcastingConnectorConfigs(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224033: Failed to broadcast connector configs", (Throwable)e);
        }
    }

    @Override
    public void errorClosingConsumer(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224034: Failed to close consumer", (Throwable)e);
        }
    }

    @Override
    public void errorClosingFlowRecord(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224035: Failed to close cluster connection flow record", (Throwable)e);
        }
    }

    @Override
    public void errorUpdatingTopology(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224036: Failed to update cluster connection topology", (Throwable)e);
        }
    }

    @Override
    public void errorHandlingMessage(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224037: cluster connection Failed to handle message", (Throwable)e);
        }
    }

    @Override
    public void errorAckingOldReference(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224038: Failed to ack old reference", (Throwable)e);
        }
    }

    @Override
    public void errorExpiringRef(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224039: Failed to expire message reference", (Throwable)e);
        }
    }

    @Override
    public void errorRemovingConsumer(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224040: Failed to remove consumer", (Throwable)e);
        }
    }

    @Override
    public void errorDelivering(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224041: Failed to deliver", (Throwable)e);
        }
    }

    @Override
    public void errorRestartingBackupServer(ActiveMQServer backup, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224042: Error while restarting the backup server: {}", (Object)backup, (Object)e);
        }
    }

    @Override
    public void errorSendingForcedDelivery(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224043: Failed to send forced delivery message", (Throwable)e);
        }
    }

    @Override
    public void errorAckingMessage(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224044: error acknowledging message", (Throwable)e);
        }
    }

    @Override
    public void errorRunningLargeMessageDeliverer(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224045: Failed to run large message deliverer", (Throwable)e);
        }
    }

    @Override
    public void errorBrowserHandlingMessage(MessageReference current, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224046: Exception while browser handled from {}", (Object)current, (Object)e);
        }
    }

    @Override
    public void errorDeletingLargeMessageFile(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224047: Failed to delete large message file", e);
        }
    }

    @Override
    public void errorRemovingTempQueue(SimpleString bindingName, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224048: Failed to remove temporary queue {}", (Object)bindingName, (Object)e);
        }
    }

    @Override
    public void cannotFindConsumer(long consumerID) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224049: Cannot find consumer with id {}", (Object)consumerID);
        }
    }

    @Override
    public void errorClosingConnection(ServerSessionImpl serverSession) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224050: Failed to close connection {}", (Object)serverSession);
        }
    }

    @Override
    public void errorCallingNotifListener(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224051: Failed to call notification listener", (Throwable)e);
        }
    }

    @Override
    public void errorCallingRepoListener(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224052: Unable to call Hierarchical Repository Change Listener", e);
        }
    }

    @Override
    public void errorTimingOutTX(Xid xid, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224053: failed to timeout transaction, xid:{}", (Object)xid, (Object)e);
        }
    }

    @Override
    public void errorStoppingReplicationManager(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224054: exception while stopping the replication manager", t);
        }
    }

    @Override
    public void bridgeFailedToAck(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224055: Bridge Failed to ack", t);
        }
    }

    @Override
    public void autoFailBackDenied() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224056: Live server will not fail-back automatically");
        }
    }

    @Override
    public void failbackMissedBackupAnnouncement() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224057: Backup server that requested fail-back was not announced. Server will not stop for fail-back.");
        }
    }

    @Override
    public void clusterManagerAuthenticationError(String msg) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224058: Stopping ClusterManager. As it failed to authenticate with the cluster: {}", (Object)msg);
        }
    }

    @Override
    public void invalidCipherSuite(String validSuites) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224059: Invalid cipher suite specified. Supported cipher suites are: {}", (Object)validSuites);
        }
    }

    @Override
    public void invalidProtocol(String validProtocols) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224060: Invalid protocol specified. Supported protocols are: {}", (Object)validProtocols);
        }
    }

    @Override
    public void incompatibleWithHAPolicy(String parameter) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224061: Setting both <{}> and <ha-policy> is invalid. Please use <ha-policy> exclusively. Ignoring value.", (Object)parameter);
        }
    }

    @Override
    public void failedToSendSlowConsumerNotification(Notification notification, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224062: Failed to send SLOW_CONSUMER notification: {}", (Object)notification, (Object)e);
        }
    }

    @Override
    public void failedToCloseConsumerConnectionsForAddress(String address, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224063: Failed to close consumer connections for address {}", (Object)address, (Object)e);
        }
    }

    @Override
    public void incompatibleWithHAPolicyChosen(String parameter) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224064: Setting <{}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring value.", (Object)parameter);
        }
    }

    @Override
    public void errorRemovingAutoCreatedDestination(String destinationType, SimpleString bindingName, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224065: Failed to remove auto-created {} {}", new Object[]{destinationType, bindingName, e});
        }
    }

    @Override
    public void errorOpeningContextForLDAP(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224066: Error opening context for LDAP", (Throwable)e);
        }
    }

    @Override
    public void errorPopulatingSecurityRolesFromLDAP(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224067: Error populating security roles from LDAP", (Throwable)e);
        }
    }

    @Override
    public void errorStoppingComponent(String componentClassName, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224068: Unable to stop component: {}", (Object)componentClassName, (Object)t);
        }
    }

    @Override
    public void configurationReloadFailed(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224069: Change detected in broker configuration file, but reload failed", t);
        }
    }

    @Override
    public void invalidMessageCounterPeriod(long value) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224072: Message Counter Sample Period too short: {}", (Object)value);
        }
    }

    @Override
    public void journalUseMAPPED() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224073: Using MAPPED Journal");
        }
    }

    @Override
    public void failedToPurgeQueue(SimpleString bindingName, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224074: Failed to purge queue {} on no consumers", (Object)bindingName, (Object)e);
        }
    }

    @Override
    public void journalCannotFindPageTX(Long id) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224075: Cannot find pageTX id = {}", (Object)id);
        }
    }

    @Override
    public void criticalSystemHalt(Object component) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224079: The process for the virtual machine will be killed, as component {} is not responsive", component);
        }
    }

    @Override
    public void criticalSystemShutdown(Object component) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224080: The server process will now be stopped, as component {} is not responsive", component);
        }
    }

    @Override
    public void criticalSystemLog(Object component) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224081: The component {} is not responsive", component);
        }
    }

    @Override
    public void undeployAddress(SimpleString addressName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224076: Undeploying address {}", (Object)addressName);
        }
    }

    @Override
    public void undeployQueue(SimpleString queueName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224077: Undeploying queue {}", (Object)queueName);
        }
    }

    @Override
    public void duplicateCacheSizeWarning(int idCacheSize, int confirmationWindowSize) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224078: The size of duplicate cache detection (<id_cache-size/>) appears to be too large {}. It should be no greater than the number of messages that can be squeezed into confirmation window buffer (<confirmation-window-size/>) {}.", (Object)idCacheSize, (Object)confirmationWindowSize);
        }
    }

    @Override
    public void failedToInvokeAnInterceptor(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224082: Failed to invoke an interceptor", (Throwable)e);
        }
    }

    @Override
    public void failedToCloseContext(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224083: Failed to close context", (Throwable)e);
        }
    }

    @Override
    public void failedToOpenContext(Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224084: Failed to open context", (Throwable)e);
        }
    }

    @Override
    public void failedToLoadProperty(String key, String reason, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224085: Failed to load property {}, reason: {}", new Object[]{key, reason, e});
        }
    }

    @Override
    public void caughtUnexpectedException(NamingException e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224086: Caught unexpected exception", (Throwable)e);
        }
    }

    @Override
    public void errorAnnouncingBackup(String backupManager) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224087: Error announcing backup: backupServerLocator is null. {}", (Object)backupManager);
        }
    }

    @Override
    public void handshakeTimeout(int timeout, String acceptorName, String remoteAddress) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224088: Timeout ({} seconds) on acceptor \"{}\" during protocol handshake with {} has occurred.", new Object[]{timeout, acceptorName, remoteAddress});
        }
    }

    @Override
    public void errorCalculatePersistentSize(Throwable e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224089: Failed to calculate persistent size", e);
        }
    }

    @Override
    public void noVoteHandlerConfigured() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224090: This node is not configured for Quorum Voting, all nodes must be configured for HA");
        }
    }

    @Override
    public void errorConnectingBridgeRetry(Bridge bridge) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224091: Bridge {} is unable to connect to destination. Retrying", (Object)bridge);
        }
    }

    @Override
    public void pageWillBePersisted() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224092: Despite disabled persistence, page files will be persisted.");
        }
    }

    @Override
    public void nullRefMessage() {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224093: Reference to message is null");
        }
    }

    @Override
    public void quorumVoteAwaitInterrupted() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("AMQ224094: Quorum vote result await is interrupted");
        }
    }

    @Override
    public void consumerCountError(String reason) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224095: Error updating Consumer Count: {}", (Object)reason);
        }
    }

    @Override
    public void failedToFindProtocolManager(String remoteAddress, String localAddress, String intendedProtocolManager, String protocolMap) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224096: Error setting up connection from {} to {}; protocol {} not found in map: {}", new Object[]{remoteAddress, localAddress, intendedProtocolManager, protocolMap});
        }
    }

    @Override
    public void failedToStartServer(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224097: Failed to start server", t);
        }
    }

    @Override
    public void quorumBackupIsLive(String liveConnector) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224098: Received a vote saying the backup is live with connector: {}", (Object)liveConnector);
        }
    }

    @Override
    public void messageWithHeaderTooLarge(Long messageID, String loggerClass) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224099: Message with ID {} has a header too large. More information available on debug level for class {}", (Object)messageID, (Object)loggerClass);
        }
    }

    @Override
    public void timedOutWaitingForLargeMessagesDeletion(List<Long> largeMessageIds) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224100: Timed out waiting for large messages deletion with IDs {}, might not be deleted if broker crashes atm", largeMessageIds);
        }
    }

    @Override
    public void scheduledPoolWithNoRemoveOnCancelPolicy() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224101: Apache ActiveMQ Artemis is using a scheduled pool without remove on cancel policy, so a cancelled task could be not automatically removed from the work queue, it may also cause unbounded retention of cancelled tasks.");
        }
    }

    @Override
    public void unableToUndeployAddress(SimpleString addressName, String reason) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224102: unable to undeploy address {} : reason {}", (Object)addressName, (Object)reason);
        }
    }

    @Override
    public void unableToUndeployQueue(SimpleString queueName, String reason) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224103: unable to undeploy queue {} : reason {}", (Object)queueName, (Object)reason);
        }
    }

    @Override
    public void errorStartingAcceptor(String name, Object configuration) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224104: Error starting the Acceptor {} {}", (Object)name, configuration);
        }
    }

    @Override
    public void failedConnectingToCluster(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224105: Connecting to cluster failed", (Throwable)e);
        }
    }

    @Override
    public void errorRemovingTX(Xid xid, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ224106: failed to remove transaction, xid:{}", (Object)xid, (Object)e);
        }
    }

    @Override
    public void enableTraceForCriticalAnalyzer() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224107: The Critical Analyzer detected slow paths on the broker.  It is recommended that you enable trace logs on org.apache.activemq.artemis.utils.critical while you troubleshoot this issue. You should disable the trace logs when you have finished troubleshooting.");
        }
    }

    @Override
    public void pageStoreStop(SimpleString storeName, String pageInfo) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224108: Stopped paging on address '{}'; {}", (Object)storeName, (Object)pageInfo);
        }
    }

    @Override
    public void connectionRouterNotFound(String name) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224109: ConnectionRouter {} not found", (Object)name);
        }
    }

    @Override
    public void useAllowList() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224110: Configuration 'whitelist' is deprecated, please use the 'allowlist' configuration");
        }
    }

    @Override
    public void useOnlyAllowList() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224111: Both 'whitelist' and 'allowlist' detected. Configuration 'whitelist' is deprecated, please use only the 'allowlist' configuration");
        }
    }

    @Override
    public void autoRemoveQueue(String name, long queueID, String address) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224112: Auto removing Queue {} with queueID={} on address={}", new Object[]{name, queueID, address});
        }
    }

    @Override
    public void autoRemoveAddress(String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224113: Auto removing Address {}", (Object)name);
        }
    }

    @Override
    public void blockingViaControl(SimpleString addressName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224114: Address control block, blocking message production on address '{}'. Clients will not get further credit.", (Object)addressName);
        }
    }

    @Override
    public void unblockingViaControl(SimpleString addressName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224115: Address control unblock of address '{}'. Clients will be granted credit as normal.", (Object)addressName);
        }
    }

    @Override
    public void tooLongToStart(Object component) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224116: The component {} is not responsive during start up. The Server may be taking too long to start", component);
        }
    }

    @Override
    public void pageMaxSizeUsed() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ224117: \"page-max-cache-size\" being used on broker.xml. This configuration attribute is no longer used and it will be ignored.");
        }
    }

    @Override
    public void dbReturnedTimeOffClock(long dbTime, long systemTime, long variance) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ224118: The SQL Database is returning a current time too far from this system current time. Adjust clock on the SQL Database server. DatabaseTime={}, CurrentTime={}, allowed variance={}", new Object[]{dbTime, systemTime, variance});
        }
    }
}

