/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Reader;
import java.io.StringReader;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class BridgeConfigurationTest {
    @Test
    public void testFromJSON() {
        String jsonString = BridgeConfigurationTest.createFullJsonObject().toString();
        BridgeConfiguration bridgeConfiguration = BridgeConfiguration.fromJSON((String)jsonString);
        Assert.assertNotNull((Object)bridgeConfiguration);
        Assert.assertEquals((Object)"name", (Object)bridgeConfiguration.getName());
        Assert.assertEquals((Object)"queue-name", (Object)bridgeConfiguration.getQueueName());
        Assert.assertEquals((Object)"forwarding-address", (Object)bridgeConfiguration.getForwardingAddress());
        Assert.assertEquals((Object)"filter-string", (Object)bridgeConfiguration.getFilterString());
        Assert.assertArrayEquals((Object[])new String[]{"connector1", "connector2"}, (Object[])bridgeConfiguration.getStaticConnectors().toArray());
        Assert.assertEquals((Object)"dg", (Object)bridgeConfiguration.getDiscoveryGroupName());
        Assert.assertTrue((boolean)bridgeConfiguration.isHA());
        Assert.assertEquals((Object)"ClassName", (Object)bridgeConfiguration.getTransformerConfiguration().getClassName());
        Assert.assertThat(bridgeConfiguration.getTransformerConfiguration().getProperties().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"prop1", "prop2"}));
        Assert.assertEquals((Object)"val1", bridgeConfiguration.getTransformerConfiguration().getProperties().get("prop1"));
        Assert.assertEquals((Object)"val2", bridgeConfiguration.getTransformerConfiguration().getProperties().get("prop2"));
        Assert.assertEquals((long)1L, (long)bridgeConfiguration.getRetryInterval());
        Assert.assertEquals((double)2.0, (double)bridgeConfiguration.getRetryIntervalMultiplier(), (double)0.0);
        Assert.assertEquals((long)3L, (long)bridgeConfiguration.getInitialConnectAttempts());
        Assert.assertEquals((long)4L, (long)bridgeConfiguration.getReconnectAttempts());
        Assert.assertEquals((long)5L, (long)bridgeConfiguration.getReconnectAttemptsOnSameNode());
        Assert.assertTrue((boolean)bridgeConfiguration.isUseDuplicateDetection());
        Assert.assertEquals((long)6L, (long)bridgeConfiguration.getConfirmationWindowSize());
        Assert.assertEquals((long)7L, (long)bridgeConfiguration.getProducerWindowSize());
        Assert.assertEquals((long)8L, (long)bridgeConfiguration.getClientFailureCheckPeriod());
        Assert.assertEquals((Object)"user", (Object)bridgeConfiguration.getUser());
        Assert.assertEquals((Object)"password", (Object)bridgeConfiguration.getPassword());
        Assert.assertEquals((long)9L, (long)bridgeConfiguration.getConnectionTTL());
        Assert.assertEquals((long)10L, (long)bridgeConfiguration.getMaxRetryInterval());
        Assert.assertEquals((long)11L, (long)bridgeConfiguration.getMinLargeMessageSize());
        Assert.assertEquals((long)12L, (long)bridgeConfiguration.getCallTimeout());
        Assert.assertEquals((Object)ComponentConfigurationRoutingType.MULTICAST, (Object)bridgeConfiguration.getRoutingType());
        Assert.assertEquals((long)1L, (long)bridgeConfiguration.getConcurrency());
    }

    @Test
    public void testToJSON() {
        JsonObject jsonObject = BridgeConfigurationTest.createFullJsonObject();
        BridgeConfiguration bridgeConfiguration = BridgeConfiguration.fromJSON((String)jsonObject.toString());
        Assert.assertNotNull((Object)bridgeConfiguration);
        String serializedBridgeConfiguration = bridgeConfiguration.toJSON();
        JsonObject serializedBridgeConfigurationJsonObject = JsonLoader.readObject((Reader)new StringReader(serializedBridgeConfiguration));
        Assert.assertEquals((Object)jsonObject, (Object)serializedBridgeConfigurationJsonObject);
    }

    @Test
    public void testDefaultsToJson() {
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration();
        String jsonString = bridgeConfiguration.toJSON();
        JsonObject jsonObject = JsonLoader.readObject((Reader)new StringReader(jsonString));
        Assert.assertEquals((Object)"2000", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.RETRY_INTERVAL)).toString());
        Assert.assertEquals((Object)"1.0", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.RETRY_INTERVAL_MULTIPLIER)).toString());
        Assert.assertEquals((Object)"-1", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.INITIAL_CONNECT_ATTEMPTS)).toString());
        Assert.assertEquals((Object)"-1", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.RECONNECT_ATTEMPTS)).toString());
        Assert.assertEquals((Object)"10", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.RECONNECT_ATTEMPTS_ON_SAME_NODE)).toString());
        Assert.assertEquals((Object)"true", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.USE_DUPLICATE_DETECTION)).toString());
        Assert.assertEquals((Object)"10485760", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.CONFIRMATION_WINDOW_SIZE)).toString());
        Assert.assertEquals((Object)Integer.toString(ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize()), (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.PRODUCER_WINDOW_SIZE)).toString());
        Assert.assertEquals((Object)"30000", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.CLIENT_FAILURE_CHECK_PERIOD)).toString());
        Assert.assertEquals((Object)"2000", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.MAX_RETRY_INTERVAL)).toString());
        Assert.assertEquals((Object)"102400", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.MIN_LARGE_MESSAGE_SIZE)).toString());
        Assert.assertEquals((Object)"30000", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.CALL_TIMEOUT)).toString());
        Assert.assertEquals((Object)"1", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.CONCURRENCY)).toString());
        Assert.assertEquals((Object)"\"ACTIVEMQ.CLUSTER.ADMIN.USER\"", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.USER)).toString());
        Assert.assertEquals((Object)"\"CHANGE ME!!\"", (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.PASSWORD)).toString());
    }

    @Test
    public void testDefaultsFromJson() {
        String jsonString = "{\"name\": \"name\"}";
        BridgeConfiguration deserializedConfiguration = BridgeConfiguration.fromJSON((String)"{\"name\": \"name\"}");
        Assert.assertNotNull((Object)deserializedConfiguration);
        Assert.assertEquals((Object)deserializedConfiguration, (Object)new BridgeConfiguration("name"));
    }

    @Test
    public void testNullableFieldsFromJson() {
        JsonObjectBuilder builder = JsonLoader.createObjectBuilder();
        builder.add(BridgeConfiguration.NAME, "name");
        builder.addNull(BridgeConfiguration.USER);
        builder.addNull(BridgeConfiguration.PASSWORD);
        BridgeConfiguration configuration = BridgeConfiguration.fromJSON((String)builder.build().toString());
        Assert.assertNotNull((Object)configuration);
        Assert.assertEquals((Object)"name", (Object)configuration.getName());
        Assert.assertNull((Object)configuration.getUser());
        Assert.assertNull((Object)configuration.getPassword());
    }

    @Test
    public void testNullableFieldsToJson() {
        BridgeConfiguration bridgeConfiguration = new BridgeConfiguration("name");
        bridgeConfiguration.setUser(null);
        bridgeConfiguration.setPassword(null);
        String jsonString = bridgeConfiguration.toJSON();
        JsonObject jsonObject = JsonLoader.readObject((Reader)new StringReader(jsonString));
        Assert.assertEquals((Object)JsonValue.ValueType.NULL, (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.USER)).getValueType());
        Assert.assertEquals((Object)JsonValue.ValueType.NULL, (Object)((JsonValue)jsonObject.get((Object)BridgeConfiguration.PASSWORD)).getValueType());
    }

    private static JsonObject createFullJsonObject() {
        JsonObjectBuilder objectBuilder = JsonLoader.createObjectBuilder();
        objectBuilder.add(BridgeConfiguration.NAME, "name");
        objectBuilder.add(BridgeConfiguration.QUEUE_NAME, "queue-name");
        objectBuilder.add(BridgeConfiguration.FORWARDING_ADDRESS, "forwarding-address");
        objectBuilder.add(BridgeConfiguration.FILTER_STRING, "filter-string");
        objectBuilder.add(BridgeConfiguration.STATIC_CONNECTORS, JsonLoader.createArrayBuilder().add("connector1").add("connector2"));
        objectBuilder.add(BridgeConfiguration.DISCOVERY_GROUP_NAME, "dg");
        objectBuilder.add(BridgeConfiguration.HA, true);
        objectBuilder.add(BridgeConfiguration.TRANSFORMER_CONFIGURATION, JsonLoader.createObjectBuilder().add("class-name", "ClassName").add("properties", JsonLoader.createObjectBuilder().add("prop1", "val1").add("prop2", "val2")));
        objectBuilder.add(BridgeConfiguration.RETRY_INTERVAL, 1);
        objectBuilder.add(BridgeConfiguration.RETRY_INTERVAL_MULTIPLIER, 2.0);
        objectBuilder.add(BridgeConfiguration.INITIAL_CONNECT_ATTEMPTS, 3);
        objectBuilder.add(BridgeConfiguration.RECONNECT_ATTEMPTS, 4);
        objectBuilder.add(BridgeConfiguration.RECONNECT_ATTEMPTS_ON_SAME_NODE, 5);
        objectBuilder.add(BridgeConfiguration.USE_DUPLICATE_DETECTION, true);
        objectBuilder.add(BridgeConfiguration.CONFIRMATION_WINDOW_SIZE, 6);
        objectBuilder.add(BridgeConfiguration.PRODUCER_WINDOW_SIZE, 7);
        objectBuilder.add(BridgeConfiguration.CLIENT_FAILURE_CHECK_PERIOD, 8);
        objectBuilder.add(BridgeConfiguration.USER, "user");
        objectBuilder.add(BridgeConfiguration.PASSWORD, "password");
        objectBuilder.add(BridgeConfiguration.CONNECTION_TTL, 9);
        objectBuilder.add(BridgeConfiguration.MAX_RETRY_INTERVAL, 10);
        objectBuilder.add(BridgeConfiguration.MIN_LARGE_MESSAGE_SIZE, 11);
        objectBuilder.add(BridgeConfiguration.CALL_TIMEOUT, 12);
        objectBuilder.add(BridgeConfiguration.ROUTING_TYPE, "MULTICAST");
        objectBuilder.add(BridgeConfiguration.CONCURRENCY, 1);
        objectBuilder.add(BridgeConfiguration.CONFIGURATION_MANAGED, true);
        return objectBuilder.build();
    }
}

