/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.federation.FederationAddressPolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationPolicySet;
import org.apache.activemq.artemis.core.config.federation.FederationQueuePolicyConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationTransformerConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.commons.lang3.ClassUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImplTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Configuration conf;

    @Test
    public void testDefaults() {
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultSecurityEnabled(), (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultBindingsDirectory(), (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir(), (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultJournalDir(), (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateJournalDir(), (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)ConfigurationImpl.DEFAULT_JOURNAL_TYPE, (Object)this.conf.getJournalType());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional(), (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalFileSize(), (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMinFiles(), (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio(), (long)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio(), (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterUser(), (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)this.conf.getClusterPassword());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistenceEnabled(), (Object)this.conf.isPersistenceEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistDeliveryCountBeforeDelivery(), (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultFileDeployerScanPeriod(), (long)this.conf.getFileDeployerScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJmxManagementEnabled(), (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultAsyncConnectionExecutionEnabled(), (Object)this.conf.isAsyncConnectionExecutionEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPagingDir(), (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultLargeMessagesDir(), (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage(), (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalLockAcquisitionTimeout(), (long)this.conf.getJournalLockAcquisitionTimeout());
        Assert.assertEquals((long)500000L, (long)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((long)3333333L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalLogWriteRate(), (Object)this.conf.isLogJournalWriteRate());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultMessageCounterEnabled(), (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageCounterMaxDayHistory(), (long)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageCounterSamplePeriod(), (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultIdCacheSize(), (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistIdCache(), (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultServerDumpInterval(), (long)this.conf.getServerDumpInterval());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMemoryWarningThreshold(), (long)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMemoryMeasureInterval(), (long)this.conf.getMemoryMeasureInterval());
        Assert.assertEquals((Object)this.conf.getJournalLocation(), (Object)this.conf.getNodeManagerLockLocation());
        Assert.assertNull((Object)this.conf.getJournalDeviceBlockSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultReadWholePage(), (Object)this.conf.isReadWholePage());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio(), (long)this.conf.getPageSyncTimeout());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultTemporaryQueueNamespace(), (Object)this.conf.getTemporaryQueueNamespace());
    }

    @Test
    public void testNullMaskPassword() {
        ConfigurationImpl impl = new ConfigurationImpl();
        impl.setMaskPassword(null);
        Assert.assertEquals((long)impl.hashCode(), (long)impl.hashCode());
    }

    @Test
    public void testSetGetAttributes() throws Exception {
        for (int j = 0; j < 100; ++j) {
            int i = RandomUtil.randomInt();
            this.conf.setScheduledThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
            long l = RandomUtil.randomLong();
            this.conf.setSecurityInvalidationInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
            boolean b = RandomUtil.randomBoolean();
            this.conf.setSecurityEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
            String s = RandomUtil.randomString();
            this.conf.setBindingsDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateBindingsDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
            s = RandomUtil.randomString();
            this.conf.setJournalDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
            b = RandomUtil.randomBoolean();
            this.conf.setCreateJournalDir(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
            i = RandomUtil.randomInt() % 2;
            JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
            this.conf.setJournalType(journal);
            Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
            b = RandomUtil.randomBoolean();
            this.conf.setJournalSyncNonTransactional(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
            i = RandomUtil.randomInt();
            this.conf.setJournalFileSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
            i = RandomUtil.randomInt();
            this.conf.setJournalMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalMaxIO_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
            s = RandomUtil.randomString();
            this.conf.setManagementAddress(new SimpleString(s));
            Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
            l = RandomUtil.randomLong();
            this.conf.setMessageExpiryScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistDeliveryCountBeforeDelivery(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
            b = RandomUtil.randomBoolean();
            this.conf.setEnabledAsyncConnectionExecution(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistenceEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
            b = RandomUtil.randomBoolean();
            this.conf.setJMXManagementEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
            l = RandomUtil.randomLong();
            this.conf.setFileDeployerScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
            l = RandomUtil.randomLong();
            this.conf.setConnectionTTLOverride(l);
            Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
            i = RandomUtil.randomInt();
            this.conf.setThreadPoolMaxSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
            SimpleString ss = RandomUtil.randomSimpleString();
            this.conf.setManagementNotificationAddress(ss);
            Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
            s = RandomUtil.randomString();
            this.conf.setClusterUser(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
            i = RandomUtil.randomInt();
            this.conf.setIDCacheSize(i);
            Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
            b = RandomUtil.randomBoolean();
            this.conf.setPersistIDCache(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactMinFiles(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
            i = RandomUtil.randomInt();
            this.conf.setJournalCompactPercentage(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
            l = RandomUtil.randomLong();
            this.conf.setJournalLockAcquisitionTimeout(l);
            Assert.assertEquals((long)l, (long)this.conf.getJournalLockAcquisitionTimeout());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_AIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferSize_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
            i = RandomUtil.randomInt();
            this.conf.setJournalBufferTimeout_NIO(i);
            Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
            b = RandomUtil.randomBoolean();
            this.conf.setLogJournalWriteRate(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
            l = RandomUtil.randomLong();
            this.conf.setServerDumpInterval(l);
            Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
            s = RandomUtil.randomString();
            this.conf.setPagingDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
            s = RandomUtil.randomString();
            this.conf.setLargeMessagesDirectory(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeout(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
            b = RandomUtil.randomBoolean();
            this.conf.setMessageCounterEnabled(b);
            Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
            l = RandomUtil.randomPositiveLong();
            this.conf.setMessageCounterSamplePeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
            i = RandomUtil.randomInt();
            this.conf.setMessageCounterMaxDayHistory(i);
            Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
            l = RandomUtil.randomLong();
            this.conf.setTransactionTimeoutScanPeriod(l);
            Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
            s = RandomUtil.randomString();
            this.conf.setClusterPassword(s);
            Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
            i = RandomUtil.randomInt();
            this.conf.setPageSyncTimeout(i);
            Assert.assertEquals((long)i, (long)this.conf.getPageSyncTimeout());
        }
    }

    @Test
    public void testGetSetInterceptors() {
        String name1 = "uqwyuqywuy";
        String name2 = "yugyugyguyg";
        this.conf.getIncomingInterceptorClassNames().add("uqwyuqywuy");
        this.conf.getIncomingInterceptorClassNames().add("yugyugyguyg");
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("uqwyuqywuy"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("yugyugyguyg"));
        Assert.assertFalse((boolean)this.conf.getIncomingInterceptorClassNames().contains("iijij"));
    }

    @Test
    public void testSerialize() throws Exception {
        boolean b = RandomUtil.randomBoolean();
        this.conf.setHAPolicyConfiguration((HAPolicyConfiguration)new LiveOnlyPolicyConfiguration());
        int i = RandomUtil.randomInt();
        this.conf.setScheduledThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getScheduledThreadPoolMaxSize());
        long l = RandomUtil.randomLong();
        this.conf.setSecurityInvalidationInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getSecurityInvalidationInterval());
        b = RandomUtil.randomBoolean();
        this.conf.setSecurityEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isSecurityEnabled());
        String s = RandomUtil.randomString();
        this.conf.setBindingsDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getBindingsDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateBindingsDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateBindingsDir());
        s = RandomUtil.randomString();
        this.conf.setJournalDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getJournalDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setCreateJournalDir(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isCreateJournalDir());
        i = RandomUtil.randomInt() % 2;
        JournalType journal = i == 0 ? JournalType.ASYNCIO : JournalType.NIO;
        this.conf.setJournalType(journal);
        Assert.assertEquals((Object)journal, (Object)this.conf.getJournalType());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncTransactional());
        b = RandomUtil.randomBoolean();
        this.conf.setJournalSyncNonTransactional(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJournalSyncNonTransactional());
        i = RandomUtil.randomInt();
        this.conf.setJournalFileSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalFileSize());
        i = RandomUtil.randomInt();
        this.conf.setJournalMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalMaxIO_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalMaxIO_NIO());
        s = RandomUtil.randomString();
        this.conf.setManagementAddress(new SimpleString(s));
        Assert.assertEquals((Object)s, (Object)this.conf.getManagementAddress().toString());
        l = RandomUtil.randomLong();
        this.conf.setMessageExpiryScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageExpiryScanPeriod());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistDeliveryCountBeforeDelivery(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        b = RandomUtil.randomBoolean();
        this.conf.setEnabledAsyncConnectionExecution(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isAsyncConnectionExecutionEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistenceEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistenceEnabled());
        b = RandomUtil.randomBoolean();
        this.conf.setJMXManagementEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isJMXManagementEnabled());
        l = RandomUtil.randomLong();
        this.conf.setFileDeployerScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getFileDeployerScanPeriod());
        l = RandomUtil.randomLong();
        this.conf.setConnectionTTLOverride(l);
        Assert.assertEquals((long)l, (long)this.conf.getConnectionTTLOverride());
        i = RandomUtil.randomInt();
        this.conf.setThreadPoolMaxSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getThreadPoolMaxSize());
        SimpleString ss = RandomUtil.randomSimpleString();
        this.conf.setManagementNotificationAddress(ss);
        Assert.assertEquals((Object)ss, (Object)this.conf.getManagementNotificationAddress());
        s = RandomUtil.randomString();
        this.conf.setClusterUser(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterUser());
        i = RandomUtil.randomInt();
        this.conf.setIDCacheSize(i);
        Assert.assertEquals((long)i, (long)this.conf.getIDCacheSize());
        b = RandomUtil.randomBoolean();
        this.conf.setPersistIDCache(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isPersistIDCache());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactMinFiles(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactMinFiles());
        i = RandomUtil.randomInt();
        this.conf.setJournalCompactPercentage(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalCompactPercentage());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_AIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_AIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferSize_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferSize_NIO());
        i = RandomUtil.randomInt();
        this.conf.setJournalBufferTimeout_NIO(i);
        Assert.assertEquals((long)i, (long)this.conf.getJournalBufferTimeout_NIO());
        b = RandomUtil.randomBoolean();
        this.conf.setLogJournalWriteRate(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isLogJournalWriteRate());
        l = RandomUtil.randomLong();
        this.conf.setServerDumpInterval(l);
        Assert.assertEquals((long)l, (long)this.conf.getServerDumpInterval());
        s = RandomUtil.randomString();
        this.conf.setPagingDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getPagingDirectory());
        s = RandomUtil.randomString();
        this.conf.setLargeMessagesDirectory(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getLargeMessagesDirectory());
        b = RandomUtil.randomBoolean();
        this.conf.setWildcardRoutingEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isWildcardRoutingEnabled());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeout(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeout());
        b = RandomUtil.randomBoolean();
        this.conf.setMessageCounterEnabled(b);
        Assert.assertEquals((Object)b, (Object)this.conf.isMessageCounterEnabled());
        l = RandomUtil.randomPositiveLong();
        this.conf.setMessageCounterSamplePeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getMessageCounterSamplePeriod());
        i = RandomUtil.randomInt();
        this.conf.setMessageCounterMaxDayHistory(i);
        Assert.assertEquals((long)i, (long)this.conf.getMessageCounterMaxDayHistory());
        l = RandomUtil.randomLong();
        this.conf.setTransactionTimeoutScanPeriod(l);
        Assert.assertEquals((long)l, (long)this.conf.getTransactionTimeoutScanPeriod());
        s = RandomUtil.randomString();
        this.conf.setClusterPassword(s);
        Assert.assertEquals((Object)s, (Object)this.conf.getClusterPassword());
        i = RandomUtil.randomInt();
        this.conf.setPageSyncTimeout(i);
        Assert.assertEquals((long)i, (long)this.conf.getPageSyncTimeout());
        this.conf.registerBrokerPlugin((ActiveMQServerBasePlugin)new LoggingActiveMQServerPlugin());
        Assert.assertEquals((String)"ensure one plugin registered", (long)1L, (long)this.conf.getBrokerPlugins().size());
        Configuration conf2 = this.conf.copy();
        Assert.assertTrue((boolean)this.conf.equals(conf2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolvePath() throws Throwable {
        String oldProperty = System.getProperty("artemis.instance");
        try {
            System.setProperty("artemis.instance", "/tmp/" + RandomUtil.randomString());
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setJournalDirectory("./data-journal");
            File journalLocation = configuration.getJournalLocation();
            Assert.assertFalse((String)"This path shouldn't resolve to a real folder", (boolean)journalLocation.exists());
            Assert.assertEquals((Object)configuration.getJournalLocation(), (Object)configuration.getNodeManagerLockLocation());
            Assert.assertFalse((boolean)configuration.getNodeManagerLockLocation().exists());
            configuration.setNodeManagerLockDirectory("./lock-folder");
            Assert.assertNotEquals((Object)configuration.getJournalLocation(), (Object)configuration.getNodeManagerLockLocation());
            Assert.assertFalse((String)"This path shouldn't resolve to a real folder", (boolean)configuration.getNodeManagerLockLocation().exists());
        }
        finally {
            if (oldProperty == null) {
                System.clearProperty("artemis.instance");
            } else {
                System.setProperty("artemis.instance", oldProperty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsolutePath() throws Throwable {
        String oldProperty = System.getProperty("artemis.instance");
        String oldEtc = System.getProperty("artemis.instance.etc");
        File tempFolder = null;
        try {
            System.setProperty("artemis.instance", "/tmp/" + RandomUtil.randomString());
            tempFolder = File.createTempFile("journal-folder", "", this.temporaryFolder.getRoot());
            tempFolder.delete();
            tempFolder = new File(tempFolder.getAbsolutePath());
            tempFolder.mkdirs();
            logger.debug("TempFolder = {}", (Object)tempFolder.getAbsolutePath());
            ConfigurationImpl configuration = new ConfigurationImpl();
            configuration.setJournalDirectory(tempFolder.getAbsolutePath());
            File journalLocation = configuration.getJournalLocation();
            Assert.assertTrue((boolean)journalLocation.exists());
            Assert.assertEquals((Object)configuration.getJournalLocation(), (Object)configuration.getNodeManagerLockLocation());
            Assert.assertTrue((boolean)configuration.getNodeManagerLockLocation().exists());
            tempFolder = File.createTempFile("lock-folder", "", this.temporaryFolder.getRoot());
            tempFolder.delete();
            tempFolder.getAbsolutePath();
            tempFolder = new File(tempFolder.getAbsolutePath());
            tempFolder.mkdirs();
            logger.debug("TempFolder = {}", (Object)tempFolder.getAbsolutePath());
            configuration.setNodeManagerLockDirectory(tempFolder.getAbsolutePath());
            File lockLocation = configuration.getNodeManagerLockLocation();
            Assert.assertTrue((boolean)lockLocation.exists());
        }
        finally {
            if (oldProperty == null) {
                System.clearProperty("artemis.instance");
                System.clearProperty("artemis.instance.etc");
            } else {
                System.setProperty("artemis.instance", oldProperty);
                System.setProperty("artemis.instance.etc", oldEtc);
            }
            if (tempFolder != null) {
                tempFolder.delete();
            }
        }
    }

    @Test
    public void testRootPrimitives() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        Method[] declaredMethods = Configuration.class.getDeclaredMethods();
        HashMap props = new HashMap();
        int nextInt = 1;
        long nextLong = 1L;
        for (Method declaredMethod : declaredMethods) {
            if (!declaredMethod.getName().startsWith("set") || declaredMethod.getAnnotation(Deprecated.class) != null || declaredMethod.getParameterCount() != 1 || !ClassUtils.isPrimitiveOrWrapper(declaredMethod.getParameters()[0].getType()) && !declaredMethod.getParameters()[0].getType().equals(String.class)) continue;
            Object prop = declaredMethod.getName().substring(3);
            prop = Character.toLowerCase(((String)prop).charAt(0)) + (((String)prop).length() > 1 ? ((String)prop).substring(1) : "");
            Class<?> type = declaredMethod.getParameters()[0].getType();
            if (type.equals(Boolean.class)) {
                properties.put(prop, Boolean.TRUE);
                continue;
            }
            if (type.equals(Boolean.TYPE)) {
                properties.put(prop, (Object)true);
                continue;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                properties.put(prop, (Object)nextLong++);
                continue;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                properties.put(prop, (Object)nextInt++);
                continue;
            }
            if (!type.equals(String.class)) continue;
            byte[] array = new byte[7];
            new Random().nextBytes(array);
            String generatedString = new String(array, StandardCharsets.UTF_8);
            properties.put(prop, generatedString);
        }
        properties.remove("status");
        configuration.parsePrefixedProperties(properties, null);
        for (Map.Entry entry : properties.entrySet()) {
            Method declaredMethod;
            Object methodName = entry.getKey().toString();
            methodName = Character.toUpperCase(((String)methodName).charAt(0)) + (((String)methodName).length() > 1 ? ((String)methodName).substring(1) : "");
            methodName = entry.getValue().getClass() == Boolean.class || entry.getValue().getClass() == Boolean.TYPE ? "is" + (String)methodName : "get" + (String)methodName;
            declaredMethod = ConfigurationImpl.class.getDeclaredMethod((String)methodName, new Class[0]);
            Object value = declaredMethod.invoke((Object)configuration, new Object[0]);
            Assert.assertEquals((Object)value, (Object)properties.get(entry.getKey()));
        }
    }

    @Test
    public void testSetSystemProperty() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put(configuration.getSystemPropertyPrefix() + "fileDeployerScanPeriod", "1234");
        properties.put(configuration.getSystemPropertyPrefix() + "globalMaxSize", "4321");
        configuration.parsePrefixedProperties(properties, configuration.getSystemPropertyPrefix());
        Assert.assertEquals((long)1234L, (long)configuration.getFileDeployerScanPeriod());
        Assert.assertEquals((long)4321L, (long)configuration.getGlobalMaxSize());
    }

    @Test
    public void testSetConnectionRoutersPolicyConfiguration() throws Throwable {
        this.testSetConnectionRoutersPolicyConfiguration(new ConfigurationImpl());
    }

    @Test
    public void testSetConnectionRoutersPolicyFileConfiguration() throws Throwable {
        this.testSetConnectionRoutersPolicyConfiguration((ConfigurationImpl)new FileConfiguration());
    }

    private void testSetConnectionRoutersPolicyConfiguration(ConfigurationImpl configuration) throws Throwable {
        ConfigurationImpl.InsertionOrderedProperties insertionOrderedProperties = new ConfigurationImpl.InsertionOrderedProperties();
        insertionOrderedProperties.put("connectionRouters.autoShard.localTargetFilter", "NULL|$STATEFUL_SET_ORDINAL");
        insertionOrderedProperties.put("connectionRouters.autoShard.keyType", KeyType.CLIENT_ID);
        insertionOrderedProperties.put("connectionRouters.autoShard.policyConfiguration", "CONSISTENT_HASH_MODULO");
        insertionOrderedProperties.put("connectionRouters.autoShard.policyConfiguration.properties.MODULO", (Object)2);
        configuration.parsePrefixedProperties((Properties)insertionOrderedProperties, null);
        Assert.assertEquals((long)1L, (long)configuration.getConnectionRouters().size());
        Assert.assertEquals((Object)KeyType.CLIENT_ID, (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getKeyType());
        Assert.assertEquals((Object)"2", ((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getPolicyConfiguration().getProperties().get("MODULO"));
    }

    @Test
    public void testAMQPConnectionsConfiguration() throws Throwable {
        this.testAMQPConnectionsConfiguration(true);
        this.testAMQPConnectionsConfiguration(false);
    }

    private void testAMQPConnectionsConfiguration(boolean sync) throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        ConfigurationImpl.InsertionOrderedProperties insertionOrderedProperties = new ConfigurationImpl.InsertionOrderedProperties();
        insertionOrderedProperties.put("AMQPConnections.target.uri", "localhost:61617");
        insertionOrderedProperties.put("AMQPConnections.target.retryInterval", (Object)55);
        insertionOrderedProperties.put("AMQPConnections.target.reconnectAttempts", (Object)-2);
        insertionOrderedProperties.put("AMQPConnections.target.user", "admin");
        insertionOrderedProperties.put("AMQPConnections.target.password", "password");
        insertionOrderedProperties.put("AMQPConnections.target.autostart", "false");
        insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.type", "MIRROR");
        insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.messageAcknowledgements", "true");
        insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.queueCreation", "true");
        insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.queueRemoval", "true");
        insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.addressFilter", "foo");
        if (sync) {
            insertionOrderedProperties.put("AMQPConnections.target.connectionElements.mirror.sync", "true");
        }
        configuration.parsePrefixedProperties((Properties)insertionOrderedProperties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAMQPConnections().size());
        AMQPBrokerConnectConfiguration connectConfiguration = (AMQPBrokerConnectConfiguration)configuration.getAMQPConnections().get(0);
        Assert.assertEquals((Object)"target", (Object)connectConfiguration.getName());
        Assert.assertEquals((Object)"localhost:61617", (Object)connectConfiguration.getUri());
        Assert.assertEquals((long)55L, (long)connectConfiguration.getRetryInterval());
        Assert.assertEquals((long)-2L, (long)connectConfiguration.getReconnectAttempts());
        Assert.assertEquals((Object)"admin", (Object)connectConfiguration.getUser());
        Assert.assertEquals((Object)"password", (Object)connectConfiguration.getPassword());
        Assert.assertEquals((Object)false, (Object)connectConfiguration.isAutostart());
        Assert.assertEquals((long)1L, (long)connectConfiguration.getConnectionElements().size());
        AMQPBrokerConnectionElement amqpBrokerConnectionElement = (AMQPBrokerConnectionElement)connectConfiguration.getConnectionElements().get(0);
        Assert.assertTrue((boolean)(amqpBrokerConnectionElement instanceof AMQPMirrorBrokerConnectionElement));
        AMQPMirrorBrokerConnectionElement amqpMirrorBrokerConnectionElement = (AMQPMirrorBrokerConnectionElement)amqpBrokerConnectionElement;
        Assert.assertEquals((Object)"mirror", (Object)amqpMirrorBrokerConnectionElement.getName());
        Assert.assertEquals((Object)true, (Object)amqpMirrorBrokerConnectionElement.isMessageAcknowledgements());
        Assert.assertEquals((Object)true, (Object)amqpMirrorBrokerConnectionElement.isQueueCreation());
        Assert.assertEquals((Object)true, (Object)amqpMirrorBrokerConnectionElement.isQueueRemoval());
        Assert.assertEquals((Object)sync, (Object)((AMQPMirrorBrokerConnectionElement)amqpBrokerConnectionElement).isSync());
        Assert.assertEquals((Object)"foo", (Object)amqpMirrorBrokerConnectionElement.getAddressFilter());
    }

    @Test
    public void testAMQPConnectionsConfigurationUriEnc() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        ConfigurationImpl.InsertionOrderedProperties insertionOrderedProperties = new ConfigurationImpl.InsertionOrderedProperties();
        insertionOrderedProperties.put("AMQPConnections.target.uri", "tcp://amq-dc1-tls-amqp-${STATEFUL_SET_ORDINAL}-svc.dc1.svc.cluster.local:5673?clientFailureCheckPeriod=30000&connectionTTL=60000&sslEnabled=true&verifyHost=false&trustStorePath=/remote-cluster-truststore/client.ts");
        insertionOrderedProperties.put("AMQPConnections.target.transportConfigurations.target.params.trustStorePassword", "ENC(2a7c211d21c295cdbcde3589c205decb)");
        configuration.parsePrefixedProperties((Properties)insertionOrderedProperties, null);
        AMQPBrokerConnectConfiguration connectConfiguration = (AMQPBrokerConnectConfiguration)configuration.getAMQPConnections().get(0);
        Assert.assertFalse((boolean)((TransportConfiguration)connectConfiguration.getTransportConfigurations().get(0)).getParams().get("trustStorePassword").toString().contains("ENC"));
    }

    @Test
    public void testCoreBridgeConfiguration() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        String queueName = "q";
        String forwardingAddress = "fa";
        ConfigurationImpl.InsertionOrderedProperties properties = new ConfigurationImpl.InsertionOrderedProperties();
        properties.put("bridgeConfigurations.b1.queueName", "q");
        properties.put("bridgeConfigurations.b1.forwardingAddress", "fa");
        properties.put("bridgeConfigurations.b1.confirmationWindowSize", "10");
        properties.put("bridgeConfigurations.b1.routingType", "STRIP");
        properties.put("bridgeConfigurations.b1.staticConnectors", "a,b");
        properties.put("bridgeConfigurations.b1.staticConnectors[1]", "c");
        configuration.parsePrefixedProperties((Properties)properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getBridgeConfigurations().size());
        Assert.assertEquals((Object)"q", (Object)((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getQueueName());
        Assert.assertEquals((Object)"fa", (Object)((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getForwardingAddress());
        Assert.assertEquals((long)10L, (long)((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getConfirmationWindowSize());
        Assert.assertEquals((long)2L, (long)((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getStaticConnectors().size());
        Assert.assertEquals((Object)"a", ((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getStaticConnectors().get(0));
        Assert.assertEquals((Object)"c", ((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getStaticConnectors().get(1));
        Assert.assertEquals((Object)ComponentConfigurationRoutingType.STRIP, (Object)((BridgeConfiguration)configuration.getBridgeConfigurations().get(0)).getRoutingType());
    }

    @Test
    public void testFederationUpstreamConfiguration() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        ConfigurationImpl.InsertionOrderedProperties properties = new ConfigurationImpl.InsertionOrderedProperties();
        properties.put("federationConfigurations.f1.upstreamConfigurations.joe.connectionConfiguration.reconnectAttempts", "1");
        properties.put("federationConfigurations.f1.upstreamConfigurations.joe.connectionConfiguration.staticConnectors", "a,b,c");
        properties.put("federationConfigurations.f1.upstreamConfigurations.joe.policyRefs", "pq1,pq2");
        properties.put("federationConfigurations.f1.queuePolicies.qp1.transformerRef", "simpleTransform");
        properties.put("federationConfigurations.f1.queuePolicies.qp2.includes.all-N.queueMatch", "N#");
        properties.put("federationConfigurations.f1.addressPolicies.a1.transformerRef", "simpleTransform");
        properties.put("federationConfigurations.f1.addressPolicies.a1.excludes.just-b.addressMatch", "b");
        properties.put("federationConfigurations.f1.policySets.combined.policyRefs", "qp1,qp2,a1");
        properties.put("federationConfigurations.f1.transformerConfigurations.simpleTransform.transformerConfiguration.className", "a.b");
        properties.put("federationConfigurations.f1.transformerConfigurations.simpleTransform.transformerConfiguration.properties.a", "b");
        properties.put("federationConfigurations.f1.credentials.user", "u");
        properties.put("federationConfigurations.f1.credentials.password", "ENC(2a7c211d21c295cdbcde3589c205decb)");
        configuration.parsePrefixedProperties((Properties)properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getFederationConfigurations().size());
        Assert.assertEquals((long)1L, (long)((FederationUpstreamConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getUpstreamConfigurations().get(0)).getConnectionConfiguration().getReconnectAttempts());
        Assert.assertEquals((long)3L, (long)((FederationUpstreamConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getUpstreamConfigurations().get(0)).getConnectionConfiguration().getStaticConnectors().size());
        Assert.assertEquals((long)2L, (long)((FederationUpstreamConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getUpstreamConfigurations().get(0)).getPolicyRefs().size());
        Assert.assertEquals((long)4L, (long)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().size());
        Assert.assertEquals((Object)"qp1", (Object)((FederationPolicy)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("qp1")).getName());
        Assert.assertEquals((Object)"combined", (Object)((FederationPolicy)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("combined")).getName());
        Assert.assertEquals((long)3L, (long)((FederationPolicySet)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("combined")).getPolicyRefs().size());
        Assert.assertEquals((Object)"simpleTransform", (Object)((FederationQueuePolicyConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("qp1")).getTransformerRef());
        Assert.assertEquals((Object)"N#", (Object)((FederationQueuePolicyConfiguration.Matcher)((FederationQueuePolicyConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("qp2")).getIncludes().toArray()[0]).getQueueMatch());
        Assert.assertEquals((Object)"b", (Object)((FederationAddressPolicyConfiguration.Matcher)((FederationAddressPolicyConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getFederationPolicyMap().get("a1")).getExcludes().toArray()[0]).getAddressMatch());
        Assert.assertEquals((Object)"b", ((FederationTransformerConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getTransformerConfigurations().get("simpleTransform")).getTransformerConfiguration().getProperties().get("a"));
        Assert.assertEquals((Object)"a.b", (Object)((FederationTransformerConfiguration)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getTransformerConfigurations().get("simpleTransform")).getTransformerConfiguration().getClassName());
        Assert.assertEquals((Object)"u", (Object)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getCredentials().getUser());
        Assert.assertEquals((Object)"secureexample", (Object)((FederationConfiguration)configuration.getFederationConfigurations().get(0)).getCredentials().getPassword());
    }

    @Test
    public void testSetNestedPropertyOnCollections() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("connectionRouters.joe.localTargetFilter", "LF");
        properties.put("connectionRouters.joe.keyFilter", "TF");
        properties.put("connectionRouters.joe.keyType", "SOURCE_IP");
        properties.put("acceptorConfigurations.tcp.params.HOST", "LOCALHOST");
        properties.put("acceptorConfigurations.tcp.params.PORT", "61616");
        properties.put("acceptorConfigurations.invm.params.ID", "0");
        properties.put("AMQPConnections.other-server.uri", "tcp://HOST:PORT");
        properties.put("AMQPConnections.other-server.retryInterval", "100");
        properties.put("AMQPConnections.other-server.reconnectAttempts", "100");
        properties.put("AMQPConnections.other-server.user", "john");
        properties.put("AMQPConnections.other-server.password", "doe");
        properties.put("AMQPConnections.brokerB.uri", "tcp://brokerB:5672");
        properties.put("AMQPConnections.brokerB.type", AMQPBrokerConnectionAddressType.MIRROR.toString());
        properties.put("AMQPConnections.brokerB.connectionElements.mirror.mirrorSNF", "mirrorSNFQueue");
        properties.put("resourceLimitSettings.joe.maxConnections", "100");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getConnectionRouters().size());
        Assert.assertEquals((Object)"LF", (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getLocalTargetFilter());
        Assert.assertEquals((Object)"TF", (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getKeyFilter());
        Assert.assertEquals((Object)KeyType.SOURCE_IP, (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getKeyType());
        Assert.assertEquals((long)2L, (long)configuration.getAcceptorConfigurations().size());
        for (TransportConfiguration acceptor : configuration.getAcceptorConfigurations()) {
            if ("tcp".equals(acceptor.getName())) {
                Assert.assertEquals((Object)"61616", acceptor.getParams().get("PORT"));
            }
            if (!"invm".equals(acceptor.getName())) continue;
            Assert.assertEquals((Object)"0", acceptor.getParams().get("ID"));
        }
        Assert.assertEquals((long)2L, (long)configuration.getAMQPConnection().size());
        for (AMQPBrokerConnectConfiguration amqpBrokerConnectConfiguration : configuration.getAMQPConnection()) {
            if ("brokerB".equals(amqpBrokerConnectConfiguration.getName())) {
                Assert.assertEquals((Object)AMQPBrokerConnectionAddressType.MIRROR.toString(), (Object)((AMQPBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(0)).getType().toString());
                Assert.assertEquals((Object)"mirrorSNFQueue", (Object)((AMQPMirrorBrokerConnectionElement)amqpBrokerConnectConfiguration.getConnectionElements().get(0)).getMirrorSNF().toString());
                continue;
            }
            if ("other-server".equals(amqpBrokerConnectConfiguration.getName())) {
                Assert.assertEquals((long)100L, (long)amqpBrokerConnectConfiguration.getReconnectAttempts());
                continue;
            }
            ConfigurationImplTest.fail((String)("unexpected amqp broker connection configuration: " + amqpBrokerConnectConfiguration.getName()));
        }
        Assert.assertEquals((long)100L, (long)((ResourceLimitSettings)configuration.getResourceLimitSettings().get("joe")).getMaxConnections());
    }

    @Test
    public void testSetNestedPropertyOnExistingCollectionEntryViaMappedNotation() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("connectionRouters.joe.localTargetFilter", "LF");
        properties.put("connectionRouters(bob).keyFilter", "TF");
        configuration.parsePrefixedProperties(properties, null);
        properties = new Properties();
        properties.put("connectionRouters(joe).keyFilter", "TF");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getConnectionRouters().size());
        Assert.assertEquals((Object)"LF", (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getLocalTargetFilter());
        Assert.assertEquals((Object)"TF", (Object)((ConnectionRouterConfiguration)configuration.getConnectionRouters().get(0)).getKeyFilter());
    }

    @Test
    public void testAddressViaProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("addressConfigurations.\"LB.TEST\".queueConfigs.\"LB.TEST\".routingType", "ANYCAST");
        properties.put("addressConfigurations.\"LB.TEST\".queueConfigs.\"LB.TEST\".durable", "false");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressConfigurations().size());
        Assert.assertEquals((long)1L, (long)((CoreAddressConfiguration)configuration.getAddressConfigurations().get(0)).getQueueConfigs().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"LB.TEST"), (Object)((QueueConfiguration)((CoreAddressConfiguration)configuration.getAddressConfigurations().get(0)).getQueueConfigs().get(0)).getAddress());
        Assert.assertEquals((Object)false, (Object)((QueueConfiguration)((CoreAddressConfiguration)configuration.getAddressConfigurations().get(0)).getQueueConfigs().get(0)).isDurable());
    }

    @Test
    public void testAddressRemovalViaProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("addressConfigurations.\"LB.TEST\".queueConfigs.\"LB.TEST\".routingType", "ANYCAST");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressConfigurations().size());
        Assert.assertEquals((long)1L, (long)((CoreAddressConfiguration)configuration.getAddressConfigurations().get(0)).getQueueConfigs().size());
        Assert.assertTrue((boolean)configuration.getStatus().contains("\"errors\":[]"));
        properties.clear();
        properties.put("addressConfigurations.\"LB.TEST\"", "-");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)0L, (long)configuration.getAddressConfigurations().size());
        Assert.assertTrue((boolean)configuration.getStatus().contains("\"errors\":[]"));
    }

    @Test
    public void testRoleRemovalViaCustomRemoveProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("securityRoles.TEST.users.send", "true");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getSecurityRoles().size());
        Assert.assertTrue((boolean)configuration.getStatus().contains("\"errors\":[]"));
        properties.clear();
        properties.put("remove.value", "^");
        properties.put("securityRoles.TEST", "^");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)0L, (long)configuration.getSecurityRoles().size());
        Assert.assertTrue((boolean)configuration.getStatus().contains("\"errors\":[]"));
    }

    @Test
    public void testIDCacheSizeViaProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Assert.assertTrue((boolean)configuration.isPersistIDCache());
        Properties properties = new Properties();
        properties.put("iDCacheSize", "50");
        properties.put("persistIDCache", (Object)false);
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)50L, (long)configuration.getIDCacheSize());
        Assert.assertFalse((boolean)configuration.isPersistIDCache());
    }

    @Test
    public void testAcceptorViaProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.getAcceptorConfigurations().add((TransportConfiguration)ConfigurationUtils.parseAcceptorURI((String)"artemis", (String)"tcp://0.0.0.0:61616?protocols=CORE,AMQP,STOMP,HORNETQ,MQTT,OPENWIRE;supportAdvisory=false;suppressInternalManagementObjects=false").get(0));
        Properties properties = new Properties();
        properties.put("acceptorConfigurations.artemis.extraParams.supportAdvisory", "true");
        properties.put("acceptorConfigurations.new.extraParams.supportAdvisory", "true");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)2L, (long)configuration.getAcceptorConfigurations().size());
        TransportConfiguration artemisTransportConfiguration = configuration.getAcceptorConfigurations().stream().filter(transportConfiguration -> transportConfiguration.getName().equals("artemis")).findFirst().get();
        Assert.assertTrue((boolean)artemisTransportConfiguration.getParams().containsKey("protocols"));
        Assert.assertEquals((Object)"CORE,AMQP,STOMP,HORNETQ,MQTT,OPENWIRE", artemisTransportConfiguration.getParams().get("protocols"));
        Assert.assertTrue((boolean)artemisTransportConfiguration.getExtraParams().containsKey("supportAdvisory"));
        Assert.assertEquals((Object)"true", artemisTransportConfiguration.getExtraParams().get("supportAdvisory"));
        Assert.assertTrue((boolean)artemisTransportConfiguration.getExtraParams().containsKey("suppressInternalManagementObjects"));
        Assert.assertEquals((Object)"false", artemisTransportConfiguration.getExtraParams().get("suppressInternalManagementObjects"));
        TransportConfiguration newTransportConfiguration = configuration.getAcceptorConfigurations().stream().filter(transportConfiguration -> transportConfiguration.getName().equals("new")).findFirst().get();
        Assert.assertTrue((boolean)newTransportConfiguration.getExtraParams().containsKey("supportAdvisory"));
        Assert.assertEquals((Object)"true", newTransportConfiguration.getExtraParams().get("supportAdvisory"));
    }

    @Test
    public void testAddressSettingsViaProperties() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("addressesSettings.#.expiryAddress", "sharedExpiry");
        properties.put("addressSettings.NeedToTrackExpired.expiryAddress", "important");
        properties.put("addressSettings.\"Name.With.Dots\".expiryAddress", "moreImportant");
        properties.put("addressSettings.NeedToSet.autoCreateExpiryResources", "true");
        properties.put("addressSettings.NeedToSet.deadLetterAddress", "iamDeadLetterAdd");
        properties.put("addressSettings.NeedToSet.expiryQueuePrefix", "add1Expiry");
        properties.put("addressSettings.NeedToSet.maxReadPageBytes", (Object)20000000);
        properties.put("addressSettings.NeedToSet.deadLetterQueuePrefix", "iamDeadLetterQueuePre");
        properties.put("addressSettings.NeedToSet.managementMessageAttributeSizeLimit", (Object)512);
        properties.put("addressSettings.NeedToSet.pageSizeBytes", (Object)12345);
        properties.put("addressSettings.NeedToSet.expiryQueueSuffix", "add1ExpirySuffix");
        properties.put("addressSettings.NeedToSet.expiryDelay", (Object)44);
        properties.put("addressSettings.NeedToSet.minExpiryDelay", (Object)5);
        properties.put("addressSettings.NeedToSet.maxExpiryDelay", (Object)10);
        properties.put("addressSettings.NeedToSet.enableIngressTimestamp", "true");
        properties.put("addressSettings.NeedToSet.managementBrowsePageSize", (Object)300);
        properties.put("addressSettings.NeedToSet.retroactiveMessageCount", (Object)-1);
        properties.put("addressSettings.NeedToSet.maxDeliveryAttempts", (Object)10);
        properties.put("addressSettings.NeedToSet.defaultGroupFirstKey", "add1Key");
        properties.put("addressSettings.NeedToSet.slowConsumerCheckPeriod", (Object)100);
        properties.put("addressSettings.NeedToSet.defaultLastValueKey", "add1Lvk");
        properties.put("addressSettings.NeedToSet.configDeleteDiverts", DeletionPolicy.FORCE);
        properties.put("addressSettings.NeedToSet.defaultConsumerWindowSize", (Object)1000);
        properties.put("addressSettings.NeedToSet.messageCounterHistoryDayLimit", (Object)7);
        properties.put("addressSettings.NeedToSet.defaultGroupRebalance", "true");
        properties.put("addressSettings.NeedToSet.defaultQueueRoutingType", RoutingType.ANYCAST);
        properties.put("addressSettings.NeedToSet.autoDeleteQueuesMessageCount", (Object)6789);
        properties.put("addressSettings.NeedToSet.addressFullMessagePolicy", AddressFullMessagePolicy.DROP);
        properties.put("addressSettings.NeedToSet.maxSizeBytes", (Object)6666);
        properties.put("addressSettings.NeedToSet.redistributionDelay", (Object)22);
        properties.put("addressSettings.NeedToSet.maxSizeBytesRejectThreshold", (Object)12334);
        properties.put("addressSettings.NeedToSet.defaultAddressRoutingType", RoutingType.ANYCAST);
        properties.put("addressSettings.NeedToSet.autoCreateDeadLetterResources", "true");
        properties.put("addressSettings.NeedToSet.pageCacheMaxSize", (Object)10);
        properties.put("addressSettings.NeedToSet.maxRedeliveryDelay", (Object)66);
        properties.put("addressSettings.NeedToSet.maxSizeMessages", (Object)10000000);
        properties.put("addressSettings.NeedToSet.redeliveryMultiplier", (Object)2.1);
        properties.put("addressSettings.NeedToSet.defaultRingSize", (Object)-2);
        properties.put("addressSettings.NeedToSet.defaultLastValueQueue", "true");
        properties.put("addressSettings.NeedToSet.redeliveryCollisionAvoidanceFactor", (Object)5.0);
        properties.put("addressSettings.NeedToSet.autoDeleteQueuesDelay", (Object)3);
        properties.put("addressSettings.NeedToSet.autoDeleteAddressesDelay", (Object)33);
        properties.put("addressSettings.NeedToSet.enableMetrics", "false");
        properties.put("addressSettings.NeedToSet.sendToDLAOnNoRoute", "true");
        properties.put("addressSettings.NeedToSet.slowConsumerThresholdMeasurementUnit", SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_HOUR);
        properties.put("addressSettings.NeedToSet.deadLetterQueueSuffix", "iamDeadLetterQueueSuf");
        properties.put("addressSettings.NeedToSet.queuePrefetch", (Object)900);
        properties.put("addressSettings.NeedToSet.defaultNonDestructive", "true");
        properties.put("addressSettings.NeedToSet.configDeleteAddresses", DeletionPolicy.FORCE);
        properties.put("addressSettings.NeedToSet.slowConsumerThreshold", (Object)10);
        properties.put("addressSettings.NeedToSet.configDeleteQueues", DeletionPolicy.FORCE);
        properties.put("addressSettings.NeedToSet.autoCreateAddresses", "false");
        properties.put("addressSettings.NeedToSet.autoDeleteQueues", "false");
        properties.put("addressSettings.NeedToSet.defaultConsumersBeforeDispatch", (Object)1);
        properties.put("addressSettings.NeedToSet.defaultPurgeOnNoConsumers", "true");
        properties.put("addressSettings.NeedToSet.autoCreateQueues", "false");
        properties.put("addressSettings.NeedToSet.autoDeleteAddresses", "false");
        properties.put("addressSettings.NeedToSet.defaultDelayBeforeDispatch", (Object)77);
        properties.put("addressSettings.NeedToSet.autoDeleteCreatedQueues", "true");
        properties.put("addressSettings.NeedToSet.defaultExclusiveQueue", "true");
        properties.put("addressSettings.NeedToSet.defaultMaxConsumers", (Object)10);
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)4L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"sharedExpiry"), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"important"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToTrackExpired")).getExpiryAddress());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"moreImportant"), (Object)((AddressSettings)configuration.getAddressSettings().get("Name.With.Dots")).getExpiryAddress());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoCreateExpiryResources());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"iamDeadLetterAdd"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDeadLetterAddress());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"add1Expiry"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getExpiryQueuePrefix());
        Assert.assertEquals((long)20000000L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxReadPageBytes());
        Assert.assertEquals((long)512L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getManagementMessageAttributeSizeLimit());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"iamDeadLetterQueuePre"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDeadLetterQueuePrefix());
        Assert.assertEquals((long)12345L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getPageSizeBytes());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"add1ExpirySuffix"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getExpiryQueueSuffix());
        Assert.assertEquals((Object)44L, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getExpiryDelay());
        Assert.assertEquals((Object)5L, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMinExpiryDelay());
        Assert.assertEquals((Object)10L, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxExpiryDelay());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isEnableIngressTimestamp());
        Assert.assertEquals((long)300L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getManagementBrowsePageSize());
        Assert.assertEquals((long)-1L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getRetroactiveMessageCount());
        Assert.assertEquals((long)10L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxDeliveryAttempts());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"add1Key"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultGroupFirstKey());
        Assert.assertEquals((long)100L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getSlowConsumerCheckPeriod());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"add1Lvk"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultLastValueKey());
        Assert.assertEquals((Object)DeletionPolicy.FORCE, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getConfigDeleteDiverts());
        Assert.assertEquals((long)1000L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultConsumerWindowSize());
        Assert.assertEquals((long)7L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMessageCounterHistoryDayLimit());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isDefaultGroupRebalance());
        Assert.assertEquals((Object)RoutingType.ANYCAST, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultQueueRoutingType());
        Assert.assertEquals((long)6789L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getAutoDeleteQueuesMessageCount());
        Assert.assertEquals((Object)AddressFullMessagePolicy.DROP, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getAddressFullMessagePolicy());
        Assert.assertEquals((long)6666L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxSizeBytes());
        Assert.assertEquals((long)22L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getRedistributionDelay());
        Assert.assertEquals((long)12334L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxSizeBytesRejectThreshold());
        Assert.assertEquals((Object)RoutingType.ANYCAST, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultAddressRoutingType());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoCreateDeadLetterResources());
        Assert.assertEquals((long)10L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getPageCacheMaxSize());
        Assert.assertEquals((long)66L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxRedeliveryDelay());
        Assert.assertEquals((long)10000000L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getMaxSizeMessages());
        Assert.assertEquals((double)2.1, (double)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getRedeliveryMultiplier(), (double)0.01);
        Assert.assertEquals((long)-2L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultRingSize());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isDefaultLastValueQueue());
        Assert.assertEquals((double)5.0, (double)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getRedeliveryCollisionAvoidanceFactor(), (double)0.01);
        Assert.assertEquals((long)3L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getAutoDeleteQueuesDelay());
        Assert.assertEquals((long)33L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getAutoDeleteAddressesDelay());
        Assert.assertFalse((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isEnableMetrics());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isSendToDLAOnNoRoute());
        Assert.assertEquals((Object)SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_HOUR, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getSlowConsumerThresholdMeasurementUnit());
        Assert.assertEquals((long)900L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getQueuePrefetch());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"iamDeadLetterQueueSuf"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDeadLetterQueueSuffix());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isDefaultNonDestructive());
        Assert.assertEquals((Object)DeletionPolicy.FORCE, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getConfigDeleteAddresses());
        Assert.assertEquals((long)10L, (long)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getSlowConsumerThreshold());
        Assert.assertEquals((Object)DeletionPolicy.FORCE, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getConfigDeleteQueues());
        Assert.assertFalse((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoCreateAddresses());
        Assert.assertFalse((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoDeleteQueues());
        Assert.assertEquals((Object)1, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultConsumersBeforeDispatch());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isDefaultPurgeOnNoConsumers());
        Assert.assertFalse((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoCreateQueues());
        Assert.assertFalse((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoDeleteAddresses());
        Assert.assertEquals((Object)77L, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultDelayBeforeDispatch());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isAutoDeleteCreatedQueues());
        Assert.assertTrue((boolean)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).isDefaultExclusiveQueue());
        Assert.assertEquals((Object)10, (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToSet")).getDefaultMaxConsumers());
    }

    @Test
    public void testAddressSettingsPageLimit() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageLimitMessages", "300");
        properties.put("addressSettings.#.pageLimitBytes", "300000");
        properties.put("addressSettings.#.pageFullMessagePolicy", "DROP");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((long)300L, (long)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals((long)300000L, (long)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals((Object)"DROP", (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy().toString());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals((long)300L, (long)storeImpl.getPageLimitMessages());
        Assert.assertEquals((long)300000L, (long)storeImpl.getPageLimitBytes());
        Assert.assertEquals((Object)"DROP", (Object)storeImpl.getPageFullMessagePolicy().toString());
    }

    @Test
    public void testAddressSettingsPageLimitInvalidConfiguration1() throws Throwable {
        AssertionLoggerHandler.startCapture();
        this.runAfter(AssertionLoggerHandler::stopCapture);
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageLimitMessages", "300");
        properties.put("addressSettings.#.pageLimitBytes", "300000");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((Object)300L, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals((Object)300000L, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitMessages());
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitBytes());
        Assert.assertEquals(null, (Object)storeImpl.getPageFullMessagePolicy());
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224125"}));
    }

    @Test
    public void testAddressSettingsPageLimitInvalidConfiguration2() throws Throwable {
        AssertionLoggerHandler.startCapture();
        this.runAfter(AssertionLoggerHandler::stopCapture);
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageLimitMessages", "300");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((Object)300L, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitMessages());
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitBytes());
        Assert.assertEquals(null, (Object)storeImpl.getPageFullMessagePolicy());
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224125"}));
    }

    @Test
    public void testAddressSettingsPageLimitInvalidConfiguration3() throws Throwable {
        AssertionLoggerHandler.startCapture();
        this.runAfter(AssertionLoggerHandler::stopCapture);
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageLimitBytes", "300000");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals((Object)300000L, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitMessages());
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitBytes());
        Assert.assertEquals(null, (Object)storeImpl.getPageFullMessagePolicy());
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224125"}));
    }

    @Test
    public void testAddressSettingsPageLimitInvalidConfiguration4() throws Throwable {
        AssertionLoggerHandler.startCapture();
        this.runAfter(AssertionLoggerHandler::stopCapture);
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageFullMessagePolicy", "DROP");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals(null, (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals((Object)"DROP", (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy().toString());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitMessages());
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitBytes());
        Assert.assertEquals(null, (Object)storeImpl.getPageFullMessagePolicy());
        Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224124"}));
    }

    @Test
    public void testAddressSettingsPageLimitInvalidConfiguration5() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String randomString = RandomUtil.randomString();
        properties.put("addressSettings.#.expiryAddress", randomString);
        properties.put("addressSettings.#.pageLimitMessages", "-1");
        properties.put("addressSettings.#.pageLimitBytes", "-1");
        properties.put("addressSettings.#.pageFullMessagePolicy", "DROP");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)randomString), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((long)-1L, (long)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitMessages());
        Assert.assertEquals((long)-1L, (long)((AddressSettings)configuration.getAddressSettings().get("#")).getPageLimitBytes());
        Assert.assertEquals((Object)"DROP", (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getPageFullMessagePolicy().toString());
        PagingStoreImpl storeImpl = new PagingStoreImpl(new SimpleString("Test"), (ScheduledExecutorService)null, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)Mockito.mock(StorageManager.class), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), new SimpleString("Test"), (AddressSettings)configuration.getAddressSettings().get("#"), null, null, true);
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitMessages());
        Assert.assertEquals(null, (Object)storeImpl.getPageLimitBytes());
        Assert.assertEquals(null, (Object)storeImpl.getPageFullMessagePolicy());
    }

    @Test
    public void testDivertViaProperties() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        String routingName = "divert1";
        String address = "testAddress";
        String forwardAddress = "forwardAddress";
        String className = "s.o.m.e.class";
        ConfigurationImpl.InsertionOrderedProperties properties = new ConfigurationImpl.InsertionOrderedProperties();
        properties.put("divertConfigurations.divert1.routingName", "divert1");
        properties.put("divertConfigurations.divert1.address", "testAddress");
        properties.put("divertConfigurations.divert1.forwardingAddress", "forwardAddress");
        properties.put("divertConfigurations.divert1.transformerConfiguration", "s.o.m.e.class");
        properties.put("divertConfigurations.divert1.transformerConfiguration.properties.a", "va");
        properties.put("divertConfigurations.divert1.transformerConfiguration.properties.b", "vb");
        configuration.parsePrefixedProperties((Properties)properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getDivertConfigurations().size());
        Assert.assertEquals((Object)"divert1", (Object)((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getRoutingName());
        Assert.assertEquals((Object)"testAddress", (Object)((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getAddress());
        Assert.assertEquals((Object)"forwardAddress", (Object)((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getForwardingAddress());
        Assert.assertEquals((Object)"s.o.m.e.class", (Object)((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getTransformerConfiguration().getClassName());
        Assert.assertEquals((Object)"va", ((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getTransformerConfiguration().getProperties().get("a"));
        Assert.assertEquals((Object)"vb", ((DivertConfiguration)configuration.getDivertConfigurations().get(0)).getTransformerConfiguration().getProperties().get("b"));
    }

    @Test
    public void testRoleSettingsViaProperties() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("securityRoles.TEST.users.send", "true");
        properties.put("securityRoles.TEST.users.consume", "true");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)1L, (long)configuration.getSecurityRoles().size());
        Assert.assertEquals((long)1L, (long)((Set)configuration.getSecurityRoles().get("TEST")).size());
        Assert.assertTrue((boolean)((Role)((Set)configuration.getSecurityRoles().get("TEST")).stream().findFirst().orElse(null)).isConsume());
        Assert.assertTrue((boolean)((Role)((Set)configuration.getSecurityRoles().get("TEST")).stream().findFirst().orElse(null)).isSend());
        Assert.assertFalse((boolean)((Role)((Set)configuration.getSecurityRoles().get("TEST")).stream().findFirst().orElse(null)).isCreateAddress());
    }

    @Test
    public void testRoleAugmentViaProperties() throws Exception {
        String xmlConfig = "<configuration xmlns=\"urn:activemq\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"urn:activemq /schema/artemis-configuration.xsd\">\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n</configuration>";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream("<configuration xmlns=\"urn:activemq\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"urn:activemq /schema/artemis-configuration.xsd\">\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n</configuration>".getBytes(StandardCharsets.UTF_8));
        ConfigurationImpl configuration = (ConfigurationImpl)parser.parseMainConfig((InputStream)input);
        Properties properties = new Properties();
        properties.put("securityRoles.TEST.users.send", "true");
        properties.put("securityRoles.TEST.users.consume", "false");
        properties.put("securityRoles.#.guest.consume", "false");
        properties.put("securityRoles.#.users.send", "true");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)2L, (long)configuration.getSecurityRoles().size());
        Assert.assertEquals((long)1L, (long)((Set)configuration.getSecurityRoles().get("TEST")).size());
        Assert.assertFalse((boolean)((Role)((Set)configuration.getSecurityRoles().get("TEST")).stream().findFirst().orElse(null)).isConsume());
        Assert.assertTrue((boolean)((Role)((Set)configuration.getSecurityRoles().get("TEST")).stream().findFirst().orElse(null)).isSend());
        Assert.assertEquals((long)2L, (long)((Set)configuration.getSecurityRoles().get("#")).size());
        Set roles = (Set)configuration.getSecurityRoles().get("#");
        class RolePredicate
        implements Predicate<Role> {
            final String roleName;

            RolePredicate(String name) {
                this.roleName = name;
            }

            @Override
            public boolean test(Role role) {
                return this.roleName.equals(role.getName()) && !role.isConsume() && role.isSend() && !role.isCreateAddress();
            }
        }
        Assert.assertEquals((long)1L, (long)roles.stream().filter(new RolePredicate("guest")).count());
        Assert.assertEquals((long)1L, (long)roles.stream().filter(new RolePredicate("users")).count());
    }

    @Test
    public void testValuePostFixModifier() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("globalMaxSize", "25K");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)25600L, (long)configuration.getGlobalMaxSize());
    }

    @Test
    public void testSystemPropValueReplaced() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String homeFromDefault = "default-home";
        String homeFromEnv = System.getenv("HOME");
        properties.put("name", "${HOME:default-home}");
        configuration.parsePrefixedProperties(properties, null);
        if (homeFromEnv != null) {
            Assert.assertEquals((Object)homeFromEnv, (Object)configuration.getName());
        } else {
            Assert.assertEquals((Object)"default-home", (Object)configuration.getName());
        }
    }

    @Test
    public void testSystemPropValueNoMatch() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("name", "vv-${SOME_RANDOM_VV}");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((Object)"vv-", (Object)configuration.getName());
    }

    @Test
    public void testSystemPropValueNonExistWithDefault() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("name", "vv-${SOME_RANDOM_VV:y}");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((Object)"vv-y", (Object)configuration.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSystemPropKeyReplacement() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        String newKeyName = RandomUtil.randomString();
        String valueFromSysProp = "VV";
        System.setProperty(newKeyName, "VV");
        try {
            properties.put("connectorConfigurations.KEY-${" + newKeyName + "}.name", "y");
            configuration.parsePrefixedProperties(properties, null);
            Assert.assertNotNull((String)"configured new key from prop", configuration.connectorConfigs.get("KEY-VV"));
            Assert.assertEquals((Object)"y", (Object)((TransportConfiguration)configuration.connectorConfigs.get("KEY-VV")).getName());
        }
        finally {
            System.clearProperty(newKeyName);
        }
    }

    @Test
    public void testEnumConversion() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("clusterConfiguration.cc.name", "cc");
        properties.put("clusterConfigurations.cc.messageLoadBalancingType", "OFF_WITH_REDISTRIBUTION");
        properties.put("criticalAnalyzerPolicy", "SHUTDOWN");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((Object)"cc", (Object)((ClusterConnectionConfiguration)configuration.getClusterConfigurations().get(0)).getName());
        Assert.assertEquals((Object)MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, (Object)((ClusterConnectionConfiguration)configuration.getClusterConfigurations().get(0)).getMessageLoadBalancingType());
        Assert.assertEquals((Object)CriticalAnalyzerPolicy.SHUTDOWN, (Object)configuration.getCriticalAnalyzerPolicy());
    }

    @Test
    public void testPropertiesReaderRespectsOrderFromFile() throws Exception {
        File tmpFile = File.createTempFile("ordered-props-test", "", this.temporaryFolder.getRoot());
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        final LinkedList<String> insertionOrderedKeys = new LinkedList<String>();
        char ascii = 'a';
        int i = 0;
        while (i < 26) {
            printWriter.println("resourceLimitSettings." + i + ".maxConnections=100");
            insertionOrderedKeys.addLast(String.valueOf(i));
            printWriter.println("resourceLimitSettings." + ascii + ".maxConnections=100");
            insertionOrderedKeys.addLast(String.valueOf(ascii));
            ++i;
            ascii = (char)(ascii + '\u0001');
        }
        printWriter.flush();
        fileOutputStream.flush();
        fileOutputStream.close();
        final AtomicReference errorAt = new AtomicReference();
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setResourceLimitSettings((Map)new HashMap<String, ResourceLimitSettings>(){

            @Override
            public ResourceLimitSettings put(String key, ResourceLimitSettings value) {
                if (!key.equals(insertionOrderedKeys.remove())) {
                    errorAt.set(key);
                    Assert.fail((String)("Expected to see props applied in insertion order!, errorAt:" + (String)errorAt.get()));
                }
                return super.put(key, value);
            }
        });
        configuration.parseProperties(tmpFile.getAbsolutePath());
        ConfigurationImplTest.assertNull((String)("no errors in insertion order, errorAt:" + (String)errorAt.get()), errorAt.get());
    }

    @Test
    public void testPropertiesFiles() throws Exception {
        LinkedList<String> files = new LinkedList<String>();
        final LinkedList<String> names = new LinkedList<String>();
        names.addLast("one");
        names.addLast("two");
        for (String suffix : names) {
            File tmpFile = File.createTempFile("props-test", suffix, this.temporaryFolder.getRoot());
            FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("name=" + suffix);
            printWriter.flush();
            fileOutputStream.flush();
            fileOutputStream.close();
            files.addLast(tmpFile.getAbsolutePath());
        }
        ConfigurationImpl configuration = new ConfigurationImpl(){

            public ConfigurationImpl setName(String name) {
                if (!name.equals(names.remove())) {
                    Assert.fail((String)"Expected names from files in order");
                }
                return super.setName(name);
            }
        };
        configuration.parseProperties(files.stream().collect(Collectors.joining(",")));
        ConfigurationImplTest.assertEquals((String)"second won", (Object)"two", (Object)configuration.getName());
    }

    @Test
    public void testPropertiesFilesInDir() throws Exception {
        LinkedList<String> files = new LinkedList<String>();
        final LinkedList<String> names = new LinkedList<String>();
        names.addLast("a_one");
        names.addLast("b_two");
        for (String name : names) {
            File tmpFile = File.createTempFile(name, ".properties", this.temporaryFolder.getRoot());
            FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("name=" + name);
            printWriter.flush();
            fileOutputStream.flush();
            fileOutputStream.close();
            files.addLast(tmpFile.getAbsolutePath());
        }
        ConfigurationImpl configuration = new ConfigurationImpl(){

            public ConfigurationImpl setName(String name) {
                if (!name.equals(names.remove())) {
                    Assert.fail((String)"Expected names from files in order");
                }
                return super.setName(name);
            }
        };
        configuration.parseProperties(this.temporaryFolder.getRoot() + "/");
        ConfigurationImplTest.assertEquals((String)"second won", (Object)"b_two", (Object)configuration.getName());
        ConfigurationImplTest.assertTrue((String)"all names applied", (boolean)names.isEmpty());
    }

    @Test
    public void testNameWithDotsSurroundWithDollarDollar() throws Throwable {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("key.surround", "$$");
        properties.put("addressesSettings.#.expiryAddress", "sharedExpiry");
        properties.put("addressesSettings.NeedToTrackExpired.expiryAddress", "important");
        properties.put("addressesSettings.$$Name.With.Dots$$.expiryAddress", "moreImportant");
        configuration.parsePrefixedProperties(properties, null);
        Assert.assertEquals((long)3L, (long)configuration.getAddressSettings().size());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"sharedExpiry"), (Object)((AddressSettings)configuration.getAddressSettings().get("#")).getExpiryAddress());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"important"), (Object)((AddressSettings)configuration.getAddressSettings().get("NeedToTrackExpired")).getExpiryAddress());
        Assert.assertEquals((Object)SimpleString.toSimpleString((String)"moreImportant"), (Object)((AddressSettings)configuration.getAddressSettings().get("Name.With.Dots")).getExpiryAddress());
        Assert.assertTrue((boolean)configuration.getStatus().contains("\"errors\":[]"));
    }

    @Test
    public void testStatusOnErrorApplyingProperties() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        Properties properties = new Properties();
        properties.put("clusterConfigurations.cc.bonkers", "bla");
        properties.put("notValid.#.expiryAddress", "sharedExpiry");
        properties.put("addressSettings.#.bla", "bla");
        properties.put("addressSettings.#.expiryAddress", "good");
        String SHA = "34311";
        properties.put("status", "{ \"properties\": { \"sha\": \"" + SHA + "\"}}");
        configuration.parsePrefixedProperties(properties, null);
        String jsonStatus = configuration.getStatus();
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains("notValid"));
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains("Unknown"));
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains("bonkers"));
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains("bla"));
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains(SHA));
        ConfigurationImplTest.assertFalse((boolean)jsonStatus.contains("good"));
        properties.clear();
        String UPDATED_SHA = "66666";
        properties.put("status", "{ \"properties\": { \"sha\": \"" + UPDATED_SHA + "\"}}");
        properties.put("addressSettings.#.expiryAddress", "changed");
        configuration.parsePrefixedProperties(properties, null);
        jsonStatus = configuration.getStatus();
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains(UPDATED_SHA));
        ConfigurationImplTest.assertFalse((boolean)jsonStatus.contains(SHA));
        ConfigurationImplTest.assertTrue((boolean)jsonStatus.contains("alder32"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetSystemPropertyCME() throws Throwable {
        final Properties properties = new Properties();
        for (int i = 0; i < 5000; ++i) {
            properties.put("key" + i, "value " + i);
        }
        ConfigurationImpl configuration = new ConfigurationImpl();
        final AtomicBoolean running = new AtomicBoolean(true);
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                latch.countDown();
                int i = 1;
                while (running.get()) {
                    properties.remove("key" + i);
                    properties.put("key" + i, "new value " + i);
                    if (++i <= 200) continue;
                    i = 1;
                }
            }
        };
        thread.start();
        try {
            latch.await();
            properties.put(configuration.getSystemPropertyPrefix() + "fileDeployerScanPeriod", "1234");
            properties.put(configuration.getSystemPropertyPrefix() + "globalMaxSize", "4321");
            configuration.parsePrefixedProperties(properties, configuration.getSystemPropertyPrefix());
        }
        finally {
            running.set(false);
            thread.join();
        }
        Assert.assertEquals((long)1234L, (long)configuration.getFileDeployerScanPeriod());
        Assert.assertEquals((long)4321L, (long)configuration.getGlobalMaxSize());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conf = this.createConfiguration();
    }

    protected Configuration createConfiguration() throws Exception {
        return new ConfigurationImpl();
    }
}

