/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.Collections;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImplTest;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.junit.Assert;
import org.junit.Test;

public class DefaultsFileConfigurationTest
extends ConfigurationImplTest {
    @Override
    @Test
    public void testDefaults() {
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize(), (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize(), (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultSecurityInvalidationInterval(), (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultSecurityEnabled(), (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJmxManagementEnabled(), (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultJmxDomain(), (Object)this.conf.getJMXDomain());
        Assert.assertEquals((long)0L, (long)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultConnectionTtlOverride(), (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((long)0L, (long)this.conf.getAcceptorConfigurations().size());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getConnectorConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBroadcastGroupConfigurations());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.conf.getDiscoveryGroupConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getBridgeConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getDivertConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getClusterConfigurations());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getQueueConfigs());
        Assert.assertEquals(Collections.emptyList(), (Object)this.conf.getAddressConfigurations());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementAddress(), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultManagementNotificationAddress(), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterUser(), (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)this.conf.getClusterPassword());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultIdCacheSize(), (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultPersistIdCache(), (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultBindingsDirectory(), (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultJournalDir(), (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)DefaultsFileConfigurationTest.getDefaultJournalType(), (Object)this.conf.getJournalType());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncTransactional(), (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultJournalSyncNonTransactional(), (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalFileSize(), (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxAtticFiles(), (long)this.conf.getJournalMaxAtticFiles());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalCompactMinFiles(), (long)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalCompactPercentage(), (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalLockAcquisitionTimeout(), (long)this.conf.getJournalLockAcquisitionTimeout());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMinFiles(), (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoAio(), (long)this.conf.getJournalMaxIO_AIO());
        Assert.assertEquals((long)500000L, (long)this.conf.getJournalBufferTimeout_AIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_AIO());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalMaxIoNio(), (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((long)3333333L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)501760L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateBindingsDir(), (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultCreateJournalDir(), (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPagingDir(), (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultLargeMessagesDir(), (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultWildcardRoutingEnabled(), (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeout(), (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultMessageCounterEnabled(), (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultTransactionTimeoutScanPeriod(), (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultMessageExpiryScanPeriod(), (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultAddressQueueScanPeriod(), (long)this.conf.getAddressQueueScanPeriod());
        Assert.assertTrue((boolean)(this.conf.getHAPolicyConfiguration() instanceof LiveOnlyPolicyConfiguration));
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.isDefaultGracefulShutdownEnabled(), (Object)this.conf.isGracefulShutdownEnabled());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultGracefulShutdownTimeout(), (long)this.conf.getGracefulShutdownTimeout());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultAmqpUseCoreSubscriptionNaming(), (Object)this.conf.isAmqpUseCoreSubscriptionNaming());
        Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalBufferTimeoutNio(), (long)this.conf.getPageSyncTimeout());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultFileDescriptorsMetrics(), (Object)this.conf.getMetricsConfiguration().isFileDescriptors());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultProcessorMetrics(), (Object)this.conf.getMetricsConfiguration().isProcessor());
        Assert.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultUptimeMetrics(), (Object)this.conf.getMetricsConfiguration().isUptime());
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("ConfigurationTest-defaults.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        return fc;
    }
}

