/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.List;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImplTest;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.junit.Assert;
import org.junit.Test;

public class FileConfigurationBrokerConnectionEncryptedTest
extends ConfigurationImplTest {
    protected String getConfigurationName() {
        return "ConfigurationTest-broker-connection-encrypted-config.xml";
    }

    @Override
    @Test
    public void testDefaults() {
    }

    @Test
    public void testAMQPBrokerConfigEncryptedUserAndPassword() {
        List brokerConnections = this.conf.getAMQPConnection();
        Assert.assertNotNull((String)"brokerConnections is null", (Object)brokerConnections);
        Assert.assertFalse((String)"brokerConnections is empty", (boolean)brokerConnections.isEmpty());
        boolean encTest = false;
        boolean plainTest = false;
        boolean emptyTest = false;
        for (AMQPBrokerConnectConfiguration brokerConnection : brokerConnections) {
            encTest = encTest || "enc-test".equals(brokerConnection.getName());
            plainTest = plainTest || "plain-test".equals(brokerConnection.getName());
            boolean bl = emptyTest = emptyTest || "empty-test".equals(brokerConnection.getName());
            if ("empty-test".equals(brokerConnection.getName())) {
                Assert.assertNull((Object)brokerConnection.getUser());
                Assert.assertNull((Object)brokerConnection.getPassword());
                continue;
            }
            Assert.assertEquals((Object)"testuser", (Object)brokerConnection.getUser());
            Assert.assertEquals((Object)"testpassword", (Object)brokerConnection.getPassword());
        }
        Assert.assertTrue((String)"enc-test configuration is not present", (boolean)encTest);
        Assert.assertTrue((String)"plain-test configuration is not present", (boolean)plainTest);
        Assert.assertTrue((String)"empty-test configuration is not present", (boolean)emptyTest);
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(this.getConfigurationName());
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        return fc;
    }
}

