/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.StringPrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class FileConfigurationParserTest
extends ActiveMQTestBase {
    private static String bridgePart = "<bridges>\n            <bridge name=\"my-bridge\">\n               <queue-name>sausage-factory</queue-name>\n               <forwarding-address>mincing-machine</forwarding-address>\n               <filter string=\"name='aardvark'\"/>\n               <transformer-class-name>org.apache.activemq.artemis.jms.example.HatColourChangeTransformer</transformer-class-name>\n               <reconnect-attempts>-1</reconnect-attempts>\n               <user>bridge-user</user>               <password>ENC(5aec0780b12bf225a13ab70c6c76bc8e)</password>               <static-connectors>\n                  <connector-ref>remote-connector</connector-ref>\n               </static-connectors>\n            </bridge>\n</bridges>\n";
    private static String firstPart = "<core xmlns=\"urn:activemq:core\">\n<name>ActiveMQ.main.config</name>\n<log-delegate-factory-class-name>org.apache.activemq.artemis.integration.logging.Log4jLogDelegateFactory</log-delegate-factory-class-name>\n<bindings-directory>${jboss.server.data.dir}/activemq/bindings</bindings-directory>\n<journal-directory>${jboss.server.data.dir}/activemq/journal</journal-directory>\n<journal-min-files>10</journal-min-files>\n<large-messages-directory>${jboss.server.data.dir}/activemq/largemessages</large-messages-directory>\n<paging-directory>${jboss.server.data.dir}/activemq/paging</paging-directory>\n<connectors>\n<connector name=\"netty\">tcp://localhost:61616</connector>\n<connector name=\"netty-throughput\">tcp://localhost:5545</connector>\n<connector name=\"in-vm\">vm://0</connector>\n</connectors>\n<acceptors>\n<acceptor name=\"netty\">tcp://localhost:5545</acceptor>\n<acceptor name=\"netty-throughput\">tcp://localhost:5545</acceptor>\n<acceptor name=\"in-vm\">vm://0</acceptor>\n</acceptors>\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"createNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"createDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteDurableQueue\" roles=\"guest\"/>\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n<address-settings>\n<address-setting match=\"#\">\n<dead-letter-address>DLQ\n</dead-letter-address>\n<expiry-address>ExpiryQueue\n</expiry-address>\n<redelivery-delay>0\n</redelivery-delay>\n<max-size-bytes>10485760\n</max-size-bytes>\n<message-counter-history-day-limit>10</message-counter-history-day-limit>\n<address-full-policy>BLOCK</address-full-policy>\n</address-setting>\n</address-settings>\n";
    private static String lastPart = "</core>";

    @Test
    public void testSchemaValidation() throws Exception {
        for (int i = 0; i < 7; ++i) {
            String filename = "InvalidConfigurationTest" + i + ".xml";
            FileConfiguration fc = new FileConfiguration();
            FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
            deploymentManager.addDeployable((Deployable)fc);
            try {
                deploymentManager.readConfiguration();
                FileConfigurationParserTest.fail((String)("parsing should have failed for " + filename));
                continue;
            }
            catch (IllegalStateException e) {
                Throwable cause = e.getCause();
                FileConfigurationParserTest.assertTrue((String)"must have been org.xml.sax.SAXParseException", (boolean)(cause instanceof SAXParseException));
            }
        }
    }

    @Test
    public void testDivertRoutingNameIsNotRequired() throws Exception {
        String filename = "divertRoutingNameNotRequired.xml";
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
    }

    @Test
    public void testDuplicateQueue() throws Exception {
        String filename = "FileConfigurationParser-duplicateQueue.xml";
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        ActiveMQServer server = this.addServer((ActiveMQServer)deploymentManager.buildService(null, null, null).get("core"));
        server.start();
        FileConfigurationParserTest.assertEquals((long)0L, (long)server.locateQueue(SimpleString.toSimpleString((String)"q")).getMaxConsumers());
    }

    @Test
    public void testAddressWithNoRoutingType() throws Exception {
        String filename = "FileConfigurationParser-addressWithNoRoutingType.xml";
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        deploymentManager.addDeployable((Deployable)fc);
        try {
            deploymentManager.readConfiguration();
            FileConfigurationParserTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDuplicateAddressSettings() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration config = parser.parseMainConfig(ClassloadingUtil.findResource((String)"FileConfigurationParser-duplicateAddressSettings.xml").openStream());
        Assert.assertEquals((long)123L, (long)((AddressSettings)config.getAddressSettings().get("foo")).getRedistributionDelay());
    }

    @Test
    public void testParsingClusterConnectionURIs() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<cluster-connections>\n   <cluster-connection-uri name=\"my-cluster\" address=\"multicast://my-discovery-group?messageLoadBalancingType=STRICT;retryInterval=333;connectorName=netty-connector;maxHops=1\"/>\n</cluster-connections>\n" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        Assert.assertEquals((long)1L, (long)config.getClusterConfigurations().size());
        Assert.assertEquals((Object)"my-discovery-group", (Object)((ClusterConnectionConfiguration)config.getClusterConfigurations().get(0)).getDiscoveryGroupName());
        Assert.assertEquals((long)333L, (long)((ClusterConnectionConfiguration)config.getClusterConfigurations().get(0)).getRetryInterval());
    }

    @Test
    public void testParsingZeroIDCacheSize() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<id-cache-size>0</id-cache-size>" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        Assert.assertEquals((long)0L, (long)config.getIDCacheSize());
    }

    @Test
    public void testWildcardConfiguration() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<wildcard-addresses>\n<routing-enabled>true</routing-enabled>\n<delimiter>/</delimiter>\n<any-words>></any-words></wildcard-addresses>" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        WildcardConfiguration wildCard = config.getWildcardConfiguration();
        FileConfigurationParserTest.assertEquals((long)47L, (long)wildCard.getDelimiter());
        FileConfigurationParserTest.assertTrue((boolean)wildCard.isRoutingEnabled());
        FileConfigurationParserTest.assertEquals((long)62L, (long)wildCard.getAnyWords());
        FileConfigurationParserTest.assertEquals((long)42L, (long)wildCard.getSingleWord());
    }

    @Test
    public void testParsingHaSharedStoreWaitForActivation() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<ha-policy><shared-store><master><wait-for-activation>false</wait-for-activation></master></shared-store></ha-policy>" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        HAPolicyConfiguration haConfig = config.getHAPolicyConfiguration();
        FileConfigurationParserTest.assertTrue((boolean)(haConfig instanceof SharedStoreMasterPolicyConfiguration));
        SharedStoreMasterPolicyConfiguration masterConfig = (SharedStoreMasterPolicyConfiguration)haConfig;
        FileConfigurationParserTest.assertFalse((boolean)masterConfig.isWaitForActivation());
    }

    @Test
    public void testParsingDefaultServerConfig() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        String clusterPassword = config.getClusterPassword();
        FileConfigurationParserTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)clusterPassword);
        Object clusterPasswordPart = "<cluster-password>helloworld</cluster-password>";
        configStr = firstPart + (String)clusterPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = codec.encode((Object)"helloworld");
        String maskPasswordPart = "<mask-password>true</mask-password>";
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        configStr = firstPart + (String)clusterPasswordPart + maskPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "newkey");
        codec.init(prop);
        mask = codec.encode((Object)"newpassword");
        clusterPasswordPart = "<cluster-password>" + mask + "</cluster-password>";
        String codecPart = "<password-codec>org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;key=newkey</password-codec>";
        configStr = firstPart + (String)clusterPasswordPart + maskPasswordPart + codecPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"newpassword", (Object)config.getClusterPassword());
    }

    @Test
    public void testParsingDefaultServerConfigWithENCMaskedPwd() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        String clusterPassword = config.getClusterPassword();
        FileConfigurationParserTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultClusterPassword(), (Object)clusterPassword);
        Object clusterPasswordPart = "<cluster-password>ENC(5aec0780b12bf225a13ab70c6c76bc8e)</cluster-password>";
        configStr = firstPart + (String)clusterPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = codec.encode((Object)"helloworld");
        clusterPasswordPart = "<cluster-password>" + PasswordMaskingUtil.wrap((String)mask) + "</cluster-password>";
        configStr = firstPart + (String)clusterPasswordPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)config.getClusterPassword());
        codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "newkey");
        codec.init(prop);
        mask = codec.encode((Object)"newpassword");
        clusterPasswordPart = "<cluster-password>" + PasswordMaskingUtil.wrap((String)mask) + "</cluster-password>";
        String codecPart = "<password-codec>org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;key=newkey</password-codec>";
        configStr = firstPart + (String)clusterPasswordPart + codecPart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        FileConfigurationParserTest.assertEquals((Object)"newpassword", (Object)config.getClusterPassword());
        configStr = firstPart + bridgePart + lastPart;
        config = parser.parseMainConfig((InputStream)new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8)));
        List bridgeConfigs = config.getBridgeConfigurations();
        FileConfigurationParserTest.assertEquals((long)1L, (long)bridgeConfigs.size());
        BridgeConfiguration bconfig = (BridgeConfiguration)bridgeConfigs.get(0);
        FileConfigurationParserTest.assertEquals((Object)"helloworld", (Object)bconfig.getPassword());
    }

    @Test
    public void testDefaultBridgeProducerWindowSize() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<bridges>\n   <bridge name=\"my-bridge\">\n      <queue-name>sausage-factory</queue-name>\n      <forwarding-address>mincing-machine</forwarding-address>\n      <static-connectors>\n         <connector-ref>remote-connector</connector-ref>\n      </static-connectors>\n   </bridge>\n</bridges>\n" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        List bridgeConfigs = config.getBridgeConfigurations();
        FileConfigurationParserTest.assertEquals((long)1L, (long)bridgeConfigs.size());
        BridgeConfiguration bconfig = (BridgeConfiguration)bridgeConfigs.get(0);
        FileConfigurationParserTest.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize(), (long)bconfig.getProducerWindowSize());
    }

    @Test
    public void testParsingOverflowPageSize() throws Exception {
        this.testParsingOverFlow("<address-settings>\n<address-setting match=\"#\">\n<page-size-bytes>2147483648</page-size-bytes>\n</address-setting>\n</address-settings>\n");
        this.testParsingOverFlow("<journal-file-size>2147483648</journal-file-size>");
        this.testParsingOverFlow("<journal-buffer-size>2147483648</journal-buffer-size>");
        this.testParsingOverFlow("<cluster-connections> \n  <cluster-connection name=\"my-cluster\"> \n    <connector-ref>netty</connector-ref>  \n    <min-large-message-size>2147483648</min-large-message-size>\n    <discovery-group-ref discovery-group-name=\"my-discovery-group\"/> \n  </cluster-connection> \n</cluster-connections>");
        this.testParsingOverFlow("<cluster-connections> \n  <cluster-connection name=\"my-cluster\"> \n    <connector-ref>netty</connector-ref>  \n    <confirmation-window-size>2147483648</confirmation-window-size>\n    <discovery-group-ref discovery-group-name=\"my-discovery-group\"/> \n  </cluster-connection> \n</cluster-connections>");
        this.testParsingOverFlow("<cluster-connections> \n  <cluster-connection name=\"my-cluster\"> \n    <connector-ref>netty</connector-ref>  \n    <producer-window-size>2147483648</producer-window-size>\n    <discovery-group-ref discovery-group-name=\"my-discovery-group\"/> \n  </cluster-connection> \n</cluster-connections>");
        this.testParsingOverFlow("<bridges> \n  <bridge name=\"price-forward-bridge\"> \n    <queue-name>priceForwarding</queue-name>  \n    <forwarding-address>newYorkPriceUpdates</forwarding-address>\n    <min-large-message-size>2147483648</min-large-message-size>\n    <static-connectors> \n      <connector-ref>netty</connector-ref> \n    </static-connectors> \n  </bridge> \n</bridges>");
        this.testParsingOverFlow("<bridges> \n  <bridge name=\"price-forward-bridge\"> \n    <queue-name>priceForwarding</queue-name>  \n    <forwarding-address>newYorkPriceUpdates</forwarding-address>\n    <confirmation-window-size>2147483648</confirmation-window-size>\n    <static-connectors> \n      <connector-ref>netty</connector-ref> \n    </static-connectors> \n  </bridge> \n</bridges>\n");
        this.testParsingOverFlow("<bridges> \n  <bridge name=\"price-forward-bridge\"> \n    <queue-name>priceForwarding</queue-name>  \n    <forwarding-address>newYorkPriceUpdates</forwarding-address>\n    <producer-window-size>2147483648</producer-window-size>\n    <static-connectors> \n      <connector-ref>netty</connector-ref> \n    </static-connectors> \n  </bridge> \n</bridges>\n");
    }

    @Test
    public void testParsingScaleDownConfig() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + "<ha-policy>\n   <live-only>\n      <scale-down>\n         <connectors>\n            <connector-ref>server0-connector</connector-ref>\n         </connectors>\n      </scale-down>\n   </live-only>\n</ha-policy>\n" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        HAPolicyConfiguration haConfig = config.getHAPolicyConfiguration();
        FileConfigurationParserTest.assertTrue((boolean)(haConfig instanceof LiveOnlyPolicyConfiguration));
        LiveOnlyPolicyConfiguration liveOnlyCfg = (LiveOnlyPolicyConfiguration)haConfig;
        ScaleDownConfiguration scaledownCfg = liveOnlyCfg.getScaleDownConfiguration();
        List connectors = scaledownCfg.getConnectors();
        FileConfigurationParserTest.assertEquals((long)1L, (long)connectors.size());
        String connector = (String)connectors.get(0);
        FileConfigurationParserTest.assertEquals((Object)"server0-connector", (Object)connector);
    }

    private void testParsingOverFlow(String config) throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        String firstPartWithoutAddressSettings = firstPart.substring(0, firstPart.indexOf("<address-settings"));
        String configStr = firstPartWithoutAddressSettings + config + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        try {
            Configuration configuration = parser.parseMainConfig((InputStream)input);
            FileConfigurationParserTest.fail((String)"parsing should have failed bcs of overflow page size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseMaxSizeOnAddressSettings() throws Exception {
        String configStr = "<configuration><address-settings>\n<address-setting match=\"foo\">\n<max-size-messages>123</max-size-messages>\n</address-setting>\n</address-settings></configuration>\n";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration configuration = parser.parseMainConfig((InputStream)input);
        AddressSettings settings = (AddressSettings)configuration.getAddressSettings().get("foo");
        Assert.assertEquals((long)123L, (long)settings.getMaxSizeMessages());
    }

    @Test
    public void testParseMaxReadAddressSettings() throws Exception {
        String configStr = "<configuration><address-settings>\n<address-setting match=\"foo\">\n<max-read-page-bytes>1k</max-read-page-bytes><max-read-page-messages>33</max-read-page-messages>.\n</address-setting>\n</address-settings></configuration>\n";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration configuration = parser.parseMainConfig((InputStream)input);
        AddressSettings settings = (AddressSettings)configuration.getAddressSettings().get("foo");
        Assert.assertEquals((long)1024L, (long)settings.getMaxReadPageBytes());
        Assert.assertEquals((long)33L, (long)settings.getMaxReadPageMessages());
        Assert.assertNull((Object)settings.getPageLimitBytes());
        Assert.assertNull((Object)settings.getPageLimitMessages());
        Assert.assertNull((Object)settings.getPageFullMessagePolicy());
    }

    @Test
    public void testParsePageLimitSettings() throws Exception {
        String configStr = "<configuration><address-settings>\n<address-setting match=\"foo\">\n<max-read-page-bytes>1k</max-read-page-bytes><page-limit-bytes>2k</page-limit-bytes><page-limit-messages>337</page-limit-messages><page-full-policy>FAIL</page-full-policy><max-read-page-messages>33</max-read-page-messages>.\n</address-setting>\n</address-settings></configuration>\n";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration configuration = parser.parseMainConfig((InputStream)input);
        AddressSettings settings = (AddressSettings)configuration.getAddressSettings().get("foo");
        Assert.assertEquals((long)1024L, (long)settings.getMaxReadPageBytes());
        Assert.assertEquals((long)33L, (long)settings.getMaxReadPageMessages());
        Assert.assertEquals((long)2048L, (long)settings.getPageLimitBytes());
        Assert.assertEquals((long)337L, (long)settings.getPageLimitMessages());
        Assert.assertEquals((Object)"FAIL", (Object)settings.getPageFullMessagePolicy().toString());
    }

    @Test
    public void testParseMaxReadAddressSettingsAllNegative() throws Exception {
        String configStr = "<configuration><address-settings>\n<address-setting match=\"foo\">\n<max-read-page-bytes>-1</max-read-page-bytes><max-read-page-messages>-1</max-read-page-messages>.\n</address-setting>\n</address-settings></configuration>\n";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration configuration = parser.parseMainConfig((InputStream)input);
        AddressSettings settings = (AddressSettings)configuration.getAddressSettings().get("foo");
        Assert.assertEquals((long)-1L, (long)settings.getMaxReadPageBytes());
        Assert.assertEquals((long)-1L, (long)settings.getMaxReadPageMessages());
    }

    @Test
    public void testExpectedErrorOverMaxMessageNotation() throws Exception {
        String configStr = "<configuration><address-settings>\n<address-setting match=\"foo\">\n<max-size-messages>123K</max-size-messages>\n</address-setting>\n</address-settings></configuration>\n";
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        boolean valid = false;
        try {
            parser.parseMainConfig((InputStream)input);
        }
        catch (Throwable expected) {
            valid = true;
        }
        Assert.assertTrue((String)"Exception expected", (boolean)valid);
    }

    @Test
    public void testParsingAddressSettings() throws Exception {
        long expected = 0x80000000L;
        String firstPartWithoutAS = firstPart.substring(0, firstPart.indexOf("<address-settings"));
        String configStr = firstPartWithoutAS + "<address-settings>\n<address-setting match=\"#\">\n" + String.format("<max-size-bytes-reject-threshold>%d</max-size-bytes-reject-threshold>\n", expected) + "</address-setting>\n</address-settings>\n" + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration configuration = new FileConfigurationParser().parseMainConfig((InputStream)input);
        FileConfigurationParserTest.assertEquals((long)1L, (long)configuration.getAddressSettings().size());
        AddressSettings addressSettings = (AddressSettings)configuration.getAddressSettings().get("#");
        FileConfigurationParserTest.assertEquals((long)expected, (long)addressSettings.getMaxSizeBytesRejectThreshold());
    }

    @Test
    public void testParsingPageSyncTimeout() throws Exception {
        int expected = 1000;
        FileConfigurationParser parser = new FileConfigurationParser();
        String configStr = firstPart + String.format("<page-sync-timeout>%d</page-sync-timeout>\n", expected) + lastPart;
        ByteArrayInputStream input = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        Configuration config = parser.parseMainConfig((InputStream)input);
        FileConfigurationParserTest.assertEquals((long)expected, (long)config.getPageSyncTimeout());
    }

    @Test
    public void testMinimalXML() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
    }

    @Test
    public void testMaxSize() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<global-max-size>10M</global-max-size>");
        stream.println("<global-max-messages>1000</global-max-messages>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
        Assert.assertEquals((long)0xA00000L, (long)configuration.getGlobalMaxSize());
        Assert.assertEquals((long)1000L, (long)configuration.getGlobalMaxMessages());
    }

    @Test
    public void testConfigurationPersistRedelivery() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<max-redelivery-records>0</max-redelivery-records>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
        Assert.assertEquals((long)0L, (long)configuration.getMaxRedeliveryRecords());
    }

    @Test
    public void testExceptionMaxSize() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<global-max-messages>1000K</global-max-messages>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        boolean exceptionHappened = false;
        try {
            parser.parseMainConfig((InputStream)inputStream);
        }
        catch (Throwable e) {
            exceptionHappened = true;
        }
        Assert.assertTrue((String)"Exception expected parsing notation for global-max-messages", (boolean)exceptionHappened);
    }

    @Test
    public void testNotations() throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<global-max-size>100MiB</global-max-size>");
        stream.println("<journal-file-size>10M</journal-file-size>");
        stream.println("<journal-buffer-size>5Mb</journal-buffer-size>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
        Assert.assertEquals((long)0x6400000L, (long)configuration.getGlobalMaxSize());
        Assert.assertEquals((long)0xA00000L, (long)configuration.getJournalFileSize());
        Assert.assertTrue((0x500000 == configuration.getJournalBufferSize_AIO() || 0x500000 == configuration.getJournalBufferSize_NIO() ? 1 : 0) != 0);
    }

    @Test
    public void testRetentionJournalOptionsDays() throws Exception {
        this.testStreamDatesOption("DAYS", TimeUnit.DAYS);
    }

    @Test
    public void testRetentionJournalOptionsHours() throws Exception {
        this.testStreamDatesOption("HOURS", TimeUnit.HOURS);
    }

    @Test
    public void testRetentionJournalOptionsMinutes() throws Exception {
        this.testStreamDatesOption("MINUTES", TimeUnit.MINUTES);
    }

    @Test
    public void testRetentionJournalOptionsSeconds() throws Exception {
        this.testStreamDatesOption("SECONDS", TimeUnit.SECONDS);
    }

    private void testStreamDatesOption(String option, TimeUnit expected) throws Exception {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<journal-retention-directory unit=\"" + option + "\" period=\"365\" storage-limit=\"10G\">history</journal-retention-directory>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
        Assert.assertEquals((Object)"history", (Object)configuration.getJournalRetentionDirectory());
        Assert.assertEquals((long)expected.toMillis(365L), (long)configuration.getJournalRetentionPeriod());
    }

    @Test
    public void unlimitedJustHistory() throws Throwable {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<journal-retention-directory>directory</journal-retention-directory>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = null;
        boolean exceptionHappened = false;
        try {
            configuration = parser.parseMainConfig((InputStream)inputStream);
        }
        catch (Exception e) {
            exceptionHappened = true;
        }
        Assert.assertTrue((boolean)exceptionHappened);
    }

    @Test
    public void noRetention() throws Throwable {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<journal-directory>journal</journal-directory>");
        stream.println("</core></configuration>");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        FileConfigurationParser parser = new FileConfigurationParser();
        Configuration configuration = null;
        configuration = parser.parseMainConfig((InputStream)inputStream);
        Assert.assertNull((Object)configuration.getJournalRetentionLocation());
        Assert.assertNull((Object)configuration.getJournalRetentionDirectory());
        Assert.assertEquals((Object)"journal", (Object)configuration.getJournalDirectory());
    }

    @Test
    public void noFolderOnRetention() throws Throwable {
        StringPrintStream stringPrintStream = new StringPrintStream();
        PrintStream stream = stringPrintStream.newStream();
        stream.println("<configuration><core>");
        stream.println("<journal-retention-directory period=\"3\"></journal-retention-directory>");
        stream.println("</core></configuration>");
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(stringPrintStream.getBytes());
        boolean exception = false;
        try {
            Configuration configuration = parser.parseMainConfig((InputStream)inputStream);
        }
        catch (Exception e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }
}

