/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImplTest;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.junit.Assert;
import org.junit.Test;

public class FileConfigurationSecurityPluginTest
extends ConfigurationImplTest {
    protected String getConfigurationName() {
        return "ConfigurationTest-security-plugin-config.xml";
    }

    @Override
    @Test
    public void testDefaults() {
        List securitySettingPlugins = this.conf.getSecuritySettingPlugins();
        Assert.assertEquals((long)1L, (long)securitySettingPlugins.size());
        Assert.assertEquals((Object)"secret", (Object)MyPlugin.options.get("setting1"));
        Assert.assertEquals((Object)"hello", (Object)MyPlugin.options.get("setting2"));
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(this.getConfigurationName());
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        return fc;
    }

    public static class MyPlugin
    implements SecuritySettingPlugin {
        private static Map<String, String> options;

        public SecuritySettingPlugin init(Map<String, String> options) {
            MyPlugin.options = options;
            return this;
        }

        public SecuritySettingPlugin stop() {
            return null;
        }

        public Map<String, Set<Role>> getSecurityRoles() {
            return null;
        }

        public void setSecurityRepository(HierarchicalRepository<Set<Role>> securityRepository) {
        }
    }
}

