/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImplTest;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LegacyLDAPSecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.metrics.ActiveMQMetricsPlugin;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.routing.KeyType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerThresholdMeasurementUnit;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.XmlProvider;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileConfigurationTest
extends ConfigurationImplTest {
    @BeforeClass
    public static void setupProperties() {
        System.setProperty("a2Prop", "a2");
        System.setProperty("falseProp", "false");
        System.setProperty("trueProp", "true");
        System.setProperty("ninetyTwoProp", "92");
    }

    @AfterClass
    public static void clearProperties() {
        System.clearProperty("a2Prop");
        System.clearProperty("falseProp");
        System.clearProperty("trueProp");
        System.clearProperty("ninetyTwoProp");
    }

    @Parameterized.Parameters(name="xxeEnabled={0}")
    public static Collection getParameters() {
        return Arrays.asList(true, false);
    }

    public FileConfigurationTest(boolean xxeEnabled) {
        XmlProvider.setXxeEnabled((boolean)xxeEnabled);
    }

    protected String getConfigurationName() {
        return "ConfigurationTest-full-config.xml";
    }

    @Override
    @Test
    public void testDefaults() {
        Assert.assertEquals((Object)"SomeNameForUseOnTheApplicationServer", (Object)this.conf.getName());
        Assert.assertEquals((Object)false, (Object)this.conf.isPersistenceEnabled());
        Assert.assertEquals((Object)true, (Object)this.conf.isClustered());
        Assert.assertEquals((long)12345L, (long)this.conf.getScheduledThreadPoolMaxSize());
        Assert.assertEquals((long)54321L, (long)this.conf.getThreadPoolMaxSize());
        Assert.assertEquals((Object)false, (Object)this.conf.isSecurityEnabled());
        Assert.assertEquals((long)5423L, (long)this.conf.getSecurityInvalidationInterval());
        Assert.assertEquals((long)333L, (long)this.conf.getAuthenticationCacheSize());
        Assert.assertEquals((long)444L, (long)this.conf.getAuthorizationCacheSize());
        Assert.assertEquals((Object)true, (Object)this.conf.isWildcardRoutingEnabled());
        Assert.assertEquals((Object)new SimpleString("Giraffe"), (Object)this.conf.getManagementAddress());
        Assert.assertEquals((Object)new SimpleString("Whatever"), (Object)this.conf.getManagementNotificationAddress());
        Assert.assertEquals((Object)"Frog", (Object)this.conf.getClusterUser());
        Assert.assertEquals((Object)"Wombat", (Object)this.conf.getClusterPassword());
        Assert.assertEquals((Object)false, (Object)this.conf.isJMXManagementEnabled());
        Assert.assertEquals((Object)"gro.qtenroh", (Object)this.conf.getJMXDomain());
        Assert.assertEquals((Object)true, (Object)this.conf.isMessageCounterEnabled());
        Assert.assertEquals((long)5L, (long)this.conf.getMessageCounterMaxDayHistory());
        Assert.assertEquals((long)123456L, (long)this.conf.getMessageCounterSamplePeriod());
        Assert.assertEquals((long)12345L, (long)this.conf.getConnectionTTLOverride());
        Assert.assertEquals((long)98765L, (long)this.conf.getTransactionTimeout());
        Assert.assertEquals((long)56789L, (long)this.conf.getTransactionTimeoutScanPeriod());
        Assert.assertEquals((long)10111213L, (long)this.conf.getMessageExpiryScanPeriod());
        Assert.assertEquals((long)25000L, (long)this.conf.getAddressQueueScanPeriod());
        Assert.assertEquals((long)127L, (long)this.conf.getIDCacheSize());
        Assert.assertEquals((Object)true, (Object)this.conf.isPersistIDCache());
        Assert.assertEquals((Object)777, (Object)this.conf.getJournalDeviceBlockSize());
        Assert.assertEquals((Object)true, (Object)this.conf.isPersistDeliveryCountBeforeDelivery());
        Assert.assertEquals((Object)"pagingdir", (Object)this.conf.getPagingDirectory());
        Assert.assertEquals((Object)"somedir", (Object)this.conf.getBindingsDirectory());
        Assert.assertEquals((Object)false, (Object)this.conf.isCreateBindingsDir());
        Assert.assertEquals((Object)true, (Object)this.conf.isAmqpUseCoreSubscriptionNaming());
        Assert.assertEquals((Object)false, (Object)this.conf.isSuppressSessionNotifications());
        Assert.assertEquals((String)"max concurrent io", (long)17L, (long)this.conf.getPageMaxConcurrentIO());
        Assert.assertEquals((Object)true, (Object)this.conf.isReadWholePage());
        Assert.assertEquals((Object)"somedir2", (Object)this.conf.getJournalDirectory());
        Assert.assertEquals((Object)"history", (Object)this.conf.getJournalRetentionDirectory());
        Assert.assertEquals((long)0x280000000L, (long)this.conf.getJournalRetentionMaxBytes());
        Assert.assertEquals((long)TimeUnit.DAYS.toMillis(365L), (long)this.conf.getJournalRetentionPeriod());
        Assert.assertEquals((Object)false, (Object)this.conf.isCreateJournalDir());
        Assert.assertEquals((Object)JournalType.NIO, (Object)this.conf.getJournalType());
        Assert.assertEquals((long)10000L, (long)this.conf.getJournalBufferSize_NIO());
        Assert.assertEquals((long)1000L, (long)this.conf.getJournalBufferTimeout_NIO());
        Assert.assertEquals((long)56546L, (long)this.conf.getJournalMaxIO_NIO());
        Assert.assertEquals((long)9876L, (long)this.conf.getJournalFileOpenTimeout());
        Assert.assertEquals((Object)false, (Object)this.conf.isJournalSyncTransactional());
        Assert.assertEquals((Object)true, (Object)this.conf.isJournalSyncNonTransactional());
        Assert.assertEquals((long)12345678L, (long)this.conf.getJournalFileSize());
        Assert.assertEquals((long)100L, (long)this.conf.getJournalMinFiles());
        Assert.assertEquals((long)123L, (long)this.conf.getJournalCompactMinFiles());
        Assert.assertEquals((long)33L, (long)this.conf.getJournalCompactPercentage());
        Assert.assertEquals((long)7654L, (long)this.conf.getJournalLockAcquisitionTimeout());
        Assert.assertEquals((Object)true, (Object)this.conf.isGracefulShutdownEnabled());
        Assert.assertEquals((long)12345L, (long)this.conf.getGracefulShutdownTimeout());
        Assert.assertEquals((Object)true, (Object)this.conf.isPopulateValidatedUser());
        Assert.assertEquals((Object)false, (Object)this.conf.isRejectEmptyValidatedUser());
        Assert.assertEquals((long)123456L, (long)this.conf.getMqttSessionScanInterval());
        Assert.assertEquals((long)98765L, (long)this.conf.getConnectionTtlCheckInterval());
        Assert.assertEquals((long)1234567L, (long)this.conf.getConfigurationFileRefreshPeriod());
        Assert.assertEquals((Object)"TEMP", (Object)this.conf.getTemporaryQueueNamespace());
        Assert.assertEquals((Object)"127.0.0.1", (Object)this.conf.getNetworkCheckList());
        Assert.assertEquals((Object)"some-nick", (Object)this.conf.getNetworkCheckNIC());
        Assert.assertEquals((long)123L, (long)this.conf.getNetworkCheckPeriod());
        Assert.assertEquals((long)321L, (long)this.conf.getNetworkCheckTimeout());
        Assert.assertEquals((Object)"ping-four", (Object)this.conf.getNetworkCheckPingCommand());
        Assert.assertEquals((Object)"ping-six", (Object)this.conf.getNetworkCheckPing6Command());
        Assert.assertEquals((Object)"largemessagesdir", (Object)this.conf.getLargeMessagesDirectory());
        Assert.assertEquals((long)95L, (long)this.conf.getMemoryWarningThreshold());
        Assert.assertEquals((long)2L, (long)this.conf.getIncomingInterceptorClassNames().size());
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.apache.activemq.artemis.tests.unit.core.config.impl.TestInterceptor1"));
        Assert.assertTrue((boolean)this.conf.getIncomingInterceptorClassNames().contains("org.apache.activemq.artemis.tests.unit.core.config.impl.TestInterceptor2"));
        Assert.assertEquals((long)2L, (long)this.conf.getConnectorConfigurations().size());
        TransportConfiguration tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector1");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((Object)"org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory", (Object)tc.getFactoryClassName());
        Assert.assertEquals((Object)"mylocal", tc.getParams().get("localAddress"));
        Assert.assertEquals((Object)"99", tc.getParams().get("localPort"));
        Assert.assertEquals((Object)"localhost1", tc.getParams().get("host"));
        Assert.assertEquals((Object)"5678", tc.getParams().get("port"));
        tc = (TransportConfiguration)this.conf.getConnectorConfigurations().get("connector2");
        Assert.assertNotNull((Object)tc);
        Assert.assertEquals((Object)"org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory", (Object)tc.getFactoryClassName());
        Assert.assertEquals((Object)"5", tc.getParams().get("serverId"));
        Assert.assertEquals((long)2L, (long)this.conf.getAcceptorConfigurations().size());
        for (TransportConfiguration ac : this.conf.getAcceptorConfigurations()) {
            if (ac.getFactoryClassName().equals("org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory")) {
                Assert.assertEquals((Object)"456", ac.getParams().get("tcpNoDelay"));
                Assert.assertEquals((Object)"44", ac.getParams().get("connectionTtl"));
                Assert.assertEquals((Object)"92", ac.getParams().get("connectionsAllowed"));
                continue;
            }
            Assert.assertEquals((Object)"org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory", (Object)ac.getFactoryClassName());
            Assert.assertEquals((Object)"0", ac.getParams().get("serverId"));
            Assert.assertEquals((Object)"87", ac.getParams().get("connectionsAllowed"));
        }
        Assert.assertEquals((long)2L, (long)this.conf.getBroadcastGroupConfigurations().size());
        for (Object bc : this.conf.getBroadcastGroupConfigurations()) {
            UDPBroadcastEndpointFactory udpBc = (UDPBroadcastEndpointFactory)bc.getEndpointFactory();
            if (bc.getName().equals("bg1")) {
                Assert.assertEquals((Object)"bg1", (Object)bc.getName());
                Assert.assertEquals((long)10999L, (long)udpBc.getLocalBindPort());
                Assert.assertEquals((Object)"192.168.0.120", (Object)udpBc.getGroupAddress());
                Assert.assertEquals((long)11999L, (long)udpBc.getGroupPort());
                Assert.assertEquals((long)12345L, (long)bc.getBroadcastPeriod());
                Assert.assertEquals((Object)"connector1", bc.getConnectorInfos().get(0));
                continue;
            }
            Assert.assertEquals((Object)"bg2", (Object)bc.getName());
            Assert.assertEquals((long)12999L, (long)udpBc.getLocalBindPort());
            Assert.assertEquals((Object)"192.168.0.121", (Object)udpBc.getGroupAddress());
            Assert.assertEquals((long)13999L, (long)udpBc.getGroupPort());
            Assert.assertEquals((long)23456L, (long)bc.getBroadcastPeriod());
            Assert.assertEquals((Object)"connector2", bc.getConnectorInfos().get(0));
        }
        Assert.assertEquals((long)2L, (long)this.conf.getDiscoveryGroupConfigurations().size());
        DiscoveryGroupConfiguration dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg1");
        Assert.assertEquals((Object)"dg1", (Object)dc.getName());
        Assert.assertEquals((Object)"192.168.0.120", (Object)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getGroupAddress());
        FileConfigurationTest.assertEquals((Object)"172.16.8.10", (Object)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getLocalBindAddress());
        Assert.assertEquals((long)11999L, (long)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getGroupPort());
        Assert.assertEquals((long)12345L, (long)dc.getRefreshTimeout());
        dc = (DiscoveryGroupConfiguration)this.conf.getDiscoveryGroupConfigurations().get("dg2");
        Assert.assertEquals((Object)"dg2", (Object)dc.getName());
        Assert.assertEquals((Object)"192.168.0.121", (Object)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getGroupAddress());
        FileConfigurationTest.assertEquals((Object)"172.16.8.11", (Object)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getLocalBindAddress());
        Assert.assertEquals((long)12999L, (long)((UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory()).getGroupPort());
        Assert.assertEquals((long)23456L, (long)dc.getRefreshTimeout());
        Assert.assertEquals((long)3L, (long)this.conf.getDivertConfigurations().size());
        for (DivertConfiguration dic : this.conf.getDivertConfigurations()) {
            if (dic.getName().equals("divert1")) {
                Assert.assertEquals((Object)"divert1", (Object)dic.getName());
                Assert.assertEquals((Object)"routing-name1", (Object)dic.getRoutingName());
                Assert.assertEquals((Object)"address1", (Object)dic.getAddress());
                Assert.assertEquals((Object)"forwarding-address1", (Object)dic.getForwardingAddress());
                Assert.assertEquals((Object)"speed > 88", (Object)dic.getFilterString());
                Assert.assertEquals((Object)"org.foo.Transformer", (Object)dic.getTransformerConfiguration().getClassName());
                Assert.assertEquals((Object)true, (Object)dic.isExclusive());
                continue;
            }
            if (dic.getName().equals("divert2")) {
                Assert.assertEquals((Object)"divert2", (Object)dic.getName());
                Assert.assertEquals((Object)"routing-name2", (Object)dic.getRoutingName());
                Assert.assertEquals((Object)"address2", (Object)dic.getAddress());
                Assert.assertEquals((Object)"forwarding-address2", (Object)dic.getForwardingAddress());
                Assert.assertEquals((Object)"speed < 88", (Object)dic.getFilterString());
                Assert.assertEquals((Object)"org.foo.Transformer2", (Object)dic.getTransformerConfiguration().getClassName());
                Assert.assertEquals((Object)false, (Object)dic.isExclusive());
                continue;
            }
            Assert.assertEquals((Object)"divert3", (Object)dic.getName());
            Assert.assertEquals((Object)"org.foo.DivertTransformer3", (Object)dic.getTransformerConfiguration().getClassName());
            Assert.assertEquals((Object)"divertTransformerValue1", dic.getTransformerConfiguration().getProperties().get("divertTransformerKey1"));
            Assert.assertEquals((Object)"divertTransformerValue2", dic.getTransformerConfiguration().getProperties().get("divertTransformerKey2"));
        }
        Assert.assertEquals((long)5L, (long)this.conf.getConnectionRouters().size());
        for (ConnectionRouterConfiguration bc : this.conf.getConnectionRouters()) {
            if (bc.getName().equals("simple-local")) {
                Assert.assertEquals((Object)bc.getKeyType(), (Object)KeyType.CLIENT_ID);
                Assert.assertNotNull((Object)bc.getLocalTargetFilter());
                Assert.assertNotNull((Object)bc.getKeyFilter());
                Assert.assertNull((Object)bc.getPolicyConfiguration());
                continue;
            }
            if (bc.getName().equals("simple-local-with-transformer")) {
                Assert.assertEquals((Object)bc.getKeyType(), (Object)KeyType.CLIENT_ID);
                Assert.assertNotNull((Object)bc.getLocalTargetFilter());
                Assert.assertNotNull((Object)bc.getKeyFilter());
                Assert.assertNotNull((Object)bc.getPolicyConfiguration());
                Assert.assertNotNull(bc.getPolicyConfiguration().getProperties().get("MODULO"));
                continue;
            }
            if (bc.getName().equals("simple-router")) {
                Assert.assertEquals((Object)bc.getKeyType(), (Object)KeyType.USER_NAME);
                Assert.assertNull((Object)bc.getLocalTargetFilter());
                Assert.assertEquals((Object)bc.getPolicyConfiguration().getName(), (Object)"FIRST_ELEMENT");
                Assert.assertEquals((Object)false, (Object)bc.getPoolConfiguration().isLocalTargetEnabled());
                Assert.assertEquals((Object)"connector1", bc.getPoolConfiguration().getStaticConnectors().get(0));
                Assert.assertEquals(null, (Object)bc.getPoolConfiguration().getDiscoveryGroupName());
                continue;
            }
            if (bc.getName().equals("consistent-hash-router")) {
                Assert.assertEquals((Object)bc.getKeyType(), (Object)KeyType.SNI_HOST);
                Assert.assertEquals((Object)bc.getKeyFilter(), (Object)"^[^.]+");
                Assert.assertEquals((Object)bc.getLocalTargetFilter(), (Object)"DEFAULT");
                Assert.assertEquals((Object)bc.getPolicyConfiguration().getName(), (Object)"CONSISTENT_HASH");
                Assert.assertEquals((long)1000L, (long)bc.getPoolConfiguration().getCheckPeriod());
                Assert.assertEquals((Object)true, (Object)bc.getPoolConfiguration().isLocalTargetEnabled());
                Assert.assertEquals(null, (Object)bc.getPoolConfiguration().getStaticConnectors());
                Assert.assertEquals((Object)"dg1", (Object)bc.getPoolConfiguration().getDiscoveryGroupName());
                continue;
            }
            Assert.assertEquals((Object)bc.getKeyType(), (Object)KeyType.SOURCE_IP);
            Assert.assertEquals((Object)"least-connections-router", (Object)bc.getName());
            Assert.assertNotNull((Object)bc.getCacheConfiguration());
            Assert.assertEquals((Object)true, (Object)bc.getCacheConfiguration().isPersisted());
            Assert.assertEquals((long)60000L, (long)bc.getCacheConfiguration().getTimeout());
            Assert.assertEquals((Object)bc.getPolicyConfiguration().getName(), (Object)"LEAST_CONNECTIONS");
            Assert.assertEquals((long)3000L, (long)bc.getPoolConfiguration().getCheckPeriod());
            Assert.assertEquals((long)2L, (long)bc.getPoolConfiguration().getQuorumSize());
            Assert.assertEquals((long)1000L, (long)bc.getPoolConfiguration().getQuorumTimeout());
            Assert.assertEquals((Object)false, (Object)bc.getPoolConfiguration().isLocalTargetEnabled());
            Assert.assertEquals(null, (Object)bc.getPoolConfiguration().getStaticConnectors());
            Assert.assertEquals((Object)"dg2", (Object)bc.getPoolConfiguration().getDiscoveryGroupName());
        }
        Assert.assertEquals((long)4L, (long)this.conf.getBridgeConfigurations().size());
        for (ConnectionRouterConfiguration bc : this.conf.getBridgeConfigurations()) {
            if (bc.getName().equals("bridge1")) {
                Assert.assertEquals((Object)"bridge1", (Object)bc.getName());
                Assert.assertEquals((Object)"queue1", (Object)bc.getQueueName());
                Assert.assertEquals((String)"minLargeMessageSize", (long)0x400000L, (long)bc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)31L, (long)bc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)370L, (long)bc.getConnectionTTL());
                Assert.assertEquals((Object)"bridge-forwarding-address1", (Object)bc.getForwardingAddress());
                Assert.assertEquals((Object)"sku > 1", (Object)bc.getFilterString());
                Assert.assertEquals((Object)"org.foo.BridgeTransformer", (Object)bc.getTransformerConfiguration().getClassName());
                Assert.assertEquals((long)3L, (long)bc.getRetryInterval());
                Assert.assertEquals((double)0.2, (double)bc.getRetryIntervalMultiplier(), (double)1.0E-4);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10002L, (long)bc.getMaxRetryInterval());
                Assert.assertEquals((long)2L, (long)bc.getReconnectAttempts());
                Assert.assertEquals((Object)true, (Object)bc.isUseDuplicateDetection());
                Assert.assertEquals((Object)"connector1", bc.getStaticConnectors().get(0));
                Assert.assertEquals(null, (Object)bc.getDiscoveryGroupName());
                Assert.assertEquals((long)444L, (long)bc.getProducerWindowSize());
                Assert.assertEquals((long)0x40000000L, (long)bc.getConfirmationWindowSize());
                Assert.assertEquals((Object)ComponentConfigurationRoutingType.STRIP, (Object)bc.getRoutingType());
                continue;
            }
            if (bc.getName().equals("bridge2")) {
                Assert.assertEquals((Object)"bridge2", (Object)bc.getName());
                Assert.assertEquals((Object)"queue2", (Object)bc.getQueueName());
                Assert.assertEquals((Object)"bridge-forwarding-address2", (Object)bc.getForwardingAddress());
                Assert.assertEquals(null, (Object)bc.getFilterString());
                Assert.assertEquals(null, (Object)bc.getTransformerConfiguration());
                Assert.assertEquals(null, (Object)bc.getStaticConnectors());
                Assert.assertEquals((Object)"dg1", (Object)bc.getDiscoveryGroupName());
                Assert.assertEquals((long)568320L, (long)bc.getProducerWindowSize());
                Assert.assertEquals((Object)ComponentConfigurationRoutingType.PASS, (Object)bc.getRoutingType());
                continue;
            }
            if (!bc.getName().equals("bridge3")) continue;
            Assert.assertEquals((Object)"bridge3", (Object)bc.getName());
            Assert.assertEquals((Object)"org.foo.BridgeTransformer3", (Object)bc.getTransformerConfiguration().getClassName());
            Assert.assertEquals((Object)"bridgeTransformerValue1", bc.getTransformerConfiguration().getProperties().get("bridgeTransformerKey1"));
            Assert.assertEquals((Object)"bridgeTransformerValue2", bc.getTransformerConfiguration().getProperties().get("bridgeTransformerKey2"));
        }
        Assert.assertEquals((long)3L, (long)this.conf.getClusterConfigurations().size());
        HAPolicyConfiguration pc = this.conf.getHAPolicyConfiguration();
        FileConfigurationTest.assertNotNull((Object)pc);
        FileConfigurationTest.assertTrue((boolean)(pc instanceof LiveOnlyPolicyConfiguration));
        LiveOnlyPolicyConfiguration lopc = (LiveOnlyPolicyConfiguration)pc;
        FileConfigurationTest.assertNotNull((Object)lopc.getScaleDownConfiguration());
        FileConfigurationTest.assertEquals((Object)lopc.getScaleDownConfiguration().getGroupName(), (Object)"boo!");
        FileConfigurationTest.assertEquals((Object)lopc.getScaleDownConfiguration().getDiscoveryGroup(), (Object)"dg1");
        for (ClusterConnectionConfiguration ccc : this.conf.getClusterConfigurations()) {
            if (ccc.getName().equals("cluster-connection3")) {
                Assert.assertEquals((Object)MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, (Object)ccc.getMessageLoadBalancingType());
                Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultClusterCallTimeout(), (long)ccc.getCallTimeout());
                Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultClusterCallFailoverTimeout(), (long)ccc.getCallFailoverTimeout());
                continue;
            }
            if (ccc.getName().equals("cluster-connection1")) {
                Assert.assertEquals((Object)"cluster-connection1", (Object)ccc.getName());
                Assert.assertEquals((String)"clusterConnectionConf minLargeMessageSize", (long)321L, (long)ccc.getMinLargeMessageSize());
                FileConfigurationTest.assertEquals((String)"check-period", (long)331L, (long)ccc.getClientFailureCheckPeriod());
                FileConfigurationTest.assertEquals((String)"connection time-to-live", (long)3370L, (long)ccc.getConnectionTTL());
                Assert.assertEquals((Object)"queues1", (Object)ccc.getAddress());
                Assert.assertEquals((long)3L, (long)ccc.getRetryInterval());
                Assert.assertEquals((Object)true, (Object)ccc.isDuplicateDetection());
                Assert.assertEquals((Object)MessageLoadBalancingType.ON_DEMAND, (Object)ccc.getMessageLoadBalancingType());
                Assert.assertEquals((long)1L, (long)ccc.getMaxHops());
                Assert.assertEquals((long)123L, (long)ccc.getCallTimeout());
                Assert.assertEquals((long)123L, (long)ccc.getCallFailoverTimeout());
                FileConfigurationTest.assertEquals((String)"multiplier", (double)0.25, (double)ccc.getRetryIntervalMultiplier(), (double)1.0E-5);
                FileConfigurationTest.assertEquals((String)"max retry interval", (long)10000L, (long)ccc.getMaxRetryInterval());
                FileConfigurationTest.assertEquals((long)72L, (long)ccc.getReconnectAttempts());
                Assert.assertEquals((Object)"connector1", ccc.getStaticConnectors().get(0));
                Assert.assertEquals((Object)"connector2", ccc.getStaticConnectors().get(1));
                Assert.assertEquals(null, (Object)ccc.getDiscoveryGroupName());
                Assert.assertEquals((long)222L, (long)ccc.getProducerWindowSize());
                continue;
            }
            Assert.assertEquals((Object)"cluster-connection2", (Object)ccc.getName());
            Assert.assertEquals((Object)"queues2", (Object)ccc.getAddress());
            Assert.assertEquals((long)4L, (long)ccc.getRetryInterval());
            Assert.assertEquals((long)456L, (long)ccc.getCallTimeout());
            Assert.assertEquals((long)456L, (long)ccc.getCallFailoverTimeout());
            Assert.assertEquals((Object)false, (Object)ccc.isDuplicateDetection());
            Assert.assertEquals((Object)MessageLoadBalancingType.STRICT, (Object)ccc.getMessageLoadBalancingType());
            Assert.assertEquals((long)2L, (long)ccc.getMaxHops());
            Assert.assertEquals(Collections.emptyList(), (Object)ccc.getStaticConnectors());
            Assert.assertEquals((Object)"dg1", (Object)ccc.getDiscoveryGroupName());
            Assert.assertEquals((long)333L, (long)ccc.getProducerWindowSize());
        }
        FileConfigurationTest.assertEquals((long)2L, (long)this.conf.getAddressSettings().size());
        FileConfigurationTest.assertTrue((this.conf.getAddressSettings().get("a1") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertTrue((this.conf.getAddressSettings().get("a2") != null ? 1 : 0) != 0);
        FileConfigurationTest.assertEquals((Object)"a1.1", (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoCreateDeadLetterResources());
        FileConfigurationTest.assertEquals((Object)AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_PREFIX, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDeadLetterQueuePrefix());
        FileConfigurationTest.assertEquals((Object)AddressSettings.DEFAULT_DEAD_LETTER_QUEUE_SUFFIX, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDeadLetterQueueSuffix());
        FileConfigurationTest.assertEquals((Object)"a1.2", (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getExpiryDelay());
        FileConfigurationTest.assertEquals((long)2L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getMinExpiryDelay());
        FileConfigurationTest.assertEquals((long)3L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getMaxExpiryDelay());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoCreateExpiryResources());
        FileConfigurationTest.assertEquals((Object)AddressSettings.DEFAULT_EXPIRY_QUEUE_PREFIX, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getExpiryQueuePrefix());
        FileConfigurationTest.assertEquals((Object)AddressSettings.DEFAULT_EXPIRY_QUEUE_SUFFIX, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getExpiryQueueSuffix());
        FileConfigurationTest.assertEquals((long)1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((double)0.5, (double)((AddressSettings)this.conf.getAddressSettings().get("a1")).getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        FileConfigurationTest.assertEquals((long)0x33100000L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)817381738L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((long)10L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((long)4L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((long)10L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getSlowConsumerThreshold());
        FileConfigurationTest.assertEquals((Object)SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_HOUR, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getSlowConsumerThresholdMeasurementUnit());
        FileConfigurationTest.assertEquals((long)5L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getSlowConsumerCheckPeriod());
        FileConfigurationTest.assertEquals((Object)SlowConsumerPolicy.NOTIFY, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getSlowConsumerPolicy());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoCreateJmsQueues());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoDeleteJmsQueues());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoCreateJmsTopics());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoDeleteJmsTopics());
        FileConfigurationTest.assertEquals((long)0L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getAutoDeleteQueuesDelay());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getAutoDeleteQueuesSkipUsageCheck());
        FileConfigurationTest.assertEquals((long)0L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getAutoDeleteAddressesDelay());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isAutoDeleteAddressesSkipUsageCheck());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).isDefaultPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)5, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDefaultMaxConsumers());
        FileConfigurationTest.assertEquals((Object)RoutingType.ANYCAST, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDefaultQueueRoutingType());
        FileConfigurationTest.assertEquals((Object)RoutingType.MULTICAST, (Object)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDefaultAddressRoutingType());
        FileConfigurationTest.assertEquals((long)3L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getDefaultRingSize());
        FileConfigurationTest.assertEquals((long)0L, (long)((AddressSettings)this.conf.getAddressSettings().get("a1")).getRetroactiveMessageCount());
        FileConfigurationTest.assertTrue((boolean)((AddressSettings)this.conf.getAddressSettings().get("a1")).isEnableMetrics());
        FileConfigurationTest.assertTrue((boolean)((AddressSettings)this.conf.getAddressSettings().get("a1")).isEnableIngressTimestamp());
        FileConfigurationTest.assertEquals((Object)"a2.1", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDeadLetterAddress().toString());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoCreateDeadLetterResources());
        FileConfigurationTest.assertEquals((Object)"", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDeadLetterQueuePrefix().toString());
        FileConfigurationTest.assertEquals((Object)".DLQ", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDeadLetterQueueSuffix().toString());
        FileConfigurationTest.assertEquals((Object)"a2.2", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getExpiryAddress().toString());
        FileConfigurationTest.assertEquals((long)-1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getExpiryDelay());
        FileConfigurationTest.assertEquals((long)-1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getMinExpiryDelay());
        FileConfigurationTest.assertEquals((long)-1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getMaxExpiryDelay());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoCreateDeadLetterResources());
        FileConfigurationTest.assertEquals((Object)"", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getExpiryQueuePrefix().toString());
        FileConfigurationTest.assertEquals((Object)".EXP", (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getExpiryQueueSuffix().toString());
        FileConfigurationTest.assertEquals((long)5L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getRedeliveryDelay());
        FileConfigurationTest.assertEquals((double)0.0, (double)((AddressSettings)this.conf.getAddressSettings().get("a2")).getRedeliveryCollisionAvoidanceFactor(), (double)0.0);
        FileConfigurationTest.assertEquals((long)932489234928324L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getMaxSizeBytes());
        FileConfigurationTest.assertEquals((long)712671626L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getPageSizeBytes());
        FileConfigurationTest.assertEquals((long)20L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getPageCacheMaxSize());
        FileConfigurationTest.assertEquals((long)8L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getMessageCounterHistoryDayLimit());
        FileConfigurationTest.assertEquals((long)20L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getSlowConsumerThreshold());
        FileConfigurationTest.assertEquals((Object)SlowConsumerThresholdMeasurementUnit.MESSAGES_PER_DAY, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getSlowConsumerThresholdMeasurementUnit());
        FileConfigurationTest.assertEquals((long)15L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getSlowConsumerCheckPeriod());
        FileConfigurationTest.assertEquals((Object)SlowConsumerPolicy.KILL, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getSlowConsumerPolicy());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoCreateJmsQueues());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoDeleteJmsQueues());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoCreateJmsTopics());
        FileConfigurationTest.assertEquals((Object)false, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoDeleteJmsTopics());
        FileConfigurationTest.assertEquals((long)500L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getAutoDeleteQueuesDelay());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getAutoDeleteQueuesSkipUsageCheck());
        FileConfigurationTest.assertEquals((long)1000L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getAutoDeleteAddressesDelay());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isAutoDeleteAddressesSkipUsageCheck());
        FileConfigurationTest.assertEquals((Object)true, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).isDefaultPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)15, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDefaultMaxConsumers());
        FileConfigurationTest.assertEquals((Object)RoutingType.MULTICAST, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDefaultQueueRoutingType());
        FileConfigurationTest.assertEquals((Object)RoutingType.ANYCAST, (Object)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDefaultAddressRoutingType());
        FileConfigurationTest.assertEquals((long)10000L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDefaultConsumerWindowSize());
        FileConfigurationTest.assertEquals((long)-1L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getDefaultRingSize());
        FileConfigurationTest.assertEquals((long)10L, (long)((AddressSettings)this.conf.getAddressSettings().get("a2")).getRetroactiveMessageCount());
        FileConfigurationTest.assertFalse((boolean)((AddressSettings)this.conf.getAddressSettings().get("a2")).isEnableMetrics());
        FileConfigurationTest.assertFalse((boolean)((AddressSettings)this.conf.getAddressSettings().get("a2")).isEnableIngressTimestamp());
        FileConfigurationTest.assertTrue((boolean)this.conf.getResourceLimitSettings().containsKey("myUser"));
        FileConfigurationTest.assertEquals((long)104L, (long)((ResourceLimitSettings)this.conf.getResourceLimitSettings().get("myUser")).getMaxConnections());
        FileConfigurationTest.assertEquals((long)13L, (long)((ResourceLimitSettings)this.conf.getResourceLimitSettings().get("myUser")).getMaxQueues());
        FileConfigurationTest.assertEquals((long)2L, (long)this.conf.getQueueConfigs().size());
        FileConfigurationTest.assertEquals((Object)"queue1", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(0)).getName().toString());
        FileConfigurationTest.assertEquals((Object)"address1", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(0)).getAddress().toString());
        FileConfigurationTest.assertEquals((Object)"color='red'", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(0)).getFilterString().toString());
        FileConfigurationTest.assertEquals((Object)false, (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(0)).isDurable());
        FileConfigurationTest.assertEquals((Object)"queue2", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(1)).getName().toString());
        FileConfigurationTest.assertEquals((Object)"address2", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(1)).getAddress().toString());
        FileConfigurationTest.assertEquals((Object)"color='blue'", (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(1)).getFilterString().toString());
        FileConfigurationTest.assertEquals((Object)false, (Object)((QueueConfiguration)this.conf.getQueueConfigs().get(1)).isDurable());
        this.verifyAddresses();
        Map roles = this.conf.getSecurityRoles();
        FileConfigurationTest.assertEquals((long)2L, (long)roles.size());
        FileConfigurationTest.assertTrue((boolean)roles.containsKey("a1"));
        FileConfigurationTest.assertTrue((boolean)roles.containsKey("a2"));
        Role a1Role = ((Set)roles.get("a1")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a1Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a1Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a1Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a1Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a1Role.isManage());
        Role a2Role = ((Set)roles.get("a2")).toArray(new Role[1])[0];
        FileConfigurationTest.assertFalse((boolean)a2Role.isSend());
        FileConfigurationTest.assertFalse((boolean)a2Role.isConsume());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isDeleteDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isCreateNonDurableQueue());
        FileConfigurationTest.assertTrue((boolean)a2Role.isDeleteNonDurableQueue());
        FileConfigurationTest.assertFalse((boolean)a2Role.isManage());
        FileConfigurationTest.assertEquals((long)1234567L, (long)this.conf.getGlobalMaxSize());
        FileConfigurationTest.assertEquals((long)37L, (long)this.conf.getMaxDiskUsage());
        FileConfigurationTest.assertEquals((long)123L, (long)this.conf.getDiskScanPeriod());
        FileConfigurationTest.assertEquals((long)333L, (long)this.conf.getCriticalAnalyzerCheckPeriod());
        FileConfigurationTest.assertEquals((long)777L, (long)this.conf.getCriticalAnalyzerTimeout());
        FileConfigurationTest.assertEquals((Object)false, (Object)this.conf.isCriticalAnalyzer());
        FileConfigurationTest.assertEquals((Object)CriticalAnalyzerPolicy.HALT, (Object)this.conf.getCriticalAnalyzerPolicy());
        FileConfigurationTest.assertEquals((Object)false, (Object)this.conf.isJournalDatasync());
        ActiveMQMetricsPlugin metricsPlugin = this.conf.getMetricsPlugin();
        FileConfigurationTest.assertTrue((boolean)(metricsPlugin instanceof SimpleMetricsPlugin));
        Map options = ((SimpleMetricsPlugin)metricsPlugin).getOptions();
        FileConfigurationTest.assertEquals((Object)"x", options.get("foo"));
        FileConfigurationTest.assertEquals((Object)"y", options.get("bar"));
        FileConfigurationTest.assertEquals((Object)"z", options.get("baz"));
        MetricsConfiguration metricsConfiguration = this.conf.getMetricsConfiguration();
        FileConfigurationTest.assertTrue((boolean)(metricsConfiguration.getPlugin() instanceof SimpleMetricsPlugin));
        options = ((SimpleMetricsPlugin)metricsPlugin).getOptions();
        FileConfigurationTest.assertEquals((Object)"x", options.get("foo"));
        FileConfigurationTest.assertEquals((Object)"y", options.get("bar"));
        FileConfigurationTest.assertEquals((Object)"z", options.get("baz"));
        FileConfigurationTest.assertFalse((boolean)metricsConfiguration.isJvmMemory());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isJvmGc());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isJvmThread());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isNettyPool());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isFileDescriptors());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isProcessor());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isUptime());
    }

    private void verifyAddresses() {
        FileConfigurationTest.assertEquals((long)3L, (long)this.conf.getAddressConfigurations().size());
        CoreAddressConfiguration addressConfiguration = (CoreAddressConfiguration)this.conf.getAddressConfigurations().get(0);
        FileConfigurationTest.assertEquals((Object)"addr1", (Object)addressConfiguration.getName());
        HashSet<RoutingType> routingTypes = new HashSet<RoutingType>();
        routingTypes.add(RoutingType.ANYCAST);
        FileConfigurationTest.assertEquals(routingTypes, (Object)addressConfiguration.getRoutingTypes());
        FileConfigurationTest.assertEquals((long)2L, (long)addressConfiguration.getQueueConfigs().size());
        QueueConfiguration queueConfiguration = (QueueConfiguration)addressConfiguration.getQueueConfigs().get(0);
        FileConfigurationTest.assertEquals((Object)"q1", (Object)queueConfiguration.getName().toString());
        FileConfigurationTest.assertEquals((long)3L, (long)queueConfiguration.getRingSize());
        FileConfigurationTest.assertFalse((boolean)queueConfiguration.isDurable());
        FileConfigurationTest.assertEquals((Object)"color='blue'", (Object)queueConfiguration.getFilterString().toString());
        FileConfigurationTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queueConfiguration.isPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)"addr1", (Object)queueConfiguration.getAddress().toString());
        FileConfigurationTest.assertEquals(null, (Object)queueConfiguration.getMaxConsumers());
        FileConfigurationTest.assertEquals(null, (Object)queueConfiguration.isGroupRebalancePauseDispatch());
        queueConfiguration = (QueueConfiguration)addressConfiguration.getQueueConfigs().get(1);
        FileConfigurationTest.assertEquals((Object)"q2", (Object)queueConfiguration.getName().toString());
        FileConfigurationTest.assertEquals((long)-1L, (long)queueConfiguration.getRingSize());
        FileConfigurationTest.assertTrue((boolean)queueConfiguration.isDurable());
        FileConfigurationTest.assertEquals((Object)"color='green'", (Object)queueConfiguration.getFilterString().toString());
        FileConfigurationTest.assertEquals((long)-1L, (long)queueConfiguration.getMaxConsumers().intValue());
        FileConfigurationTest.assertFalse((boolean)queueConfiguration.isPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)"addr1", (Object)queueConfiguration.getAddress().toString());
        FileConfigurationTest.assertEquals((Object)true, (Object)queueConfiguration.isGroupRebalancePauseDispatch());
        addressConfiguration = (CoreAddressConfiguration)this.conf.getAddressConfigurations().get(1);
        FileConfigurationTest.assertEquals((Object)"addr2", (Object)addressConfiguration.getName());
        routingTypes = new HashSet();
        routingTypes.add(RoutingType.MULTICAST);
        FileConfigurationTest.assertEquals(routingTypes, (Object)addressConfiguration.getRoutingTypes());
        FileConfigurationTest.assertEquals((long)2L, (long)addressConfiguration.getQueueConfigs().size());
        queueConfiguration = (QueueConfiguration)addressConfiguration.getQueueConfigs().get(0);
        FileConfigurationTest.assertEquals((Object)"q3", (Object)queueConfiguration.getName().toString());
        FileConfigurationTest.assertTrue((boolean)queueConfiguration.isDurable());
        FileConfigurationTest.assertEquals((Object)"color='red'", (Object)queueConfiguration.getFilterString().toString());
        FileConfigurationTest.assertEquals((long)10L, (long)queueConfiguration.getMaxConsumers().intValue());
        FileConfigurationTest.assertEquals((Object)ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), (Object)queueConfiguration.isPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)"addr2", (Object)queueConfiguration.getAddress().toString());
        FileConfigurationTest.assertEquals(null, (Object)queueConfiguration.isGroupRebalancePauseDispatch());
        queueConfiguration = (QueueConfiguration)addressConfiguration.getQueueConfigs().get(1);
        FileConfigurationTest.assertEquals((Object)"q4", (Object)queueConfiguration.getName().toString());
        FileConfigurationTest.assertTrue((boolean)queueConfiguration.isDurable());
        FileConfigurationTest.assertNull((Object)queueConfiguration.getFilterString());
        FileConfigurationTest.assertEquals(null, (Object)queueConfiguration.getMaxConsumers());
        FileConfigurationTest.assertTrue((boolean)queueConfiguration.isPurgeOnNoConsumers());
        FileConfigurationTest.assertEquals((Object)"addr2", (Object)queueConfiguration.getAddress().toString());
        FileConfigurationTest.assertEquals((Object)true, (Object)queueConfiguration.isGroupRebalancePauseDispatch());
        addressConfiguration = (CoreAddressConfiguration)this.conf.getAddressConfigurations().get(2);
        FileConfigurationTest.assertEquals((Object)"addr2", (Object)addressConfiguration.getName());
        routingTypes = new HashSet();
        routingTypes.add(RoutingType.MULTICAST);
        routingTypes.add(RoutingType.ANYCAST);
        FileConfigurationTest.assertEquals(routingTypes, (Object)addressConfiguration.getRoutingTypes());
    }

    @Test
    public void testSecuritySettingPlugin() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("securitySettingPlugin.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        List securitySettingPlugins = fc.getSecuritySettingPlugins();
        SecuritySettingPlugin securitySettingPlugin = (SecuritySettingPlugin)securitySettingPlugins.get(0);
        FileConfigurationTest.assertTrue((boolean)(securitySettingPlugin instanceof LegacyLDAPSecuritySettingPlugin));
        LegacyLDAPSecuritySettingPlugin legacyLDAPSecuritySettingPlugin = (LegacyLDAPSecuritySettingPlugin)securitySettingPlugin;
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getInitialContextFactory(), (Object)"testInitialContextFactory");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getConnectionURL(), (Object)"testConnectionURL");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getConnectionUsername(), (Object)"testConnectionUsername");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getConnectionPassword(), (Object)"testConnectionPassword");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getConnectionProtocol(), (Object)"testConnectionProtocol");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getAuthentication(), (Object)"testAuthentication");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getDestinationBase(), (Object)"testDestinationBase");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getFilter(), (Object)"testFilter");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getRoleAttribute(), (Object)"testRoleAttribute");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getAdminPermissionValue(), (Object)"testAdminPermissionValue");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getReadPermissionValue(), (Object)"testReadPermissionValue");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.getWritePermissionValue(), (Object)"testWritePermissionValue");
        FileConfigurationTest.assertEquals((Object)legacyLDAPSecuritySettingPlugin.isEnableListener(), (Object)false);
    }

    @Test
    public void testSecurityRoleMapping() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("securityRoleMappings.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        Map securityRoles = fc.getSecurityRoles();
        Set roles = (Set)securityRoles.get("#");
        Role testRole1 = new Role("cn=mygroup,dc=local,dc=com", false, false, false, false, true, false, false, false, false, false);
        Role testRole2 = new Role("myrole1", false, false, false, false, true, true, false, false, false, false);
        Role testRole3 = new Role("myrole3", false, false, true, true, false, false, false, false, false, false);
        Role testRole4 = new Role("myrole4", true, true, false, false, false, false, false, true, true, true);
        Role testRole5 = new Role("myrole5", false, false, true, true, false, false, false, false, false, false);
        Role testRole6 = new Role("amq1", false, false, false, false, true, false, false, false, false, false);
        Role testRole7 = new Role("amq2", false, false, false, false, false, true, false, false, false, false);
        Role testRole8 = new Role("amq3", false, false, true, false, false, false, false, false, false, false);
        Role testRole9 = new Role("amq4", false, false, true, true, false, false, false, false, false, false);
        Role testRole10 = new Role("amq5", false, false, false, false, false, false, false, false, true, true);
        Role testRole11 = new Role("amq6", false, true, false, false, false, false, false, true, false, false);
        Role testRole12 = new Role("amq7", false, false, false, false, false, false, true, false, false, false);
        Role testRole13 = new Role("amq!@#$%^&*()", true, false, false, false, false, false, false, false, false, false);
        FileConfigurationTest.assertEquals((long)13L, (long)roles.size());
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole1));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole2));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole3));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole4));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole5));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole6));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole7));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole8));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole9));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole10));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole11));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole12));
        FileConfigurationTest.assertTrue((boolean)roles.contains(testRole13));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextClassLoaderUsage() throws Exception {
        final File customConfiguration = File.createTempFile("hornetq-unittest", ".xml");
        try {
            Path workingConfiguration = new File(((Object)((Object)this)).getClass().getResource("/" + this.getConfigurationName()).toURI()).toPath();
            Path targetFile = customConfiguration.toPath();
            Files.copy(workingConfiguration, targetFile, StandardCopyOption.REPLACE_EXISTING);
            URL customConfigurationDirUrl = customConfiguration.getParentFile().toURI().toURL();
            URLClassLoader testWebappClassLoader = new URLClassLoader(new URL[]{customConfigurationDirUrl});
            final class ThrowableHolder {
                volatile Exception t;

                ThrowableHolder() {
                }
            }
            final ThrowableHolder holder = new ThrowableHolder();
            Thread webappContextThread = new Thread(new Runnable(){
                {
                }

                @Override
                public void run() {
                    FileConfiguration fileConfiguration = new FileConfiguration();
                    try {
                        FileDeploymentManager deploymentManager = new FileDeploymentManager(customConfiguration.getName());
                        deploymentManager.addDeployable((Deployable)fileConfiguration);
                        deploymentManager.readConfiguration();
                    }
                    catch (Exception e) {
                        holder.t = e;
                    }
                }
            });
            webappContextThread.setContextClassLoader(testWebappClassLoader);
            webappContextThread.start();
            webappContextThread.join();
            if (holder.t != null) {
                FileConfigurationTest.fail((String)("Exception caught while loading configuration with the context class loader: " + holder.t.getMessage()));
            }
        }
        finally {
            customConfiguration.delete();
        }
    }

    @Test
    public void testBrokerPlugin() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("brokerPlugin.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        List brokerPlugins = fc.getBrokerPlugins();
        FileConfigurationTest.assertEquals((long)2L, (long)brokerPlugins.size());
        FileConfigurationTest.assertTrue((boolean)(brokerPlugins.get(0) instanceof EmptyPlugin1));
        FileConfigurationTest.assertTrue((boolean)(brokerPlugins.get(1) instanceof EmptyPlugin2));
    }

    @Test
    public void testDefaultConstraints() {
        int defaultConfirmationWinSize = ActiveMQDefaultConfiguration.getDefaultClusterConfirmationWindowSize();
        int defaultIdCacheSize = ActiveMQDefaultConfiguration.getDefaultIdCacheSize();
        FileConfigurationTest.assertTrue((String)("check failed, " + defaultConfirmationWinSize + ":" + defaultIdCacheSize), (boolean)ConfigurationImpl.checkoutDupCacheSize((int)defaultConfirmationWinSize, (int)defaultIdCacheSize));
        defaultConfirmationWinSize = ActiveMQDefaultConfiguration.getDefaultBridgeConfirmationWindowSize();
        FileConfigurationTest.assertTrue((String)("check failed, " + defaultConfirmationWinSize + ":" + defaultIdCacheSize), (boolean)ConfigurationImpl.checkoutDupCacheSize((int)defaultConfirmationWinSize, (int)defaultIdCacheSize));
    }

    @Test
    public void testJournalFileOpenTimeoutDefaultValue() throws Exception {
        ActiveMQServerImpl server = new ActiveMQServerImpl();
        server.getConfiguration().setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).setBindingsDirectory(this.getBindingsDir());
        try {
            server.start();
            JournalImpl journal = (JournalImpl)server.getStorageManager().getBindingsJournal();
            Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalFileOpenTimeout(), (long)journal.getFilesRepository().getJournalFileOpenTimeout());
            Assert.assertEquals((long)ActiveMQDefaultConfiguration.getDefaultJournalFileOpenTimeout(), (long)server.getConfiguration().getJournalFileOpenTimeout());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournalFileOpenTimeoutValue() throws Exception {
        int timeout = RandomUtil.randomPositiveInt();
        Configuration configuration = this.createConfiguration("shared-store-master-hapolicy-config.xml");
        configuration.setJournalFileOpenTimeout(timeout).setJournalDirectory(this.getJournalDir()).setPagingDirectory(this.getPageDir()).setLargeMessagesDirectory(this.getLargeMessagesDir()).setBindingsDirectory(this.getBindingsDir());
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            JournalImpl journal = (JournalImpl)server.getStorageManager().getBindingsJournal();
            Assert.assertEquals((long)timeout, (long)journal.getFilesRepository().getJournalFileOpenTimeout());
            Assert.assertEquals((long)timeout, (long)server.getConfiguration().getJournalFileOpenTimeout());
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void testMetricsPlugin() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("metricsPlugin.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        ActiveMQMetricsPlugin metricPlugin = fc.getMetricsConfiguration().getPlugin();
        FileConfigurationTest.assertTrue((boolean)(metricPlugin instanceof FakeMetricPlugin));
        Map<String, String> metricPluginOptions = ((FakeMetricPlugin)metricPlugin).getOptions();
        FileConfigurationTest.assertEquals((Object)"value1", (Object)metricPluginOptions.get("key1"));
        FileConfigurationTest.assertEquals((Object)"value2", (Object)metricPluginOptions.get("key2"));
        FileConfigurationTest.assertEquals((Object)"value3", (Object)metricPluginOptions.get("key3"));
    }

    @Test
    public void testMetrics() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("metrics.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        MetricsConfiguration metricsConfiguration = fc.getMetricsConfiguration();
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isJvmMemory());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isJvmGc());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isJvmThread());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isNettyPool());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isFileDescriptors());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isProcessor());
        FileConfigurationTest.assertTrue((boolean)metricsConfiguration.isUptime());
        ActiveMQMetricsPlugin metricPlugin = metricsConfiguration.getPlugin();
        FileConfigurationTest.assertTrue((boolean)(metricPlugin instanceof FakeMetricPlugin));
        Map<String, String> metricPluginOptions = ((FakeMetricPlugin)metricPlugin).getOptions();
        FileConfigurationTest.assertEquals((Object)"value1", (Object)metricPluginOptions.get("key1"));
        FileConfigurationTest.assertEquals((Object)"value2", (Object)metricPluginOptions.get("key2"));
        FileConfigurationTest.assertEquals((Object)"value3", (Object)metricPluginOptions.get("key3"));
    }

    @Test
    public void testMetricsConflict() throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager("metricsConflict.xml");
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        ActiveMQMetricsPlugin metricPlugin = fc.getMetricsConfiguration().getPlugin();
        FileConfigurationTest.assertTrue((boolean)(metricPlugin instanceof FakeMetricPlugin));
        Map<String, String> metricPluginOptions = ((FakeMetricPlugin)metricPlugin).getOptions();
        FileConfigurationTest.assertEquals((Object)"value1", (Object)metricPluginOptions.get("key1"));
        FileConfigurationTest.assertEquals((Object)"value2", (Object)metricPluginOptions.get("key2"));
        FileConfigurationTest.assertEquals((Object)"value3", (Object)metricPluginOptions.get("key3"));
    }

    @Override
    protected Configuration createConfiguration() throws Exception {
        System.clearProperty("brokerconfig.maxDiskUsage");
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(this.getConfigurationName());
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        return fc;
    }

    private Configuration createConfiguration(String filename) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(filename);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        return fc;
    }

    @Test
    public void testValidateCache() throws Exception {
        AssertionLoggerHandler.startCapture((boolean)true);
        try {
            FileConfiguration fc = new FileConfiguration();
            FileDeploymentManager deploymentManager = new FileDeploymentManager(this.getConfigurationName());
            deploymentManager.addDeployable((Deployable)fc);
            deploymentManager.readConfiguration();
            Assert.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ224117"}));
            Assert.assertEquals((long)1L, (long)AssertionLoggerHandler.countText((String[])new String[]{"AMQ224117"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    public static class FakeMetricPlugin
    implements ActiveMQMetricsPlugin {
        private Map<String, String> options;

        public Map<String, String> getOptions() {
            return this.options;
        }

        public ActiveMQMetricsPlugin init(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public MeterRegistry getRegistry() {
            return null;
        }
    }

    public static class EmptyPlugin2
    implements ActiveMQServerPlugin {
    }

    public static class EmptyPlugin1
    implements ActiveMQServerPlugin {
    }
}

