/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import org.apache.activemq.artemis.core.config.impl.FileConfigurationTest;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;

public class FileXIncludeSchemaConfigurationTest
extends FileConfigurationTest {
    public FileXIncludeSchemaConfigurationTest(boolean xxeEnabled) {
        super(xxeEnabled);
        Assume.assumeTrue((boolean)xxeEnabled);
    }

    @BeforeClass
    public static void setupProperties() {
        System.setProperty("xincludePath", "./src/test/resources");
        System.setProperty("a2Prop", "a2");
        System.setProperty("falseProp", "false");
        System.setProperty("trueProp", "true");
        System.setProperty("ninetyTwoProp", "92");
    }

    @AfterClass
    public static void clearProperties() {
        System.clearProperty("xincludePath");
        System.clearProperty("a2Prop");
        System.clearProperty("falseProp");
        System.clearProperty("trueProp");
        System.clearProperty("ninetyTwoProp");
    }

    @Override
    public void testSerialize() throws Exception {
        FileXIncludeSchemaConfigurationTest.assertEquals((String)"included broker plugins are not present", (long)2L, (long)this.conf.getBrokerPlugins().size());
        for (ActiveMQServerBasePlugin plugin : this.conf.getBrokerPlugins()) {
            this.conf.unRegisterBrokerPlugin(plugin);
        }
        super.testSerialize();
    }

    @Override
    protected String getConfigurationName() {
        return "ConfigurationTest-xinclude-schema-config.xml";
    }
}

