/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationBackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicationPrimaryPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ColocatedActivation;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.LiveOnlyActivation;
import org.apache.activemq.artemis.core.server.impl.ReplicationBackupActivation;
import org.apache.activemq.artemis.core.server.impl.ReplicationPrimaryActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStoreBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedStoreLiveActivation;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.DistributedPrimitiveManager;
import org.apache.activemq.artemis.quorum.MutableLong;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Test;

public class HAPolicyConfigurationTest
extends ActiveMQTestBase {
    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.shutdownDerby();
    }

    @Test
    public void shouldNotUseJdbcNodeManagerWithoutHAPolicy() throws Exception {
        Configuration configuration = this.createConfiguration("database-store-no-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        HAPolicyConfigurationTest.assertEquals((Object)StoreConfiguration.StoreType.DATABASE, (Object)server.getConfiguration().getStoreConfiguration().getStoreType());
        HAPolicyConfigurationTest.assertEquals((Object)HAPolicyConfiguration.TYPE.LIVE_ONLY, (Object)server.getConfiguration().getHAPolicyConfiguration().getType());
        try {
            server.start();
            HAPolicyConfigurationTest.assertThat((Object)server.getNodeManager(), (Matcher)CoreMatchers.instanceOf(FileLockNodeManager.class));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void liveOnlyTest() throws Exception {
        Configuration configuration = this.createConfiguration("live-only-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void liveOnlyTest2() throws Exception {
        Configuration configuration = this.createConfiguration("live-only-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)scaleDownPolicy.isEnabled());
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void liveOnlyTest3() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config3.xml");
    }

    @Test
    public void liveOnlyTest4() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config4.xml");
    }

    @Test
    public void liveOnlyTest5() throws Exception {
        this.liveOnlyTest("live-only-hapolicy-config5.xml");
    }

    private static void validateManagerConfig(Map<String, String> config) {
        HAPolicyConfigurationTest.assertEquals((Object)"127.0.0.1:6666", (Object)config.get("connect-string"));
        HAPolicyConfigurationTest.assertEquals((Object)"16000", (Object)config.get("session-ms"));
        HAPolicyConfigurationTest.assertEquals((Object)"2000", (Object)config.get("connection-ms"));
        HAPolicyConfigurationTest.assertEquals((Object)"2", (Object)config.get("retries"));
        HAPolicyConfigurationTest.assertEquals((Object)"2000", (Object)config.get("retries-ms"));
        HAPolicyConfigurationTest.assertEquals((Object)"test", (Object)config.get("namespace"));
        HAPolicyConfigurationTest.assertEquals((Object)"10", (Object)config.get("session-percent"));
        HAPolicyConfigurationTest.assertEquals((long)7L, (long)config.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void PrimaryReplicationTest() throws Exception {
        Configuration configuration = this.createConfiguration("primary-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ReplicationPrimaryActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicationPrimaryPolicy));
            ReplicationPrimaryPolicy policy = (ReplicationPrimaryPolicy)haPolicy;
            HAPolicyConfigurationTest.assertFalse((boolean)policy.isAllowAutoFailBack());
            HAPolicyConfigurationTest.assertEquals((long)9876L, (long)policy.getInitialReplicationSyncTimeout());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.canScaleDown());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.isBackup());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.isSharedStore());
            HAPolicyConfigurationTest.assertTrue((boolean)policy.isWaitForActivation());
            HAPolicyConfigurationTest.assertEquals((Object)"purple", (Object)policy.getGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)"purple", (Object)policy.getBackupGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)"abcdefg", (Object)policy.getClusterName());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.useQuorumManager());
            ReplicationBackupPolicy failbackPolicy = policy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)failbackPolicy);
            HAPolicyConfigurationTest.assertSame((Object)policy, (Object)failbackPolicy.getLivePolicy());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getGroupName(), (Object)failbackPolicy.getGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getBackupGroupName(), (Object)failbackPolicy.getBackupGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getClusterName(), (Object)failbackPolicy.getClusterName());
            HAPolicyConfigurationTest.assertEquals((long)73L, (long)failbackPolicy.getMaxSavedReplicatedJournalsSize());
            HAPolicyConfigurationTest.assertTrue((boolean)failbackPolicy.isTryFailback());
            HAPolicyConfigurationTest.assertTrue((boolean)failbackPolicy.isBackup());
            HAPolicyConfigurationTest.assertFalse((boolean)failbackPolicy.isSharedStore());
            HAPolicyConfigurationTest.assertTrue((boolean)failbackPolicy.isWaitForActivation());
            HAPolicyConfigurationTest.assertFalse((boolean)failbackPolicy.useQuorumManager());
            HAPolicyConfigurationTest.assertEquals((long)12345L, (long)failbackPolicy.getRetryReplicationWait());
            HAPolicyConfigurationTest.assertFalse((boolean)failbackPolicy.canScaleDown());
            HAPolicyConfigurationTest.assertNull((Object)failbackPolicy.getScaleDownClustername());
            HAPolicyConfigurationTest.assertNull((Object)failbackPolicy.getScaleDownGroupName());
            DistributedPrimitiveManager manager = ((ReplicationPrimaryActivation)activation).getDistributedManager();
            HAPolicyConfigurationTest.assertNotNull((Object)manager);
            HAPolicyConfigurationTest.assertEquals((Object)FakeDistributedPrimitiveManager.class.getName(), (Object)manager.getClass().getName());
            MatcherAssert.assertThat((Object)manager, (Matcher)IsInstanceOf.instanceOf(FakeDistributedPrimitiveManager.class));
            FakeDistributedPrimitiveManager forwardingManager = (FakeDistributedPrimitiveManager)manager;
            HAPolicyConfigurationTest.validateManagerConfig(forwardingManager.getConfig());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void BackupReplicationTest() throws Exception {
        Configuration configuration = this.createConfiguration("backup-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ReplicationBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicationBackupPolicy));
            ReplicationBackupPolicy policy = (ReplicationBackupPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)"tiddles", (Object)policy.getGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)"tiddles", (Object)policy.getBackupGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)"33rrrrr", (Object)policy.getClusterName());
            HAPolicyConfigurationTest.assertEquals((long)22L, (long)policy.getMaxSavedReplicatedJournalsSize());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.isTryFailback());
            HAPolicyConfigurationTest.assertTrue((boolean)policy.isBackup());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.isSharedStore());
            HAPolicyConfigurationTest.assertTrue((boolean)policy.isWaitForActivation());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.useQuorumManager());
            HAPolicyConfigurationTest.assertEquals((long)12345L, (long)policy.getRetryReplicationWait());
            HAPolicyConfigurationTest.assertFalse((boolean)policy.canScaleDown());
            HAPolicyConfigurationTest.assertNull((Object)policy.getScaleDownClustername());
            HAPolicyConfigurationTest.assertNull((Object)policy.getScaleDownGroupName());
            ReplicationPrimaryPolicy failoverLivePolicy = policy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)failoverLivePolicy);
            HAPolicyConfigurationTest.assertSame((Object)policy, (Object)failoverLivePolicy.getBackupPolicy());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.isAllowAutoFailBack());
            HAPolicyConfigurationTest.assertEquals((long)9876L, (long)failoverLivePolicy.getInitialReplicationSyncTimeout());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.canScaleDown());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.isBackup());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.isSharedStore());
            HAPolicyConfigurationTest.assertTrue((boolean)failoverLivePolicy.isWaitForActivation());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getGroupName(), (Object)failoverLivePolicy.getGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getClusterName(), (Object)failoverLivePolicy.getClusterName());
            HAPolicyConfigurationTest.assertEquals((Object)policy.getBackupGroupName(), (Object)failoverLivePolicy.getBackupGroupName());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.useQuorumManager());
            HAPolicyConfigurationTest.assertFalse((boolean)failoverLivePolicy.canScaleDown());
            HAPolicyConfigurationTest.assertNull((Object)failoverLivePolicy.getScaleDownClustername());
            HAPolicyConfigurationTest.assertNull((Object)failoverLivePolicy.getScaleDownGroupName());
            DistributedPrimitiveManager manager = ((ReplicationBackupActivation)activation).getDistributedManager();
            HAPolicyConfigurationTest.assertNotNull((Object)manager);
            HAPolicyConfigurationTest.assertEquals((Object)FakeDistributedPrimitiveManager.class.getName(), (Object)manager.getClass().getName());
            MatcherAssert.assertThat((Object)manager, (Matcher)IsInstanceOf.instanceOf(FakeDistributedPrimitiveManager.class));
            FakeDistributedPrimitiveManager forwardingManager = (FakeDistributedPrimitiveManager)manager;
            HAPolicyConfigurationTest.validateManagerConfig(forwardingManager.getConfig());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicatedTest() throws Exception {
        Configuration configuration = this.createConfiguration("replicated-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingLiveActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicatedPolicy));
            ReplicatedPolicy replicatedPolicy = (ReplicatedPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicatedPolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertTrue((boolean)replicatedPolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)replicatedPolicy.getClusterName(), (Object)"abcdefg");
            HAPolicyConfigurationTest.assertEquals((long)replicatedPolicy.getInitialReplicationSyncTimeout(), (long)9876L);
            HAPolicyConfigurationTest.assertEquals((long)replicatedPolicy.getRetryReplicationWait(), (long)12345L);
            HAPolicyConfigurationTest.assertEquals((long)replicatedPolicy.getMaxSavedReplicatedJournalsSize(), (long)73L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            HAPolicyConfigurationTest.assertTrue((boolean)replicaPolicy.isAllowFailback());
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getInitialReplicationSyncTimeout(), (long)9876L);
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getRetryReplicationWait(), (long)12345L);
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest2() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void ReplicaTest3() throws Exception {
        Configuration configuration = this.createConfiguration("replica-hapolicy-config3.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedNothingBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ReplicaPolicy));
            ReplicaPolicy replicaPolicy = (ReplicaPolicy)haPolicy;
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)replicaPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)replicaPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)replicaPolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = replicaPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreMasterTest() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-master-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreLiveActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreMasterPolicy));
            SharedStoreMasterPolicy masterPolicy = (SharedStoreMasterPolicy)haPolicy;
            HAPolicyConfigurationTest.assertFalse((boolean)masterPolicy.isFailoverOnServerShutdown());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertFalse((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertFalse((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), (Object)"wahey");
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)0L);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest2() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)scaleDownPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getGroupName(), (Object)"boo!");
            HAPolicyConfigurationTest.assertEquals((Object)scaleDownPolicy.getDiscoveryGroup(), null);
            List connectors = scaleDownPolicy.getConnectors();
            HAPolicyConfigurationTest.assertNotNull((Object)connectors);
            HAPolicyConfigurationTest.assertEquals((long)connectors.size(), (long)2L);
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector1"));
            HAPolicyConfigurationTest.assertTrue((boolean)connectors.contains("sd-connector2"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SharedStoreSlaveTest3() throws Exception {
        Configuration configuration = this.createConfiguration("shared-store-slave-hapolicy-config3.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof SharedStoreBackupActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof SharedStoreSlavePolicy));
            SharedStoreSlavePolicy sharedStoreSlavePolicy = (SharedStoreSlavePolicy)haPolicy;
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertTrue((boolean)sharedStoreSlavePolicy.isRestartBackup());
            ScaleDownPolicy scaleDownPolicy = sharedStoreSlavePolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            ReplicatedPolicy livePolicy = (ReplicatedPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertTrue((boolean)livePolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getClusterName(), (Object)"abcdefg");
            ReplicaPolicy backupPolicy = (ReplicaPolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
            HAPolicyConfigurationTest.assertEquals((Object)backupPolicy.getGroupName(), (Object)"tiddles");
            HAPolicyConfigurationTest.assertEquals((long)backupPolicy.getMaxSavedReplicatedJournalsSize(), (long)22L);
            HAPolicyConfigurationTest.assertEquals((Object)backupPolicy.getClusterName(), (Object)"33rrrrr");
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isRestartBackup());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTestNullBackup() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config-null-backup.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            ReplicatedPolicy livePolicy = (ReplicatedPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getGroupName(), (Object)"purple");
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getGroupName(), (Object)livePolicy.getBackupGroupName());
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getBackupGroupName(), (Object)haPolicy.getBackupGroupName());
            HAPolicyConfigurationTest.assertTrue((boolean)livePolicy.isCheckForLiveServer());
            HAPolicyConfigurationTest.assertEquals((Object)livePolicy.getClusterName(), (Object)"abcdefg");
            ReplicaPolicy backupPolicy = (ReplicaPolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest2() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config2.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            SharedStoreMasterPolicy livePolicy = (SharedStoreMasterPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)livePolicy.isFailoverOnServerShutdown());
            SharedStoreSlavePolicy backupPolicy = (SharedStoreSlavePolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isFailoverOnServerShutdown());
            HAPolicyConfigurationTest.assertFalse((boolean)backupPolicy.isRestartBackup());
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void colocatedTest2nullbackup() throws Exception {
        Configuration configuration = this.createConfiguration("colocated-hapolicy-config2-null-backup.xml");
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof ColocatedActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof ColocatedPolicy));
            ColocatedPolicy colocatedPolicy = (ColocatedPolicy)haPolicy;
            SharedStoreMasterPolicy livePolicy = (SharedStoreMasterPolicy)colocatedPolicy.getLivePolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)livePolicy);
            HAPolicyConfigurationTest.assertFalse((boolean)livePolicy.isFailoverOnServerShutdown());
            SharedStoreSlavePolicy backupPolicy = (SharedStoreSlavePolicy)colocatedPolicy.getBackupPolicy();
            HAPolicyConfigurationTest.assertNotNull((Object)backupPolicy);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void liveOnlyTest(String file) throws Exception {
        Configuration configuration = this.createConfiguration(file);
        ActiveMQServerImpl server = new ActiveMQServerImpl(configuration);
        try {
            server.start();
            Activation activation = server.getActivation();
            HAPolicyConfigurationTest.assertTrue((boolean)(activation instanceof LiveOnlyActivation));
            HAPolicy haPolicy = server.getHAPolicy();
            HAPolicyConfigurationTest.assertTrue((boolean)(haPolicy instanceof LiveOnlyPolicy));
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            ScaleDownPolicy scaleDownPolicy = liveOnlyPolicy.getScaleDownPolicy();
            HAPolicyConfigurationTest.assertNull((Object)scaleDownPolicy);
        }
        finally {
            server.stop();
        }
    }

    protected Configuration createConfiguration(String fileName) throws Exception {
        FileConfiguration fc = new FileConfiguration();
        FileDeploymentManager deploymentManager = new FileDeploymentManager(fileName);
        deploymentManager.addDeployable((Deployable)fc);
        deploymentManager.readConfiguration();
        fc.setPagingDirectory(this.getTestDir() + "/" + fc.getPagingDirectory());
        fc.setLargeMessagesDirectory(this.getTestDir() + "/" + fc.getLargeMessagesDirectory());
        fc.setJournalDirectory(this.getTestDir() + "/" + fc.getJournalDirectory());
        fc.setBindingsDirectory(this.getTestDir() + "/" + fc.getBindingsDirectory());
        return fc;
    }

    public static class FakeDistributedPrimitiveManager
    implements DistributedPrimitiveManager {
        private final Map<String, String> config;
        private boolean started;
        private DistributedLock lock;

        public FakeDistributedPrimitiveManager(Map<String, String> config) {
            this.config = config;
            this.started = false;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public void addUnavailableManagerListener(DistributedPrimitiveManager.UnavailableManagerListener listener) {
        }

        public void removeUnavailableManagerListener(DistributedPrimitiveManager.UnavailableManagerListener listener) {
        }

        public boolean start(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
            this.started = true;
            return true;
        }

        public void start() throws InterruptedException, ExecutionException {
            this.started = true;
        }

        public boolean isStarted() {
            return this.started;
        }

        public void stop() {
            this.started = false;
            if (this.lock != null) {
                this.lock.close();
            }
            this.lock = null;
        }

        public DistributedLock getDistributedLock(final String lockId) {
            if (!this.started) {
                throw new IllegalStateException("need to start first");
            }
            if (this.lock == null) {
                this.lock = new DistributedLock(){
                    private boolean held;

                    public String getLockId() {
                        return lockId;
                    }

                    public boolean isHeldByCaller() throws UnavailableStateException {
                        return this.held;
                    }

                    public boolean tryLock() throws UnavailableStateException, InterruptedException {
                        if (this.held) {
                            return false;
                        }
                        this.held = true;
                        return true;
                    }

                    public void unlock() throws UnavailableStateException {
                        this.held = false;
                    }

                    public void addListener(DistributedLock.UnavailableLockListener listener) {
                    }

                    public void removeListener(DistributedLock.UnavailableLockListener listener) {
                    }

                    public void close() {
                        this.held = false;
                    }
                };
            } else if (!this.lock.getLockId().equals(lockId)) {
                throw new IllegalStateException("This shouldn't happen");
            }
            return this.lock;
        }

        public MutableLong getMutableLong(final String mutableLongId) {
            return new MutableLong(){
                private long value = 0L;

                public String getMutableLongId() {
                    return mutableLongId;
                }

                public long get() {
                    return this.value;
                }

                public void set(long value) {
                    this.value = value;
                }

                public void close() {
                }
            };
        }

        public void close() {
            this.stop();
        }
    }
}

