/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WrongRoleFileConfigurationParserTest
extends ActiveMQTestBase {
    private static final String configuration = "<configuration xmlns=\"urn:activemq\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"urn:activemq /schema/artemis-configuration.xsd\">\n<name>ActiveMQ.main.config</name>\n<log-delegate-factory-class-name>org.apache.activemq.artemis.integration.logging.Log4jLogDelegateFactory</log-delegate-factory-class-name>\n<bindings-directory>${jboss.server.data.dir}/activemq/bindings</bindings-directory>\n<journal-directory>${jboss.server.data.dir}/activemq/journal</journal-directory>\n<journal-min-files>10</journal-min-files>\n<large-messages-directory>${jboss.server.data.dir}/activemq/largemessages</large-messages-directory>\n<paging-directory>${jboss.server.data.dir}/activemq/paging</paging-directory>\n<connectors>\n<connector name=\"netty\">tcp://localhost:61616</connector>\n<connector name=\"netty-throughput\">tcp://localhost:5545</connector>\n<connector name=\"in-vm\">vm://0</connector>\n</connectors>\n<acceptors>\n<acceptor name=\"netty\">tcp://localhost:5545</acceptor>\n<acceptor name=\"netty-throughput\">tcp://localhost:5545</acceptor>\n<acceptor name=\"in-vm\">vm://0</acceptor>\n</acceptors>\n<security-settings>\n<security-setting match=\"#\">\n<permission type=\"createNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"deleteNonDurableQueue\" roles=\"guest\"/>\n<permission type=\"create-durable-queue\" roles=\"guest\"/>\n<permission type=\"delete-durable-queue\" roles=\"guest\"/>\n<permission type=\"consume\" roles=\"guest\"/>\n<permission type=\"send\" roles=\"guest\"/>\n</security-setting>\n</security-settings>\n<address-settings>\n<address-setting match=\"#\">\n<dead-letter-address>DLQ\n</dead-letter-address>\n<expiry-address>ExpiryQueue\n</expiry-address>\n<redelivery-delay>0\n</redelivery-delay>\n<max-size-bytes>10485760\n</max-size-bytes>\n<message-counter-history-day-limit>10</message-counter-history-day-limit>\n<address-full-policy>BLOCK</address-full-policy>\n</address-setting>\n</address-settings>\n</configuration>";

    @BeforeClass
    public static void prepareLogger() {
        AssertionLoggerHandler.startCapture();
    }

    @AfterClass
    public static void clearLogger() {
        AssertionLoggerHandler.stopCapture();
    }

    @Test
    public void testParsingDefaultServerConfig() throws Exception {
        FileConfigurationParser parser = new FileConfigurationParser();
        ByteArrayInputStream input = new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8));
        parser.parseMainConfig((InputStream)input);
        WrongRoleFileConfigurationParserTest.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222177", "create-durable-queue"}));
        WrongRoleFileConfigurationParserTest.assertTrue((boolean)AssertionLoggerHandler.findText((String[])new String[]{"AMQ222177", "delete-durable-queue"}));
    }
}

