/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.filter.impl;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.SilentTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterTest
extends SilentTestCase {
    private Filter filter;
    private Message message;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.message = new CoreMessage().initBuffer(1024).setMessageID(1L);
    }

    @Test
    public void testNewlineMatch() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("fooprop LIKE '%1234%'"));
        this.message.putStringProperty(new SimpleString("fooprop"), new SimpleString("hello1234\n"));
        Assert.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testFilterForgets() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("color = 'RED'"));
        this.message.putStringProperty(new SimpleString("color"), new SimpleString("RED"));
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.message = new CoreMessage();
        Assert.assertFalse((boolean)this.filter.match(this.message));
    }

    @Test
    public void testInvalidString() throws Exception {
        this.testInvalidFilter("color = 'red");
        this.testInvalidFilter(new SimpleString("color = 'red"));
        this.testInvalidFilter("3");
        this.testInvalidFilter(new SimpleString("3"));
    }

    @Test
    public void testNullFilter() throws Exception {
        Assert.assertNull((Object)FilterImpl.createFilter((String)null));
        Assert.assertNull((Object)FilterImpl.createFilter((String)""));
        Assert.assertNull((Object)FilterImpl.createFilter((SimpleString)null));
        Assert.assertNull((Object)FilterImpl.createFilter((SimpleString)new SimpleString("")));
    }

    @Test
    public void testAMQDurable() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("AMQDurable='DURABLE'"));
        this.message.setDurable(true);
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.message.setDurable(false);
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("AMQDurable='NON_DURABLE'"));
        this.message = new CoreMessage();
        this.message.setDurable(true);
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.message.setDurable(false);
        Assert.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testAMQSize() throws Exception {
        this.message.setAddress(RandomUtil.randomSimpleString());
        int encodeSize = this.message.getEncodeSize();
        Filter moreThanSmall = FilterImpl.createFilter((SimpleString)new SimpleString("AMQSize > " + (encodeSize - 1)));
        Filter lessThanLarge = FilterImpl.createFilter((SimpleString)new SimpleString("AMQSize < " + (encodeSize + 1)));
        Filter lessThanSmall = FilterImpl.createFilter((SimpleString)new SimpleString("AMQSize < " + encodeSize));
        Filter moreThanLarge = FilterImpl.createFilter((SimpleString)new SimpleString("AMQSize > " + encodeSize));
        Assert.assertTrue((boolean)moreThanSmall.match(this.message));
        Assert.assertTrue((boolean)lessThanLarge.match(this.message));
        Assert.assertFalse((boolean)lessThanSmall.match(this.message));
        Assert.assertFalse((boolean)moreThanLarge.match(this.message));
    }

    @Test
    public void testAMQPriority() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("AMQPriority=3"));
        for (int i = 0; i < 10; ++i) {
            this.message.setPriority((byte)i);
            if (i == 3) {
                Assert.assertTrue((boolean)this.filter.match(this.message));
                continue;
            }
            Assert.assertFalse((boolean)this.filter.match(this.message));
        }
    }

    @Test
    public void testAMQTimestamp() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("AMQTimestamp=12345678"));
        this.message.setTimestamp(87654321L);
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.message.setTimestamp(12345678L);
        Assert.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testBooleanTrue() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyBoolean=true"));
        this.testBoolean("MyBoolean", true);
    }

    @Test
    public void testIdentifier() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyBoolean"));
        this.testBoolean("MyBoolean", true);
    }

    @Test
    public void testDifferentNullString() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("prop <> 'foo'"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("prop <> 'foo' OR prop IS NULL"));
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("NOT (prop = 'foo')"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("NOT (prop = 'foo') OR prop IS NULL"));
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("prop <> 'foo'"));
        this.doPutStringProperty("prop", "bar");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("prop <> 'foo'"));
        this.doPutStringProperty("prop", "foo");
        Assert.assertFalse((boolean)this.filter.match(this.message));
    }

    @Test
    public void testBooleanFalse() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyBoolean=false"));
        this.testBoolean("MyBoolean", false);
    }

    private void testBoolean(String name, boolean flag) throws Exception {
        this.message.putBooleanProperty(new SimpleString(name), flag);
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.message.putBooleanProperty(new SimpleString(name), !flag);
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
    }

    @Test
    public void testStringEquals() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString='astring'"));
        this.doPutStringProperty("MyString", "astring");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "NOTastring");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString=''"));
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((String)"test 1", (boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "NOTastring");
        Assert.assertTrue((String)"test 2", (!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString='test JBoss''s filter'"));
        this.doPutStringProperty("MyString", "test JBoss's filter");
        this.doPutStringProperty("MyString", "NOTastring");
        Assert.assertTrue((String)"test 4", (!this.filter.match(this.message) ? 1 : 0) != 0);
    }

    @Test
    public void testNOT_INWithNullProperty() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("myNullProp NOT IN ('foo','jms','test')"));
        FilterTest.assertFalse((boolean)this.filter.match(this.message));
        this.message.putStringProperty("myNullProp", "JMS");
        FilterTest.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testNOT_LIKEWithNullProperty() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("myNullProp NOT LIKE '1_3'"));
        FilterTest.assertFalse((boolean)this.filter.match(this.message));
        this.message.putStringProperty("myNullProp", "JMS");
        FilterTest.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testIS_NOT_NULLWithNullProperty() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("myNullProp IS NOT NULL"));
        FilterTest.assertFalse((boolean)this.filter.match(this.message));
        this.message.putStringProperty("myNullProp", "JMS");
        FilterTest.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testStringLike() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'astring'"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "astring");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'a'"));
        this.doPutStringProperty("MyString", "a");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE ''"));
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'astring'"));
        this.doPutStringProperty("MyString", "NOTastring");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "astringNOT");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "astNOTring");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "totally different");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "ASTRING");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
    }

    @Test
    public void testStringLikeUnderbarWildcard() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '_'"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "a");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "aaaaa");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '_bcdf'"));
        this.doPutStringProperty("MyString", "abcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "aXcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abXdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "XXXabcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdfXXX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "bcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'abcd_'"));
        this.doPutStringProperty("MyString", "abcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abcXf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abXdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "Xbcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "XXXabcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdfXXX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcd");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'ab_df'"));
        this.doPutStringProperty("MyString", "abcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "aXcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcXf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "XXXabcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdfXXX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
    }

    @Test
    public void testNotLikeExpression() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("NOT (MyString LIKE '%')"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
    }

    @Test
    public void testStringLikePercentWildcard() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '%'"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "a");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "aaaaa");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '%bcdf'"));
        this.doPutStringProperty("MyString", "Xbcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "XXbcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abXdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdfXXX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "bcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'abcd%'"));
        this.doPutStringProperty("MyString", "abcdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abcdfgh");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abcXf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abXdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "Xbcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "XXXabcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcd");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'ab%df'"));
        this.doPutStringProperty("MyString", "abXdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "abXXXdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "aXcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcXf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "XXXabcdf");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abcdfXXX");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.doPutStringProperty("MyString", "abdf");
        Assert.assertTrue((boolean)this.filter.match(this.message));
    }

    @Test
    public void testStringLikePunctuation() throws Exception {
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'a^$b'"));
        Assert.assertFalse((boolean)this.filter.match(this.message));
        this.doPutStringProperty("MyString", "a^$b");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'a\\dc'"));
        this.doPutStringProperty("MyString", "a\\dc");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'a.c'"));
        this.doPutStringProperty("MyString", "abc");
        Assert.assertTrue((!this.filter.match(this.message) ? 1 : 0) != 0);
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '[abc]'"));
        this.doPutStringProperty("MyString", "[abc]");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '[^abc]'"));
        this.doPutStringProperty("MyString", "[^abc]");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '[a-c]'"));
        this.doPutStringProperty("MyString", "[a-c]");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '[:alpha]'"));
        this.doPutStringProperty("MyString", "[:alpha]");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc)'"));
        this.doPutStringProperty("MyString", "(abc)");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE 'a|bc'"));
        this.doPutStringProperty("MyString", "a|bc");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc)?'"));
        this.doPutStringProperty("MyString", "(abc)?");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc)*'"));
        this.doPutStringProperty("MyString", "(abc)*");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc)+'"));
        this.doPutStringProperty("MyString", "(abc)+");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc){3}'"));
        this.doPutStringProperty("MyString", "(abc){3}");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc){3,5}'"));
        this.doPutStringProperty("MyString", "(abc){3,5}");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(abc){3,}'"));
        this.doPutStringProperty("MyString", "(abc){3,}");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(?=abc)'"));
        this.doPutStringProperty("MyString", "(?=abc)");
        Assert.assertTrue((boolean)this.filter.match(this.message));
        this.filter = FilterImpl.createFilter((SimpleString)new SimpleString("MyString LIKE '(?!abc)'"));
        this.doPutStringProperty("MyString", "(?!abc)");
        Assert.assertTrue((boolean)this.filter.match(this.message));
    }

    private void doPutStringProperty(String key, String value) {
        this.message.putStringProperty(new SimpleString(key), new SimpleString(value));
    }

    private void testInvalidFilter(String filterString) throws Exception {
        try {
            this.filter = FilterImpl.createFilter((String)filterString);
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQInvalidFilterExpressionException activeMQInvalidFilterExpressionException) {
        }
        catch (ActiveMQException e) {
            FilterTest.fail((String)("Invalid exception type:" + e.getType()));
        }
    }

    private void testInvalidFilter(SimpleString filterString) throws Exception {
        try {
            this.filter = FilterImpl.createFilter((SimpleString)filterString);
            Assert.fail((String)"Should throw exception");
        }
        catch (ActiveMQInvalidFilterExpressionException activeMQInvalidFilterExpressionException) {
        }
        catch (ActiveMQException e) {
            FilterTest.fail((String)("Invalid exception type:" + e.getType()));
        }
    }
}

