/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.list;

import io.netty.util.collection.LongObjectHashMap;
import java.util.HashSet;
import java.util.Objects;
import org.apache.activemq.artemis.utils.collections.LinkedListImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.NodeStore;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class PriorityLinkedListTest
extends Assert {
    protected Wibble a;
    protected Wibble b;
    protected Wibble c;
    protected Wibble d;
    protected Wibble e;
    protected Wibble f;
    protected Wibble g;
    protected Wibble h;
    protected Wibble i;
    protected Wibble j;
    protected Wibble k;
    protected Wibble l;
    protected Wibble m;
    protected Wibble n;
    protected Wibble o;
    protected Wibble p;
    protected Wibble q;
    protected Wibble r;
    protected Wibble s;
    protected Wibble t;
    protected Wibble u;
    protected Wibble v;
    protected Wibble w;
    protected Wibble x;
    protected Wibble y;
    protected Wibble z;
    private PriorityLinkedListImpl<Wibble> list;

    protected PriorityLinkedListImpl<Wibble> getList() {
        return new PriorityLinkedListImpl(10);
    }

    @Before
    public void setUp() throws Exception {
        this.list = this.getList();
        this.a = new Wibble("a", 1L);
        this.b = new Wibble("b", 2L);
        this.c = new Wibble("c", 3L);
        this.d = new Wibble("d", 4L);
        this.e = new Wibble("e", 5L);
        this.f = new Wibble("f", 6L);
        this.g = new Wibble("g", 7L);
        this.h = new Wibble("h", 8L);
        this.i = new Wibble("i", 9L);
        this.j = new Wibble("j", 10L);
        this.k = new Wibble("k", 11L);
        this.l = new Wibble("l", 12L);
        this.m = new Wibble("m", 13L);
        this.n = new Wibble("n", 14L);
        this.o = new Wibble("o", 15L);
        this.p = new Wibble("p", 16L);
        this.q = new Wibble("q", 17L);
        this.r = new Wibble("r", 18L);
        this.s = new Wibble("s", 19L);
        this.t = new Wibble("t", 20L);
        this.u = new Wibble("u", 21L);
        this.v = new Wibble("v", 22L);
        this.w = new Wibble("w", 23L);
        this.x = new Wibble("x", 24L);
        this.y = new Wibble("y", 25L);
        this.z = new Wibble("z", 26L);
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertTrue((boolean)this.list.isEmpty());
        this.list.addHead((Object)this.a, 0);
        Assert.assertFalse((boolean)this.list.isEmpty());
        Wibble w1 = (Wibble)this.list.poll();
        Assert.assertEquals((Object)this.a, (Object)w1);
        Assert.assertTrue((boolean)this.list.isEmpty());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testaddHead() throws Exception {
        this.list.addHead((Object)this.a, 0);
        this.list.addHead((Object)this.b, 0);
        this.list.addHead((Object)this.c, 0);
        this.list.addHead((Object)this.d, 0);
        this.list.addHead((Object)this.e, 0);
        PriorityLinkedListTest.assertEquals((long)5L, (long)this.list.size());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testaddTail() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        PriorityLinkedListTest.assertEquals((long)5L, (long)this.list.size());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testAddLastAndFirst() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        this.list.addTail((Object)this.f, 0);
        this.list.addTail((Object)this.g, 0);
        this.list.addTail((Object)this.h, 0);
        this.list.addTail((Object)this.i, 0);
        this.list.addTail((Object)this.j, 0);
        this.list.addHead((Object)this.k, 0);
        this.list.addHead((Object)this.l, 0);
        this.list.addHead((Object)this.m, 0);
        this.list.addHead((Object)this.n, 0);
        this.list.addHead((Object)this.o, 0);
        this.list.addHead((Object)this.p, 0);
        this.list.addHead((Object)this.q, 0);
        this.list.addHead((Object)this.r, 0);
        this.list.addHead((Object)this.s, 0);
        this.list.addHead((Object)this.t, 0);
        PriorityLinkedListTest.assertEquals((Object)this.t, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.s, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.r, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.q, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.p, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.o, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.n, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.m, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.l, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.h, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.i, (Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((Object)this.j, (Object)this.list.poll());
    }

    @Test
    public void testAddLastAndFirstWithIterator() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 0);
        this.list.addTail((Object)this.d, 0);
        this.list.addTail((Object)this.e, 0);
        this.list.addTail((Object)this.f, 0);
        this.list.addTail((Object)this.g, 0);
        this.list.addTail((Object)this.h, 0);
        this.list.addTail((Object)this.i, 0);
        this.list.addTail((Object)this.j, 0);
        this.list.addHead((Object)this.k, 0);
        this.list.addHead((Object)this.l, 0);
        this.list.addHead((Object)this.m, 0);
        this.list.addHead((Object)this.n, 0);
        this.list.addHead((Object)this.o, 0);
        this.list.addHead((Object)this.p, 0);
        this.list.addHead((Object)this.q, 0);
        this.list.addHead((Object)this.r, 0);
        this.list.addHead((Object)this.s, 0);
        this.list.addHead((Object)this.t, 0);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.t, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.s, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.r, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.q, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.p, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.o, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.n, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.m, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.l, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.h, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.i, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.j, (Object)iter.next());
    }

    @Test
    public void testPoll() throws Exception {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 1);
        this.list.addTail((Object)this.c, 2);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 4);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 7);
        this.list.addTail((Object)this.i, 8);
        this.list.addTail((Object)this.j, 9);
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 8);
        this.list.addTail((Object)this.c, 7);
        this.list.addTail((Object)this.d, 6);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.f, 4);
        this.list.addTail((Object)this.g, 3);
        this.list.addTail((Object)this.h, 2);
        this.list.addTail((Object)this.i, 1);
        this.list.addTail((Object)this.j, 0);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 0);
        this.list.addTail((Object)this.c, 8);
        this.list.addTail((Object)this.d, 1);
        this.list.addTail((Object)this.e, 7);
        this.list.addTail((Object)this.f, 2);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 3);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.j, 4);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 3);
        this.list.addTail((Object)this.c, 3);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 6);
        this.list.addTail((Object)this.f, 6);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 9);
        this.list.addTail((Object)this.i, 9);
        this.list.addTail((Object)this.j, 9);
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.a, 5);
        this.list.addTail((Object)this.b, 5);
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.g, 5);
        this.list.addTail((Object)this.h, 5);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.j, 5);
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        this.list.addTail((Object)this.j, 5);
        this.list.addTail((Object)this.i, 5);
        this.list.addTail((Object)this.h, 5);
        this.list.addTail((Object)this.g, 5);
        this.list.addTail((Object)this.f, 5);
        this.list.addTail((Object)this.e, 5);
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.b, 5);
        this.list.addTail((Object)this.a, 5);
        Assert.assertEquals((Object)this.j, (Object)this.list.poll());
        Assert.assertEquals((Object)this.i, (Object)this.list.poll());
        Assert.assertEquals((Object)this.h, (Object)this.list.poll());
        Assert.assertEquals((Object)this.g, (Object)this.list.poll());
        Assert.assertEquals((Object)this.f, (Object)this.list.poll());
        Assert.assertEquals((Object)this.e, (Object)this.list.poll());
        Assert.assertEquals((Object)this.d, (Object)this.list.poll());
        Assert.assertEquals((Object)this.c, (Object)this.list.poll());
        Assert.assertEquals((Object)this.b, (Object)this.list.poll());
        Assert.assertEquals((Object)this.a, (Object)this.list.poll());
        Assert.assertNull((Object)this.list.poll());
        PriorityLinkedListTest.assertEquals((long)0L, (long)this.list.size());
    }

    @Test
    public void testIterator() {
        Wibble w1;
        this.list.addTail((Object)this.a, 9);
        this.list.addTail((Object)this.b, 9);
        this.list.addTail((Object)this.c, 8);
        this.list.addTail((Object)this.d, 8);
        this.list.addTail((Object)this.e, 7);
        this.list.addTail((Object)this.f, 7);
        this.list.addTail((Object)this.g, 7);
        this.list.addTail((Object)this.h, 6);
        this.list.addTail((Object)this.i, 6);
        this.list.addTail((Object)this.j, 6);
        this.list.addTail((Object)this.k, 5);
        this.list.addTail((Object)this.l, 5);
        this.list.addTail((Object)this.m, 4);
        this.list.addTail((Object)this.n, 4);
        this.list.addTail((Object)this.o, 4);
        this.list.addTail((Object)this.p, 3);
        this.list.addTail((Object)this.q, 3);
        this.list.addTail((Object)this.r, 3);
        this.list.addTail((Object)this.s, 2);
        this.list.addTail((Object)this.t, 2);
        this.list.addTail((Object)this.u, 2);
        this.list.addTail((Object)this.v, 1);
        this.list.addTail((Object)this.w, 1);
        this.list.addTail((Object)this.x, 1);
        this.list.addTail((Object)this.y, 0);
        this.list.addTail((Object)this.z, 0);
        LinkedListIterator iter = this.list.iterator();
        int count = 0;
        while (iter.hasNext()) {
            w1 = (Wibble)iter.next();
            ++count;
        }
        Assert.assertEquals((long)26L, (long)count);
        Assert.assertEquals((long)26L, (long)this.list.size());
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"a", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        Assert.assertEquals((Object)"b", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"j", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"z", (Object)w1.s1);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"a", (Object)w1.s1);
        iter.remove();
        Assert.assertEquals((long)25L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w1.s1);
        iter.remove();
        Assert.assertEquals((long)24L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"j", (Object)w1.s1);
        iter.remove();
        Assert.assertEquals((long)23L, (long)this.list.size());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"z", (Object)w1.s1);
        iter.remove();
        iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"e", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"f", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"g", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"h", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"i", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"k", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"l", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"m", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"n", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"o", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"p", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"q", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"r", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"s", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"t", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"u", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"v", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"w", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"x", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"y", (Object)w1.s1);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"a", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"b", (Object)w1.s1);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
        this.list.addTail((Object)this.c, 4);
        this.list.addTail((Object)this.d, 4);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"c", (Object)w1.s1);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        w1 = (Wibble)iter.next();
        Assert.assertEquals((Object)"d", (Object)w1.s1);
        PriorityLinkedListTest.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorPicksUpHigherPriorities() {
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        this.list.addTail((Object)this.c, 4);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        this.list.addTail((Object)this.d, 5);
        this.list.addTail((Object)this.e, 5);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.e, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        this.list.addTail((Object)this.f, 1);
        this.list.addTail((Object)this.g, 9);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.g, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.f, (Object)iter.next());
    }

    @Test
    public void testClear() {
        this.list.addTail((Object)this.a, 0);
        this.list.addTail((Object)this.b, 3);
        this.list.addTail((Object)this.c, 3);
        this.list.addTail((Object)this.d, 3);
        this.list.addTail((Object)this.e, 6);
        this.list.addTail((Object)this.f, 6);
        this.list.addTail((Object)this.g, 6);
        this.list.addTail((Object)this.h, 9);
        this.list.addTail((Object)this.i, 9);
        this.list.addTail((Object)this.j, 9);
        this.list.clear();
        Assert.assertNull((Object)this.list.poll());
    }

    @Test
    public void testMixupIterator() {
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.a, 4);
        this.list.addTail((Object)this.b, 4);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        this.list.addTail((Object)this.d, 5);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
    }

    @Test
    public void testMixupIterator2() {
        this.list.addTail((Object)this.c, 5);
        this.list.addTail((Object)this.k, 0);
        this.list.addTail((Object)this.a, 2);
        this.list.addTail((Object)this.b, 2);
        LinkedListIterator iter = this.list.iterator();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.b, (Object)iter.next());
        iter.remove();
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)iter.next());
        iter.remove();
        this.list.addTail((Object)this.d, 2);
        PriorityLinkedListTest.assertTrue((boolean)iter.hasNext());
        PriorityLinkedListTest.assertEquals((Object)this.d, (Object)iter.next());
        iter.remove();
    }

    @Test
    public void testPeek() {
        PriorityLinkedListTest.assertNull((Object)this.list.peek());
        this.list.addTail((Object)this.c, 5);
        PriorityLinkedListTest.assertEquals((Object)this.c, (Object)this.list.peek());
        this.list.addTail((Object)this.k, 0);
        PriorityLinkedListTest.assertEquals((Object)this.k, (Object)this.list.peek());
        this.list.addHead((Object)this.a, 0);
        PriorityLinkedListTest.assertEquals((Object)this.a, (Object)this.list.peek());
    }

    @Test
    public void testRemoveWithID() {
        int i;
        for (i = 1; i <= 3000; ++i) {
            this.list.addHead((Object)new Wibble("" + i, i), i % 10);
        }
        class WibbleNodeStore
        implements NodeStore<Wibble> {
            LongObjectHashMap<LinkedListImpl.Node<Wibble>> list = new LongObjectHashMap();

            WibbleNodeStore() {
            }

            public void storeNode(Wibble element, LinkedListImpl.Node<Wibble> node) {
                this.list.put(element.id, node);
            }

            public LinkedListImpl.Node<Wibble> getNode(String listID, long id) {
                return (LinkedListImpl.Node)this.list.get(id);
            }

            public void removeNode(Wibble element, LinkedListImpl.Node<Wibble> node) {
                this.list.remove(element.id);
            }

            public void clear() {
                this.list.clear();
            }

            public int size() {
                return this.list.size();
            }
        }
        this.list.setNodeStore((NodeStore)new WibbleNodeStore());
        for (i = 3; i <= 3000; i += 3) {
            Assert.assertEquals((Object)new Wibble("" + i, i), (Object)this.list.removeWithID("", (long)i));
        }
        Assert.assertEquals((long)2000L, (long)this.list.size());
        LinkedListIterator iterator = this.list.iterator();
        HashSet<String> values = new HashSet<String>();
        while (iterator.hasNext()) {
            values.add(((Wibble)iterator.next()).s1);
        }
        Assert.assertEquals((long)2000L, (long)values.size());
        for (int i2 = 1; i2 <= 3000; i2 += 3) {
            if (i2 % 3 == 0) {
                Assert.assertFalse((boolean)values.contains("" + i2));
                continue;
            }
            Assert.assertTrue((boolean)values.contains("" + i2));
        }
    }

    static class Wibble {
        String s1;
        long id;

        Wibble(String s, long id) {
            this.s1 = s;
            this.id = id;
        }

        public String toString() {
            return this.s1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Wibble wibble = (Wibble)o;
            return Objects.equals(this.s1, wibble.s1);
        }

        public int hashCode() {
            return Objects.hash(this.s1);
        }
    }
}

