/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.message.impl;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Before;
import org.junit.Test;

public class MessagePropertyTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;
    private ClientSessionFactory sf;
    private final int numMessages = 20;
    private static final String ADDRESS = "anAddress123";
    private static final SimpleString SIMPLE_STRING_KEY = new SimpleString("StringToSimpleString");

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
    }

    private void sendMessages() throws Exception {
        ClientSession session = this.sf.createSession(true, true);
        String filter = null;
        session.createAddress(SimpleString.toSimpleString((String)ADDRESS), RoutingType.MULTICAST, false);
        session.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.MULTICAST).setFilterString(filter));
        ClientProducer producer = session.createProducer(ADDRESS);
        for (int i = 0; i < 20; ++i) {
            ClientMessage message = session.createMessage(true);
            this.setBody(i, message);
            message.putIntProperty("int", i);
            message.putShortProperty("short", (short)i);
            message.putByteProperty("byte", (byte)i);
            message.putFloatProperty("float", this.floatValue(i));
            message.putStringProperty(SIMPLE_STRING_KEY, new SimpleString(Integer.toString(i)));
            message.putBytesProperty("byte[]", this.byteArray(i));
            message.putObjectProperty("null-value", null);
            producer.send((Message)message);
        }
        session.commit();
    }

    private float floatValue(int i) {
        return (float)((double)i * 1.3);
    }

    private byte[] byteArray(int i) {
        return new byte[]{(byte)i, (byte)(i / 2)};
    }

    @Test
    public void testProperties() throws Exception {
        this.sendMessages();
        this.receiveMessages();
    }

    private void receiveMessages() throws Exception {
        ClientSession session = this.sf.createSession(true, true);
        session.start();
        try (ClientConsumer consumer = session.createConsumer(ADDRESS);){
            for (int i = 0; i < 20; ++i) {
                ClientMessage message = consumer.receive(100L);
                MessagePropertyTest.assertNotNull((String)("Expecting a message " + i), (Object)message);
                this.assertMessageBody(i, message);
                MessagePropertyTest.assertEquals((long)i, (long)message.getIntProperty("int").intValue());
                MessagePropertyTest.assertEquals((long)((short)i), (long)message.getShortProperty("short").shortValue());
                MessagePropertyTest.assertEquals((long)((byte)i), (long)message.getByteProperty("byte").byteValue());
                MessagePropertyTest.assertEquals((double)this.floatValue(i), (double)message.getFloatProperty("float").floatValue(), (double)0.001);
                MessagePropertyTest.assertEquals((Object)new SimpleString(Integer.toString(i)), (Object)message.getSimpleStringProperty(SIMPLE_STRING_KEY.toString()));
                MessagePropertyTest.assertEqualsByteArrays(this.byteArray(i), message.getBytesProperty("byte[]"));
                MessagePropertyTest.assertNull((Object)message.getIngressTimestamp());
                MessagePropertyTest.assertTrue((boolean)message.containsProperty("null-value"));
                MessagePropertyTest.assertEquals((Object)message.getObjectProperty("null-value"), null);
                message.acknowledge();
            }
            MessagePropertyTest.assertNull((String)"no more messages", (Object)consumer.receive(50L));
        }
        session.commit();
    }
}

