/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageCursorProviderImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ConcurrentAckTest
extends ActiveMQTestBase {
    @Test
    public void testConcurrentAddAckPaging() throws Throwable {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.runAfter(scheduledExecutorService::shutdownNow);
        ExecutorService service = Executors.newFixedThreadPool(10);
        this.runAfter(service::shutdownNow);
        for (int repeat = 0; repeat < 100; ++repeat) {
            this.testConcurrentAddAckPaging(scheduledExecutorService, service);
        }
    }

    private void testConcurrentAddAckPaging(ScheduledExecutorService scheduledExecutorService, ExecutorService service) throws Throwable {
        AtomicInteger errors = new AtomicInteger(0);
        PagingStoreImpl store = new PagingStoreImpl(SimpleString.toSimpleString((String)"TEST"), scheduledExecutorService, 100L, (PagingManager)Mockito.mock(PagingManager.class), (StorageManager)new NullStorageManager(), (SequentialFileFactory)Mockito.mock(SequentialFileFactory.class), (PagingStoreFactory)Mockito.mock(PagingStoreFactory.class), SimpleString.toSimpleString((String)"TEST"), new AddressSettings(), ArtemisExecutor.delegate((Executor)service), ArtemisExecutor.delegate((Executor)service), false);
        PageCursorProviderImpl pageCursorProvider = new PageCursorProviderImpl((PagingStore)store, (StorageManager)new NullStorageManager());
        PageSubscriptionImpl subscription = (PageSubscriptionImpl)pageCursorProvider.createSubscription(1L, null, true);
        PageSubscriptionImpl.PageCursorInfo cursorInfo = subscription.getPageInfo((PagePosition)new PagePositionImpl(1L, 1));
        CountDownLatch done = new CountDownLatch(5);
        CyclicBarrier barrier = new CyclicBarrier(5);
        for (int r = 0; r < 4; ++r) {
            service.execute(() -> {
                try {
                    barrier.await(1L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < 5000; ++i) {
                    try {
                        cursorInfo.internalAddACK((PagePosition)new PagePositionImpl((long)i, i));
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                }
                done.countDown();
            });
        }
        service.execute(() -> {
            try {
                try {
                    barrier.await(1L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < 5000; ++i) {
                    cursorInfo.isAck(i);
                    cursorInfo.isRemoved(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.incrementAndGet();
            }
            done.countDown();
        });
        Assert.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)errors.get());
    }
}

