/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.util.EnumSet;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class AddressBindingEncodingTest
extends Assert {
    @Test
    public void testEncodeDecode() {
        SimpleString name = RandomUtil.randomSimpleString();
        boolean autoCreated = RandomUtil.randomBoolean();
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        PersistentAddressBindingEncoding encoding = new PersistentAddressBindingEncoding(name, routingTypes, autoCreated);
        int size = encoding.getEncodeSize();
        ActiveMQBuffer encodedBuffer = ActiveMQBuffers.fixedBuffer((int)size);
        encoding.encode(encodedBuffer);
        PersistentAddressBindingEncoding decoding = new PersistentAddressBindingEncoding();
        decoding.decode(encodedBuffer);
        AddressBindingEncodingTest.assertEquals((Object)name, (Object)decoding.getName());
        AddressBindingEncodingTest.assertEquals((Object)autoCreated, (Object)decoding.autoCreated);
        AddressBindingEncodingTest.assertEquals(routingTypes, (Object)decoding.routingTypes);
    }
}

