/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.persistence.impl.journal.BufferSplitter;
import org.junit.Assert;
import org.junit.Test;

public class BufferSplitterTest {
    @Test
    public void testSplitting() {
        ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)4000);
        for (int i = 0; i < 1000; ++i) {
            buffer.writeInt(i);
        }
        ActiveMQBuffer outputBuffer = ActiveMQBuffers.fixedBuffer((int)4000);
        int rdx = buffer.readerIndex();
        int readableBytes = buffer.readableBytes();
        BufferSplitter.split((ActiveMQBuffer)buffer, (int)77, c -> {
            Assert.assertTrue((c.getEncodeSize() <= 77 ? 1 : 0) != 0);
            c.encode(outputBuffer);
        });
        Assert.assertEquals((long)rdx, (long)buffer.readerIndex());
        Assert.assertEquals((long)readableBytes, (long)buffer.readableBytes());
        outputBuffer.resetReaderIndex();
        buffer.resetReaderIndex();
        byte[] sourceBytes = new byte[4000];
        buffer.readBytes(sourceBytes);
        byte[] targetBytes = new byte[4000];
        outputBuffer.readBytes(targetBytes);
        Assert.assertArrayEquals((byte[])sourceBytes, (byte[])targetBytes);
    }
}

