/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class JournalStorageManagerTest
extends ActiveMQTestBase {
    @Parameterized.Parameter
    public JournalType journalType;
    private static ExecutorService executor;
    private static ExecutorService ioExecutor;
    private static ExecutorService testExecutor;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="journal type={0}")
    public static Collection<Object[]> getParams() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeClass
    public static void initExecutors() {
        executor = Executors.newSingleThreadExecutor();
        ioExecutor = Executors.newFixedThreadPool(2);
        testExecutor = Executors.newSingleThreadExecutor();
    }

    @AfterClass
    public static void destroyExecutors() {
        ioExecutor.shutdownNow();
        executor.shutdownNow();
        testExecutor.shutdownNow();
    }

    @Test
    public void testFixJournalFileSize() throws Exception {
        if (this.journalType == JournalType.ASYNCIO) {
            Assume.assumeTrue((String)"AIO is not supported on this platform", (boolean)AIOSequentialFileFactory.isSupported());
        }
        Configuration configuration = this.createDefaultInVMConfig().setJournalType(this.journalType);
        OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
        OrderedExecutorFactory ioExecutorFactory = new OrderedExecutorFactory((Executor)ioExecutor);
        JournalStorageManager manager = new JournalStorageManager(configuration, null, (ExecutorFactory)executorFactory, null, (ExecutorFactory)ioExecutorFactory);
        Assert.assertEquals((long)4096L, (long)manager.fixJournalFileSize(1024, 4096));
        Assert.assertEquals((long)4096L, (long)manager.fixJournalFileSize(4098, 4096));
        Assert.assertEquals((long)8192L, (long)manager.fixJournalFileSize(8192, 4096));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddBytesToLargeMessageNotLeakingByteBuffer() throws Exception {
        if (this.journalType == JournalType.ASYNCIO) {
            Assume.assumeTrue((String)"AIO is not supported on this platform", (boolean)AIOSequentialFileFactory.isSupported());
        }
        Configuration configuration = this.createDefaultInVMConfig().setJournalType(this.journalType);
        OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
        OrderedExecutorFactory ioExecutorFactory = new OrderedExecutorFactory((Executor)ioExecutor);
        JournalStorageManager manager = new JournalStorageManager(configuration, null, (ExecutorFactory)executorFactory, null, (ExecutorFactory)ioExecutorFactory);
        manager.largeMessagesFactory = (SequentialFileFactory)Mockito.spy((Object)manager.largeMessagesFactory);
        manager.start();
        manager.loadBindingJournal(new ArrayList(), new ArrayList(), new ArrayList());
        PostOffice postOffice = (PostOffice)Mockito.mock(PostOffice.class);
        JournalLoader journalLoader = (JournalLoader)Mockito.mock(JournalLoader.class);
        manager.loadMessageJournal(postOffice, null, null, null, null, null, null, null, journalLoader);
        long id = manager.generateID() + 1L;
        SequentialFile file = manager.createFileForLargeMessage(id, false);
        try {
            file.open();
            ((SequentialFileFactory)Mockito.doAnswer(invocation -> {
                Assert.fail((String)"No buffer should leak into the factory pool while writing into a large message");
                return invocation.callRealMethod();
            }).when((Object)manager.largeMessagesFactory)).releaseBuffer((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
            int size = 100;
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(100);
            ActiveMQBuffer directBuffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)byteBuffer);
            directBuffer.writerIndex(100);
            long fileSize = file.size();
            manager.addBytesToLargeMessage(file, 1L, directBuffer);
            Assert.assertThat((Object)file.size(), (Matcher)Matchers.is((Object)(fileSize + 100L)));
            fileSize = file.size();
            ActiveMQBuffer heapBuffer = ActiveMQBuffers.wrappedBuffer((byte[])new byte[100]);
            heapBuffer.writerIndex(100);
            manager.addBytesToLargeMessage(file, 1L, heapBuffer);
            Assert.assertThat((Object)file.size(), (Matcher)Matchers.is((Object)(fileSize + 100L)));
        }
        finally {
            manager.stop();
            file.close();
            file.delete();
        }
    }
}

